/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.MemberFilterBase;
import org.jetbrains.debugger.Variable;

public class MemberFilterWithNameMappings
extends MemberFilterBase {
    protected final Map<String, String> rawNameToSource;

    public MemberFilterWithNameMappings(@Nullable Map<String, String> rawNameToSource) {
        this.rawNameToSource = rawNameToSource == null ? Collections.emptyMap() : rawNameToSource;
    }

    @Override
    public final boolean hasNameMappings() {
        return !this.rawNameToSource.isEmpty();
    }

    @Override
    @NotNull
    public String rawNameToSource(@NotNull Variable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/debugger/MemberFilterWithNameMappings", "rawNameToSource"));
        }
        String name = variable.getName();
        String sourceName = this.rawNameToSource.get(name);
        String string = sourceName == null ? this.normalizeMemberName(name) : sourceName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/MemberFilterWithNameMappings", "rawNameToSource"));
        }
        return string;
    }

    @NotNull
    protected String normalizeMemberName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/debugger/MemberFilterWithNameMappings", "normalizeMemberName"));
        }
        String string = name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/MemberFilterWithNameMappings", "normalizeMemberName"));
        }
        return string;
    }

    @Override
    @Nullable
    public String sourceNameToRaw(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/debugger/MemberFilterWithNameMappings", "sourceNameToRaw"));
        }
        if (!this.hasNameMappings()) {
            return null;
        }
        for (Map.Entry<String, String> entry : this.rawNameToSource.entrySet()) {
            if (!entry.getValue().equals(name)) continue;
            return entry.getKey();
        }
        return null;
    }
}

