/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.Url;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.PromiseManager;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.ScriptBase;
import org.jetbrains.debugger.ScriptManager;

public abstract class ScriptManagerBase<SCRIPT extends ScriptBase>
implements ScriptManager {
    private final PromiseManager<ScriptBase, String> scriptSourceLoader = new PromiseManager<ScriptBase, String>(ScriptBase.class){

        @NotNull
        public Promise<String> load(@NotNull ScriptBase script) {
            if (script == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/debugger/ScriptManagerBase$1", "load"));
            }
            Promise<String> promise = ScriptManagerBase.this.loadScriptSource(script);
            if (promise == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/ScriptManagerBase$1", "load"));
            }
            return promise;
        }
    };

    @NotNull
    protected abstract Promise<String> loadScriptSource(@NotNull SCRIPT var1);

    @Override
    @NotNull
    public Promise<String> getSource(@NotNull Script script) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/debugger/ScriptManagerBase", "getSource"));
        }
        if (!this.containsScript(script)) {
            Promise promise = Promise.reject((String)"No Script");
            if (promise == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/ScriptManagerBase", "getSource"));
            }
            return promise;
        }
        Promise promise = this.scriptSourceLoader.get((Object)((ScriptBase)script));
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/ScriptManagerBase", "getSource"));
        }
        return promise;
    }

    @Override
    public boolean hasSource(Script script) {
        return this.scriptSourceLoader.has((Object)((ScriptBase)script));
    }

    public void setSource(@NotNull SCRIPT script, @Nullable String source) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/debugger/ScriptManagerBase", "setSource"));
        }
        this.scriptSourceLoader.set(script, (Object)source);
    }

    @Override
    @Nullable
    public Promise<Void> getScriptSourceMapPromise(@NotNull Script script) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/debugger/ScriptManagerBase", "getScriptSourceMapPromise"));
        }
        return null;
    }

    @Override
    public Script forEachScript(@NotNull CommonProcessors.FindProcessor<Script> scriptProcessor) {
        if (scriptProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptProcessor", "org/jetbrains/debugger/ScriptManagerBase", "forEachScript"));
        }
        this.forEachScript((Processor<Script>)scriptProcessor);
        return (Script)scriptProcessor.getFoundValue();
    }

    public static boolean isSpecial(@NotNull Url url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/debugger/ScriptManagerBase", "isSpecial"));
        }
        return !url.isInLocalFileSystem() && (url.getScheme() == null || url.getScheme().equals("vm") || url.getAuthority() == null);
    }

    @Override
    @Nullable
    public Script findScriptById(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/debugger/ScriptManagerBase", "findScriptById"));
        }
        return null;
    }
}

