/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.google.gson.Gson;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.RefreshSession;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.Consumer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.ide.RestService;

class OpenFileHttpService
extends RestService {
    private static final RuntimeException NOT_FOUND = Promise.createError((String)"not found");
    private static final Pattern LINE_AND_COLUMN = Pattern.compile("^(.*?)(?::(\\d+))?(?::(\\d+))?$");
    private volatile long refreshSessionId = 0L;
    private final ConcurrentLinkedQueue<OpenFileTask> requests = new ConcurrentLinkedQueue();

    OpenFileHttpService() {
    }

    @Override
    @NotNull
    protected String getServiceName() {
        if ("file" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/ide/OpenFileHttpService", "getServiceName"));
        }
        return "file";
    }

    @Override
    protected boolean isMethodSupported(@NotNull HttpMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/ide/OpenFileHttpService", "isMethodSupported"));
        }
        return method == HttpMethod.GET || method == HttpMethod.POST;
    }

    @Override
    @Nullable
    public String execute(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) throws IOException {
        OpenFileRequest apiRequest;
        if (urlDecoder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlDecoder", "org/jetbrains/ide/OpenFileHttpService", "execute"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/ide/OpenFileHttpService", "execute"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/ide/OpenFileHttpService", "execute"));
        }
        final boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)request);
        final Channel channel = context.channel();
        if (request.method() == HttpMethod.POST) {
            apiRequest = (OpenFileRequest)((Gson)this.gson.getValue()).fromJson(OpenFileHttpService.createJsonReader(request), OpenFileRequest.class);
        } else {
            apiRequest = new OpenFileRequest();
            apiRequest.file = StringUtil.nullize((String)OpenFileHttpService.getStringParameter("file", urlDecoder), (boolean)true);
            apiRequest.line = OpenFileHttpService.getIntParameter("line", urlDecoder);
            apiRequest.column = OpenFileHttpService.getIntParameter("column", urlDecoder);
            apiRequest.focused = OpenFileHttpService.getBooleanParameter("focused", urlDecoder, true);
        }
        int prefixLength = 1 + "api".length() + 1 + this.getServiceName().length() + 1;
        String path = urlDecoder.path();
        if (path.length() > prefixLength) {
            Matcher matcher = LINE_AND_COLUMN.matcher(path).region(prefixLength, path.length());
            LOG.assertTrue(matcher.matches());
            if (apiRequest.file == null) {
                apiRequest.file = matcher.group(1).trim();
            }
            if (apiRequest.line == -1) {
                apiRequest.line = StringUtilRt.parseInt((String)matcher.group(2), (int)1);
            }
            if (apiRequest.column == -1) {
                apiRequest.column = StringUtilRt.parseInt((String)matcher.group(3), (int)1);
            }
        }
        if (apiRequest.file == null) {
            OpenFileHttpService.sendStatus(HttpResponseStatus.BAD_REQUEST, keepAlive, channel);
            return null;
        }
        this.openFile(apiRequest).done((Consumer)new Consumer<Void>(){

            public void consume(Void aVoid) {
                RestService.sendStatus(HttpResponseStatus.OK, keepAlive, channel);
            }
        }).rejected((Consumer)new Consumer<Throwable>(){

            public void consume(Throwable throwable) {
                if (throwable == NOT_FOUND) {
                    RestService.sendStatus(HttpResponseStatus.NOT_FOUND, keepAlive, channel);
                } else {
                    RestService.sendStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR, keepAlive, channel);
                    RestService.LOG.error(throwable);
                }
            }
        });
        return null;
    }

    private static void navigate(@Nullable Project project, @NotNull VirtualFile file, @NotNull OpenFileRequest request) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/ide/OpenFileHttpService", "navigate"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/ide/OpenFileHttpService", "navigate"));
        }
        if (project == null && (project = OpenFileHttpService.getLastFocusedOrOpenedProject()) == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        new OpenFileDescriptor(project, file, request.line, request.column).navigate(true);
        if (request.focused) {
            ProjectUtil.focusProjectWindow(project, true);
        }
    }

    @NotNull
    Promise<Void> openFile(@NotNull OpenFileRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/ide/OpenFileHttpService", "openFile"));
        }
        String path = FileUtil.expandUserHome((String)request.file);
        File file = new File(FileUtil.toSystemDependentName((String)path));
        if (file.isAbsolute()) {
            Promise<Void> promise = OpenFileHttpService.openAbsolutePath(file, request);
            if (promise == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/ide/OpenFileHttpService", "openFile"));
            }
            return promise;
        }
        RefreshQueue queue = RefreshQueue.getInstance();
        queue.cancelSession(this.refreshSessionId);
        OpenFileTask task = new OpenFileTask(FileUtil.toCanonicalPath((String)FileUtil.toSystemIndependentName((String)path), (char)'/'), request);
        this.requests.offer(task);
        RefreshSession session = queue.createSession(true, true, new Runnable(){

            @Override
            public void run() {
                OpenFileTask task;
                while ((task = (OpenFileTask)OpenFileHttpService.this.requests.poll()) != null) {
                    try {
                        if (OpenFileHttpService.openRelativePath(task.path, task.request)) {
                            task.promise.setResult(null);
                            continue;
                        }
                        task.promise.setError((Throwable)NOT_FOUND);
                    }
                    catch (Throwable e) {
                        task.promise.setError(e);
                    }
                }
            }
        }, ModalityState.NON_MODAL);
        session.addAllFiles(ManagingFS.getInstance().getLocalRoots());
        this.refreshSessionId = session.getId();
        session.launch();
        AsyncPromise<Void> asyncPromise = task.promise;
        if (asyncPromise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/ide/OpenFileHttpService", "openFile"));
        }
        return asyncPromise;
    }

    private static boolean openRelativePath(@NotNull String path, final @NotNull OpenFileRequest request) {
        Project[] projects;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/ide/OpenFileHttpService", "openRelativePath"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/ide/OpenFileHttpService", "openRelativePath"));
        }
        VirtualFile virtualFile = null;
        Project project = null;
        for (Project openedProject : projects = ProjectManager.getInstance().getOpenProjects()) {
            VirtualFile openedProjectBaseDir = openedProject.getBaseDir();
            if (openedProjectBaseDir != null) {
                virtualFile = openedProjectBaseDir.findFileByRelativePath(path);
            }
            if (virtualFile == null) {
                virtualFile = WebServerPathToFileManager.getInstance(openedProject).findVirtualFile(path);
            }
            if (virtualFile == null) continue;
            project = openedProject;
            break;
        }
        if (virtualFile == null) {
            block1: for (Project openedProject : projects) {
                for (VcsRoot vcsRoot : ProjectLevelVcsManager.getInstance((Project)openedProject).getAllVcsRoots()) {
                    VirtualFile root = vcsRoot.getPath();
                    if (root == null || (virtualFile = root.findFileByRelativePath(path)) == null) continue;
                    project = openedProject;
                    continue block1;
                }
            }
        }
        if (virtualFile == null) {
            return false;
        }
        final Project finalProject = project;
        final VirtualFile finalVirtualFile = virtualFile;
        AppUIUtil.invokeLaterIfProjectAlive(project, new Runnable(){

            @Override
            public void run() {
                OpenFileHttpService.navigate(finalProject, finalVirtualFile, request);
            }
        });
        return true;
    }

    @NotNull
    private static Promise<Void> openAbsolutePath(final @NotNull File file, final @NotNull OpenFileRequest request) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/ide/OpenFileHttpService", "openAbsolutePath"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/ide/OpenFileHttpService", "openAbsolutePath"));
        }
        if (!file.exists()) {
            Promise promise = Promise.reject((Throwable)NOT_FOUND);
            if (promise == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/ide/OpenFileHttpService", "openAbsolutePath"));
            }
            return promise;
        }
        final AsyncPromise promise = new AsyncPromise();
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    VirtualFile virtualFile;
                    AccessToken token = WriteAction.start();
                    try {
                        virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
                    }
                    finally {
                        token.finish();
                    }
                    if (virtualFile == null) {
                        promise.setError((Throwable)NOT_FOUND);
                    } else {
                        OpenFileHttpService.navigate(com.intellij.openapi.project.ProjectUtil.guessProjectForContentFile((VirtualFile)virtualFile), virtualFile, request);
                        promise.setResult(null);
                    }
                }
                catch (Throwable e) {
                    promise.setError(e);
                }
            }
        });
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/ide/OpenFileHttpService", "openAbsolutePath"));
        }
        return asyncPromise;
    }

    static final class OpenFileRequest {
        public String file;
        public int line;
        public int column;
        public boolean focused = true;

        OpenFileRequest() {
        }
    }

    private static final class OpenFileTask {
        final String path;
        final OpenFileRequest request;
        final AsyncPromise<Void> promise;

        OpenFileTask(@NotNull String path, @NotNull OpenFileRequest request) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/ide/OpenFileHttpService$OpenFileTask", "<init>"));
            }
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/ide/OpenFileHttpService$OpenFileTask", "<init>"));
            }
            this.promise = new AsyncPromise();
            this.path = path;
            this.request = request;
        }
    }
}

