/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.NotNullProducer;
import com.intellij.util.net.NetUtils;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;
import org.jetbrains.io.ChannelRegistrar;
import org.jetbrains.io.DelegatingHttpRequestHandler;
import org.jetbrains.io.NettyUtil;
import org.jetbrains.io.PortUnificationServerHandler;

public class BuiltInServer
implements Disposable {
    static final Logger LOG = Logger.getInstance(BuiltInServer.class);
    private static final int[] FORBIDDEN_PORTS = new int[]{6953, 6969, 6970};
    private final ChannelRegistrar channelRegistrar;
    private final boolean isOwnerOfEventLoopGroup;
    private final EventLoopGroup eventLoopGroup;
    private final int port;

    public boolean isRunning() {
        return !this.channelRegistrar.isEmpty();
    }

    private BuiltInServer(@NotNull EventLoopGroup eventLoopGroup, int port, boolean isOwnerOfEventLoopGroup) {
        if (eventLoopGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventLoopGroup", "org/jetbrains/io/BuiltInServer", "<init>"));
        }
        this.channelRegistrar = new ChannelRegistrar();
        this.eventLoopGroup = eventLoopGroup;
        this.port = port;
        this.isOwnerOfEventLoopGroup = isOwnerOfEventLoopGroup;
    }

    @NotNull
    public static BuiltInServer start(int workerCount, int firstPort, int portsCount, boolean tryAnyPort, @Nullable NotNullProducer<ChannelHandler> channelHandler) throws Throwable {
        BuiltInServer builtInServer = BuiltInServer.start((EventLoopGroup)new NioEventLoopGroup(workerCount, (Executor)PooledThreadExecutor.INSTANCE), true, firstPort, portsCount, tryAnyPort, channelHandler);
        if (builtInServer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/io/BuiltInServer", "start"));
        }
        return builtInServer;
    }

    @NotNull
    public static BuiltInServer start(@NotNull EventLoopGroup eventLoopGroup, boolean isOwnerOfEventLoopGroup, int firstPort, int portsCount, boolean tryAnyPort, @Nullable NotNullProducer<ChannelHandler> channelHandler) throws Throwable {
        if (eventLoopGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventLoopGroup", "org/jetbrains/io/BuiltInServer", "start"));
        }
        ChannelRegistrar channelRegistrar = new ChannelRegistrar();
        ServerBootstrap bootstrap = NettyUtil.nioServerBootstrap(eventLoopGroup);
        BuiltInServer.configureChildHandler(bootstrap, channelRegistrar, channelHandler);
        BuiltInServer builtInServer = new BuiltInServer(eventLoopGroup, BuiltInServer.bind(firstPort, portsCount, tryAnyPort, bootstrap, channelRegistrar), isOwnerOfEventLoopGroup);
        if (builtInServer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/io/BuiltInServer", "start"));
        }
        return builtInServer;
    }

    public int getPort() {
        return this.port;
    }

    @NotNull
    public EventLoopGroup getEventLoopGroup() {
        EventLoopGroup eventLoopGroup = this.eventLoopGroup;
        if (eventLoopGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/io/BuiltInServer", "getEventLoopGroup"));
        }
        return eventLoopGroup;
    }

    static void configureChildHandler(@NotNull ServerBootstrap bootstrap, final @NotNull ChannelRegistrar channelRegistrar, final @Nullable NotNullProducer<ChannelHandler> channelHandler) {
        if (bootstrap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bootstrap", "org/jetbrains/io/BuiltInServer", "configureChildHandler"));
        }
        if (channelRegistrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channelRegistrar", "org/jetbrains/io/BuiltInServer", "configureChildHandler"));
        }
        final PortUnificationServerHandler portUnificationServerHandler = channelHandler == null ? new PortUnificationServerHandler() : null;
        bootstrap.childHandler((ChannelHandler)new ChannelInitializer(){

            protected void initChannel(Channel channel) throws Exception {
                channel.pipeline().addLast(new ChannelHandler[]{channelRegistrar, channelHandler == null ? portUnificationServerHandler : (ChannelHandler)channelHandler.produce()});
            }
        });
    }

    public static boolean isPortForbidden(int port) {
        for (int forbiddenPort : FORBIDDEN_PORTS) {
            if (port != forbiddenPort) continue;
            return true;
        }
        return false;
    }

    private static int bind(int firstPort, int portsCount, boolean tryAnyPort, @NotNull ServerBootstrap bootstrap, @NotNull ChannelRegistrar channelRegistrar) throws Throwable {
        if (bootstrap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bootstrap", "org/jetbrains/io/BuiltInServer", "bind"));
        }
        if (channelRegistrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channelRegistrar", "org/jetbrains/io/BuiltInServer", "bind"));
        }
        InetAddress loopbackAddress = NetUtils.getLoopbackAddress();
        for (int i = 0; i < portsCount; ++i) {
            int port = firstPort + i;
            if (BuiltInServer.isPortForbidden(i)) continue;
            ChannelFuture future2 = bootstrap.bind(loopbackAddress, port).awaitUninterruptibly();
            if (future2.isSuccess()) {
                channelRegistrar.add(future2.channel());
                return port;
            }
            if (tryAnyPort || i != portsCount - 1) continue;
            throw future2.cause();
        }
        LOG.info("We cannot bind to our default range, so, try to bind to any free port");
        ChannelFuture future3 = bootstrap.bind(loopbackAddress, 0).awaitUninterruptibly();
        if (future3.isSuccess()) {
            channelRegistrar.add(future3.channel());
            return ((InetSocketAddress)future3.channel().localAddress()).getPort();
        }
        throw future3.cause();
    }

    public void dispose() {
        this.channelRegistrar.close(this.isOwnerOfEventLoopGroup);
        LOG.info("web server stopped");
    }

    public static void replaceDefaultHandler(@NotNull ChannelHandlerContext context, @NotNull ChannelHandler channelHandler) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/io/BuiltInServer", "replaceDefaultHandler"));
        }
        if (channelHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channelHandler", "org/jetbrains/io/BuiltInServer", "replaceDefaultHandler"));
        }
        context.pipeline().replace(DelegatingHttpRequestHandler.class, "replacedDefaultHandler", channelHandler);
    }
}

