/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.fastCgi;

import com.intellij.util.Consumer;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.CharsetUtil;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.Decoder;
import org.jetbrains.io.fastCgi.FastCgiConstants;
import org.jetbrains.io.fastCgi.FastCgiDecoder;
import org.jetbrains.io.fastCgi.FastCgiDecoder$WhenMappings;
import org.jetbrains.io.fastCgi.FastCgiService;
import org.jetbrains.io.fastCgi.FastCgiServiceKt;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\u000e\n)qa)Y:u\u0007\u001eLG)Z2pI\u0016\u0014(bA8sO*I!.\u001a;ce\u0006Lgn\u001d\u0006\u0003S>TqAZ1ti\u000e;\u0017NC\u0004EK\u000e|G-\u001a:\u000b'\u0019+H\u000e\\'fgN\fw-Z\"p]N,X.\u001a:\u000b\tY{\u0017\u000e\u001a\u0006\u0005U\u00064\u0018M\u0003\u0003mC:<'B\u0002\u001fj]&$hHC\nfeJ|'oT;uaV$8i\u001c8tk6,'O\u0003\u0005D_:\u001cX/\\3s\u0015\r\u0019w.\u001c\u0006\tS:$X\r\u001c7jU*!Q\u000f^5m\u0015\u0019\u0019FO]5oO*11n\u001c;mS:TqB]3ta>t7/\u001a%b]\u0012dWM\u001d\u0006\u000f\r\u0006\u001cHoQ4j'\u0016\u0014h/[2f\u00155\u0019wN\u001c;f]RdUM\\4uQ*\u0019\u0011J\u001c;\u000b\u0017\u0011\fG/\u0019\"vM\u001a,'o\u001d\u0006\u0012)&sGo\u00142kK\u000e$\b*Y:i\u001b\u0006\u0004(bA4ok*)AO]8wK*9!)\u001f;f\u0005V4'\"\u00028fiRL(B\u00022vM\u001a,'O\u0003\u0002jI*i\u0001/\u00193eS:<G*\u001a8hi\"TQa\u001d;bi\u0016TQa\u0015;bi\u0016TACR1ti\u000e;\u0017\u000eR3d_\u0012,'\u000fJ*uCR,'\u0002\u0002;za\u0016Tqb\u00195b]:,G.\u00138bGRLg/\u001a\u0006\bG>tG/\u001a=u\u0015U\u0019\u0005.\u00198oK2D\u0015M\u001c3mKJ\u001cuN\u001c;fqRTqa\u00195b]:,GN\u0003\u0003V]&$(bD2p]R,g\u000e\u001e*fG\u0016Lg/\u001a3\u000b!%\u001c8)^7vY\u0006$XMQ;gM\u0016\u0014(b\u0002\"p_2,\u0017M\u001c\u0006\rI\u0016\u001cw\u000eZ3IK\u0006$WM\u001d\u0006\u0010[\u0016\u001c8/Y4f%\u0016\u001cW-\u001b<fI*)\u0011N\u001c9vi*q\u0001K]8u_\u000e|Gn\u0015;biV\u001c(B\u0003*fG>\u0014H\rV=qK:\u0010!B\u0001\t\u0002\u0015\u0011A\u0001\u0001\u0005\u0002\u000b\t!\t\u0001c\u0001\u0006\u0005\u0011\t\u0001BA\u0003\u0004\t\u0007A\u0001\u0001\u0004\u0001\u0006\u0007\u0011\t\u0001R\u0001\u0007\u0001\u000b\r!)\u0001C\u0002\r\u0001\u0015\t\u0001\u0002B\u0003\u0003\t\u000fAI!B\u0002\u0005\t!\u001dA\u0002A\u0003\u0002\u0011\u001b)!\u0001B\u0003\t\u000f\u0015\u0011A1\u0002E\b\u000b\r!a\u0001\u0003\u0004\r\u0001\u0015\t\u0001\u0012C\u0003\u0004\t\u001dA\u0001\u0002\u0004\u0001\u0006\u0007\u0011\r\u00012\u0003\u0007\u0001\u000b\t!a\u0001\u0003\u0004\u0006\u0005\u0011\r\u00012C\u0003\u0004\t\u001dA)\u0002\u0004\u0001\u0006\u0003!aQA\u0001\u0003\u000b\u00113)1\u0001\"\u0006\t\u00181\u0001Q!\u0001E\u0002\u000b\t!9\u0002c\u0007\u0006\u0005\u0011a\u0001BD\u0003\u0004\t3AQ\u0002\u0004\u0001\u0006\u0005\u0011U\u0001rC\u0003\u0004\t\tA\u0001\u0003\u0004\u0001\u0006\u0005\u0011\r\u0001\u0012E\u0003\u0003\t1A1#B\u0002\u0005\u001f!\u0015B\u0002A\u0003\u0004\t\u001dA9\u0003\u0004\u0001\u0006\u0005\u0011y\u0001RE\u0003\u0004\t\u001dAQ\u0003\u0004\u0001\u0006\u0005\u0011!\u0001rA\u0003\u0003\t3AQ\u0002B\u0002\r\u0005e\u0019Q!\u0001E\u00031\u000bI\u0002\"B\u0001\t\u0007%!\u0011bA\u0003\u0002\u0011\u0013AJ\u0001G\u0002\u001e\u0004]=\u0002#\f\u0007\u0005\u00034A\"\"I\u0002\u0006\u0003!M\u00014C+\u0004\t\u0015\u0019AAC\u0005\u0002\t\u000bi\u0013\u0003B1\u00051-\t\u0003\"B\u0001\t\u0017%!\u0011bA\u0003\u0002\u00115AR\u0002G\u0006V\u0007\u0011)1\u0001B\u0006\n\u0003!mQ&\u0005\u0003b\ta-\u0011\u0005C\u0003\u0002\u0011\u001bIA!C\u0002\u0006\u0003!=\u0001t\u0002M\u0007+\u000e!Qa\u0001C\u0006\u0013\u0005A\t\"\f\u0007\u0005\u00034Aj\"I\u0002\u0006\u0003!M\u00014C+\u0004\t\u0015\u0019AQD\u0005\u0002\t\u000biC\u0002Ba\r1=\t3!B\u0001\t\u0014aMQk\u0001\u0003\u0006\u0007\u0011y\u0011\"\u0001C\u0003[1!\u0011\r\u0002\r\nC\r)\u0011\u0001\u0003\u0005\u0019\u0011U\u001bA!B\u0002\u0005\u0013%\t\u0001\"C\u0017\r\t\u0005g\u0001tD\u0011\u0004\u000b\u0005Aa\u0002\u0007\bV\u0007\u0011)1\u0001b\b\n\u0003!uQ\u0006\u0004\u0003B\u001aa\t\u0012eA\u0003\u0002\u0011'A\u001a\"V\u0002\u0005\u000b\r!\u0011#C\u0001\u0005\u00065*Ba\u0003M\u0012;\u001f!\u0001\u0001\u0003\n\u000e\u0007\u0015\t\u0001r\u0004M\u0010!\u000e\u0001\u0011eA\u0003\u0002\u0011AA\u0002#U\u0002\u0006\tGI\u0011\u0001\u0002\u0001\u000e\u0003!\u0005Rf\u000b\u0003\f1Qiz\u0001\u0002\u0001\t\u001d5\u0019Q!\u0001\u0005\u000e15\u00016\u0001AO\b\t\u0001A!#D\u0002\u0006\u0003!}\u0001t\u0004)\u0004\u0002u=A\u0001\u0001E\u0015\u001b\r)\u0011\u0001C\t\u0019#A\u001b\u0011!\t\u0003\u0006\u0003!%A\u0012\u0001M\u0005#\u000eIA\u0001F\u0005\u0002\u0011Gi\u0011\u0001\u0003\n\u000e\u0003!\u0005R\"\u0001C\u0001[U!\u0011\u0001g\u000b\u001e\u0010\u0011\u0001\u0001BD\u0007\u0004\u000b\u0005AQ\u0002G\u0007Q\u0007\u0001\t3!B\u0001\t!a\u0001\u0012kA\u0003\u0005,%\tA\u0001A\u0007\u0002\u0011Ii{\u0004\u0002\u0006\u0019-u=A\u0001\u0001\u0005\u0013\u001b\r)\u0011\u0001c\b\u0019 A\u001b\u0001!h\u0004\u0005\u0001!5RbA\u0003\u0002\u00115AR\u0002UB\u0001C\r)\u0011\u0001\u0003\t\u0019!E\u001bq\u0001\u0002\f\n\u0003\u0011\u0001Q\"\u0001E\u0011\u001b\u0005A!#\u000e\u0014\u0006K\u0011\u0019\u000f\u0001G\u0003\u001e\u001a\u0011\u0001\u00012B\u0007\t\u000b\u0005Ai!\u0003\u0003\n\u0007\u0015\t\u0001r\u0002M\b1\u001b\u00016\u0001AO\b\t\u0001A\u0011\"D\u0002\u0006\u0003!A\u0001\u0004\u0003)\u0004\u0002\u0005\u001aQ!\u0001\u0005\u00031\t\t6a\u0002\u0003\u0006\u0013\u0005!\u0001!D\u0001\t\u00125\t\u0001\"\u0003"})
public final class FastCgiDecoder
extends Decoder
implements Decoder.FullMessageConsumer<Void> {
    public static final /* synthetic */ KClass $kotlinClass;
    private State state;
    private int type;
    private int id;
    private int contentLength;
    private int paddingLength;
    private final TIntObjectHashMap<ByteBuf> dataBuffers;
    private final Consumer<String> errorOutputConsumer;
    private final FastCgiService responseHandler;

    static {
        $kotlinClass = Reflection.createKotlinClass(FastCgiDecoder.class);
    }

    @Override
    protected void messageReceived(@NotNull ChannelHandlerContext context, @NotNull ByteBuf input) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        while (true) {
            switch (FastCgiDecoder$WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    ByteBuf buffer;
                    if (this.paddingLength > 0) {
                        if (input.readableBytes() > this.paddingLength) {
                            input.skipBytes(this.paddingLength);
                            this.paddingLength = 0;
                        } else {
                            this.paddingLength -= input.readableBytes();
                            input.skipBytes(input.readableBytes());
                            return;
                        }
                    }
                    if (this.getBufferIfSufficient(input, FastCgiConstants.HEADER_LENGTH, context) == null) {
                        return;
                    }
                    ByteBuf byteBuf = buffer;
                    Intrinsics.checkExpressionValueIsNotNull((Object)byteBuf, (String)"buffer");
                    this.decodeHeader(byteBuf);
                    this.state = State.CONTENT;
                    if (this.contentLength > 0) {
                        this.readContent(input, context, this.contentLength, this);
                    }
                    this.state = State.HEADER;
                    break;
                }
                case 2: {
                    if (this.contentLength > 0) {
                        this.readContent(input, context, this.contentLength, this);
                    }
                    this.state = State.HEADER;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelInactive(@NotNull ChannelHandlerContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        try {
            if (!this.dataBuffers.isEmpty()) {
                this.dataBuffers.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<ByteBuf>(){
                    public static final /* synthetic */ KClass $kotlinClass;

                    static {
                        $kotlinClass = Reflection.createKotlinClass(channelInactive.1.class);
                    }

                    public boolean execute(int a, @NotNull ByteBuf buffer) {
                        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
                        try {
                            buffer.release();
                        }
                        catch (Throwable e) {
                            FastCgiServiceKt.getLOG().error(e);
                        }
                        return true;
                    }
                });
                this.dataBuffers.clear();
            }
        }
        finally {
            super.channelInactive(context);
        }
    }

    private final void decodeHeader(ByteBuf buffer) {
        buffer.skipBytes(1);
        this.type = buffer.readUnsignedByte();
        this.id = buffer.readUnsignedShort();
        this.contentLength = buffer.readUnsignedShort();
        this.paddingLength = buffer.readUnsignedByte();
        buffer.skipBytes(1);
    }

    @Override
    @Nullable
    public Void contentReceived(@NotNull ByteBuf buffer, @NotNull ChannelHandlerContext context, boolean isCumulateBuffer) {
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        switch (this.type) {
            case 3: {
                int appStatus = buffer.readInt();
                short protocolStatus = buffer.readUnsignedByte();
                if (appStatus != 0 || protocolStatus != ProtocolStatus.REQUEST_COMPLETE.ordinal()) {
                    FastCgiServiceKt.getLOG().warn("Protocol status " + protocolStatus);
                    this.dataBuffers.remove(this.id);
                    this.responseHandler.responseReceived(this.id, null);
                    break;
                }
                if (protocolStatus != ProtocolStatus.REQUEST_COMPLETE.ordinal()) break;
                this.responseHandler.responseReceived(this.id, (ByteBuf)this.dataBuffers.remove(this.id));
                break;
            }
            case 6: {
                ByteBuf sliced;
                ByteBuf data = (ByteBuf)this.dataBuffers.get(this.id);
                ByteBuf byteBuf = sliced = isCumulateBuffer ? buffer : buffer.slice(buffer.readerIndex(), this.contentLength);
                if (data == null) {
                    this.dataBuffers.put(this.id, (Object)sliced);
                } else if (data instanceof CompositeByteBuf) {
                    ((CompositeByteBuf)data).addComponent(sliced);
                    ((CompositeByteBuf)data).writerIndex(((CompositeByteBuf)data).writerIndex() + sliced.readableBytes());
                } else {
                    if (sliced instanceof CompositeByteBuf) {
                        data = (ByteBuf)((CompositeByteBuf)sliced).addComponent(0, data);
                        ((CompositeByteBuf)data).writerIndex(((CompositeByteBuf)data).writerIndex() + ((CompositeByteBuf)data).readableBytes());
                    } else {
                        int newLength = data.readableBytes() + sliced.readableBytes();
                        data = (ByteBuf)context.alloc().compositeBuffer(Decoder.DEFAULT_MAX_COMPOSITE_BUFFER_COMPONENTS).addComponents(new ByteBuf[]{data, sliced});
                        ((CompositeByteBuf)data).writerIndex(((CompositeByteBuf)data).writerIndex() + newLength);
                    }
                    this.dataBuffers.put(this.id, (Object)data);
                }
                sliced.retain();
                break;
            }
            case 7: {
                try {
                    this.errorOutputConsumer.consume((Object)buffer.toString(buffer.readerIndex(), this.contentLength, CharsetUtil.UTF_8));
                }
                catch (Throwable e) {
                    FastCgiServiceKt.getLOG().error(e);
                }
                break;
            }
            default: {
                FastCgiServiceKt.getLOG().error("Unknown type " + this.type);
            }
        }
        return null;
    }

    public FastCgiDecoder(@NotNull Consumer<String> errorOutputConsumer, @NotNull FastCgiService responseHandler) {
        Intrinsics.checkParameterIsNotNull(errorOutputConsumer, (String)"errorOutputConsumer");
        Intrinsics.checkParameterIsNotNull((Object)responseHandler, (String)"responseHandler");
        this.errorOutputConsumer = errorOutputConsumer;
        this.responseHandler = responseHandler;
        this.state = State.HEADER;
        this.dataBuffers = new TIntObjectHashMap();
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"p\u0015\u0015\u0019F/\u0019;f\u001591\u0015m\u001d;DO&$UmY8eKJT1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0002j_*9a-Y:u\u0007\u001eL'\u0002B#ok6Taa[8uY&t'B\u0002\u001fj]&$hH\u0003\u0003kCZ\f'\u0002\u00027b]\u001eTaa\u0015;sS:<'B\u0002%F\u0003\u0012+%KC\u0004D\u001f:#VI\u0014+C\u0015\t\u0001\"A\u0003\u0003\t\u0001A\u0019!\u0002\u0002\u0005\u0002!\u0011QA\u0001\u0003\u0002\u0011\u000b)1\u0001b\u0001\t\u00021\u0001Qa\u0001\u0003\u0003\u0011\u0001a\u0001!B\u0001\t\b\u0015\u0019Aa\u0001\u0005\u0004\u0019\u0001)\u0011\u0001#\u0003\u0006\u0005\u0011!\u0001\"B\u0003\u0003\t\u0013AY\u0001Ba\u0001\u0019\u000bI\u0002\"B\u0001\t\b%!\u0011bA\u0003\u0002\u0011\u000bA*\u0001g\u00022\u0003\u00195Q\u0007E\u0003\u0010\t\u0005\b\u0001\u0004B\u0011\u0004\u000b\u0005A)\u0001'\u0002R\u0007\u001d!A!C\u0001\u0005\u00015\t\u0001\"B\u0007\u0002\t\u000b\u0001"})
    private static final class State
    extends Enum<State> {
        public static final /* synthetic */ KClass $kotlinClass;
        public static final /* enum */ State HEADER;
        public static final /* enum */ State CONTENT;
        private static final /* synthetic */ State[] $VALUES;

        static {
            $kotlinClass = Reflection.createKotlinClass(State.class);
            State[] stateArray = new State[2];
            State[] stateArray2 = stateArray;
            stateArray[0] = HEADER = new State();
            stateArray[1] = CONTENT = new State();
            $VALUES = stateArray;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"#\u0004)q\u0001K]8u_\u000e|Gn\u0015;biV\u001c(B\u0004$bgR\u001cu-\u001b#fG>$WM\u001d\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\tIwNC\u0004gCN$8iZ5\u000b\t\u0015sW/\u001c\u0006\u0007W>$H.\u001b8\u000b\rqJg.\u001b;?\u0015\u0011Q\u0017M^1\u000b\t1\fgn\u001a\u0006\u0007'R\u0014\u0018N\\4\u000b!I+\u0015+V#T)~\u001bu*\u0014)M\u000bR+%\"D\"B\u001dR{V\n\u0015-`\u0007>seJ\u0003\u0006P-\u0016\u0013FjT!E\u000b\u0012SA\"\u0016(L\u001d>;fj\u0018*P\u0019\u0016\u0013%B\u0001\t\u0003\u0015\u0011A\u0001\u0001E\u0002\u000b\t!\t\u0001\u0003\u0002\u0006\u0005\u0011\t\u0001RA\u0003\u0004\t\u0007A\t\u0001\u0004\u0001\u0006\u0007\u0011\u0011\u0001\u0002\u0001\u0007\u0001\u000b\u0005A9!B\u0002\u0005\u0007!\u0019A\u0002A\u0003\u0002\u0011\u0013)!\u0001\u0002\u0003\t\u000b\u0015\u0011A\u0011\u0002E\u0006\t\u0005\u0007ARA\r\t\u000b\u0005A9!\u0003\u0003\n\u0007\u0015\t\u0001R\u0001M\u00031\u000f\t$A\"\u0004\b\u0010U\u0002Ra\u0004\u0003b\u0002a!\u0011eA\u0003\u0002\u0011\u000bA*!U\u0002\b\t\u0011I\u0011\u0001\u0002\u0001\u000e\u0003!)Q\"\u0001C\u0003"})
    private static final class ProtocolStatus
    extends Enum<ProtocolStatus> {
        public static final /* synthetic */ KClass $kotlinClass;
        public static final /* enum */ ProtocolStatus REQUEST_COMPLETE;
        public static final /* enum */ ProtocolStatus CANT_MPX_CONN;
        public static final /* enum */ ProtocolStatus OVERLOADED;
        public static final /* enum */ ProtocolStatus UNKNOWN_ROLE;
        private static final /* synthetic */ ProtocolStatus[] $VALUES;

        static {
            $kotlinClass = Reflection.createKotlinClass(ProtocolStatus.class);
            ProtocolStatus[] protocolStatusArray = new ProtocolStatus[4];
            ProtocolStatus[] protocolStatusArray2 = protocolStatusArray;
            protocolStatusArray[0] = REQUEST_COMPLETE = new ProtocolStatus();
            protocolStatusArray[1] = CANT_MPX_CONN = new ProtocolStatus();
            protocolStatusArray[2] = OVERLOADED = new ProtocolStatus();
            protocolStatusArray[3] = UNKNOWN_ROLE = new ProtocolStatus();
            $VALUES = protocolStatusArray;
        }

        public static ProtocolStatus[] values() {
            return (ProtocolStatus[])$VALUES.clone();
        }

        public static ProtocolStatus valueOf(String string) {
            return Enum.valueOf(ProtocolStatus.class, string);
        }
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\u000f\u0004)Q!+Z2pe\u0012$\u0016\u0010]3\u000b\u001d\u0019\u000b7\u000f^\"hS\u0012+7m\u001c3fe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BA5p\u0015\u001d1\u0017m\u001d;DO&T1!\u00118z\u0015\u0019Yw\u000e\u001e7j]*YQI\u0014#`%\u0016\u000bV+R*U\u0015\rIe\u000e\u001e\u0006\u000fO\u0016$XI\u0014#`%\u0016\u000bV+R*U\u0015\u0019\u0019F\u000bR#S%*Iq-\u001a;T)\u0012+%K\u0015\u0006\u0007'R#u*\u0016+\u000b\u0013\u001d,Go\u0015+E\u001fV#&H\u0003\u0002\u0011\u0005)!\u0001\u0002\u0001\t\u0004\u0015\u0011A\u0011\u0001\u0005\u0003\u000b\t!\u0011\u0001#\u0002\u0006\u0007\u0011\r\u0001\u0012\u0001\u0007\u0001\u000b\r!!\u0001\u0003\u0001\r\u0001\u0015\t\u0001rA\u0003\u0004\t\rA1\u0001\u0004\u0001\u0006\u0007\u0011\u0019\u0001\u0012\u0002\u0007\u0001\t\r\fARA\r\u0004\u000b\u0005A9\u0001g\u0002.!\u0011\u0019G\u0003\u0007\u0003\"\u0007\u0015\t\u0001\u0002\u0002\r\u0005+\u000eAQa\u0001\u0003\u0005\u0013\u0005!)!D\u0002\u0005\u000b%\tAQA\u0017\u0011\t\r$\u00024B\u0011\u0004\u000b\u0005AA\u0001\u0007\u0003V\u0007!)1\u0001b\u0003\n\u0003\u0011\u0015Qb\u0001\u0003\u0007\u0013\u0005!)!\f\t\u0005GRAj!I\u0002\u0006\u0003!!\u0001\u0004B+\u0004\u0011\u0015\u0019AQB\u0005\u0002\t\u000bi1\u0001B\u0004\n\u0003\u0011\u0015Q\u0007\u0001"})
    public static final class RecordType {
        public static final /* synthetic */ KClass $kotlinClass;
        public static final int END_REQUEST = 3;
        public static final int STDOUT = 6;
        public static final int STDERR = 7;
        public static final RecordType INSTANCE$;

        static {
            $kotlinClass = Reflection.createKotlinClass(RecordType.class);
            new RecordType();
        }

        public final int getEND_REQUEST() {
            return END_REQUEST;
        }

        public final int getSTDOUT() {
            return STDOUT;
        }

        public final int getSTDERR() {
            return STDERR;
        }

        RecordType() {
            INSTANCE$ = this;
            END_REQUEST = 3;
            STDOUT = 6;
            STDERR = 7;
        }
    }
}

