/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.util.concurrency;

import com.intellij.util.Consumer;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.util.concurrency.AsyncPromise;
import org.jetbrains.util.concurrency.DonePromise;
import org.jetbrains.util.concurrency.MessageError;
import org.jetbrains.util.concurrency.Promise;
import org.jetbrains.util.concurrency.RejectedPromise;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"\u0011\u0006)!Ai\u0014(F\u0015\u001d\u0001&o\\7jg\u0016T1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0003vi&d'bC2p]\u000e,(O]3oGfTqaZ3u\t>sUIC\u0005Qe>l\u0017n]3Li*A!+\u0012&F\u0007R+EIC\u0006hKR\u0014VIS#D)\u0016#%\"C5t!\u0016tG-\u001b8h\u0015\u001d\u0011un\u001c7fC:Taa[8uY&t'\u0002D4fi&\u001b\b+\u001a8eS:<'BC5t%\u0016TWm\u0019;fI*iq-\u001a;JgJ+'.Z2uK\u0012T\u0011\u0001\u0016\u0006\u0004\u0003:L(b\u0004*fU\u0016\u001cG/\u001a3Qe>l\u0017n]3\u000b\u000b\u0015\u0014(o\u001c:\u000b\rM#(/\u001b8h\u0015\u0011Q\u0017M^1\u000b\t1\fgn\u001a\u0006\u0010%\u0016\u001cx\u000e\u001c<fIB\u0013x.\\5tK*1!/Z:vYRTaa\u00142kK\u000e$(\"\u0003;p!J|W.[:f\u00151\t5/\u001f8d!J|W.[:f\r\u0007Q!\u0001\u0005\u0002\u000b\t!\u0001\u0001c\u0001\u0006\u0005\u0011\u0005\u0001BA\u0003\u0003\t\u0005A)!B\u0002\u0005\u0004!\u0005A\u0002A\u0003\u0003\t\u0007A\t!B\u0001\t\r\u0015\u0019Aa\u0001E\u0006\u0019\u0001)1\u0001B\u0002\t\u00121\u0001Qa\u0001\u0003\u0004\u0011)a\u0001!B\u0001\t\u0016\u0015\u0011A!\u0002\u0005\f\u000b\t!Y\u0001\u0003\u0006\u0006\u0005\u0011-\u0001\u0012D\u0003\u0003\t\u0003A)!B\u0002\u0005\u000f!\u0005A\u0002A\u0003\u0004\t\u0007AY\u0002\u0004\u0001\u0006\u0005\u0011\r\u00012D\u0003\u0003\t\u001dA\t!B\u0002\u0005\u000f!mA\u0002A\u0003\u0003\t\u001dAY\"b\n\u0005C\u0012A\u0002!I\u0003\u0006\u0003!\u0011\u0011\"\u0001C\u00021\t)6\u0001C\u0003\u0004\t\u0001I\u0011\u0001#\u0002\u000e\u0007\u0011\u0019\u0011\"\u0001E\u00031\u000e\u001dQq\u0005\u0003b\ta!\u0011%B\u0003\u0002\u0011\tI\u0011\u0001b\u0001\u0019\u0005U\u001b\u0001\"B\u0002\u0005\t%\t\u0001RA\u0007\u0004\t\u0013I\u0011\u0001#\u0002Y\u0007\u000f)i\u0003B2\u0005+\u0015)\u0011\u0001\u0003\u0002\n\u0003\u0011\r\u0001D\u0001\r\u0006C\r)\u0011\u0001c\u0002\u0019\b\u0011\u001aSk\u0001\u0004\u000e\u000b\u00115\u0011\"\u0001C\u0001\u001b\u0005A)\u0001WB\u0004\u000b[!1\rB\u000b\u0006\u000b\u0005A!!C\u0001\u0005\u0004a\u0011\u0001dB\u0011\u0004\u000b\u0005A9\u0001g\u0002%GU\u001ba!D\u0003\u0005\u0010%\tA\u0011A\u0007\u0002\u0011\u000bA6qAC%\t\r\tr\u0001\u0002\u0001\t\u0011U!Q!\u0001\u0005\u0005\u0019\u0003AB\u0001G\u0005\u001e\u0010\u0011\u0001\u00012C\u0007\u0004\u000b\u0005AI\u0001'\u0003Q\u0007\u0001\t\u0013\"B\u0001\t\u0005%)\u0011\u0002B\u0003\u0003\t\u0003A\u0001\u0001\b\u0001\u0019\u0005E\u001bQ\u0001B\u0005\n\u0003!\u0015Q\"\u0001\u0005\u00071\u000e\u001dQA\u0004\u0003\u00041/\tS!B\u0001\t\u0005%\tA1\u0001\r\u0003#\u000e\u0019AqC\u0005\u0002\u0011\u000bA6qAC&\t\r\tr\u0001\u0002\u0001\t\u0011U!Q!\u0001\u0005\u0005\u0019\u0003AB\u0001g\u0006\u001e\u0012\u0011\u0001\u0001\u0002D\u0007\u0005\u000b\t!\t\u0001\u0003\u0001\u001d\u0001A\u001b\u0001!I\u0005\u0006\u0003!\u0011\u0011\"B\u0005\u0005\u000b\t!\t\u0001\u0003\u0001\u001d\u0001a\u0011\u0011kA\u0003\u0005\u0018%\t\u0001RA\u0007\u0002\u0011\u001bA6qA\u0003'\t\r\tr\u0001\u0002\u0001\t\u0011U!Q!\u0001\u0005\u0005\u0019\u0003AB!F\u0005\u0006\u0003!=\u0011\"B\u0005\u0005\u000b\t!\t\u0001\u0003\u0001\u001d\u0001a=\u0001$D\u0011\n\u000b\u0005A\u0001\"C\u0003\n\t\u0015\u0011A\u0011\u0001\u0005\u00019\u0001A\u0002\"U\u0002\u0006\t5I\u0011\u0001#\u0005\u000e\u0003!I\u0001la\u0002\u0006M\u0011\u0019\u0011c\u0002\u0003\u0001\u0011!)B!B\u0001\t\t1\u0005\u0001\u0004B\u000b\n\u000b\u0005A!!C\u0003\n\t\u0015\u0011A\u0011\u0001\u0005\u00019\u0001A\"\u0001G\u0007\"\u0013\u0015\t\u00012C\u0005\u0006\u0013\u0011)!\u0001\"\u0001\t\u0001q\u0001\u00014C)\u0004\u000b\u0011i\u0011\"\u0001\u0005\u000b\u001b\u0005A)\u0001WB\u0004"})
public final class PromiseKt {
    @NotNull
    static final Promise<?> DONE = new DonePromise<Object>(null);
    @NotNull
    static final Promise<?> REJECTED = new RejectedPromise(new MessageError("rejected"));

    @NotNull
    public static final Promise<?> getDONE() {
        return DONE;
    }

    @NotNull
    public static final Promise<?> getREJECTED() {
        return REJECTED;
    }

    @NotNull
    public static final <T> Promise<T> RejectedPromise(@NotNull String error) {
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        return new RejectedPromise(new MessageError(error));
    }

    @NotNull
    public static final Promise<?> ResolvedPromise() {
        return DONE;
    }

    @NotNull
    public static final <T> Promise<T> ResolvedPromise(T result) {
        return new DonePromise<T>(result);
    }

    @NotNull
    public static final <T> AsyncPromise<T> toPromise(org.jetbrains.concurrency.Promise<T> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        AsyncPromise promise = new AsyncPromise();
        org.jetbrains.concurrency.Promise<T> oldPromise = $receiver;
        $receiver.done(new Consumer<T>(promise){
            final /* synthetic */ AsyncPromise $promise;

            public final void consume(T it) {
                this.$promise.setResult(it);
            }
            {
                this.$promise = asyncPromise;
            }
        }).rejected((Consumer)new Consumer<Throwable>(promise){
            final /* synthetic */ AsyncPromise $promise;

            public final void consume(Throwable it) {
                Throwable throwable = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"it");
                this.$promise.setError(throwable);
            }
            {
                this.$promise = asyncPromise;
            }
        });
        if (oldPromise instanceof org.jetbrains.concurrency.AsyncPromise) {
            promise.done((Function1)new Function1<T, Unit>(oldPromise){
                final /* synthetic */ org.jetbrains.concurrency.Promise $oldPromise;

                public final void invoke(T it) {
                    ((org.jetbrains.concurrency.AsyncPromise)this.$oldPromise).setResult(it);
                }
                {
                    this.$oldPromise = promise;
                    super(1);
                }
            }).rejected((Function1<Throwable, Unit>)((Function1)new Function1<Throwable, Unit>(oldPromise){
                final /* synthetic */ org.jetbrains.concurrency.Promise $oldPromise;

                public final void invoke(@NotNull Throwable it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    ((org.jetbrains.concurrency.AsyncPromise)this.$oldPromise).setError(it);
                }
                {
                    this.$oldPromise = promise;
                    super(1);
                }
            }));
        }
        return promise;
    }

    @NotNull
    public static final <T> org.jetbrains.concurrency.AsyncPromise<T> toPromise(Promise<T> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        org.jetbrains.concurrency.AsyncPromise promise = new org.jetbrains.concurrency.AsyncPromise();
        $receiver.done((Function1)new Function1<T, Unit>(promise){
            final /* synthetic */ org.jetbrains.concurrency.AsyncPromise $promise;

            public final void invoke(T it) {
                this.$promise.setResult(it);
            }
            {
                this.$promise = asyncPromise;
                super(1);
            }
        }).rejected((Function1<Throwable, Unit>)((Function1)new Function1<Throwable, Unit>(promise){
            final /* synthetic */ org.jetbrains.concurrency.AsyncPromise $promise;

            public final void invoke(@NotNull Throwable it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.$promise.setError(it);
            }
            {
                this.$promise = asyncPromise;
                super(1);
            }
        }));
        return promise;
    }

    public static final boolean getIsPending(Promise<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return Intrinsics.areEqual((Object)((Object)$receiver.getState()), (Object)((Object)Promise.State.PENDING));
    }

    public static final boolean getIsRejected(Promise<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return Intrinsics.areEqual((Object)((Object)$receiver.getState()), (Object)((Object)Promise.State.REJECTED));
    }
}

