/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.KotlinPackage;
import kotlin.jvm.functions.Function1;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.taskdefs.compilers.Javac13;
import org.apache.tools.ant.taskdefs.condition.AntVersion;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ant.AntPackage;
import org.jetbrains.kotlin.ant.Kotlin2JvmTask;
import org.jetbrains.kotlin.ant.KotlinAntTaskUtil;

public class KotlinCompilerAdapter
extends Javac13 {
    private static final List<String> KOTLIN_EXTENSIONS = Arrays.asList("kt", "kts");
    private Path externalAnnotations;
    private String moduleName;
    public List<Commandline.Argument> additionalArguments = new ArrayList<Commandline.Argument>(0);

    public void setExternalAnnotations(Path externalAnnotations) {
        this.externalAnnotations = externalAnnotations;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public Path createExternalAnnotations() {
        if (this.externalAnnotations == null) {
            this.externalAnnotations = new Path(this.getProject());
        }
        return this.externalAnnotations.createPath();
    }

    public Commandline.Argument createCompilerArg() {
        Commandline.Argument argument = new Commandline.Argument();
        this.additionalArguments.add(argument);
        return argument;
    }

    public String[] getSupportedFileExtensions() {
        List<String> result = KotlinPackage.plus(Arrays.asList(super.getSupportedFileExtensions()), KOTLIN_EXTENSIONS);
        return result.toArray(new String[result.size()]);
    }

    public boolean execute() throws BuildException {
        boolean hasKotlinFilesInSources;
        Javac javac = this.getJavac();
        this.checkAntVersion();
        Kotlin2JvmTask kotlinc = new Kotlin2JvmTask();
        kotlinc.setFailOnError(javac.getFailonerror());
        kotlinc.setOutput(javac.getDestdir());
        Path classpath = javac.getClasspath();
        if (classpath != null) {
            kotlinc.setClasspath(classpath);
        }
        kotlinc.setSrc(javac.getSrcdir());
        kotlinc.setExternalAnnotations(this.externalAnnotations);
        if (this.moduleName == null) {
            this.moduleName = AntPackage.getDefaultModuleName((Task)javac);
        }
        kotlinc.setModuleName(this.moduleName);
        kotlinc.getAdditionalArguments().addAll(this.additionalArguments);
        File[] compileListForJavac = KotlinCompilerAdapter.filterOutKotlinSources(this.compileList);
        boolean bl = hasKotlinFilesInSources = compileListForJavac.length < this.compileList.length;
        if (hasKotlinFilesInSources) {
            kotlinc.execute();
            if (!Integer.valueOf(0).equals(kotlinc.getExitCode())) {
                return false;
            }
        } else {
            kotlinc.fillArguments();
        }
        javac.log("Running javac...");
        this.compileList = compileListForJavac;
        this.addRuntimeToJavacClasspath(kotlinc);
        return this.compileList.length == 0 || super.execute();
    }

    private void addRuntimeToJavacClasspath(@NotNull Kotlin2JvmTask kotlinc) {
        if (kotlinc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinc", "org/jetbrains/kotlin/ant/KotlinCompilerAdapter", "addRuntimeToJavacClasspath"));
        }
        for (String arg : kotlinc.getArgs()) {
            if (!"-no-stdlib".equals(arg)) continue;
            return;
        }
        if (this.compileClasspath == null) {
            this.compileClasspath = new Path(this.getProject());
        }
        this.compileClasspath.add(new Path(this.getProject(), KotlinAntTaskUtil.INSTANCE$.getRuntimeJar().getAbsolutePath()));
    }

    private void checkAntVersion() {
        AntVersion checkVersion = new AntVersion();
        checkVersion.setAtLeast("1.8.2");
        if (!checkVersion.eval()) {
            this.getJavac().log("<withKotlin> task requires Ant of version at least 1.8.2 to operate reliably. Please upgrade or, as a workaround, make sure you have at least one Java source and the output directory is clean before running this task. You have: " + this.getProject().getProperty("ant.version"), 1);
        }
    }

    @NotNull
    private static File[] filterOutKotlinSources(@NotNull File[] files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/ant/KotlinCompilerAdapter", "filterOutKotlinSources"));
        }
        List<File> nonKotlinSources = KotlinPackage.filterNot(files, new Function1<File, Boolean>(){

            @Override
            public Boolean invoke(File file) {
                for (String extension : KOTLIN_EXTENSIONS) {
                    if (!file.getPath().endsWith("." + extension)) continue;
                    return true;
                }
                return false;
            }
        });
        File[] fileArray = nonKotlinSources.toArray(new File[nonKotlinSources.size()]);
        if (fileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/ant/KotlinCompilerAdapter", "filterOutKotlinSources"));
        }
        return fileArray;
    }
}

