/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.JSR45Util;
import com.intellij.rt.coverage.util.StringsPool;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

public class NewSamplingInstrumenter
extends ClassVisitor {
    private static final String LINE_HITS_FIELD_NAME = "__$lineHits$__";
    private boolean myVisitedStaticBlock;
    private final ProjectData myProjectData;
    private ClassData myClassData;
    private LineData[] myLines;
    private final String myClassName;
    private final String myClassNameType;
    private final boolean myShouldCalculateSource;
    private int myMaxLineNumber;
    private boolean myProcess;
    private boolean myEnum;

    public NewSamplingInstrumenter(ProjectData projectData, ClassVisitor classVisitor, ClassReader cr, String className, boolean shouldCalculateSource) {
        super(327680, classVisitor);
        this.myProjectData = projectData;
        this.myClassName = className.replace('$', '.');
        this.myClassNameType = className.replace(".", "/");
        this.myShouldCalculateSource = shouldCalculateSource;
        this.myMaxLineNumber = this.calcMaxLineNumber(cr);
        this.myLines = new LineData[this.myMaxLineNumber + 1];
    }

    private int calcMaxLineNumber(ClassReader cr) {
        final int[] maxLine = new int[]{0};
        ClassVisitor instrumentedMethodCounter = new ClassVisitor(327680){
            private boolean myEnum;

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                this.myEnum = (access & 0x4000) != 0;
                super.visit(version, access, name, signature, superName, interfaces);
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                if (!NewSamplingInstrumenter.this.shouldProcessMethod(access, name, desc, signature, this.myEnum)) {
                    return null;
                }
                return new MethodVisitor(327680){

                    public void visitLineNumber(int line, Label start) {
                        if (maxLine[0] < line) {
                            maxLine[0] = line;
                        }
                        super.visitLineNumber(line, start);
                    }
                };
            }
        };
        cr.accept(instrumentedMethodCounter, 0);
        return maxLine[0];
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.myEnum = (access & 0x4000) != 0;
        this.myProcess = (access & 0x200) == 0;
        this.myClassData = this.myProjectData.getOrCreateClassData(StringsPool.getFromPool(this.myClassName));
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public MethodVisitor visitMethod(int access, final String name, final String desc, String signature, String[] exceptions) {
        MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
        if (mv == null || !this.shouldProcessMethod(access, name, desc, signature, this.myEnum)) {
            return mv;
        }
        this.myProcess = true;
        if ("<clinit>".equals(name)) {
            this.myVisitedStaticBlock = true;
            return new StaticBlockMethodVisitor(mv);
        }
        return new MethodVisitor(327680, mv){

            public void visitLineNumber(int line, Label start) {
                NewSamplingInstrumenter.this.getOrCreateLineData(line, name, desc);
                this.visitFieldInsn(178, NewSamplingInstrumenter.this.myClassNameType, NewSamplingInstrumenter.LINE_HITS_FIELD_NAME, "[I");
                NewSamplingInstrumenter.pushInstruction(this.mv, line);
                this.visitFieldInsn(178, NewSamplingInstrumenter.this.myClassNameType, NewSamplingInstrumenter.LINE_HITS_FIELD_NAME, "[I");
                NewSamplingInstrumenter.pushInstruction(this.mv, line);
                this.visitInsn(46);
                this.visitInsn(4);
                this.visitInsn(96);
                this.visitInsn(79);
                super.visitLineNumber(line, start);
            }
        };
    }

    protected void getOrCreateLineData(int line, String name, String desc) {
        if (this.myLines == null) {
            this.myLines = new LineData[this.myMaxLineNumber + 1];
        }
        if (this.myLines[line] == null) {
            this.myLines[line] = new LineData(line, StringsPool.getFromPool(name + desc));
        }
    }

    private boolean shouldProcessMethod(int access, String name, String desc, String signature, boolean isEnum) {
        return (access & 0x40) == 0 && (access & 0x400) == 0 && (!isEnum || !NewSamplingInstrumenter.isDefaultEnumMethod(name, desc, signature, this.myClassName));
    }

    private static boolean isDefaultEnumMethod(String name, String desc, String signature, String className) {
        return name.equals("values") && desc.equals("()[L" + className + ";") || name.equals("valueOf") && desc.equals("(Ljava/lang/String;)L" + className + ";") || name.equals("<init>") && signature != null && signature.equals("()V");
    }

    public void visitEnd() {
        if (this.myProcess) {
            this.visitField(25, LINE_HITS_FIELD_NAME, "[I", null, null);
            if (!this.myVisitedStaticBlock) {
                MethodVisitor mv = super.visitMethod(8, "<clinit>", "()V", null, null);
                mv = new StaticBlockMethodVisitor(mv);
                mv.visitCode();
                mv.visitInsn(177);
                mv.visitMaxs(2, 0);
                mv.visitEnd();
            }
            this.myClassData.setLines(this.myLines);
        }
        this.myLines = null;
        super.visitEnd();
    }

    public void visitSource(String source, String debug) {
        super.visitSource(source, debug);
        if (this.myShouldCalculateSource) {
            this.myProjectData.getOrCreateClassData(this.myClassName).setSource(source);
        }
        if (debug != null) {
            this.myProjectData.addLineMaps(this.myClassName, JSR45Util.extractLineMapping(debug, this.myClassName));
        }
    }

    public void visitOuterClass(String outerClassName, String methodName, String methodSig) {
        if (this.myShouldCalculateSource) {
            this.myProjectData.getOrCreateClassData(outerClassName).setSource(this.myClassData.getSource());
        }
        super.visitOuterClass(outerClassName, methodName, methodSig);
    }

    private static void pushInstruction(MethodVisitor mv, int operand) {
        if (operand <= Short.MAX_VALUE) {
            mv.visitIntInsn(17, operand);
        } else {
            mv.visitLdcInsn((Object)new Integer(operand));
        }
    }

    private class StaticBlockMethodVisitor
    extends MethodVisitor {
        public StaticBlockMethodVisitor(MethodVisitor mv) {
            super(327680, mv);
        }

        public void visitCode() {
            super.visitCode();
            this.visitLdcInsn(NewSamplingInstrumenter.this.myClassName);
            NewSamplingInstrumenter.pushInstruction(this, NewSamplingInstrumenter.this.myMaxLineNumber + 1);
            this.visitIntInsn(188, 10);
            this.visitMethodInsn(184, "com/intellij/rt/coverage/data/ProjectData", "touchClassLines", "(Ljava/lang/String;[I)[I", false);
            this.visitFieldInsn(179, NewSamplingInstrumenter.this.myClassNameType, NewSamplingInstrumenter.LINE_HITS_FIELD_NAME, "[I");
        }

        public void visitMaxs(int maxStack, int maxLocals) {
            super.visitMaxs(Math.max(2, maxStack), maxLocals);
        }
    }
}

