/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.types.JetType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IntegerValueTypeConstructor
implements TypeConstructor {
    public static final /* synthetic */ KClass $kotlinClass;
    private final ArrayList<JetType> supertypes;
    private final long value;
    private final KotlinBuiltIns builtIns;

    static {
        $kotlinClass = Reflection.createKotlinClass(IntegerValueTypeConstructor.class);
    }

    private final void checkBoundsAndAddSuperType(long value, long minValue, long maxValue, JetType kotlinType) {
        if (value >= minValue && value <= maxValue) {
            this.supertypes.add(kotlinType);
        }
    }

    @Override
    @NotNull
    public Collection<JetType> getSupertypes() {
        return this.supertypes;
    }

    @Override
    @NotNull
    public List<TypeParameterDescriptor> getParameters() {
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    public boolean isDenotable() {
        return false;
    }

    @Nullable
    public Void getDeclarationDescriptor() {
        return null;
    }

    @Override
    @NotNull
    public Annotations getAnnotations() {
        return Annotations.Companion.getEMPTY();
    }

    public final long getValue() {
        return this.value;
    }

    @NotNull
    public String toString() {
        return "IntegerValueType(" + this.value + ")";
    }

    public IntegerValueTypeConstructor(long value, @NotNull KotlinBuiltIns builtIns) {
        Intrinsics.checkParameterIsNotNull(builtIns, "builtIns");
        this.value = value;
        this.builtIns = builtIns;
        this.supertypes = new ArrayList(4);
        long l = Integer.MIN_VALUE;
        long l2 = Integer.MAX_VALUE;
        JetType jetType = this.builtIns.getIntType();
        Intrinsics.checkExpressionValueIsNotNull(jetType, "builtIns.getIntType()");
        this.checkBoundsAndAddSuperType(this.value, l, l2, jetType);
        long l3 = Byte.MIN_VALUE;
        long l4 = Byte.MAX_VALUE;
        JetType jetType2 = this.builtIns.getByteType();
        Intrinsics.checkExpressionValueIsNotNull(jetType2, "builtIns.getByteType()");
        this.checkBoundsAndAddSuperType(this.value, l3, l4, jetType2);
        long l5 = Short.MIN_VALUE;
        long l6 = Short.MAX_VALUE;
        JetType jetType3 = this.builtIns.getShortType();
        Intrinsics.checkExpressionValueIsNotNull(jetType3, "builtIns.getShortType()");
        this.checkBoundsAndAddSuperType(this.value, l5, l6, jetType3);
        this.supertypes.add(this.builtIns.getLongType());
    }
}

