/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.keychain;

import com.intellij.openapi.util.PasswordUtil;
import gnu.trove.THashMap;
import java.util.Map;
import kotlin.MapsKt;
import kotlin.StringsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.keychain.Credentials;
import org.jetbrains.keychain.CredentialsStore;
import org.jetbrains.keychain.OSXKeychainLibrary;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\t\u0006)\u0019rj\u001d-De\u0016$WM\u001c;jC2\u001c8\u000b^8sK*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(\u0002C6fs\u000eD\u0017-\u001b8\u000b!\r\u0013X\rZ3oi&\fGn]*u_J,'B\u0002\u001fj]&$hHC\u0006tKJ4\u0018nY3OC6,'BB*ue&twM\u0003\u0004l_Rd\u0017N\u001c\u0006\u0005U\u00064\u0018M\u0003\u0003mC:<'\u0002F1dG>,h\u000e\u001e+p\u0007J,G-\u001a8uS\u0006d7O\u0003\u0005U\u0011\u0006\u001c\b.T1q\u0015\r9g.\u001e\u0006\u0006iJ|g/\u001a\u0006\f\u0007J,G-\u001a8uS\u0006d7OC\u0005CsR,\u0017I\u001d:bs*\u0019q-\u001a;\u000b\t!|7\u000f\u001e\u0006\u000bgND7*Z=GS2,'BD4fiN+'O^5dK:\u000bW.\u001a\u0006\u0006e\u0016\u001cX\r\u001e\u0006\u0005+:LGO\u0003\u0003tCZ,'bC2sK\u0012,g\u000e^5bYNT\u0011bQ8na\u0006t\u0017n\u001c8s\u0015\t\u0001\u0012A\u0003\u0003\t\u0001A\u0011!\u0002\u0002\u0005\u0002!\rQa\u0001\u0003\u0002\u0011\u0001a\u0001!B\u0002\u0005\u0003!\u0011A\u0002A\u0003\u0002\u0011\u0011)1\u0001\"\u0002\t\b1\u0001Q!\u0001E\u0005\u000b\t!9\u0001C\u0003\u0006\u0005\u0011!\u0001rA\u0003\u0002\u0011\u001b)!\u0001B\u0003\t\u000f\u0015\u0019A1\u0002\u0005\u0007\u0019\u0001)1\u0001B\u0001\t\u00101\u0001QA\u0001C\u0006\u0011\u0019)1\u0001\"\u0002\t\u00111\u0001QA\u0001\u0003\u0002\u0011\u001f)1\u0001\"\u0002\t\u00171\u0001Aa\u0001G\u0002!3I2!B\u0001\t\u0005a\u0011Q\u0014!\u0007.-\u0011\tG\u0001g\u0003\"\u001b\u0015\t\u0001BB\u0005\u0005\u0013\r)\u0011\u0001C\u0002\u0019\u0007%!\u0011bA\u0003\u0002\u0011\u001bAj\u0001\u0007\u0004V\u0007\u0011)1\u0001b\u0003\n\u0003!9Q&\u0004\u0003b\ta\u0019\u0011eA\u0003\u0002\u0011\u001fAz!V\u0002\u0006\u000b\u0011!1!\u0003\u0002\u0005\u00041\u0005QV\t\u0003\f1#i\n\u0002\u0002\u0001\t\u00135!Q!\u0001\u0005\u0004\u0019\u0003A2\u0001U\u0002\u0001;#!\u0001\u0001c\u0005\u000e\t\u0015\t\u0001b\u0001G\u00011\r\u00016\u0011A\u0011\u0005\u000b\u0005Ai\u0001$\u0001\u0019\u000eE\u001bq\u0001\"\u0005\n\u0003!AQ\"\u0001E\u0005\u001b\u0005AI!L\f\u0005\u0003aQQ\u0014\u0003\u0003\u0001\u0011'iA!B\u0001\t\u00071\u0005\u0001d\u0001)\u0004\u0001\u0005\u001aQ!\u0001E\b1\u001f\t6A\u0002\u0003\u000b\u0013\t!\u0019\u0001$\u0001\u000e\u0003!%Q&\u0006\u0003\f1+iz\u0001\u0002\u0001\t\u00135\u0019Q!\u0001\u0005\u00041\r\u00016\u0001A\u0011\u0004\u000b\u0005A\t\u0002'\u0005R\u0007\u0015!)\"C\u0001\u0005\u00015\t\u0001\u0012B\u0017-\t-A:\"(\u0005\u0005\u0001!IQ\u0002B\u0003\u0002\u0011\ra\t\u0001G\u0002Q\u0007\u0001iz\u0001\u0002\u0001\t\u00195\u0019Q!\u0001E\u00071\u001b\u00016\u0011AO\t\t\u0001A\u0019\"\u0004\u0003\u0006\u0003!\u0019A\u0012\u0001\r\u0004!\u000e\t\u0011eA\u0003\u0002\u0011#A\n\"U\u0002\n\t/I\u0011\u0001\u0002\u0001\u000e\u0003!%Q\"\u0001\u0005\t\u001b\u0005AI!.\f\u0006,\u0011\u0019\u000f\u0001'\u0002\u001e\u0010\u0011\u0001\u0001bA\u0007\u0004\u000b\u0005A1\u0001G\u0002Q\u0007\u0001\t3!B\u0001\t\u0004a\r\u0011kA\u0003\u0005\u0006%\tA\u0001A\u0007\u0002\u0011\u0013\u0001"})
public final class OsXCredentialsStore
implements CredentialsStore {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    public static final byte[] SSH;
    private final byte[] serviceName;
    private final THashMap<String, Credentials> accountToCredentials;
    public static final Companion Companion;

    static {
        $kotlinClass = Reflection.createKotlinClass(OsXCredentialsStore.class);
        Companion companion = Companion = new Companion(null);
        SSH = StringsKt.toByteArray$default((String)"SSH", null, (int)1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public Credentials get(@Nullable String host, @Nullable String sshKeyFile) {
        if (host == null) {
            return null;
        }
        String string = sshKeyFile;
        if (string == null) {
            string = host;
        }
        String accountName = string;
        Credentials credentials = (Credentials)this.accountToCredentials.get((Object)accountName);
        if (credentials != null) {
            return credentials;
        }
        String string2 = OSXKeychainLibrary.Companion.findGenericPassword(this.getServiceName(sshKeyFile), accountName);
        if (string2 == null) {
            return null;
        }
        String data2 = string2;
        if (sshKeyFile == null) {
            int separatorIndex = StringsKt.indexOf$default((String)data2, (char)'@', (int)0, (boolean)false, (int)6);
            if (separatorIndex <= 0) return null;
            String username = PasswordUtil.decodePassword((String)StringsKt.substring((String)data2, (int)0, (int)separatorIndex));
            String password = PasswordUtil.decodePassword((String)StringsKt.substring((String)data2, (int)(separatorIndex + 1)));
            credentials = new Credentials(username, password);
        } else {
            credentials = new Credentials(sshKeyFile, data2);
        }
        MapsKt.set((Map)((Map)this.accountToCredentials), (Object)accountName, (Object)credentials);
        return credentials;
    }

    private final byte[] getServiceName(String sshKeyFile) {
        return sshKeyFile == null ? this.serviceName : Companion.getSSH();
    }

    @Override
    public void save(@Nullable String host, @NotNull Credentials credentials, @Nullable String sshKeyFile) {
        String string;
        String accountName;
        Credentials oldCredentials;
        Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
        String string2 = sshKeyFile;
        if (string2 == null && (string2 = host) == null) {
            Intrinsics.throwNpe();
        }
        if (credentials.equals(oldCredentials = (Credentials)this.accountToCredentials.put((Object)(accountName = string2), (Object)credentials))) {
            return;
        }
        if (sshKeyFile == null) {
            string = PasswordUtil.encodePassword((String)credentials.getId()) + "@" + PasswordUtil.encodePassword((String)credentials.getToken());
        } else {
            string = credentials.getToken();
            if (string == null) {
                Intrinsics.throwNpe();
            }
        }
        String data2 = string;
        OSXKeychainLibrary.Companion.saveGenericPassword(this.getServiceName(sshKeyFile), accountName, data2);
    }

    @Override
    public void reset(@NotNull String host) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        if (this.accountToCredentials.remove((Object)host) != null) {
            OSXKeychainLibrary.Companion.deleteGenericPassword(this.serviceName, host);
        }
    }

    public OsXCredentialsStore(@NotNull String serviceName) {
        Intrinsics.checkParameterIsNotNull((Object)serviceName, (String)"serviceName");
        this.serviceName = StringsKt.toByteArray$default((String)serviceName, null, (int)1);
        this.accountToCredentials = new THashMap();
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"`\u0015%\u0019u.\u001c9b]&|gNC\nPgb\u001b%/\u001a3f]RL\u0017\r\\:Ti>\u0014XMC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\u0011-,\u0017p\u00195bS:T1!\u00118z\u0015\u0019Yw\u000e\u001e7j]*\u00191k\u0015%\u000b\u0013\tKH/Z!se\u0006L(BB4fiN\u001b\u0006\n\u000e\u0006\u0003!\tQA\u0001\u0003\u0001\u0011\u0007)!\u0001\"\u0001\t\u0005\u0015\u0019A!\u0001E\u0001\u0019\u0001)1\u0001b\u0001\t\u00011\u0001Q!\u0001\u0005\u0004\u000b\r!)\u0001#\u0002\r\u0001\u0015\u0019AQ\u0001\u0005\u0005\u0019\u0001!19\u0001\u0007\u00033\r)\u0011\u0001C\u0002\u0019\u00075\u001aBa\u0019\u0003\u0019\b\u0005\u001aQ!\u0001E\u00041\u000f)6aC\u0003\u0006\t\u000fI!\u0001b\u0001\r\u00021\u0005Q\u0002\u0002C\u0005\u0013\t!\u0019\u0001$\u00016\u0001\u0001"})
    public static final class Companion {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(Companion.class);
        }

        @NotNull
        public final byte[] getSSH() {
            return SSH;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

