/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.notification.Notification;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsAdapter;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.util.messages.MessageBus;
import java.util.concurrent.Future;
import kotlin.StringsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.AuthenticationException;
import org.jetbrains.settingsRepository.AutoSyncManager;
import org.jetbrains.settingsRepository.AutoSyncManager$sync$;
import org.jetbrains.settingsRepository.IcsManager;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.NoRemoteRepositoryException;
import org.jetbrains.settingsRepository.RepositoryManager;
import org.jetbrains.settingsRepository.RepositoryManager$$TImpl;
import org.jetbrains.settingsRepository.SyncKt;
import org.jetbrains.settingsRepository.UpdateResult;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"m\u0006)y\u0011)\u001e;p'ft7-T1oC\u001e,'OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b%M,G\u000f^5oON\u0014V\r]8tSR|'/\u001f\u0006\u0004\u0003:L(BB6pi2LgN\u0003\u0004=S:LGO\u0010\u0006\u000bS\u000e\u001cX*\u00198bO\u0016\u0014(BC%dg6\u000bg.Y4fe*q\u0011-\u001e;p'ft7MR;ukJ,'B\u0002$viV\u0014XM\u0003\u0003kCZ\f'\u0002B;uS2T!bY8oGV\u0014(/\u001a8u\u0015!\tW\u000f^8Ts:\u001c'\"C8o\u0003B\u0004X\t_5u\u0015\u001d\u0011un\u001c7fC:TQAZ8sG\u0016TA!\u00168ji*\t\"/Z4jgR,'\u000fT5ti\u0016tWM]:\u000b\u0017\u0005\u0004\b\u000f\\5dCRLwN\u001c\u0006\f\u0003B\u0004H.[2bi&|gNC\u0002d_6T\u0001\"\u001b8uK2d\u0017N\u001b\u0006\b_B,g.\u00199j\u0015\u001d\u0001(o\u001c6fGRTq\u0001\u0015:pU\u0016\u001cGO\u0003\u0003ts:\u001c'bA1qa*y\u0011\t\u001d9mS\u000e\fG/[8o\u00136\u0004HN\u0003\u0003j[Bd'\u0002D<bSR\fU\u000f^8Ts:\u001c'\"C5oI&\u001c\u0017\r^8s\u0015E\u0001&o\\4sKN\u001c\u0018J\u001c3jG\u0006$xN\u001d\u0006\taJ|wM]3tg\u0002\u000f!B\u0001\t\u0002\u0015\u0011A\u0001\u0001\u0005\u0002\u000b\t!\t\u0001c\u0001\u0006\u0007\u0011\t\u0001\u0002\u0001\u0007\u0001\u000b\u0005A)!B\u0002\u0005\u0005!\u0011A\u0002A\u0003\u0004\t\u0005AA\u0001\u0004\u0001\u0006\u0005\u0011\t\u0001\u0002B\u0003\u0002\u0011\u0017)!\u0001\u0002\u0003\t\r\u0015\u0011A\u0011\u0002E\u0007\u000b\r!Q\u0001C\u0003\r\u0001\u0015\u0011A!\u0002\u0005\u0006\u000b\r!!\u0001\u0003\u0005\r\u0001\u0015\u0019AA\u0001\u0005\n\u0019\u0001)\u0011\u0001C\u0006\u0006\u0005\u0011=\u0001rC\u0003\u0003\t!AA\"\u0002\u0002\u0005\u0012!QQa\u0001\u0003\n\u0011+a\u0001!\u0002\u0002\u0005\u0013!UQA\u0001C\t\u00113)1\u0001\"\u0006\t\u001b1\u0001QA\u0001C\u000b\u00115)!\u0001B\u0005\t\u001f\u0015\u0019A\u0001\u0004E\u000f\u0019\u0001)!\u0001\u0002\u0007\t\u001e\u0015\u0011A\u0011\u0003\u0005\u0012\u000b\r!Y\u0002#\t\r\u0001\u0015\u0011A1\u0004E\u0011\t\u0001a\u0019!G\u0002\u0006\u0003!\u0015\u0001TA\u0017\u0012\t\u0007g\u0001\u0014B\u0011\u0007\u000b\u0005AY!C\u0001\u0005\u00041\u0005\u00014\u0002\u0013\u0002Q\u0005)6\u0001B\u0003\u0004\t\u0013I\u0011\u0001\u0003\u0004.\u0019\u0011\tG\u0001g\u0002\"\u0007\u0015\t\u0001b\u0001\r\u0004+\u000e!Qa\u0001C\u0004\u0013\u0005A9!l\u0010\u0005\u0007a9Qt\u0002\u0003\u0002\u0011\u001fi1!B\u0001\t\u000ea5\u0001k\u0001\u0001\u001e\u0010\u0011\t\u0001\u0012C\u0007\u0004\u000b\u0005Ai\u0001'\u0004Q\u0007\u0003\t3!B\u0001\t\u000fa9\u0011kA\u0004\u0005\u000f%\tA\u0001A\u0007\u0002\t\u0003i\u0011\u0001\"\u0001.+\u0011\u0019\u00014CO\b\t\u0001A!\"D\u0002\u0006\u0003!M\u00014\u0003)\u0004\u0001\u0005\u001aQ!\u0001\u0005\b1\u001d\t6!\u0002C\n\u0013\u0005!\u0001!D\u0001\t\u00155*Ba\u0001M\n;\u001f!\u0001\u0001#\u0007\u000e\u0007\u0015\t\u0001b\u0003\r\f!\u000e\u0001\u0011eA\u0003\u0002\u0011\u001dAr!U\u0002\u0006\t'I\u0011\u0001\u0002\u0001\u000e\u0003!]Qv\b\u0003\u000217iz\u0001\u0002\u0001\t\u001d5\u0019Q!\u0001E\r13\u00016\u0001AO\b\t\u0001Ay!D\u0002\u0006\u0003!5\u0001T\u0002)\u0004\u0002\u0005\u001aQ!\u0001\u0005\b1\u001d\t6a\u0002C\u000e\u0013\u0005!\u0001!D\u0001\t\u001b5\tA\u0011A\u0017\u0016\t\rAz\"h\u0004\u0005\u0001!\u0001RbA\u0003\u0002\u00119Ab\u0002U\u0002\u0001C\r)\u0011\u0001C\u0004\u0019\u000fE\u001bQ\u0001b\b\n\u0003\u0011\u0001Q\"\u0001E\u000fk[)Y\u0003Br\u00011\riz\u0001\u0002\u0001\t\b5\u0019Q!\u0001\u0005\u00041\r\u00016\u0001A\u0011\u0004\u000b\u0005A\u0019\u0001g\u0001R\u0007\u0015!1!C\u0001\u0005\u00015\t\u0001r\u0001"})
public final class AutoSyncManager {
    public static final /* synthetic */ KClass $kotlinClass;
    private volatile Future<?> autoSyncFuture;
    private final IcsManager icsManager;

    static {
        $kotlinClass = Reflection.createKotlinClass(AutoSyncManager.class);
    }

    public final void waitAutoSync(@NotNull ProgressIndicator indicator) {
        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
        Future<?> autoFuture = this.autoSyncFuture;
        if (autoFuture != null) {
            if (autoFuture.isDone()) {
                this.autoSyncFuture = null;
            } else if (this.autoSyncFuture != null) {
                IcsManagerKt.getLOG().info("Wait for auto sync future");
                indicator.setText("Wait for auto sync completion");
                while (!autoFuture.isDone()) {
                    if (indicator.isCanceled()) {
                        return;
                    }
                    Thread.sleep(5L);
                }
            }
        }
    }

    public final void registerListeners(@NotNull Application application) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        application.addApplicationListener((ApplicationListener)new ApplicationAdapter(this){
            public static final /* synthetic */ KClass $kotlinClass;
            final /* synthetic */ AutoSyncManager this$0;

            static {
                $kotlinClass = Reflection.createKotlinClass(registerListeners.1.class);
            }

            public void applicationExiting() {
                AutoSyncManager.autoSync$default(this.this$0, true, false, 2);
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    public final void registerListeners(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        project.getMessageBus().connect().subscribe(Notifications.TOPIC, (Object)new NotificationsAdapter(this, project){
            public static final /* synthetic */ KClass $kotlinClass;
            final /* synthetic */ AutoSyncManager this$0;
            final /* synthetic */ Project $project;

            static {
                $kotlinClass = Reflection.createKotlinClass(registerListeners.2.class);
            }

            public void notify(@NotNull Notification notification) {
                String message;
                Intrinsics.checkParameterIsNotNull((Object)notification, (String)"notification");
                if (!AutoSyncManager.access$getIcsManager$1(this.this$0).getRepositoryActive() || this.$project.isDisposed()) {
                    return;
                }
                boolean bl = Intrinsics.areEqual((Object)notification.getGroupId(), (Object)VcsBalloonProblemNotifier.NOTIFICATION_GROUP.getDisplayId()) ? StringsKt.startsWith$default((String)(message = notification.getContent()), (String)"VCS Update Finished", (boolean)false, (int)2) || Intrinsics.areEqual((Object)message, (Object)VcsBundle.message((String)"message.text.file.is.up.to.date", (Object[])new Object[0])) || Intrinsics.areEqual((Object)message, (Object)VcsBundle.message((String)"message.text.all.files.are.up.to.date", (Object[])new Object[0])) : Intrinsics.areEqual((Object)notification.getGroupId(), (Object)VcsNotifier.NOTIFICATION_GROUP_ID.getDisplayId()) && Intrinsics.areEqual((Object)notification.getTitle(), (Object)"Push successful");
                if (bl) {
                    AutoSyncManager.autoSync$default(this.this$0, false, false, 3);
                }
            }
            {
                this.this$0 = $outer;
                this.$project = $captured_local_variable$1;
            }
        });
    }

    public final void autoSync(boolean onAppExit, boolean force) {
        Object future;
        if (!this.icsManager.getRepositoryActive() || !force && !this.icsManager.getSettings().getAutoSync()) {
            return;
        }
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = this.autoSyncFuture;
        if ((Future)future.element != null && !((Future)future.element).isDone()) {
            return;
        }
        ApplicationEx applicationEx = ApplicationManagerEx.getApplicationEx();
        if (applicationEx == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.application.impl.ApplicationImpl");
        }
        ApplicationImpl app = (ApplicationImpl)applicationEx;
        if (onAppExit) {
            this.sync(app, onAppExit);
            return;
        }
        if (app.isDisposeInProgress()) {
            return;
        }
        future.element = app.executeOnPooledThread(new Runnable(this, future, app, onAppExit){
            final /* synthetic */ AutoSyncManager this$0;
            final /* synthetic */ Ref.ObjectRef $future;
            final /* synthetic */ ApplicationImpl $app;
            final /* synthetic */ boolean $onAppExit;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void run() {
                if (Intrinsics.areEqual(AutoSyncManager.access$getAutoSyncFuture$0(this.this$0), (Object)((Future)this.$future.element))) {
                    ShutDownTracker.getInstance().registerStopperThread(Thread.currentThread());
                    try {
                        AutoSyncManager.access$sync$2(this.this$0, this.$app, this.$onAppExit);
                    }
                    finally {
                        AutoSyncManager.access$setAutoSyncFuture$0(this.this$0, null);
                        ShutDownTracker.getInstance().unregisterStopperThread(Thread.currentThread());
                    }
                }
            }
            {
                this.this$0 = autoSyncManager;
                this.$future = objectRef;
                this.$app = applicationImpl;
                this.$onAppExit = bl;
            }
        });
        this.autoSyncFuture = (Future)future.element;
        future = null;
    }

    public static /* synthetic */ void autoSync$default(AutoSyncManager autoSyncManager, boolean bl, boolean bl2, int n) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        autoSyncManager.autoSync(bl, bl2);
    }

    private final void sync(ApplicationImpl app, boolean onAppExit) {
        try {
            this.icsManager.runInAutoCommitDisabledMode((Function0<? extends Unit>)((Function0)new Function0<Unit>(this, onAppExit, app){
                final /* synthetic */ AutoSyncManager this$0;
                final /* synthetic */ boolean $onAppExit$inlined;
                final /* synthetic */ ApplicationImpl $app$inlined;

                public final void invoke() {
                    RepositoryManager repositoryManager = AutoSyncManager.access$getIcsManager$1(this.this$0).getRepositoryManager();
                    if (!repositoryManager.canCommit()) {
                        IcsManagerKt.getLOG().warn("Auto sync skipped: repository is not committable");
                        return;
                    }
                    if (this.$onAppExit$inlined && !RepositoryManager$$TImpl.commit$default(repositoryManager, null, null, false, 7) && repositoryManager.getAheadCommitsCount() == 0) {
                        return;
                    }
                    RepositoryManager.Updater updater = RepositoryManager$$TImpl.fetch$default(repositoryManager, null, 1);
                    this.$app$inlined.invokeAndWait(new Runnable(this, updater){
                        final /* synthetic */ sync$$inlined$catchAndLog$lambda$1 this$0;
                        final /* synthetic */ RepositoryManager.Updater $updater;

                        public final void run() {
                            try {
                                UpdateResult updateResult = this.$updater.merge();
                                if (!this.this$0.$onAppExit$inlined && !this.this$0.$app$inlined.isDisposeInProgress() && updateResult != null) {
                                    IComponentStore iComponentStore = ServiceKt.getStateStore((ComponentManager)((ComponentManager)this.this$0.$app$inlined));
                                    if (iComponentStore == null) {
                                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.ComponentStoreImpl");
                                    }
                                    ComponentStoreImpl componentStoreImpl = (ComponentStoreImpl)iComponentStore;
                                    MessageBus messageBus = this.this$0.$app$inlined.getMessageBus();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)messageBus, (String)"app.messageBus");
                                    if (SyncKt.updateStoragesFromStreamProvider(componentStoreImpl, updateResult, messageBus)) {
                                        this.this$0.$app$inlined.exit(true, true, true, true);
                                    }
                                }
                            }
                            catch (ProcessCanceledException e) {
                            }
                            catch (Throwable e) {
                                if (e instanceof AuthenticationException || e instanceof NoRemoteRepositoryException) {
                                    IcsManagerKt.getLOG().warn(e);
                                }
                                IcsManagerKt.getLOG().error(e);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$updater = updater;
                        }
                    }, ModalityState.NON_MODAL);
                    if (!updater.getDefinitelySkipPush()) {
                        RepositoryManager$$TImpl.push$default(repositoryManager, null, 1);
                    }
                }
                {
                    this.this$0 = autoSyncManager;
                    this.$onAppExit$inlined = bl;
                    this.$app$inlined = applicationImpl;
                    super(0);
                }
            }));
        }
        catch (ProcessCanceledException e) {
        }
        catch (Throwable e) {
            if (e instanceof AuthenticationException || e instanceof NoRemoteRepositoryException) {
                IcsManagerKt.getLOG().warn(e);
            }
            IcsManagerKt.getLOG().error(e);
        }
    }

    public AutoSyncManager(@NotNull IcsManager icsManager2) {
        Intrinsics.checkParameterIsNotNull((Object)icsManager2, (String)"icsManager");
        this.icsManager = icsManager2;
    }

    @Nullable
    public static final /* synthetic */ Future<?> access$getAutoSyncFuture$0(AutoSyncManager $this) {
        return $this.autoSyncFuture;
    }

    public static final /* synthetic */ void access$setAutoSyncFuture$0(AutoSyncManager $this, @Nullable Future<?> future) {
        $this.autoSyncFuture = future;
    }

    public static final /* synthetic */ void access$sync$2(AutoSyncManager $this, @NotNull ApplicationImpl app, boolean onAppExit) {
        $this.sync(app, onAppExit);
    }
}

