/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.ArraysKt;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.BaseRepositoryManagerKt;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.RepositoryManager;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={";\b))\")Y:f%\u0016\u0004xn]5u_JLX*\u00198bO\u0016\u0014(bA8sO*I!.\u001a;ce\u0006Lgn\u001d\u0006\u0013g\u0016$H/\u001b8hgJ+\u0007o\\:ji>\u0014\u0018PC\tSKB|7/\u001b;pefl\u0015M\\1hKJTa\u0001P5oSRt$b\u00013je*!a)\u001b7f\u0015\u0011Q\u0017M^1\u000b\u0005%|'BB4fi\u0012K'O\u0003\u0003m_\u000e\\'B\u0006*fK:$(/\u00198u%\u0016\fGm\u0016:ji\u0016dunY6\u000b\tU$\u0018\u000e\u001c\u0006\u000bG>t7-\u001e:sK:$(\"\u00027pG.\u001c(bB4fi2{7m\u001b\u0006\u000bC\u0012$Gk\\%oI\u0016D(\u0002\u00024jY\u0016TA\u0001]1uQ*11\u000b\u001e:j]\u001eTaa[8uY&t'bB2p]R,g\u000e\u001e\u0006\n\u0005f$X-\u0011:sCfTAa]5{K*\u0019\u0011J\u001c;\u000b\tUs\u0017\u000e\u001e\u0006\u0005Y\u0006twM\u0003\u0004eK2,G/\u001a\u0006\u0010I\u0016dW\r^3Ge>l\u0017J\u001c3fq*1\u0011n\u001d$jY\u0016TqAQ8pY\u0016\fgN\u0003\teK2,G/\u001a*fa>\u001c\u0018\u000e^8ss*\u0019\u0001.Y:\u000b\u001b%\u001c\b+\u0019;i\u0013\u001etwN]3e\u0015=\u0001(o\\2fgN\u001c\u0005.\u001b7ee\u0016t'B\u00024jYR,'OC\u0005Gk:\u001cG/[8oc)I\u0001O]8dKN\u001cxN\u001d\u0006\n\rVt7\r^5p]JR1\"\u00138qkR\u001cFO]3b[*\u0019!N^7\u000b\u0013\u0019,hn\u0019;j_:\u001c(\u0002\u0002:fC\u0012TQa\u001e:ji\u00164\u001dA\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\r!\u0011\u0001\u0003\u0001\r\u0001\u0015\u0019A!\u0001\u0005\u0003\u0019\u0001)\u0011\u0001\u0003\u0003\u0006\u0005\u0011\u0015\u0001\u0012B\u0003\u0004\t\rA9\u0001\u0004\u0001\u0006\u0005\u0011\u0019\u0001rA\u0003\u0003\t\u000bAi!\u0002\u0002\u0005\n!9QA\u0001\u0003\u0006\u0011\u001f)1\u0001b\u0003\t\r1\u0001QA\u0001C\u0006\u0011\u0019)\u0011\u0001#\u0006\u0006\u0007\u00119\u0001B\u0003\u0007\u0001\u000b\r!q\u0001c\u0006\r\u0001\u0015\u0019Aa\u0002E\r\u0019\u0001)1\u0001B\u0004\t\u001b1\u0001QA\u0001C\u0003\u00117)!\u0001b\u0005\t\u0015\u0015\u0019Aa\u0002E\u0010\u0019\u0001)1\u0001B\u0004\t&1\u0001Qa\u0001\u0003\b\u0011Oa\u0001!B\u0002\u0005\u0007!!B\u0002A\u0003\u0003\t\u001dAI#\u0002\u0002\u0005\u001a!)RA\u0001\u0003\u000e\u0011K)!\u0001B\u0007\t(\u0015\u0011Aa\u0001\u0005\u0015\tMa\u0019!G\u0002\u0006\u0003!\u0011\u0001DA\u0017\u0011\t\t$\u0001dA\u0011\u0004\u000b\u0005A9\u0001g\u0002V\u0007!)1\u0001B\u0002\n\u0003!!Qb\u0001\u0003\u0006\u0013\u0005AA!\f\t\u0005E\u0012AZ!I\u0002\u0006\u0003!1\u0001DB+\u0004\u0011\u0015\u0019A1B\u0005\u0002\u0011\u001bi1\u0001\u0002\u0005\n\u0003!5Q6\u000e\u0003\u00131#iz\u0001\u0002\u0001\t\u00135\u0019Q!\u0001E\u00041\u000f\u00016\u0001AO\b\t\u0001A\u0019\"D\u0002\u0006\u0003!=\u0001t\u0002)\u0004\u0002u=A\u0001\u0001\u0005\f\u001b\r)\u0011\u0001\u0003\u0005\u0019\u0011A\u001b\u0011!h\u0004\u0005\u0001!aQbA\u0003\u0002\u0011#A\n\u0002UB\u0002C\r)\u0011\u0001C\u0005\u0019\u0013E\u001bA\u0002\"\u0005\n\u0003\u0011\u0001Q\"\u0001\u0005\u0005\u001b\u0005A!\"\u0004\u0002\u0005\u00041\u0005Q\"\u0001C\u0003[\u007f!\u0011\u0001\u0007\b\u001e\u0010\u0011\u0001\u0001\"C\u0007\u0004\u000b\u0005A9\u0001g\u0002Q\u0007\u0001iz\u0001\u0002\u0001\t\u00145\u0019Q!\u0001E\b1\u001f\u00016\u0011A\u0011\u0004\u000b\u0005A\u0011\u0002G\u0005R\u0007\u001d!a\"C\u0001\u0005\u00015\t\u0001\u0002B\u0007\u0002\u0011)iS\u0003B\u0006\u0019\u001du=A\u0001\u0001E\n\u001b\r)\u0011\u0001c\u0004\u0019\u0010A\u001b\u0001!I\u0002\u0006\u0003!I\u0001$C)\u0004\u000b\u0011q\u0011\"\u0001\u0003\u0001\u001b\u0005A!\"l\u0010\u0005%auQt\u0002\u0003\u0001\u0011'i1!B\u0001\t\u0010a=\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001bD\u0007\u0004\u000b\u0005A)\u0002'\u0006Q\u0007\u0003\t3!B\u0001\t\u0013aI\u0011kA\u0004\u0005\u001e%\tA\u0001A\u0007\u0002\u0011)i\u0011\u0001\"\u0001.\u0016\u0011Y\u0001\u0004E\u0011\u0004\u000b\u0005A\u0011\u0002G\u0005R\u0007\r!\u0001#C\u0001\u0005\u00015*Ba\u0003M\u0011;\u001f!\u0001\u0001c\u0005\u000e\u0007\u0015\t\u0001r\u0002M\b!\u000e\u0001\u0011eA\u0003\u0002\u0011+A*\"U\u0002\u0006\tCI\u0011\u0001\"\u0001\u000e\u0003!QQ&\u0006\u0003\u000b1Eiz\u0001\u0002\u0001\t\u00145\u0019Q!\u0001E\b1\u001f\u00016\u0001A\u0011\u0004\u000b\u0005A)\u0002'\u0006R\u0007\u0015!\u0011#C\u0001\u0005\u00025\t\u0001BC\u0017D\u0002\u0011Y\u00014EO\b\t\u0001A\u0019\"D\u0002\u0006\u0003!=\u0001t\u0002)\u0004\u0001u\rB\u0001\u0001\u0005\u0013\u001b5)\u0011\u0001C\u0006\n\t%\u0019Q!\u0001E\b1\u001fIA!C\u0002\u0006\u0003!U\u0001T\u0003\r\f!\u000e\u0005QT\u0006\u0003\u0001\u0011Mi!#B\u0001\t\u0018%!\u0011bA\u0003\u0002\u0011\u001fAz!\u0003\u0003\n\u0007\u0015\t\u0001\u0002\u0004\r\r\u0013\u0011I1!B\u0001\t\u0016aU\u0001t\u0003)\u0004\u0003\u0005\u001aQ!\u0001\u0005\n1%\t6!\u0003C\u0012\u0013\u0005!\u0001!D\u0001\t\u00155\t\u00012D\u0007\u0002\u00119ic\u0003B\u0006\u0019,u=A\u0001\u0001E\n\u001b\r)\u0011\u0001c\u0004\u0019\u0010A\u001b\u0001!\t\u0003\u0006\u0003!aA\u0012\u0001\r\r#\u000e)A1F\u0005\u0002\u0011;i\u0011\u0001\u0003\u0006.W\u0011Y\u0001DFO\b\t\u0001A\u0019\"D\u0002\u0006\u0003!=\u0001t\u0002)\u0004\u0001u=A\u0001\u0001\u0005\f\u001b\r)\u0011\u0001\u0003\u0005\u0019\u0011A\u001b\t!h\u0004\u0005\u0001!aQbA\u0003\u0002\u0011#A\n\u0002U\u0002\u0002C\r)\u0011\u0001#\u0006\u0019\u0016E\u001b!\u0002\u0002\f\n\u0003\u0011\u0005Q\"\u0001\u0005\u000b\u001b\t!\u0019\u0001$\u0001\u000e\u0003\u0011\u0015QWFC\u0016\t\r\b\u0001TAO\b\t\u0001A1!D\u0002\u0006\u0003!\u001d\u0001t\u0001)\u0004\u0001\u0005\u001aQ!\u0001E\u00021\u0007\t6!\u0002C\u0003\u0013\u0005!\u0001!D\u0001\t\t\u0001"})
public abstract class BaseRepositoryManager
implements RepositoryManager {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    private final ReentrantReadWriteLock lock;
    @NotNull
    private final File dir;

    static {
        $kotlinClass = Reflection.createKotlinClass(BaseRepositoryManager.class);
    }

    @NotNull
    protected final ReentrantReadWriteLock getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void processChildren(@NotNull String path, @NotNull Function1<? super String, ? extends Boolean> filter, @NotNull Function2<? super String, ? super InputStream, ? extends Boolean> processor) {
        File[] fileArray;
        Object files2;
        block14: {
            block13: {
                void $receiver;
                Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
                Intrinsics.checkParameterIsNotNull(filter, (String)"filter");
                Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
                Ref.ObjectRef objectRef = new Ref.ObjectRef();
                objectRef.element = null;
                ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
                ReentrantReadWriteLock.ReadLock rl = $receiver.readLock();
                rl.lock();
                try {
                    files2.element = new File(this.getDir(), path).listFiles(new FilenameFilter(this, files2, path, filter){
                        final /* synthetic */ BaseRepositoryManager this$0;
                        final /* synthetic */ Ref.ObjectRef $files$inlined;
                        final /* synthetic */ String $path$inlined;
                        final /* synthetic */ Function1 $filter$inlined;

                        public final boolean accept(File file, String name) {
                            String string = name;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
                            return (Boolean)this.$filter$inlined.invoke((Object)string);
                        }
                        {
                            this.this$0 = baseRepositoryManager;
                            this.$files$inlined = objectRef;
                            this.$path$inlined = string;
                            this.$filter$inlined = function1;
                        }
                    });
                    fileArray = Unit.INSTANCE$;
                }
                finally {
                    rl.unlock();
                }
                if ((File[])files2.element == null) break block13;
                File[] fileArray2 = (File[])files2.element;
                if (fileArray2 == null) {
                    Intrinsics.throwNpe();
                }
                if (!ArraysKt.isEmpty((Object[])fileArray2)) break block14;
            }
            return;
        }
        File[] fileArray3 = (File[])files2.element;
        if (fileArray3 == null) {
            Intrinsics.throwNpe();
        }
        fileArray = fileArray3;
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            if (file.isDirectory() || file.isHidden()) continue;
            if (file.length() == 0L) {
                if (!file.exists()) continue;
                try {
                    IcsManagerKt.getLOG().warn("File " + path + " is empty (length 0), will be removed");
                    this.delete(file, path);
                }
                catch (Exception e) {
                    IcsManagerKt.getLOG().error((Throwable)e);
                }
                continue;
            }
            String string = file.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
            if (!((Boolean)processor.invoke((Object)string, (Object)FilesKt.inputStream((File)file))).booleanValue()) break;
        }
        files2 = null;
    }

    @Override
    public void deleteRepository() {
        FileUtil.delete((File)this.dir);
    }

    protected boolean isPathIgnored(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public InputStream read(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        if (this.isPathIgnored(path)) {
            if (IcsManagerKt.getLOG().isDebugEnabled()) {
                IcsManagerKt.getLOG().debug(path + " is ignored");
            }
            return null;
        }
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        ReentrantReadWriteLock $receiver = this.lock;
        ReentrantReadWriteLock.ReadLock rl = $receiver.readLock();
        rl.lock();
        try {
            File file = new File(this.getDir(), path);
            if (file.length() != 0L) {
                InputStream inputStream = new FileInputStream(file);
                return inputStream;
            }
            fileToDelete.element = file;
            file = Unit.INSTANCE$;
        }
        finally {
            rl.unlock();
        }
        try {
            int index;
            int it;
            $receiver = this.lock;
            rl = $receiver.readLock();
            int readCount = $receiver.getWriteHoldCount() == 0 ? $receiver.getReadHoldCount() : 0;
            int n = 0;
            int n2 = readCount - 1;
            if (n <= n2) {
                void index2;
                do {
                    it = ++index2;
                    rl.unlock();
                } while (index2 != n2);
            }
            ReentrantReadWriteLock.WriteLock wl = $receiver.writeLock();
            wl.lock();
            try {
                void fileToDelete;
                File file = (File)fileToDelete.element;
                if (file == null) {
                    Intrinsics.throwNpe();
                }
                if (file.exists()) {
                    File file2 = (File)fileToDelete.element;
                    if (file2 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (file2.length() == 0L) {
                        IcsManagerKt.getLOG().warn("File " + path + " is empty (length 0), will be removed");
                        File file3 = (File)fileToDelete.element;
                        if (file3 == null) {
                            Intrinsics.throwNpe();
                        }
                        this.delete(file3, path);
                    }
                }
                Unit unit = Unit.INSTANCE$;
            }
            catch (Throwable throwable) {
                index = 0;
                int n3 = readCount - 1;
                if (index <= n3) {
                    do {
                        int it2 = ++index;
                        rl.lock();
                    } while (index != n3);
                }
                wl.unlock();
                throw throwable;
            }
            it = 0;
            int n4 = readCount - 1;
            if (it <= n4) {
                do {
                    int it3 = ++index;
                    rl.lock();
                } while (index != n4);
            }
            wl.unlock();
        }
        catch (Exception e) {
            IcsManagerKt.getLOG().error((Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public boolean write(@NotNull String path, @NotNull byte[] content, int size) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        if (this.isPathIgnored(path)) {
            if (IcsManagerKt.getLOG().isDebugEnabled()) {
                IcsManagerKt.getLOG().debug(path + " is ignored");
            }
            return false;
        }
        if (IcsManagerKt.getLOG().isDebugEnabled()) {
            IcsManagerKt.getLOG().debug("Write " + path);
        }
        try {
            int index;
            int it;
            void $receiver;
            ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
            ReentrantReadWriteLock.ReadLock rl = $receiver.readLock();
            int readCount = $receiver.getWriteHoldCount() == 0 ? $receiver.getReadHoldCount() : 0;
            int n = 0;
            int n2 = readCount - 1;
            if (n <= n2) {
                void index2;
                do {
                    it = ++index2;
                    rl.unlock();
                } while (index2 != n2);
            }
            ReentrantReadWriteLock.WriteLock wl = $receiver.writeLock();
            wl.lock();
            try {
                File file = new File(this.getDir(), path);
                FileUtil.writeToFile((File)file, (byte[])content, (int)0, (int)size);
                this.addToIndex(file, path, content, size);
                Unit unit = Unit.INSTANCE$;
            }
            catch (Throwable throwable) {
                index = 0;
                int n3 = readCount - 1;
                if (index <= n3) {
                    do {
                        int it2 = ++index;
                        rl.lock();
                    } while (index != n3);
                }
                wl.unlock();
                throw throwable;
            }
            it = 0;
            int n4 = readCount - 1;
            if (it <= n4) {
                do {
                    int it3 = ++index;
                    rl.lock();
                } while (index != n4);
            }
            wl.unlock();
        }
        catch (Exception e) {
            IcsManagerKt.getLOG().error((Throwable)e);
            return false;
        }
        return true;
    }

    protected abstract void addToIndex(@NotNull File var1, @NotNull String var2, @NotNull byte[] var3, int var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void delete(@NotNull String path) {
        int index;
        int it;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        if (IcsManagerKt.getLOG().isDebugEnabled()) {
            IcsManagerKt.getLOG().debug("Remove " + path);
        }
        ReentrantReadWriteLock $receiver = this.lock;
        ReentrantReadWriteLock.ReadLock rl = $receiver.readLock();
        int readCount = $receiver.getWriteHoldCount() == 0 ? $receiver.getReadHoldCount() : 0;
        int n = 0;
        int n2 = readCount - 1;
        if (n <= n2) {
            void index2;
            do {
                it = ++index2;
                rl.unlock();
            } while (index2 != n2);
        }
        ReentrantReadWriteLock.WriteLock wl = $receiver.writeLock();
        wl.lock();
        try {
            File file = new File(this.getDir(), path);
            if (file.exists()) {
                this.delete(file, path);
            }
            Unit unit = Unit.INSTANCE$;
        }
        catch (Throwable throwable) {
            index = 0;
            int n3 = readCount - 1;
            if (index <= n3) {
                do {
                    int it2 = ++index;
                    rl.lock();
                } while (index != n3);
            }
            wl.unlock();
            throw throwable;
        }
        it = 0;
        int n4 = readCount - 1;
        if (it <= n4) {
            do {
                int it3 = ++index;
                rl.lock();
            } while (index != n4);
        }
        wl.unlock();
    }

    private final void delete(File file, String path) {
        boolean isFile = file.isFile();
        BaseRepositoryManagerKt.removeWithParentsIfEmpty(file, this.dir, isFile);
        this.deleteFromIndex(path, isFile);
    }

    protected abstract void deleteFromIndex(@NotNull String var1, boolean var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean has(@NotNull String path) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        ReentrantReadWriteLock $receiver = this.lock;
        ReentrantReadWriteLock.ReadLock rl = $receiver.readLock();
        rl.lock();
        try {
            bl = new File(this.getDir(), path).exists();
        }
        finally {
            rl.unlock();
        }
        return bl;
    }

    @NotNull
    protected final File getDir() {
        return this.dir;
    }

    public BaseRepositoryManager(@NotNull File dir) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        this.dir = dir;
        this.lock = new ReentrantReadWriteLock();
    }
}

