/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.configurationStore.SchemeManagerFactoryImplKt;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.ide.actions.ExportSettingsAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ExportableComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.Collection;
import kotlin.ArraysKt;
import kotlin.StringsKt;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.settingsRepository.IcsManager;
import org.jetbrains.settingsRepository.IcsManagerKt;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"'\b)y1m\u001c9z\u0019>\u001c\u0017\r\\\"p]\u001aLwM\u0003\bti>\u0014\u0018mZ3NC:\fw-\u001a:\u000b/M#\u0018\r^3Ti>\u0014\u0018mZ3NC:\fw-\u001a:J[Bd'bA2p[*A\u0011N\u001c;fY2L'N\u0003\nd_:4\u0017nZ;sCRLwN\\*u_J,'\u0002B+oSRTaa[8uY&t'\"H\"paf\f\u0005\u000f]*fiRLgnZ:U_J+\u0007o\\:ji>\u0014\u0018p\u0013;\u000b\u001d\u001d,GOU8b[&tw\rV=qK*Q1m\\7q_:,g\u000e^:\u000b\u0015\r{G\u000e\\3di&|gNC\nFqB|'\u000f^1cY\u0016\u001cu.\u001c9p]\u0016tGOC\u0004pa\u0016t\u0017\r]5\u000b\u0017I{\u0017-\\5oORK\b/\u001a\u0006\u0005U\u00064\u0018M\u0003\u0003vi&d'\"D:bm\u0016$\u0015N]3di>\u0014\u0018P\u0003\u0004qCJ,g\u000e\u001e\u0006\u0005\r&dWM\u0003\u0002j_*q\u0001/\u0019:f]R4\u0015\u000e\\3Ta\u0016\u001c'BB*ue&twMC\u0006s_\u0006l\u0017N\\4UsB,'BD:ue\u0016\fW\u000e\u0015:pm&$WM\u001d\u0006\u0012\u0013\u000e\u001c8\u000b\u001e:fC6\u0004&o\u001c<jI\u0016\u0014(BC%dg6\u000bg.Y4fe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BE:fiRLgnZ:SKB|7/\u001b;pefTA\u0001\\1oO*a\u0012jY:NC:\fw-\u001a:%\u0013\u000e\u001c8\u000b\u001e:fC6\u0004&o\u001c<jI\u0016\u0014(7\u0001\u0006\u0003!\rQA\u0001\u0003\u0001\u0011\t)!\u0001\"\u0001\t\u0006\u0015\u0019A!\u0001\u0005\u0002\u0019\u0001)\u0011\u0001c\u0002\u0006\u0007\u0011\u0011\u0001b\u0001\u0007\u0001\u000b\t!\u0011\u0001C\u0001\u0006\u0007\u0011\u0011\u00012\u0002\u0007\u0001\u000b\t!\t\u0001#\u0004\u0006\u0005\u0011!\u0001\"B\u0003\u0004\t\u0013Aa\u0001\u0004\u0001\u0006\u0007\u0011%\u0001b\u0002\u0007\u0001\u000b\t!I\u0001C\u0004\u0006\u0003!=QA\u0001C\u0007\u0011!)!\u0001B\u0004\t\f\u0015\u0011AQ\u0002\u0005\u000b\u000b\r!\u0001\u0002c\u0005\r\u0001\u0015\u0019AA\u0001\u0005\f\u0019\u0001)\u0011\u0001c\u0007\u0006\u0005\u0011M\u0001BD\u0003\u0003\t)Ai\"B\u0002\u0005\u0016!iA\u0002A\u0003\u0004\t-AI\u0002\u0004\u0001\u0006\u0005\u0011A\u00012C\u0003\u0003\t\u001bAq\"\u0002\u0002\u0005\u001a!YQA\u0001C\u000b\u0011?)i\u0003B\u0002\u0019\u0001u=A!\u0001E\u0001\u001b\r)\u0011\u0001c\u0001\u0019\u0004A\u001b\u0001!I\u0002\u0006\u0003!\u0015\u0001TA)\u0004\u000b\u0011\u0001\u0011\"\u0001\u0003\u0001\u001b\u0005A1\u0001W\u0002\u0005\u000bo!\u0011\u0001'\u0003\u001e\u001a\u0011\u0001\u0001\"B\u0007\t\u000b\u0005A9!\u0003\u0003\n\u0007\u0015\t\u0001\"\u0002\r\u00061\u000f\u00016\u0001A\u0011\u0004\u000b\u0005AY\u0001g\u0003R\u0007\u0015!I!C\u0001\t\r5\t\u0001r\u0002-\u0004\t\u00151D!\u0001M\t;\u001f!\u0001\u0001C\u0005\u000e\u0007\u0015\t\u0001\u0012\u0003M\t!\u000e\u0001Qt\u0002\u0003\u0001\u0011+i1!B\u0001\t\u0013aI\u0001k!\u0001\u001e\u0010\u0011\u0001\u0001rC\u0007\u0004\u000b\u0005AY\u0001g\u0003Q\u0007\u0005iz\u0001\u0002\u0001\t\u00195\u0019Q!\u0001E\f1/\u000161A\u0011\u0004\u000b\u0005A)\u0001'\u0002R\u0007-!\t\"C\u0001\u0005\u00015\t\u0001\u0002D\u0007\u0002\u00115i\u0011\u0001\u0003\u0004\u000e\u0003!m\u0001l\u0001\u0003"})
public final class CopyAppSettingsToRepositoryKt {
    public static final void copyLocalConfig(@NotNull StateStorageManagerImpl storageManager) {
        Intrinsics.checkParameterIsNotNull((Object)storageManager, (String)"storageManager");
        StreamProvider streamProvider = storageManager.getStreamProvider();
        if (streamProvider == null) {
            Intrinsics.throwNpe();
        }
        if (streamProvider == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.settingsRepository.IcsManager.IcsStreamProvider");
        }
        IcsManager.IcsStreamProvider streamProvider2 = (IcsManager.IcsStreamProvider)streamProvider;
        MultiMap fileToComponents = ExportSettingsAction.getExportableComponentsMap((boolean)true, (boolean)false, (StateStorageManager)((StateStorageManager)storageManager));
        for (File file : fileToComponents.keySet()) {
            String canonicalPath;
            String absolutePath;
            String string = absolutePath = FileUtilRt.toSystemIndependentName((String)file.getAbsolutePath());
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"absolutePath");
            String fileSpec = storageManager.collapseMacros(string);
            IcsManagerKt.LOG.assertTrue(!StringsKt.contains$default((String)fileSpec, (CharSequence)SchemeManagerFactoryImplKt.getROOT_CONFIG(), (boolean)false, (int)2));
            if (fileSpec.equals(absolutePath) && !(canonicalPath = FileUtilRt.toSystemIndependentName((String)file.getCanonicalPath())).equals(absolutePath)) {
                String string2 = canonicalPath;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"canonicalPath");
                fileSpec = storageManager.collapseMacros(string2);
            }
            Collection collection = fileToComponents.get((Object)file);
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"fileToComponents.get(file)");
            RoamingType roamingType = CopyAppSettingsToRepositoryKt.getRoamingType(collection);
            if (file.isFile()) {
                byte[] fileBytes = FileUtil.loadFileBytes((File)file);
                Intrinsics.checkExpressionValueIsNotNull((Object)fileBytes, (String)"fileBytes");
                streamProvider2.doSave(fileSpec, fileBytes, fileBytes.length, roamingType);
                continue;
            }
            File file2 = file;
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
            CopyAppSettingsToRepositoryKt.saveDirectory(file2, fileSpec, roamingType, streamProvider2);
        }
    }

    public static /* synthetic */ void copyLocalConfig$default(StateStorageManagerImpl stateStorageManagerImpl, int n) {
        if ((n & 1) != 0) {
            Application application = ApplicationManager.getApplication();
            if (application == null) {
                Intrinsics.throwNpe();
            }
            StateStorageManager stateStorageManager = ServiceKt.getStateStore((ComponentManager)((ComponentManager)application)).getStateStorageManager();
            if (stateStorageManager == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.StateStorageManagerImpl");
            }
            stateStorageManagerImpl = (StateStorageManagerImpl)stateStorageManager;
        }
        CopyAppSettingsToRepositoryKt.copyLocalConfig(stateStorageManagerImpl);
    }

    public static final void saveDirectory(@NotNull File parent, @NotNull String parentFileSpec, @NotNull RoamingType roamingType, @NotNull IcsManager.IcsStreamProvider streamProvider) {
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        Intrinsics.checkParameterIsNotNull((Object)parentFileSpec, (String)"parentFileSpec");
        Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
        Intrinsics.checkParameterIsNotNull((Object)streamProvider, (String)"streamProvider");
        File[] files2 = parent.listFiles();
        if (files2 != null) {
            for (int i = 0; i < files2.length; ++i) {
                File file = files2[i];
                String childFileSpec = parentFileSpec + '/' + file.getName();
                if (file.isFile()) {
                    byte[] fileBytes = FileUtil.loadFileBytes((File)file);
                    Intrinsics.checkExpressionValueIsNotNull((Object)fileBytes, (String)"fileBytes");
                    streamProvider.doSave(childFileSpec, fileBytes, fileBytes.length, roamingType);
                    continue;
                }
                File file2 = file;
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
                CopyAppSettingsToRepositoryKt.saveDirectory(file2, childFileSpec, roamingType, streamProvider);
            }
        }
    }

    @NotNull
    public static final RoamingType getRoamingType(@NotNull Collection<? extends ExportableComponent> components) {
        Intrinsics.checkParameterIsNotNull(components, (String)"components");
        for (ExportableComponent exportableComponent : components) {
            Storage[] storages;
            State stateAnnotation;
            if (exportableComponent instanceof ExportSettingsAction.ExportableComponentItem) {
                RoamingType roamingType = ((ExportSettingsAction.ExportableComponentItem)exportableComponent).getRoamingType();
                Intrinsics.checkExpressionValueIsNotNull((Object)roamingType, (String)"component.roamingType");
                return roamingType;
            }
            if (!(exportableComponent instanceof PersistentStateComponent) || (stateAnnotation = ((PersistentStateComponent)exportableComponent).getClass().getAnnotation(State.class)) == null || ArraysKt.isEmpty((Object[])(storages = stateAnnotation.storages()))) continue;
            return storages[0].roamingType();
        }
        return RoamingType.DEFAULT;
    }
}

