/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Time;
import java.io.File;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.settingsRepository.IcsSettings;
import org.jetbrains.settingsRepository.MyPrettyPrinter;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"G\u0004)!B)\u0012$B+2#vlQ(N\u001b&#v\fR#M\u0003fS1!\u00138u\u0015\u0019Yw\u000e\u001e7j]*9r-\u001a;E\u000b\u001a\u000bU\u000b\u0014+`\u0007>kU*\u0013+`\t\u0016c\u0015)\u0017\u0006\u000e\u0013\u000e\u001c8+\u001a;uS:<7o\u0013;\u000b\u00191|\u0017\rZ*fiRLgnZ:\u000b\u0019M,G\u000f^5oON4\u0015\u000e\\3\u000b\t\u0019KG.\u001a\u0006\u0005U\u00064\u0018M\u0003\u0002j_*Y\u0011jY:TKR$\u0018N\\4t\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NT!c]3ui&twm\u001d*fa>\u001c\u0018\u000e^8ss*a1/\u0019<f'\u0016$H/\u001b8hg*A1/\u001a;uS:<7O\u0003\u0003V]&$(J\u0003\u0002\u0011\u0005)1\u0001\u0002\u0001\t\u00021\u0001Q!\u0001\u0005\u0005\u000b\t!\u0011\u0001#\u0003\u0006\u0007\u0011\r\u0001r\u0001\u0007\u0001\u000b\u0005AY!\u0002\u0002\u0005\u0006!1QA\u0001\u0003\u0004\u0011\u001b)1\u0001b\u0002\t\u000b1\u0001QA\u0001C\u0004\u0011\u0015)!\u0001b\u0001\t\b\u0015\u0019A\u0001\u0001\u0005\t\u0019\u0001)\u0019\u0003B1\u00151\u0001\t3!B\u0001\t\u0002a\u0005Qk\u0001\u0005\u0006\u0007\u0011\u0001\u0011\"\u0001C\u0003\u001b\r!\u0019!C\u0001\u0005\u0006a\u001b!!\"\f\u0005\u0007a\u0015Qt\u0002\u0003\u0001\u0011\ri1!B\u0001\t\u0005a\u0011\u0001k\u0001\u0001\"\u0007\u0015\t\u0001\u0002\u0002\r\u0005#\u000e)AQA\u0005\u0002\u0011\u0013i\u0011\u0001C\u0003Y\u0007\t)\u0011\u0005B\u0002\u0019\u000fu=A\u0001\u0001E\b\u001b\r)\u0011\u0001\u0003\u0003\u0019\tA\u001b\u0001!h\u0004\u0005\u0001!\u0019QbA\u0003\u0002\u0011\tA\"\u0001UB\u0001C\r)\u0011\u0001c\u0003\u0019\fE\u001bq\u0001B\u0004\n\u0003\u0011\u0001Q\"\u0001E\u0005\u001b\u0005AQ\u0001W\u0002\u0003"})
public final class IcsSettingsKt {
    static final int DEFAULT_COMMIT_DELAY = 600000;

    public static final int getDEFAULT_COMMIT_DELAY() {
        return DEFAULT_COMMIT_DELAY;
    }

    public static final void saveSettings(@NotNull IcsSettings settings, @NotNull File settingsFile) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)settingsFile, (String)"settingsFile");
        byte[] serialized = new ObjectMapper().writer((PrettyPrinter)new MyPrettyPrinter()).writeValueAsBytes((Object)settings);
        if (serialized.length <= 2) {
            FileUtil.delete((File)settingsFile);
        } else {
            FileUtil.writeToFile((File)settingsFile, (byte[])serialized);
        }
    }

    @NotNull
    public static final IcsSettings loadSettings(@NotNull File settingsFile) {
        Intrinsics.checkParameterIsNotNull((Object)settingsFile, (String)"settingsFile");
        if (!settingsFile.exists()) {
            return new IcsSettings();
        }
        IcsSettings settings = (IcsSettings)new ObjectMapper().readValue(settingsFile, IcsSettings.class);
        if (settings.getCommitDelay() <= 0) {
            settings.setCommitDelay(DEFAULT_COMMIT_DELAY);
        }
        IcsSettings icsSettings = settings;
        Intrinsics.checkExpressionValueIsNotNull((Object)icsSettings, (String)"settings");
        return icsSettings;
    }

    static {
        DEFAULT_COMMIT_DELAY = 10 * Time.MINUTE;
    }
}

