/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.CollectionItemEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.table.TableModelEditor;
import gnu.trove.THashSet;
import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.keychain.CredentialsStore;
import org.jetbrains.settingsRepository.IcsBundle;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.IcsSettings;
import org.jetbrains.settingsRepository.ReadOnlySourcesEditorKt;
import org.jetbrains.settingsRepository.ReadOnlySourcesManager;
import org.jetbrains.settingsRepository.ReadonlySource;
import org.jetbrains.settingsRepository.git.GitExKt;
import org.jetbrains.settingsRepository.git.JGitProgressMonitorKt;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={":\u0006)91i\u0014'V\u001b:\u001b&\"B!se\u0006L(BB6pi2LgN\u0003\nFI&$\u0018M\u00197f\u0007>dW/\u001c8J]\u001a|'\u0002\u0005+bE2,Wj\u001c3fY\u0016#\u0017\u000e^8s\u0015\r\u0019w.\u001c\u0006\tS:$X\r\u001c7jU*!Q\u000f^5m\u0015\t)\u0018NC\u0003uC\ndWM\u0003\bSK\u0006$wN\u001c7z'>,(oY3\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*\u00112/\u001a;uS:<7OU3q_NLGo\u001c:z\u0015)\u0019u.\u001c9be\u0006\u0014G.\u001a\u0006\u0004\u0003:L(b\t+bE2,Wj\u001c3fY\u0016#\u0017\u000e^8sI\u0015#\u0017\u000e^1cY\u0016\u001cu\u000e\\;n]&sgm\u001c\u0006\u000bO\u0016$8i\u0014'V\u001b:\u001b&b\u0006*fC\u0012|e\u000e\\=T_V\u00148-Z:FI&$xN]&u\u0015m\u0019'/Z1uKJ+\u0017\rZ(oYf\u001cv.\u001e:dKN,E-\u001b;pe*q1i\u001c8gS\u001e,(/\u00192mKVK'bB8qK:\f\u0007/\u001b\u0006\b_B$\u0018n\u001c8t\u0015-I5m]*fiRLgnZ:\t\u0004)\u0011\u0001C\u0001\u0006\u0007\u0011\u0001\u0001\u0012\u0001\u0007\u0001\u000b\u0005A)!\u0002\u0002\u0005\u0003!\u0019QA\u0001C\u0002\u0011\u000f)!\u0001\u0002\u0002\t\t\u0015\u0011AQ\u0001E\u0005\u000b\r!1\u0001\u0003\u0002\r\u0001\u0015\u0019Aq\u0001E\u0002\u0019\u0001)\u0011\u0001c\u0003\u0006\u0005\u0011%\u0001BB\u0003\u0003\t\u0015Ai!B\u0002\u0005\f!)A\u0002A\u0003\u0004\t\u0001Aq\u0001\u0004\u0001\u0006\u0007\u0011\u0001\u0001r\u0002\u0007\u0001\u000b\t!1\u0001\u0003\u0005\u0006\u0005\u0011\r\u0001RC\u0003\u0003\t!A1\"B\u0002\u0005\u0012!QA\u0002A\u0003\u0004\t\u0017A9\u0002\u0004\u0001\u0006\u0005\u0011E\u0001BCC+\t\u0005$\u0001\u0004A\u0011\u001b\u000b\u0005A\t!\u0003\f\n+\u0015\t\u0001\u0002B\u0005\u0005\u0013\r)\u0011\u0001\u0003\u0004\u0019\r%aA\u0011A\u0005\u000b\u000b\u0005Ai!\u0003\u0004\u0005\u0002%!Q!\u0001\u0005\b\u0019\u0003Ar\u0001'\u0004\u0019\ta\u0005Qk\u0001\u0006\u0006\t\u0011\u0001\u0011B\u0001E\b\u0019\u0003iA\u0001\"\u0005\n\u0005!=A\u0012\u0001-\u0004\u0013\u0015\tB\u0001\u0001M\nC!)\u0011\u0001C\u0005\n\t%\u0019Q!\u0001E\n1'A\u0012\"U\u0002\u0004\t'I\u0011\u0001\u0003\u0006Y\u0007%\u0001"})
public final class ReadOnlySourcesEditorKt {
    @NotNull
    static final TableModelEditor.EditableColumnInfo<ReadonlySource, ? extends Comparable<? extends Object>>[] COLUMNS = new TableModelEditor.EditableColumnInfo[]{(TableModelEditor.EditableColumnInfo)new TableModelEditor.EditableColumnInfo<ReadonlySource, Boolean>(){
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(COLUMNS.1.class);
        }

        @NotNull
        public Class<Boolean> getColumnClass() {
            return Boolean.TYPE;
        }

        @NotNull
        public Boolean valueOf(@NotNull ReadonlySource item) {
            Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
            return item.getActive();
        }

        public void setValue(@NotNull ReadonlySource item, boolean value) {
            Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
            item.setActive(value);
        }
    }, (TableModelEditor.EditableColumnInfo)new TableModelEditor.EditableColumnInfo<ReadonlySource, String>(){
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(COLUMNS.2.class);
        }

        @Nullable
        public String valueOf(@NotNull ReadonlySource item) {
            Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
            return item.getUrl();
        }

        public void setValue(@NotNull ReadonlySource item, @NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            item.setUrl(value);
        }
    }};

    @NotNull
    public static final TableModelEditor.EditableColumnInfo<ReadonlySource, ? extends Comparable<? extends Object>>[] getCOLUMNS() {
        return COLUMNS;
    }

    @NotNull
    public static final ConfigurableUi<IcsSettings> createReadOnlySourcesEditor() {
        TableModelEditor.DialogItemEditor<ReadonlySource> itemEditor2 = new TableModelEditor.DialogItemEditor<ReadonlySource>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(createReadOnlySourcesEditor.itemEditor.1.class);
            }

            @NotNull
            public ReadonlySource clone(@NotNull ReadonlySource item, boolean forInPlaceEditing) {
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                return new ReadonlySource(item.getUrl(), item.getActive());
            }

            @NotNull
            public Class<ReadonlySource> getItemClass() {
                return ReadonlySource.class;
            }

            public void edit(@NotNull ReadonlySource item, @NotNull Function<ReadonlySource, ReadonlySource> mutator, boolean isAdd) {
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                Intrinsics.checkParameterIsNotNull(mutator, (String)"mutator");
                DialogBuilder dialogBuilder = new DialogBuilder();
                TextFieldWithBrowseButton urlField = new TextFieldWithBrowseButton(new JTextField(20));
                urlField.addBrowseFolderListener(new TextBrowseFolderListener(FileChooserDescriptorFactory.createSingleFolderDescriptor()));
                urlField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(urlField, dialogBuilder){
                    public static final /* synthetic */ KClass $kotlinClass;
                    final /* synthetic */ TextFieldWithBrowseButton $urlField;
                    final /* synthetic */ DialogBuilder $dialogBuilder;

                    static {
                        $kotlinClass = Reflection.createKotlinClass(createReadOnlySourcesEditor.itemEditor.edit.1.class);
                    }

                    protected void textChanged(@NotNull DocumentEvent event) {
                        boolean enabled;
                        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                        String url = StringUtil.nullize((String)this.$urlField.getText());
                        try {
                            enabled = url != null && url.length() > 1 && IcsManagerKt.getIcsManager().getRepositoryService().checkUrl(url, null);
                        }
                        catch (Exception e) {
                            enabled = false;
                        }
                        this.$dialogBuilder.setOkActionEnabled(enabled);
                    }
                    {
                        this.$urlField = $captured_local_variable$0;
                        this.$dialogBuilder = $captured_local_variable$1;
                    }
                });
                dialogBuilder.title("Add read-only source").resizable(false).centerPanel((JComponent)FormBuilder.createFormBuilder().addLabeledComponent("URL:", (JComponent)urlField).getPanel()).setPreferredFocusComponent((JComponent)urlField);
                if (dialogBuilder.showAndGet()) {
                    ((ReadonlySource)mutator.fun((Object)item)).setUrl(urlField.getText());
                }
            }

            public void applyEdited(@NotNull ReadonlySource oldItem, @NotNull ReadonlySource newItem) {
                Intrinsics.checkParameterIsNotNull((Object)oldItem, (String)"oldItem");
                Intrinsics.checkParameterIsNotNull((Object)newItem, (String)"newItem");
                newItem.setUrl(oldItem.getUrl());
            }

            public boolean isUseDialogToAdd() {
                return true;
            }
        };
        TableModelEditor editor = new TableModelEditor((ColumnInfo[])COLUMNS, (CollectionItemEditor)itemEditor2, "No sources configured");
        editor.reset(IcsManagerKt.getIcsManager().getSettings().getReadOnlySources());
        return (ConfigurableUi)new ConfigurableUi<IcsSettings>(editor){
            public static final /* synthetic */ KClass $kotlinClass;
            final /* synthetic */ TableModelEditor $editor;

            static {
                $kotlinClass = Reflection.createKotlinClass(createReadOnlySourcesEditor.1.class);
            }

            public boolean isModified(@NotNull IcsSettings settings) {
                Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
                return this.$editor.isModified();
            }

            public void apply(@NotNull IcsSettings settings) {
                Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
                List<ReadonlySource> oldList = settings.getReadOnlySources();
                THashSet toDelete = new THashSet(oldList.size());
                for (ReadonlySource oldSource : oldList) {
                    ContainerUtil.addIfNotNull((Collection)((Collection)toDelete), (Object)oldSource.getPath());
                }
                THashSet toCheckout = new THashSet();
                List newList = this.$editor.apply();
                for (ReadonlySource newSource : newList) {
                    String path = newSource.getPath();
                    if (path == null || toDelete.remove((Object)path)) continue;
                    toCheckout.add((Object)newSource);
                }
                if (toDelete.isEmpty() && toCheckout.isEmpty()) {
                    return;
                }
                ProgressManager.getInstance().run((Task)new Task.Modal(toDelete, toCheckout, newList, null, IcsBundle.Companion.message("task.sync.title", new Object[0]), true){
                    public static final /* synthetic */ KClass $kotlinClass;
                    final /* synthetic */ THashSet $toDelete;
                    final /* synthetic */ THashSet $toCheckout;
                    final /* synthetic */ List $newList;

                    static {
                        $kotlinClass = Reflection.createKotlinClass(createReadOnlySourcesEditor.apply.1.class);
                    }

                    public void run(@NotNull ProgressIndicator indicator) {
                        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                        indicator.setIndeterminate(true);
                        File root = IcsManagerKt.getIcsManager().getReadOnlySourcesManager().getRootDir();
                        if (CollectionsKt.isNotEmpty((Collection)((Collection)this.$toDelete))) {
                            indicator.setText("Deleting old repositories");
                            for (String path : this.$toDelete) {
                                indicator.checkCanceled();
                                try {
                                    indicator.setText2(path);
                                    FileUtil.delete((File)new File(root, path));
                                }
                                catch (Exception e) {
                                    IcsManagerKt.getLOG().error((Throwable)e);
                                }
                            }
                        }
                        if (CollectionsKt.isNotEmpty((Collection)((Collection)this.$toCheckout))) {
                            for (ReadonlySource source : this.$toCheckout) {
                                indicator.checkCanceled();
                                try {
                                    File dir;
                                    StringBuilder stringBuilder = new StringBuilder().append("Cloning ");
                                    String string = source.getUrl();
                                    if (string == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    indicator.setText(stringBuilder.append(StringUtil.trimMiddle((String)string, (int)255)).toString());
                                    String string2 = source.getPath();
                                    if (string2 == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    if ((dir = new File(root, string2)).exists()) {
                                        FileUtil.delete((File)dir);
                                    }
                                    String string3 = source.getUrl();
                                    if (string3 == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    NotNullLazyValue notNullLazyValue = (NotNullLazyValue)IcsManagerKt.getIcsManager().getCredentialsStore();
                                    ProgressMonitor progressMonitor = JGitProgressMonitorKt.asProgressMonitor(indicator);
                                    Intrinsics.checkExpressionValueIsNotNull((Object)progressMonitor, (String)"indicator.asProgressMonitor()");
                                    GitExKt.cloneBare(string3, dir, (NotNullLazyValue<CredentialsStore>)notNullLazyValue, progressMonitor).close();
                                }
                                catch (Exception e) {
                                    IcsManagerKt.getLOG().error((Throwable)e);
                                }
                            }
                        }
                        ReadOnlySourcesManager readOnlySourcesManager = IcsManagerKt.getIcsManager().getReadOnlySourcesManager();
                        List list = this.$newList;
                        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"newList");
                        readOnlySourcesManager.setSources(list);
                    }
                    {
                        this.$toDelete = $captured_local_variable$0;
                        this.$toCheckout = $captured_local_variable$1;
                        this.$newList = $captured_local_variable$2;
                        super($super_call_param$3, $super_call_param$4, $super_call_param$5);
                    }
                });
            }

            public void reset(@NotNull IcsSettings settings) {
                Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
                this.$editor.reset(settings.getReadOnlySources());
            }

            @NotNull
            public JComponent getComponent() {
                return this.$editor.createComponent();
            }
            {
                this.$editor = $captured_local_variable$0;
            }
        };
    }
}

