/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.util.SmartList;
import java.io.File;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.IcsSettings;
import org.jetbrains.settingsRepository.ReadonlySource;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"(\u0006)1\"+Z1e\u001f:d\u0017pU8ve\u000e,7/T1oC\u001e,'OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b%M,G\u000f^5oON\u0014V\r]8tSR|'/\u001f\u0006\u0004\u0003:L(BB6pi2LgN\u0003\u0004=S:LGO\u0010\u0006\tg\u0016$H/\u001b8hg*Y\u0011jY:TKR$\u0018N\\4t\u0015\u001d\u0011xn\u001c;ESJTAAR5mK*!!.\u0019<b\u0015\tIwNC\u0007`e\u0016\u0004xn]5u_JLWm\u001d\u0006\u0005\u0019&\u001cHO\u0003\u0006SKB|7/\u001b;pefTq!Z2mSB\u001cXM\u0003\u0003kO&$(b\u00017jE*!Q\u000f^5m\u00151\u0011X\r]8tSR|'/[3t\u0015=9W\r\u001e*fa>\u001c\u0018\u000e^8sS\u0016\u001c(BC4fiJ{w\u000e\u001e#je*Q1/\u001a;T_V\u00148-Z:\u000b\u000fM|WO]2fg*q!+Z1e_:d\u0017pU8ve\u000e,'\u0002B+oSRT1b]8ve\u000e,Gk\u001c#je*11o\\;sG\u0016t\u0019A\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\r!\u0011\u0001\u0003\u0001\r\u0001\u0015\t\u0001RA\u0003\u0004\t\tA!\u0001\u0004\u0001\u0006\u0007\u0011\t\u0001\u0002\u0002\u0007\u0001\u000b\u0005AY!\u0002\u0002\u0005\b!1Qa\u0001\u0003\u0005\u0011\u0015a\u0001!\u0002\u0002\u0005\u0003!!QA\u0001\u0003\u0005\u0011\u0015)1\u0001\u0002\u0002\t\u000f1\u0001QA\u0001\u0003\u0001\u0011!)!\u0001\"\u0004\t\u0012\u0015\u0011Aa\u0002\u0005\n\u000b\r!y\u0001c\u0004\r\u0001\u0015\u0011Aq\u0001E\n\u000b\t!\t\u0002C\u0004\u0006\u0007\u0011\t\u0001\u0012\u0004\u0007\u0001\u000b\r!!\u0001C\u0007\r\u0001\u0015\u0011A!\u0001E\r\t\ra\u0019!G\u0002\u0006\u0003!\u0015\u0001TA\u0017\u0013\t\u0005g\u0001TB\u0011\n\u000b\u0005Aa!\u0003\u0003\n\u0007\u0015\t\u0001\u0002\u0003\r\t\u0019\u0003Ab!V\u0002\u0005\u000b\r!i!C\u0001\t\u00135\u0012Ba\u0019\u0003\u0019\u0015\u0005BQ!\u0001\u0005\u0007\u0013\u0011I1!B\u0001\t\u0011aA\u0001D\u0002\u0013$+\u000e!Qb\u0001C\u000b\u0013\u0005A\u0011\"\f\t\u0005G\u0012AJ!I\u0002\u0006\u0003!%\u0001\u0014B+\u0004\u0011\u0015\u0019A\u0011B\u0005\u0002\u0011\u0017i1\u0001B\u0006\n\u0003!-Q\u0006\u0004\u0003b\ta\u001d\u0011eA\u0003\u0002\u0011\rA2!V\u0002\u0005\u000b\r!9!C\u0001\t\u000b5RBa\u0001M\f;3!\u0001\u0001\u0003\u0007\u000e\u0011\u0015\t\u0001BB\u0005\u0005\u0013\r)\u0011\u0001c\u0005\u0019\u0014a1\u0001k\u0001\u0001\"\u0007\u0015\t\u0001B\u0003\r\u000b#\u000e)AqC\u0005\u0002\t\u0001i\u0011\u0001C\u0005.+\u0011\u001d\u00014DO\b\t\u0001Aa\"D\u0002\u0006\u0003!M\u00014\u0003)\u0004\u0001\u0005\u001aQ!\u0001E\u00051\u0013\t6!\u0002C\u000e\u0013\u0005AY!D\u0001\t\u0016U\nS\u0001\t\u0003d\u0002a\u0019Qt\u0002\u0003\u0001\u0011\u000fi1!B\u0001\t\u0007a\u0019\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001\u0012B\u0007\u0004\u000b\u0005AI\u0001'\u0003Q\u0007\u0003\t3!B\u0001\t\u0004a\r\u0011kA\u0004\u0005\u0007%\tA\u0001A\u0007\u0002\u0011\u0015i\u0011\u0001c\u0003"})
public final class ReadOnlySourcesManager {
    public static final /* synthetic */ KClass $kotlinClass;
    private List<? extends Repository> _repositories;
    private final IcsSettings settings;
    @NotNull
    private final File rootDir;

    static {
        $kotlinClass = Reflection.createKotlinClass(ReadOnlySourcesManager.class);
    }

    @NotNull
    public final List<Repository> getRepositories() {
        List r = this._repositories;
        if (r == null) {
            if (this.settings.getReadOnlySources().isEmpty()) {
                r = CollectionsKt.emptyList();
            } else {
                r = (List)new SmartList();
                for (ReadonlySource source : this.settings.getReadOnlySources()) {
                    try {
                        String path;
                        if (source.getPath() == null) {
                            continue;
                        }
                        File dir = new File(this.rootDir, path);
                        if (dir.exists()) {
                            ((SmartList)r).add((Object)((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().setBare()).setGitDir(dir)).build());
                            continue;
                        }
                        IcsManagerKt.getLOG().warn("Skip read-only source " + source.getUrl() + " because dir doesn't exists");
                    }
                    catch (Exception e) {
                        IcsManagerKt.getLOG().error((Throwable)e);
                    }
                }
            }
            this._repositories = r;
        }
        return r;
    }

    public final void setSources(@NotNull List<? extends ReadonlySource> sources) {
        Intrinsics.checkParameterIsNotNull(sources, (String)"sources");
        this.settings.setReadOnlySources(sources);
        this._repositories = null;
    }

    @NotNull
    public final File sourceToDir(@NotNull ReadonlySource source) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        String string = source.getPath();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return new File(this.rootDir, string);
    }

    @NotNull
    public final File getRootDir() {
        return this.rootDir;
    }

    public ReadOnlySourcesManager(@NotNull IcsSettings settings, @NotNull File rootDir) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)rootDir, (String)"rootDir");
        this.settings = settings;
        this.rootDir = rootDir;
    }
}

