/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.actions;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.UUID;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.CommitToIcsDialog;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.ProjectId;
import org.jetbrains.settingsRepository.actions.CommitToIcsActionKt;
import org.jetbrains.settingsRepository.actions.ProjectChangeCollectConsumer;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"X\u0006))2m\u001c7mK\u000e$\bK]8kK\u000e$8\t[1oO\u0016\u001c(bB2iC:<Wm\u001d\u0006\u000b\u0007>dG.Z2uS>t'BB6pi2LgN\u0003\u0004DQ\u0006tw-\u001a\u0006\u0004G>l'\u0002C5oi\u0016dG.\u001b6\u000b\u000f=\u0004XM\\1qS*\u0019aoY:\u000b\u001f\r|G\u000e\\3di\u000e{gn];nKJTA\u0004\u0015:pU\u0016\u001cGo\u00115b]\u001e,7i\u001c7mK\u000e$8i\u001c8tk6,'OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b%M,G\u000f^5oON\u0014V\r]8tSR|'/\u001f\u0006\bC\u000e$\u0018n\u001c8t\u0015\u0011)f.\u001b;\u000b\t)\fg/\u0019\u0006\u0005kRLGNC\nD_6l\u0017\u000e\u001e+p\u0013\u000e\u001c\u0018i\u0019;j_:\\EO\u0003\u0007hKR\u0004&o\u001c6fGRLEMC\u0004qe>TWm\u0019;\u000b\u000fA\u0013xN[3di*11\u000b\u001e:j]\u001eTA\u0001\\1oO*\u0019\u0012n\u001d)s_*,7\r^\"p]\u001aLwMR5mK*!a-\u001b7f\u0015-1\u0016N\u001d;vC24\u0015\u000e\\3\u000b\u0007Y47OC\u0004C_>dW-\u00198\u000b\u0015MDwn\u001e#jC2|wMC\u0005qe>TWm\u0019;JIB\u000e!B\u0001\t\u0004\u0015\u0019A\u0001\u0001\u0005\u0002\u0019\u0001)\u0011\u0001#\u0002\u0006\u0005\u0011\t\u0001bA\u0003\u0003\t\u0007A9!\u0002\u0002\u0005\u0005!!QA\u0001C\u0003\u0011\u0003)1\u0001B\u0002\t\u00051\u0001Q!\u0001E\u0006\u000b\t!A\u0001\u0003\u0004\u0006\u0005\u0011%\u0001RB\u0003\u0003\t\u0015Aq!B\u0002\u0005\f!)A\u0002A\u0003\u0004\t\u0001Ay\u0001\u0004\u0001\u0006\u0003!AQA\u0001\u0003\b\u0011#)!\u0001b\u0004\t\u0003\u0015\u0011A1\u0002\u0005\u0006\u000b\t!!\u0001\u0003\u0006\u0006\u0007\u0011I\u0001R\u0003\u0007\u0001\u000b\r!\u0001\u0001C\u0006\r\u0001\u0015\u0011Aa\u0002E\f\u000b\t!)\u0002C\u0006\u0006\u0005\u0011I\u0001RC\u0003\u0003\t\tAY\"B\u0002\u0005\u0019!iA\u0002A\u0003\u0004\t\u0001Aa\u0002\u0004\u0001\u0006\u0005\u0011a\u0001\"D\u0003'\t\u0005A\u0002!(\u0007\u0005\u0001!\u0005Q\u0002C\u0003\u0002\u0011\u0003IA!C\u0002\u0006\u0003!\u001d\u0001t\u0001M\u0001!\u000e\u0001Qt\u0002\u0003\u0001\u0011\u0013i1!B\u0001\t\ra1\u0001k!\u0001\"\u0007\u0015\t\u0001R\u0002M\u0007#\u000e9A\u0001A\u0005\u0002\t\u0001i\u0011\u0001\u0003\u0005\u000e\u0003!E\u0001lA\u0005\u00060\u0011\t\u00014CO\b\t\u0001A!\"D\u0002\u0006\u0003!M\u00014\u0003)\u0004\u0001\u0005\"Q!\u0001\u0005\u000b\u0019\u0003A\"\"U\u0002\u0006\t'I\u0011\u0001C\u0006\u000e\u0003!]\u0001lA\u0005\u0006E\u0011\t\u0001\u0004DO\t\t\u0001AI\"\u0004\u0003\u0006\u0003!eA\u0012\u0001M\r!\u000e\u0001Qt\u0002\u0003\u0001\u0011)i1!B\u0001\t\u0014aM\u0001k!\u0001\"\u0007\u0015\t\u0001\"\u0004\r\u000e#\u000e9A\u0001D\u0005\u0002\t\u0003i\u0011\u0001c\u0007\u000e\u0003!]\u0001lA\u0005\u0006Z\u0011\t\u0001TDO\b\t\u0001A!\"D\u0002\u0006\u0003!M\u00014\u0003)\u0004\u0001u=A\u0001\u0001E\u0005\u001b\r)\u0011\u0001\u0003\u0004\u0019\rA\u001b\t!(\u0005\u0005\u0001!yQ\u0002B\u0003\u0002\u0011)a\t\u0001\u0007\u0006Q\u0007\u0005\t3!B\u0001\t\u000ea5\u0011kA\u0005\u0005\u001e%\tA\u0001A\u0007\u0002\u0011/i\u0011\u0001#\u0005\u000e\u0003!Y\u0001lA\u0005"})
public final class CommitToIcsActionKt {
    @Nullable
    public static final String getProjectId(@NotNull Project project) {
        ProjectId projectId;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Object object = ServiceManager.getService((Project)project, ProjectId.class);
        if (object == null) {
            Intrinsics.throwNpe();
        }
        if ((projectId = (ProjectId)object).getUid() == null && ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)"Settings Server Project Mapping", (String)"Project is not mapped on Settings Server. Would you like to map?").project(project)).doNotAsk((DialogWrapper.DoNotAskOption)new DialogWrapper.PropertyDoNotAskOption(""){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(getProjectId.1.class);
            }

            public void setToBeShown(boolean value, int exitCode) {
                IcsManagerKt.getIcsManager().getSettings().setDoNoAskMapProject(!value);
            }

            public boolean isToBeShown() {
                return !IcsManagerKt.getIcsManager().getSettings().getDoNoAskMapProject();
            }

            public boolean canBeHidden() {
                return true;
            }
        })).show() == 0) {
            projectId.setUid(UUID.randomUUID().toString());
        }
        return projectId.getUid();
    }

    public static final void showDialog(@NotNull Project project, @NotNull ProjectChangeCollectConsumer collectConsumer, @Nullable String projectId) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)collectConsumer, (String)"collectConsumer");
        if (!collectConsumer.hasResult()) {
            return;
        }
        String effectiveProjectId = projectId;
        if (effectiveProjectId == null && (effectiveProjectId = CommitToIcsActionKt.getProjectId(project)) == null) {
            return;
        }
        new CommitToIcsDialog(project, effectiveProjectId, collectConsumer.getResult()).show();
    }

    public static final void collectProjectChanges(@NotNull Collection<? extends Change> changes, @NotNull ProjectChangeCollectConsumer collectConsumer) {
        Intrinsics.checkParameterIsNotNull(changes, (String)"changes");
        Intrinsics.checkParameterIsNotNull((Object)collectConsumer, (String)"collectConsumer");
        for (Change change : changes) {
            collectConsumer.consume(change);
        }
    }

    public static final boolean isProjectConfigFile(@Nullable VirtualFile file, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (file == null) {
            return false;
        }
        String string = project.getBasePath();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return FileUtil.isAncestor((String)string, (String)file.getPath(), (boolean)true);
    }
}

