/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.util.SmartList;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.settingsRepository.actions.CommitToIcsActionKt;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\u0006\u0006)a\u0002K]8kK\u000e$8\t[1oO\u0016\u001cu\u000e\u001c7fGR\u001cuN\\:v[\u0016\u0014(bA8sO*I!.\u001a;ce\u0006Lgn\u001d\u0006\u0013g\u0016$H/\u001b8hgJ+\u0007o\\:ji>\u0014\u0018PC\u0004bGRLwN\\:\u000b\u0007\u0005s\u0017P\u0003\u0004l_Rd\u0017N\u001c\u0006\u0007y%t\u0017\u000e\u001e \u000b\u000fA\u0014xN[3di*9\u0001K]8kK\u000e$(bA2p[*A\u0011N\u001c;fY2L'NC\u0004pa\u0016t\u0017\r]5\u000b\u001dA\u0014xN[3di\u000eC\u0017M\\4fg*YQ*\u001e;bE2,G*[:u\u0015\u0019\u0019\u0005.\u00198hK*\u0019aoY:\u000b\u000f\rD\u0017M\\4fg*!!.\u0019<b\u0015\u0011)H/\u001b7\u000b\t1K7\u000f\u001e\u0006\bG>t7/^7f\u0015\u0019\u0019\u0007.\u00198hK*!QK\\5u\u0015%9W\r\u001e*fgVdGOC\u0005iCN\u0014Vm];mi*9!i\\8mK\u0006t\u00074\u0001\u0006\u0003!\u0005QA\u0001\u0003\u0001\u0011\u0005)!\u0001\"\u0001\t\u0004\u0015\u0011A!\u0001\u0005\u0003\u000b\r!\u0019\u0001\u0003\u0001\r\u0001\u0015\t\u0001bA\u0003\u0004\t\u000bA)\u0001\u0004\u0001\u0006\u0003!)QA\u0001C\u0004\u0011\u0017)!\u0001\u0002\u0003\t\r\u0015\u0011A\u0011\u0002\u0005\u0005\u000b\r!Q\u0001#\u0003\r\u0001\u0015\u0011A!\u0002E\u0005\u000b\r!)\u0001C\u0004\r\u0001\u0015\u0011A\u0011\u0002\u0005\t\u000b\t!q\u0001#\u0005\u0006\u0007\u0011=\u0001r\u0002\u0007\u0001\u000b\u0005A\u0011\"\u0002\u0002\u0005\u0012!MQA\u0001\u0003\n\u0011))1\u0001\"\u0002\t\u00181\u0001QA\u0001C\b\u0011\u001f)1\u0001\"\u0002\t\u00151\u0001Qa\u0001C\u0003\u00115a\u0001\u0001B\u0001\r\u0005e\u0019Q!\u0001\u0005\u00041\riC\u0002B1\u00051\u0011\t3!B\u0001\t\fa-Qk\u0001\u0003\u0006\u0007\u0011!\u0011\"\u0001\u0005\u0007[I!\u0011\u0019\u0004M\u0007C%)\u0011\u0001#\u0004\n\t%\u0019Q!\u0001\u0005\t1!a\t\u0001'\u0004V\u0007\u0011)1\u0001\"\u0004\n\u0003!MQ&\u0006\u0003\u00041+iz\u0001\u0002\u0001\t\u00175\u0019Q!\u0001\u0005\t1!\u00016\u0001A\u0011\u0004\u000b\u0005A!\u0002\u0007\u0006R\u0007\u0015!)\"C\u0001\u0005\u00015\t\u0001RCW\u0010\t\rAB\"\t\u0005\u0006\u0003!Y\u0011\u0002B\u0005\u0004\u000b\u0005A\u0001\u0002\u0007\u0005\u0019\u0017E\u001b1\u0001\u0002\u0007\n\u0003!MQV\u0003\u0003\u000413\t3!B\u0001\t\u0018a]\u0011kA\u0002\u0005\u001a%\tA\u0011A[\u0017\u000bW!1\u001d\u0001M\u0004;\u001f!\u0001\u0001\u0003\u0003\u000e\u0007\u0015\t\u00012\u0002M\u0006!\u000e\u0001\u0011eA\u0003\u0002\u0011\tA\"!U\u0002\u0006\t\u000fI\u0011\u0001\u0002\u0001\u000e\u0003!1\u0001"})
public final class ProjectChangeCollectConsumer {
    public static final /* synthetic */ KClass $kotlinClass;
    private List<Change> projectChanges;
    private final Project project;

    static {
        $kotlinClass = Reflection.createKotlinClass(ProjectChangeCollectConsumer.class);
    }

    public final void consume(@NotNull Change change) {
        Intrinsics.checkParameterIsNotNull((Object)change, (String)"change");
        if (CommitToIcsActionKt.isProjectConfigFile(change.getVirtualFile(), this.project)) {
            if (this.projectChanges == null) {
                this.projectChanges = (List)new SmartList();
            }
            List<Change> list = this.projectChanges;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            list.add(change);
        }
    }

    @NotNull
    public final List<Change> getResult() {
        List<Change> list;
        if (this.projectChanges == null) {
            list = CollectionsKt.listOf();
        } else {
            list = this.projectChanges;
            if (list == null) {
                Intrinsics.throwNpe();
            }
        }
        return list;
    }

    public final boolean hasResult() {
        return this.projectChanges != null;
    }

    public ProjectChangeCollectConsumer(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
    }
}

