/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import kotlin.StringsKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.eclipse.jgit.lib.IndexDiff;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jgit.dirCache.AddFile;
import org.jetbrains.jgit.dirCache.DirCacheEditorKt;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.IcsUrlBuilderKt;
import org.jetbrains.settingsRepository.git.CommitMessageFormatter;
import org.jetbrains.settingsRepository.git.GitExKt;
import org.jetbrains.settingsRepository.git.IdeaCommitMessageFormatter;
import org.jetbrains.settingsRepository.git.JGitProgressMonitorKt;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"y\u0006)11m\\7nSRT!B]3q_NLGo\u001c:z\u0015)\u0011V\r]8tSR|'/\u001f\u0006\u0004_J<'bB3dY&\u00048/\u001a\u0006\u0005U\u001eLGOC\u0002mS\nT\u0011\"\u001b8eS\u000e\fGo\u001c:\u000b#A\u0013xn\u001a:fgNLe\u000eZ5dCR|'OC\u0002d_6T\u0001\"\u001b8uK2d\u0017N\u001b\u0006\b_B,g.\u00199j\u0015!\u0001(o\\4sKN\u001c(BF2p[6LG/T3tg\u0006<WMR8s[\u0006$H/\u001a:\u000b-\r{W.\\5u\u001b\u0016\u001c8/Y4f\r>\u0014X.\u0019;uKJT\u0011B[3uEJ\f\u0017N\\:\u000b%M,G\u000f^5oON\u0014V\r]8tSR|'/\u001f\u0006\u0004O&$(b\u0002\"p_2,\u0017M\u001c\u0006\u0007W>$H.\u001b8\u000b\u0011\r{W.\\5u\u0017RT\u0011#\u001b8eKb$\u0015N\u001a4U_N#(/\u001b8h\u0015\u0011!\u0017N\u001a4\u000b\u0013%sG-\u001a=ES\u001a4'BB*ue&twM\u0003\u0003kCZ\f'\u0002\u00027b]\u001eTQb\u0015;sS:<')^5mI\u0016\u0014(bB1eI2K7\u000f\u001e\u0006\u0005]\u0006lWM\u0003\u0003mSN$(BC\"pY2,7\r^5p]*91m\\7qC\u000e$(\u0002B+oSRTA!\u001e;jY*\t\u0012\r\u001d9f]\u0012\u001cu.\u001c9bGRd\u0015n\u001d;E\u0004)\u0011\u0001c\u0001\u0006\u0005\u0011\u0001\u0001BA\u0003\u0003\t\u0003A)!\u0002\u0002\u0005\u0003!\u0019Qa\u0001C\u0002\u0011\u0005a\u0001!B\u0001\t\n\u0015\u0011AQ\u0001\u0005\u0006\u000b\t!1\u0001c\u0003\u0006\u0005\u0011\u001d\u0001BB\u0003\u0004\t\u0011AA\u0001\u0004\u0001\u0006\u0005\u0011\u0001\u0001rB\u0003\u0003\t\u0015A\u0001\"\u0002\u0002\u0005\f!EQa\u0001\u0003\u0007\u0011\u001da\u0001!B\u0001\t\u0014\u0015\u0019Aa\u0002\u0005\n\u0019\u0001)!\u0001b\u0001\t\u0003\u0015\u0011A\u0001\u0002\u0005\u0005\u000b\t!a\u0001C\u0004\u0006\u0007\u0011\r\u0001r\u0003\u0007\u0001\u000b\r!q\u0001\u0003\u0007\r\u0001\u0015\t\u0001\u0012D\u0003\u0003\t+AQ\"\u0002\u0002\u0005\u0017!aQA\u0001C\u0002\u0011/)1\u0001B\u0006\t\u001c1\u0001Qa\u0001\u0003\b\u0011?a\u0001!B\u0002\u0005\u000f!\u0005B\u0002A\u0003\u0003\t-AY\"\u0002\u0002\u0005\u0016!\tRA\u0001C\u000f\u0011?)I\u0006B\u0002\u0019\u0001u=A\u0001\u0001E\u0001\u001b\r)\u0011\u0001\u0003\u0002\u0019\u0005A\u001b\u0001!(\u0005\u0005\u0001!\u001dQ\u0002B\u0003\u0002\u0011\u0013a\t\u0001'\u0003Q\u0007\u0003iz\u0001B\u0001\t\u000e5\u0019Q!\u0001E\u00071\u001b\u00016!A\u0011\u0004\u000b\u0005Ay\u0001g\u0004R\u0007%!\u0001!C\u0001\u0005\u00025\t\u0001\u0002C\u0007\u0002\u0011#i\u0011\u0001C\u0005Y\u0007))i\u0003B\u0001\u0019\u0016u=A\u0001\u0001\u0005\f\u001b\r)\u0011\u0001c\u0005\u0019\u0014A\u001b\u0001!I\u0002\u0006\u0003!Q\u0001DC)\u0004\u000b\u0011U\u0011\"\u0001E\f\u001b\u0005AA\u0002W\u0002\u000b\u000b[\"\u0011!F\u0002\u0006\u0003!e\u0001\u0014\u0004\r\u000f;\u001f!\u0001\u0001#\b\u000e\u0007\u0015\t\u0001B\u0003\r\u000b!\u000e\u0005Q\u0014\u0004\u0003\u0001\u0011=i\u0001\"B\u0001\t\u001b%!\u0011bA\u0003\u0002\u0011)A\"\u0002G\u0007Q\u0007\u0005iz\u0001B\u0001\t!5\u0019Q!\u0001E\b1\u001f\u000161A\u0011\u0004\u000b\u0005AY\u0002g\u0007R\u0007-!a\"C\u0001\u0005\u00015\t\u0001BD\u0007\u0002\u0011/i\u0011\u0001C\b\u000e\u0003\u0011\u0005\u0001l\u0001\u0006\u0006Y\u0011\tQcA\u0003\u0002\u00113AJ\u0002g\t\u001e\u0010\u0011\u0001\u0001RD\u0007\u0004\u000b\u0005A!\u0002\u0007\u0006Q\u0007\u0003iJ\u0002\u0002\u0001\t\u001f5AQ!\u0001\u0005\u000e\u0013\u0011I1!B\u0001\t\u0015aQ\u0001$\u0004)\u0004\u0003\u0005\u001aQ!\u0001E\u000e17\t6!\u0003C\u0012\u0013\u0005!\u0001!D\u0001\t\u001d5\t\u0001rC\u0007\u0002\u0011=A6A\u0003"})
public final class CommitKt {
    public static final boolean commit(@NotNull Repository repository2, @Nullable ProgressIndicator indicator, @NotNull CommitMessageFormatter commitMessageFormatter) {
        Unit unit;
        Unit unit2;
        Intrinsics.checkParameterIsNotNull((Object)repository2, (String)"repository");
        Intrinsics.checkParameterIsNotNull((Object)commitMessageFormatter, (String)"commitMessageFormatter");
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator != null) {
            progressIndicator.checkCanceled();
            unit2 = Unit.INSTANCE$;
        } else {
            unit2 = null;
        }
        IndexDiff diff = GitExKt.computeIndexDiff(repository2);
        ProgressIndicator progressIndicator2 = indicator;
        boolean changed = diff.diff((ProgressMonitor)(progressIndicator2 != null ? JGitProgressMonitorKt.asProgressMonitor(progressIndicator2) : null), ProgressMonitor.UNKNOWN, ProgressMonitor.UNKNOWN, "Commit");
        if (!changed || diff.getAdded().isEmpty() && diff.getChanged().isEmpty() && diff.getRemoved().isEmpty()) {
            if (diff.getModified().isEmpty()) {
                IcsManagerKt.getLOG().debug("Nothing to commit");
                return false;
            }
            List edits = null;
            for (String path : diff.getModified()) {
                if (StringsKt.startsWith$default((String)path, (String)IcsUrlBuilderKt.getPROJECTS_DIR_NAME(), (boolean)false, (int)2)) continue;
                if (edits == null) {
                    edits = (List)new SmartList();
                }
                String string = path;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path");
                edits.add(new AddFile(string));
            }
            if (edits != null) {
                DirCacheEditorKt.edit(repository2, edits);
            }
        }
        if (IcsManagerKt.getLOG().isDebugEnabled()) {
            IcsManagerKt.getLOG().debug(CommitKt.indexDiffToString(diff));
        }
        ProgressIndicator progressIndicator3 = indicator;
        if (progressIndicator3 != null) {
            progressIndicator3.checkCanceled();
            unit = Unit.INSTANCE$;
        } else {
            unit = null;
        }
        StringBuilder builder = new StringBuilder();
        commitMessageFormatter.prependMessage(builder);
        Collection collection = diff.getChanged();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"diff.changed");
        CommitKt.appendCompactList(builder, "Update", collection);
        Collection collection2 = diff.getAdded();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection2, (String)"diff.added");
        CommitKt.appendCompactList(builder, "Create", collection2);
        Collection collection3 = diff.getRemoved();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection3, (String)"diff.removed");
        CommitKt.appendCompactList(builder, "Delete", collection3);
        GitExKt.commit$default(repository2, builder.toString(), null, null, null, 14);
        return true;
    }

    public static /* synthetic */ boolean commit$default(Repository repository2, ProgressIndicator progressIndicator, CommitMessageFormatter commitMessageFormatter, int n) {
        if ((n & 4) != 0) {
            commitMessageFormatter = new IdeaCommitMessageFormatter();
        }
        return CommitKt.commit(repository2, progressIndicator, commitMessageFormatter);
    }

    @NotNull
    public static final String indexDiffToString(@NotNull IndexDiff diff) {
        Intrinsics.checkParameterIsNotNull((Object)diff, (String)"diff");
        StringBuilder builder = new StringBuilder();
        builder.append("To commit:");
        Collection collection = diff.getAdded();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"diff.added");
        CommitKt.addList$default(builder, "Added", collection, false, 4);
        Collection collection2 = diff.getChanged();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection2, (String)"diff.changed");
        CommitKt.addList$default(builder, "Changed", collection2, false, 4);
        Collection collection3 = diff.getRemoved();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection3, (String)"diff.removed");
        CommitKt.addList$default(builder, "Deleted", collection3, false, 4);
        Collection collection4 = diff.getModified();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection4, (String)"diff.modified");
        CommitKt.addList$default(builder, "Modified on disk relative to the index", collection4, false, 4);
        Collection collection5 = diff.getUntracked();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection5, (String)"diff.untracked");
        CommitKt.addList$default(builder, "Untracked files", collection5, false, 4);
        Collection collection6 = diff.getUntrackedFolders();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection6, (String)"diff.untrackedFolders");
        CommitKt.addList$default(builder, "Untracked folders", collection6, false, 4);
        Collection collection7 = diff.getMissing();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection7, (String)"diff.missing");
        CommitKt.addList$default(builder, "Missing", collection7, false, 4);
        String string = builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
        return string;
    }

    public static final void appendCompactList(StringBuilder $receiver, @NotNull String name, @NotNull Collection<? extends String> list) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(list, (String)"list");
        CommitKt.addList($receiver, name, list, true);
    }

    public static final void addList(StringBuilder $receiver, @NotNull String name, @NotNull Collection<? extends String> list, boolean compact) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(list, (String)"list");
        if (list.isEmpty()) {
            return;
        }
        if (compact) {
            if ($receiver.length() != 0 && $receiver.charAt($receiver.length() - 1) != ' ') {
                $receiver.append('\t');
            }
            $receiver.append(name);
        } else {
            $receiver.append('\t').append(name).append(':');
        }
        $receiver.append(' ');
        boolean isNotFirst = false;
        for (String string : list) {
            if (isNotFirst) {
                $receiver.append(',').append(' ');
            } else {
                isNotFirst = true;
            }
            $receiver.append(compact ? PathUtilRt.getFileName((String)string) : string);
        }
    }

    public static /* synthetic */ void addList$default(StringBuilder stringBuilder, String string, Collection collection, boolean bl, int n) {
        if ((n & 4) != 0) {
            bl = false;
        }
        CommitKt.addList(stringBuilder, string, collection, bl);
    }
}

