/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.openapi.util.text.StringUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import kotlin.StringsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.URIish;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.keychain.Credentials;
import org.jetbrains.settingsRepository.IcsManagerKt;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"V\u0004)a1-\u00198Vg\u0016<\u0015\u000e^#yK*9!i\\8mK\u0006t'BB6pi2LgNC\bhKR\u001c\u0015M\\+tK\u001eKG/\u0012=f\u0015=\u0019X\r^\"b]V\u001bXmR5u\u000bb,'bD$ji\u000e\u0013X\rZ3oi&\fGn\u0013;\u000b-\u001d,Go\u0011:fI\u0016tG/[1mgV\u001b\u0018N\\4HSRT1!\u001e:j\u0015\u0019)&+S5tQ*\u0019qN]4\u000b\u000f\u0015\u001cG.\u001b9tK*!!nZ5u\u0015%!(/\u00198ta>\u0014HO\u0003\u0006sKB|7/\u001b;pefT!BU3q_NLGo\u001c:z\u0015\ra\u0017N\u0019\u0006\f\u0007J,G-\u001a8uS\u0006d7OC\u0005kKR\u0014'/Y5og*A1.Z=dQ\u0006LgN\u0018\u0006\u0003!\tQa\u0001\u0003\u0001\u0011\u0003a\u0001!B\u0001\t\n\u0015\u0011A!\u0001\u0005\u0006\u000b\t!\u0019\u0001c\u0003\u0006\u0005\u0011\u0011\u0001BB\u0003\u0004\t\u000bAA\u0001\u0004\u0001\u0006\u0005\u0011\u0011\u0001rB\u0003\u0004\t\u000fAq\u0001\u0004\u0001\u0006\u0005\u0011\t\u0001\u0012C\u0003\u0003\t\u0013A\u0011\"B\u0002\u0005\u000b!AA\u0002A\u0003\u0003\t\u0015A\u0001\"\u0002\u0002\u0005\u0006!!QA\u0001C\u0004\u0011\u001d)y\u0003Ba\r1\u0001\t3!B\u0001\t\u0002a\u0005Qk\u0001\b\u0006\u0007\u0011\u0001\u0011\"\u0001C\u0001\u001b\r!\u0019!C\u0001\u0005\u0002E)AAA\u0005\u0002\t\u0001i\u0011\u0001\"\u0001Y\u0007\u000b)!\u0005B\u0002\u0019\u0007u=A\u0001\u0001E\u0004\u001b\r)\u0011\u0001C\u0002\u0019\u0007A\u001b\u0001!h\u0004\u0005\u0001!5QbA\u0003\u0002\u0011\u0011AB\u0001UB\u0001C\u0011)\u0011\u0001c\u0003\r\u0002a-\u0011kA\u0004\u0005\u0007%\t\u0001BB\u0007\u0002\u0011\u001bi\u0011\u0001C\u0004Y\u0007\u000b\u0001"})
public final class GitCredentialKt {
    static boolean canUseGitExe = true;

    public static final boolean getCanUseGitExe() {
        return canUseGitExe;
    }

    public static final void setCanUseGitExe(boolean bl) {
        canUseGitExe = bl;
    }

    @Nullable
    public static final Credentials getCredentialsUsingGit(@NotNull URIish uri, @NotNull Repository repository2) {
        Process process;
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        Intrinsics.checkParameterIsNotNull((Object)repository2, (String)"repository");
        if (!canUseGitExe || repository2.getConfig().getSubsections("credential").isEmpty()) {
            return null;
        }
        GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{"git", "credential", "fill"});
        try {
            Process process2 = commandLine.createProcess();
            Intrinsics.checkExpressionValueIsNotNull((Object)process2, (String)"commandLine.createProcess()");
            process = process2;
        }
        catch (ProcessNotCreatedException e) {
            canUseGitExe = false;
            return null;
        }
        OutputStreamWriter writer = ByteStreamsKt.writer$default((OutputStream)process.getOutputStream(), null, (int)1);
        writer.write("url=");
        writer.write(uri.toPrivateString());
        writer.write("\n\n");
        writer.close();
        BufferedReader reader = TextStreamsKt.buffered$default((Reader)ByteStreamsKt.reader$default((InputStream)process.getInputStream(), null, (int)1), (int)0, (int)1);
        Object username = null;
        Object password = null;
        while (true) {
            String line;
            String string = reader.readLine();
            String string2 = line = string != null ? StringsKt.trim((String)string) : null;
            if (line == null || StringsKt.isEmpty((String)line)) break;
            Function0<String> readValue$ = new Function0<String>(line){
                final /* synthetic */ String $line;

                @NotNull
                public final String invoke() {
                    return StringsKt.trim((String)StringsKt.substring((String)this.$line, (int)(StringsKt.indexOf$default((String)this.$line, (char)'=', (int)0, (boolean)false, (int)6) + 1)));
                }
                {
                    this.$line = string;
                    super(0);
                }
            };
            if (StringsKt.startsWith$default((String)line, (String)"username=", (boolean)false, (int)2)) {
                username = readValue$.invoke();
                continue;
            }
            if (!StringsKt.startsWith$default((String)line, (String)"password=", (boolean)false, (int)2)) continue;
            password = readValue$.invoke();
        }
        reader.close();
        String errorText = TextStreamsKt.readText((Reader)ByteStreamsKt.reader$default((InputStream)process.getErrorStream(), null, (int)1));
        if (!StringUtil.isEmpty((String)errorText)) {
            IcsManagerKt.getLOG().warn(errorText);
        }
        return username == null && password == null ? (Credentials)null : new Credentials((String)username, (String)password);
    }
}

