/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import kotlin.CharsKt;
import kotlin.StringsKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.jvm.internal.Ref;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BranchConfig;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ConfigConstants;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.IndexDiff;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.keychain.CredentialsStore;
import org.jetbrains.settingsRepository.AuthenticationException;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.NoRemoteRepositoryException;
import org.jetbrains.settingsRepository.git.InputStreamWrapper;
import org.jetbrains.settingsRepository.git.JGitCredentialsProvider;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"=\u0010)I1\r\\8oK\n\u000b'/\u001a\u0006\u0004kJL'BB*ue&twM\u0003\u0004l_Rd\u0017N\u001c\u0006\u0004I&\u0014(\u0002\u0002$jY\u0016TAA[1wC*\u0011\u0011n\u001c\u0006\u0011GJ,G-\u001a8uS\u0006d7o\u0015;pe\u0016T\u0001CT8u\u001dVdG\u000eT1{sZ\u000bG.^3\u000b\u0007\r|WN\u0003\u0005j]R,G\u000e\\5k\u0015\u001dy\u0007/\u001a8ba&TA!\u001e;jY*\u00012I]3eK:$\u0018.\u00197t'R|'/\u001a\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015!YW-_2iC&t'b\u00049s_\u001e\u0014Xm]:N_:LGo\u001c:\u000b\u001fA\u0013xn\u001a:fgNluN\\5u_JTq!Z2mSB\u001cXM\u0003\u0003kO&$(b\u00017jE*Q!+\u001a9pg&$xN]=\u000b\t1\fgn\u001a\u0006\b\u000f&$X\t_&u\u0015Q\u0019'/Z1uK\n\u000b'/\u001a*fa>\u001c\u0018\u000e^8ss*\u00012M]3bi\u0016\u0014V\r]8tSR|'/\u001f\u0006\u0015M&tGM\u0011:b]\u000eDGk\\\"iK\u000e\\w.\u001e;\u000b\rI,7/\u001e7u\u0015-1U\r^2i%\u0016\u001cX\u000f\u001c;\u000b\u0013Q\u0014\u0018M\\:q_J$(b\u0001*fM*!rO]1q\u0013\u001atU-\u001a3B]\u0012\u0014V\r\u00165s_^T\u0011!\u001a\u0006\u0013)J\fgn\u001d9peR,\u0005pY3qi&|gN\u0003\u0004feJ|'o\u001d\u0006\u0005+:LGO\u0003\u0004d_6l\u0017\u000e\u001e\u0006\b[\u0016\u001c8/Y4f\u00155\u0011XM\u001a7pO\u000e{W.\\3oi*1\u0011-\u001e;i_JT1\u0002U3sg>t\u0017\nZ3oi*I1m\\7nSR$XM\u001d\u0006\n%\u001648i\\7nSRTqA]3wo\u0006d7N\u0003\td_6\u0004X\u000f^3J]\u0012,\u0007\u0010R5gM*I\u0011J\u001c3fq\u0012KgM\u001a\u0006\u0010I&\u001c\u0018M\u00197f\u0003V$xn\u0011:MM*)a-\u001a;dQ*a!/Z7pi\u0016\u001cuN\u001c4jO*a!+Z7pi\u0016\u001cuN\u001c4jO*\u00192M]3eK:$\u0018.\u00197t!J|g/\u001b3fe*\u00192I]3eK:$\u0018.\u00197t!J|g/\u001b3fe*!r-\u001a;BQ\u0016\fGmQ8n[&$8oQ8v]RT1!\u00138u\u00151y%M[3diJ+\u0017\rZ3s\u001599W\r^\"bG\",GMQ=uKNTQ\u0002Z5s\u0007\u0006\u001c\u0007.Z#oiJL(\"\u0004#je\u000e\u000b7\r[3F]R\u0014\u0018P\u0003\u0005eSJ\u001c\u0017m\u00195f\u0015%\u0011\u0015\u0010^3BeJ\f\u0017PC\fl_Rd\u0017N\u001c\u0018km6t\u0003\u000b\\1uM>\u0014X\u000eV=qK*11i\u001c8gS\u001eTqcZ3u%\u0016lw\u000e^3Ce\u0006t7\r\u001b$vY2t\u0015-\\3\u000b\u001fA\u0014xnY3tg\u000eC\u0017\u000e\u001c3sK:TA\u0001]1uQ*1a-\u001b7uKJT\u0011BR;oGRLwN\\\u0019\u000b\u000f\t{w\u000e\\3b]*I\u0001O]8dKN\u001cxN\u001d\u0006\n\rVt7\r^5p]JR1\"\u00138qkR\u001cFO]3b[*\u0019!N^7\u000b\u0013\u0019,hn\u0019;j_:\u001c(\u0002\u0002:fC\u0012T\u0011B]3tKRD\u0015M\u001d3\u000b!\u0011K'oQ1dQ\u0016\u001c\u0005.Z2l_V$(bC:fiV\u00038\u000f\u001e:fC6T1!\u001e:m\u0015)\u0011'/\u00198dQ:\u000bW.\u001a\u0006\r'R|'/\u001a3D_:4\u0017n\u001a`\u0004\u0015\t\u00012A\u0003\u0004\t\u0001A\u0011\u0001\u0004\u0001\u0006\u0003!\u0019QA\u0001\u0003\u0002\u0011\u000f)1\u0001b\u0001\t\u00061\u0001Q!\u0001\u0005\u0006\u000b\t!)\u0001c\u0003\u0006\u0005\u0011\u0019\u0001BB\u0003\u0003\t\u000fAi!B\u0002\u0005\t!%A\u0002A\u0003\u0002\u0011\u001f)!\u0001B\u0003\t\u0011\u0015\u0011A1\u0002E\t\u000b\r!a\u0001C\u0004\r\u0001\u0015\u0011A!\u0002\u0005\u000b\u000b\t!q\u0001#\u0006\u0006\u0005\u0011=\u0001bC\u0003\u0004\t!A\u0019\u0002\u0004\u0001\u0006\u0007\u0011A\u0001r\u0003\u0007\u0001\u000b\t!\u0001\u0002c\u0006\u0006\u0005\u0011\t\u0001\u0002D\u0003\u0003\t)A\u0011!\u0002\u0002\u0005\u0004!\u0015QA\u0001\u0003\u0005\u0011\u0013)!\u0001\u0002\u0005\t\u0014\u0015\u0011Aq\u0002E\u0010\u000b\r!I\u0002C\b\r\u0001\u0015\u0019A\u0001\u0003\u0005\u0011\u0019\u0001)!\u0001\u0002\u0005\t!\u0015\u0011A\u0011\u0004\u0005\u0010\u000b\t!y\u0001\u0003\n\u0006\u0007\u0011y\u00012\u0005\u0007\u0001\u000b\r!\u0001\u0001#\n\r\u0001\u0015\u0011Aa\u0004E\u0012\u000b\r!\u0001\u0002C\u000b\r\u0001\u0015\u0011Aq\u0002E\u0017\u000b\r!\u0019\u0003\u0003\f\r\u0001\u0015\u0011A1\u0005\u0005\u0017\u000b\t!\u0001\u0002C\u000b\u0006\u0007\u0011A\u0001r\u0006\u0007\u0001\u000b\t!\u0001\u0002c\f\u0006\u0007\u0011e\u00012\u0007\u0007\u0001\u000b\r!I\u0002#\u000e\r\u0001\u0015\u0011A\u0011\u0004E\u001a\u000b\t!I\u0002#\u000e\u0006\u0007\u0011\u0001\u0001r\u0007\u0007\u0001\u000b\r!\u0001\u0002\u0003\u000f\r\u0001\u0015\u0011Aq\u0002\u0005\u001f\u000b\r!y\u0003c\u000f\r\u0001\u0015\u0019A\u0001\u0001E\u001f\u0019\u0001)!\u0001\u0002\u0005\t9\u0015\u0011Aq\u0006E\u001e\u000b\r!\u0001\u0002c\u0010\r\u0001\u0015\u0011A\u0001\u0003E \u000b\r!\u0001\u0001\u0003\u0012\r\u0001\u0015\u0019A\u0001\u0001E#\u0019\u0001)1\u0001\u0002\u0001\tH1\u0001Qa\u0001C\u0002\u0011\u0011b\u0001!\u0002\u0002\u0005\u0001!%SA\u0001\u0003\u001e\u0011\u0015*!\u0001b\u000f\tE\u0015\u0011A1\bE$\u000b\t!\u0019\u0001\u0003\u0013\u0006\u0007\u0011=\u0002R\n\u0007\u0001\u000b\t!y\u0003#\u0014\u0006\u0007\u0011A\u0001\u0012\u000b\u0007\u0001\u000b\t!\u0001\u0002#\u0015\u0006y\u0011\u0019\u0001\u0004AO\b\t\u0001A\t!D\u0002\u0006\u0003!\u0005\u0001\u0014\u0001)\u0004\u0001u=A\u0001\u0001\u0005\u0003\u001b\r)\u0011\u0001\u0003\u0002\u0019\u0005A\u001b\t!h\u0007\u0005\u0003!!Q\"C\u0003\u0002\u0011\u0013IA!C\u0002\u0006\u0003!5\u0001T\u0002G\u00011\u0013\u00016!AO\b\t\u0005A\u0011\"D\u0002\u0006\u0003!E\u0001\u0014\u0003)\u0004\u0004\u0005\u001aQ!\u0001\u0005\n1%\t6a\u0003\u0003\u0001\u0013\u0005A\u0019\"D\u0001\t\u00165\t\u0001bC\u0007\u0002\u0011/i\u0011\u0001\u0003\u0007Y\u00073)i\u0003B\u0002\u0019\u001bu=A\u0001\u0001\u0005\u0003\u001b\r)\u0011\u0001\u0003\u0002\u0019\u0005A\u001b\u0001!I\u0002\u0006\u0003!I\u0001$C)\u0004\u000b\u0011i\u0011\"\u0001E\n\u001b\u0005A1\u0002WB\r\u000b[!1\u0001g\u0007\u001e\u0010\u0011\u0001\u0001BA\u0007\u0004\u000b\u0005A!\u0001\u0007\u0002Q\u0007\u0001\t3!B\u0001\t\u0013aI\u0011kA\u0003\u0005\u001c%\t\u00012C\u0007\u0002\u0011-A6\u0011DC\u0018\t\u0005Ab\"h\u0004\u0005\u0001!uQbA\u0003\u0002\u00115AR\u0002U\u0002\u0001C\u0011)\u0011\u0001c\u0007\r\u0002am\u0011kA\u0003\u0005\u001d%\t\u0001BD\u0007\u0002\u0011;A6\u0011DC\u0017\t\rA\n#h\u0004\u0005\u0001!\tRbA\u0003\u0002\u0011?Az\u0002U\u0002\u0001C\r)\u0011\u0001\u0003\t\u0019!E\u001bQ\u0001\"\t\n\u0003\u0011\u0001Q\"\u0001E\u00111\u000eeQ\u00011\u0001\u0005\u0007U\u0019Q!\u0001\u0005\n1%A2#(\u0005\u0005\u0003!\u001dR\u0002B\u0003\u0002\u0011\u0003a\t\u0001'\u0001Q\u0007\u0003i\n\u0002B\u0001\t)5!Q!\u0001E\u0001\u0019\u0003A\n\u0001U\u0002\u0002;#!\u0011\u0001#\u000b\u000e\t\u0015\t\u0001\"\u0005G\u00011E\u000161AO\t\t\u0005AY#\u0004\u0003\u0006\u0003!\tB\u0012\u0001\r\u0012!\u000e\u0011\u0011eA\u0003\u0002\u0011IA\"#U\u0002\u000e\tMI\u0011\u0001#\n\u000e\u0003!MQ\"\u0001E\u000b\u001b\u0005A)\"D\u0001\t'5\t\u0001b\u0005-\u0004\u001a\u0015\u0011BaA\u000b\u0004\u000b\u0005A\u0011\u0002G\u0005\u0019/\u0005\u001aQ!\u0001E\u00141O\t6!\u0002\u0003\u0018\u0013\u0005AA#D\u0001\t\u0014a\u001bI\"\u0002\n\u0005\u0007U\u0019Q!\u0001\u0005\n1%A\u0002$I\u0002\u0006\u0003!I\u0001$C)\u0004\u000b\u0011A\u0012\"\u0001E\n\u001b\u0005A\u0019\u0002WB\r\u000bS\"1!F\u0002\u0006\u0003!I\u0001$\u0003M\u0019;\u001f!\u0001\u0001C\r\u000e\u0007\u0015\t\u0001\u0012\u0006M\u0015!\u000e\u0005Q\u0014\u0003\u0003\u0002\u0011iiA!B\u0001\t+1\u0005\u0001$\u0006)\u0004\u0003uEA!\u0001\u0005\n\u001b\u0011)\u0011\u0001#\u0005\r\u0002aE\u0001ka\u0001\"\t\u0015\t\u0001\"\u0004G\u000115\t6a\u0003C\u0019\u0013\u0005Ai\"D\u0001\t\u00145\t\u00012F\u0007\u0002\u0011Yi\u0011\u0001\u0003\u0007Y\u00073)!\u0003B\u0002\u0016\u0007\u0015\t\u0001\"\u0003\r\n1m\t3!B\u0001\t.a5\u0012kA\u0003\u00057%\tAQA\u0007\u0002\u0011'A6\u0011DC$\t\r)2!B\u0001\t/a9\u0002\u0014HO\b\t\u0001AQ$D\u0002\u0006\u0003!A\u0002\u0004\u0007)\u0004\u0002\u0005JQ!\u0001E\u0019!})B!B\u0001\t21\u0005\u0001\u0014\u0007M\u0019#\u000eAA\u0011H\u0005\u0003\t\u0007a\t!D\u0001\t35\t\u00012\u0007-\u0004\u001a\u0015\u0011BaA\u000b\u0004\u000b\u0005A!\u0004\u0007\u000e\u0019A\u0005\u001aQ!\u0001E\u00011\u0003\t6!\u0002\u0003!\u0013\u0005A)\"D\u0001\t6a\u001bI\"bf\u0001\t\r)2!B\u0001\t\u0013aI\u0001\u0014IO\b\t\u0001A\u0011%D\u0002\u0006\u0003!\u0005\u0001\u0014\u0001)\u0004\u0002u\u0015B!\u0001E\"\u001b9)\u0011\u0001C\u000e\n\t%\u0019Q!\u0001E\u00011\u0003IA!C\u0002\u0006\u0003!]\u0002t\u0007G\u00011m\u00016!AO\u0017\t\u0001A1%\u0004\n\u0006\u0003!a\u0012\u0002B\u0005\u0004\u000b\u0005A\t\u0001'\u0001\n\t%\u0019Q!\u0001E\u001d1sIA!C\u0002\u0006\u0003!]\u0002t\u0007\r\u001d!\u000e\r\u0011eA\u0003\u0002\u0011AA\u0002#U\u0002\f\t\u0003J\u0011\u0001\u0002\u0001\u000e\u0003!MQ\"\u0001E\u000b\u001b\u0005Aa$D\u0001\t>a\u001bI\"b\u000f\u0005\u0007U\u0019Q!\u0001\u0005\n1%AZ%h\u0004\u0005\u0001!\tSbA\u0003\u0002\u0011\u0003A\n\u0001UB\u0001C\u0011)\u0011\u0001#\u000f\r\u0002ae\u0012kA\u0004\u0005L%\t\u0001bH\u0007\u0002\u0011'i\u0011\u0001#\u0006Y\u00073)!\u0003B\u0002\u0016\u0007\u0015\t\u0001\"\u0003\r\n1\u0019\n3!B\u0001\t@a}\u0012kA\u0003\u0005M%\t\u0001\u0002I\u0007\u0002\u0011'A6\u0011D\u0003)\t\r)2!B\u0001\t\u0013aI\u0001dJO\t\t\u0001Ay%\u0004\u0003\u0006\u0003!\u0005A\u0012\u0001M\u0001!\u000e\u0005Qt\u0002\u0003\u0002\u0011!j1!B\u0001\t\u0002a\u0005\u0001kA\u0001\"\u0007\u0015\t\u0001\u0012\tM!#\u000eIAaJ\u0005\u0002\u0011\u0005j\u0011\u0001c\u0005\u000e\u0003!UQ\"\u0001E\u000b1\u000ee\u0001"})
public final class GitExKt {
    public static final void wrapIfNeedAndReThrow(@NotNull TransportException e) {
        String message;
        block7: {
            block6: {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                if (e instanceof org.eclipse.jgit.errors.NoRemoteRepositoryException || Intrinsics.areEqual((Object)e.getStatus(), (Object)TransportException.Status.CANNOT_RESOLVE_REPO)) {
                    throw (Throwable)new NoRemoteRepositoryException(e);
                }
                String string = e.getMessage();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                message = string;
                if (Intrinsics.areEqual((Object)e.getStatus(), (Object)TransportException.Status.NOT_AUTHORIZED) || Intrinsics.areEqual((Object)e.getStatus(), (Object)TransportException.Status.NOT_PERMITTED)) break block6;
                CharSequence charSequence = JGitText.get().notAuthorized;
                Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"JGitText.get().notAuthorized");
                if (!StringsKt.contains$default((String)message, (CharSequence)charSequence, (boolean)false, (int)2) && !StringsKt.contains$default((String)message, (CharSequence)"Auth cancel", (boolean)false, (int)2) && !StringsKt.contains$default((String)message, (CharSequence)"Auth fail", (boolean)false, (int)2) && !StringsKt.contains$default((String)message, (CharSequence)": reject HostKey:", (boolean)false, (int)2)) break block7;
            }
            throw (Throwable)new AuthenticationException(e);
        }
        if (Intrinsics.areEqual((Object)e.getStatus(), (Object)TransportException.Status.CANCELLED) || Intrinsics.areEqual((Object)message, (Object)"Download cancelled")) {
            throw (Throwable)new ProcessCanceledException();
        }
        throw (Throwable)e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final FetchResult fetch(Repository $receiver, @NotNull RemoteConfig remoteConfig, @Nullable CredentialsProvider credentialsProvider2, @Nullable ProgressMonitor progressMonitor) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)remoteConfig, (String)"remoteConfig");
        try {
            Transport transport = Transport.open((Repository)$receiver, (RemoteConfig)remoteConfig);
            try {
                transport.setCredentialsProvider(credentialsProvider2);
                ProgressMonitor progressMonitor2 = progressMonitor;
                if (progressMonitor2 == null) {
                    progressMonitor2 = (ProgressMonitor)NullProgressMonitor.INSTANCE;
                }
                FetchResult fetchResult = transport.fetch(progressMonitor2, (Collection)null);
                return fetchResult;
            }
            finally {
                transport.close();
            }
        }
        catch (TransportException e) {
            String message;
            String string = e.getMessage();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            if (StringsKt.startsWith$default((String)(message = string), (String)"Remote does not have ", (boolean)false, (int)2)) {
                IcsManagerKt.getLOG().info(message);
                return null;
            }
            GitExKt.wrapIfNeedAndReThrow(e);
            return null;
        }
    }

    @Nullable
    public static /* synthetic */ FetchResult fetch$default(Repository repository2, RemoteConfig remoteConfig, CredentialsProvider credentialsProvider2, ProgressMonitor progressMonitor, int n) {
        if ((n & 2) != 0) {
            credentialsProvider2 = null;
        }
        if ((n & 4) != 0) {
            progressMonitor = null;
        }
        return GitExKt.fetch(repository2, remoteConfig, credentialsProvider2, progressMonitor);
    }

    @NotNull
    public static final Repository disableAutoCrLf(Repository $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        StoredConfig config = $receiver.getConfig();
        config.setString(ConfigConstants.CONFIG_CORE_SECTION, (String)null, ConfigConstants.CONFIG_KEY_AUTOCRLF, ConfigConstants.CONFIG_KEY_FALSE);
        config.save();
        return $receiver;
    }

    @NotNull
    public static final Repository createBareRepository(@NotNull File dir) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        Repository repository2 = ((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().setBare()).setGitDir(dir)).build();
        repository2.create(true);
        Repository repository3 = repository2;
        Intrinsics.checkExpressionValueIsNotNull((Object)repository3, (String)"repository");
        return repository3;
    }

    @NotNull
    public static final Repository createRepository(@NotNull File dir) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        Repository repository2 = ((FileRepositoryBuilder)new FileRepositoryBuilder().setWorkTree(dir)).build();
        repository2.create();
        Repository repository3 = repository2;
        Intrinsics.checkExpressionValueIsNotNull((Object)repository3, (String)"repository");
        return repository3;
    }

    @NotNull
    public static final RevCommit commit(Repository $receiver, @Nullable String message, @Nullable String reflogComment, @Nullable PersonIdent author, @Nullable PersonIdent committer) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        CommitCommand commitCommand = new CommitCommand($receiver).setAuthor(author).setCommitter(committer);
        if (message != null) {
            commitCommand.setMessage(message);
        }
        if (reflogComment != null) {
            commitCommand.setReflogComment(reflogComment);
        }
        RevCommit revCommit = commitCommand.call();
        Intrinsics.checkExpressionValueIsNotNull((Object)revCommit, (String)"commitCommand.call()");
        return revCommit;
    }

    @NotNull
    public static /* synthetic */ RevCommit commit$default(Repository repository2, String string, String string2, PersonIdent personIdent, PersonIdent personIdent2, int n) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            personIdent = null;
        }
        if ((n & 8) != 0) {
            personIdent2 = null;
        }
        return GitExKt.commit(repository2, string, string2, personIdent, personIdent2);
    }

    @NotNull
    public static final DirCacheCheckout resetHard(Repository $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ResetCommand resetCommand = new ResetCommand($receiver).setMode(ResetCommand.ResetType.HARD);
        resetCommand.call();
        DirCacheCheckout dirCacheCheckout = resetCommand.getDirCacheCheckout();
        if (dirCacheCheckout == null) {
            Intrinsics.throwNpe();
        }
        return dirCacheCheckout;
    }

    @NotNull
    public static final String getRemoteBranchFullName(Config $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String name = $receiver.getString(ConfigConstants.CONFIG_BRANCH_SECTION, Constants.MASTER, ConfigConstants.CONFIG_KEY_MERGE);
        if (StringUtil.isEmpty((String)name)) {
            throw (Throwable)new IllegalStateException("branch.master.merge refspec must be specified");
        }
        String string = name;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    @NotNull
    public static final StoredConfig setUpstream(Repository $receiver, @Nullable String url, @NotNull String branchName) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)branchName, (String)"branchName");
        String localBranchName = Constants.MASTER;
        StoredConfig config = $receiver.getConfig();
        String remoteName = Constants.DEFAULT_REMOTE_NAME;
        if (StringUtil.isEmptyOrSpaces((String)url)) {
            IcsManagerKt.getLOG().debug("Unset remote");
            config.unsetSection(ConfigConstants.CONFIG_REMOTE_SECTION, remoteName);
            config.unsetSection(ConfigConstants.CONFIG_BRANCH_SECTION, localBranchName);
        } else {
            IcsManagerKt.getLOG().debug("Set remote " + url);
            config.setString(ConfigConstants.CONFIG_REMOTE_SECTION, remoteName, ConfigConstants.CONFIG_KEY_URL, url);
            config.setString(ConfigConstants.CONFIG_REMOTE_SECTION, remoteName, ConfigConstants.CONFIG_FETCH_SECTION, CharsKt.plus((char)'+', (String)Constants.R_HEADS) + branchName + ':' + Constants.R_REMOTES + remoteName + '/' + branchName);
            config.setString(ConfigConstants.CONFIG_BRANCH_SECTION, localBranchName, ConfigConstants.CONFIG_KEY_REMOTE, remoteName);
            config.setString(ConfigConstants.CONFIG_BRANCH_SECTION, localBranchName, ConfigConstants.CONFIG_KEY_MERGE, Constants.R_HEADS + branchName);
        }
        config.save();
        StoredConfig storedConfig = config;
        Intrinsics.checkExpressionValueIsNotNull((Object)storedConfig, (String)"config");
        return storedConfig;
    }

    @NotNull
    public static /* synthetic */ StoredConfig setUpstream$default(Repository repository2, String string, String string2, int n) {
        if ((n & 2) != 0) {
            string2 = Constants.MASTER;
        }
        return GitExKt.setUpstream(repository2, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final IndexDiff computeIndexDiff(Repository $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        FileTreeIterator workingTreeIterator = new FileTreeIterator($receiver);
        try {
            IndexDiff indexDiff = new IndexDiff($receiver, Constants.HEAD, (WorkingTreeIterator)workingTreeIterator);
            return indexDiff;
        }
        finally {
            workingTreeIterator.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final Repository cloneBare(@NotNull String uri, @NotNull File dir, @Nullable NotNullLazyValue<CredentialsStore> credentialsStore2, @NotNull ProgressMonitor progressMonitor) {
        RevWalk it;
        void $receiver;
        Object branchName;
        void head;
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        Intrinsics.checkParameterIsNotNull((Object)progressMonitor, (String)"progressMonitor");
        Repository repository2 = GitExKt.createBareRepository(dir);
        StoredConfig config = GitExKt.setUpstream$default(repository2, uri, null, 2);
        RemoteConfig remoteConfig = new RemoteConfig((Config)config, Constants.DEFAULT_REMOTE_NAME);
        FetchResult fetchResult = GitExKt.fetch(repository2, remoteConfig, credentialsStore2 == null ? (JGitCredentialsProvider)null : new JGitCredentialsProvider(credentialsStore2, repository2), progressMonitor);
        if (fetchResult == null) {
            return repository2;
        }
        FetchResult result = fetchResult;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = GitExKt.findBranchToCheckout(result);
        if ((Ref)head.element == null) {
            Object object;
            String branch = Constants.HEAD;
            Ref ref = result.getAdvertisedRef(branch);
            if (ref == null) {
                ref = object = result.getAdvertisedRef(Constants.R_HEADS + branch);
            }
            if (ref == null) {
                object = head.element = result.getAdvertisedRef(Constants.R_TAGS + branch);
            }
        }
        if ((Ref)head.element == null || ((Ref)head.element).getObjectId() == null) {
            return repository2;
        }
        if (StringsKt.startsWith$default((String)((Ref)head.element).getName(), (String)Constants.R_HEADS, (boolean)false, (int)2)) {
            RefUpdate newHead = repository2.updateRef(Constants.HEAD);
            newHead.disableRefLog();
            newHead.link(((Ref)head.element).getName());
            branchName = Repository.shortenRefName((String)((Ref)head.element).getName());
            config.setString(ConfigConstants.CONFIG_BRANCH_SECTION, (String)branchName, ConfigConstants.CONFIG_KEY_REMOTE, Constants.DEFAULT_REMOTE_NAME);
            config.setString(ConfigConstants.CONFIG_BRANCH_SECTION, (String)branchName, ConfigConstants.CONFIG_KEY_MERGE, ((Ref)head.element).getName());
            String autoSetupRebase = config.getString(ConfigConstants.CONFIG_BRANCH_SECTION, (String)null, ConfigConstants.CONFIG_KEY_AUTOSETUPREBASE);
            if (Intrinsics.areEqual((Object)ConfigConstants.CONFIG_KEY_ALWAYS, (Object)autoSetupRebase) || Intrinsics.areEqual((Object)ConfigConstants.CONFIG_KEY_REMOTE, (Object)autoSetupRebase)) {
                config.setBoolean(ConfigConstants.CONFIG_BRANCH_SECTION, (String)branchName, ConfigConstants.CONFIG_KEY_REBASE, true);
            }
            config.save();
        }
        branchName = (Closeable)new RevWalk(repository2);
        boolean closed = false;
        try {
            it = (RevWalk)$receiver;
            Ref ref = (Ref)head.element;
            if (ref == null) {
                Intrinsics.throwNpe();
            }
            it = it.parseCommit((AnyObjectId)ref.getObjectId());
        }
        catch (Exception e) {
            closed = true;
            try {
                $receiver.close();
            }
            catch (Exception closeException) {
                // empty catch block
            }
            throw (Throwable)e;
        }
        finally {
            if (!closed) {
                $receiver.close();
            }
        }
        RevCommit commit = (RevCommit)it;
        Ref ref = (Ref)head.element;
        if (ref == null) {
            Intrinsics.throwNpe();
        }
        RefUpdate u = repository2.updateRef(Constants.HEAD, !StringsKt.startsWith$default((String)ref.getName(), (String)Constants.R_HEADS, (boolean)false, (int)2));
        u.setNewObjectId((AnyObjectId)commit.getId());
        u.forceUpdate();
        return repository2;
    }

    @NotNull
    public static /* synthetic */ Repository cloneBare$default(String string, File file, NotNullLazyValue notNullLazyValue, ProgressMonitor progressMonitor, int n) {
        if ((n & 4) != 0) {
            notNullLazyValue = null;
        }
        if ((n & 8) != 0) {
            NullProgressMonitor nullProgressMonitor = NullProgressMonitor.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)nullProgressMonitor, (String)"NullProgressMonitor.INSTANCE");
            progressMonitor = (ProgressMonitor)nullProgressMonitor;
        }
        return GitExKt.cloneBare(string, file, (NotNullLazyValue<CredentialsStore>)notNullLazyValue, progressMonitor);
    }

    @Nullable
    public static final Ref findBranchToCheckout(@NotNull FetchResult result) {
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        Ref ref = result.getAdvertisedRef(Constants.HEAD);
        if (ref == null) {
            return null;
        }
        Ref idHead = ref;
        Ref master = result.getAdvertisedRef(Constants.R_HEADS + Constants.MASTER);
        if (master != null && master.getObjectId().equals((AnyObjectId)idHead.getObjectId())) {
            return master;
        }
        for (Ref r : result.getAdvertisedRefs()) {
            if (!StringsKt.startsWith$default((String)r.getName(), (String)Constants.R_HEADS, (boolean)false, (int)2) || !r.getObjectId().equals((AnyObjectId)idHead.getObjectId())) continue;
            return r;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void processChildren(Repository $receiver, @NotNull String path, @Nullable Function1<? super String, ? extends Boolean> filter, @NotNull Function2<? super String, ? super InputStream, ? extends Boolean> processor) {
        void $receiver2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
        ObjectId objectId = $receiver.resolve(Constants.HEAD);
        if (objectId == null) {
            return;
        }
        ObjectId lastCommitId = objectId;
        ObjectReader reader = $receiver.newObjectReader();
        Closeable closeable = (Closeable)reader;
        boolean closed = false;
        try {
            TreeWalk treeWalk;
            ObjectReader it = (ObjectReader)$receiver2;
            if (TreeWalk.forPath((ObjectReader)reader, (String)path, (AnyObjectId[])new AnyObjectId[]{(AnyObjectId)new RevWalk(reader).parseCommit((AnyObjectId)lastCommitId).getTree()}) == null) {
                return;
            }
            TreeWalk treeWalk2 = treeWalk;
            if (!treeWalk2.isSubtree()) {
                IcsManagerKt.getLOG().warn("File " + path + " is not a directory");
                return;
            }
            treeWalk2.setFilter(TreeFilter.ALL);
            treeWalk2.enterSubtree();
            while (treeWalk2.next()) {
                ObjectLoader objectLoader;
                FileMode fileMode = treeWalk2.getFileMode(0);
                if (!Intrinsics.areEqual((Object)fileMode, (Object)FileMode.REGULAR_FILE) && !Intrinsics.areEqual((Object)fileMode, (Object)FileMode.SYMLINK) && !Intrinsics.areEqual((Object)fileMode, (Object)FileMode.EXECUTABLE_FILE)) continue;
                String fileName = treeWalk2.getNameString();
                if (filter != null) {
                    String string = fileName;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fileName");
                    if (!((Boolean)filter.invoke((Object)string)).booleanValue()) continue;
                }
                if ((objectLoader = reader.open((AnyObjectId)treeWalk2.getObjectId(0), Constants.OBJ_BLOB)).getSize() == 0L) {
                    IcsManagerKt.getLOG().warn("File " + path + " skipped because empty (length 0)");
                    continue;
                }
                String string = fileName;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fileName");
                ObjectStream objectStream = objectLoader.openStream();
                Intrinsics.checkExpressionValueIsNotNull((Object)objectStream, (String)"objectLoader.openStream()");
                if (((Boolean)processor.invoke((Object)string, (Object)objectStream)).booleanValue()) continue;
                break;
            }
            it = Unit.INSTANCE$;
        }
        catch (Exception e) {
            closed = true;
            try {
                $receiver2.close();
            }
            catch (Exception closeException) {
                // empty catch block
            }
            throw (Throwable)e;
        }
        finally {
            if (!closed) {
                $receiver2.close();
            }
        }
    }

    public static /* synthetic */ void processChildren$default(Repository repository2, String string, Function1 function1, Function2 function2, int n) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        GitExKt.processChildren(repository2, string, (Function1<? super String, ? extends Boolean>)function1, (Function2<? super String, ? super InputStream, ? extends Boolean>)function2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final InputStream read(Repository $receiver, @NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        ObjectId lastCommitId = $receiver.resolve(Constants.HEAD);
        if (lastCommitId == null) {
            IcsManagerKt.getLOG().warn("Repository " + $receiver.getDirectory().getName() + " doesn't have HEAD");
            return null;
        }
        ObjectReader reader = $receiver.newObjectReader();
        boolean releaseReader = true;
        try {
            TreeWalk treeWalk;
            if (TreeWalk.forPath((ObjectReader)reader, (String)path, (AnyObjectId[])new AnyObjectId[]{(AnyObjectId)new RevWalk(reader).parseCommit((AnyObjectId)lastCommitId).getTree()}) == null) {
                InputStream inputStream = null;
                return inputStream;
            }
            TreeWalk treeWalk2 = treeWalk;
            ObjectLoader objectLoader = reader.open((AnyObjectId)treeWalk2.getObjectId(0), Constants.OBJ_BLOB);
            ObjectStream input = objectLoader.openStream();
            if (objectLoader.isLarge()) {
                releaseReader = false;
                InputStream inputStream = (InputStream)input;
                Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"input");
                ObjectReader objectReader = reader;
                Intrinsics.checkExpressionValueIsNotNull((Object)objectReader, (String)"reader");
                InputStream inputStream2 = new InputStreamWrapper(inputStream, objectReader);
                return inputStream2;
            }
            InputStream inputStream = (InputStream)input;
            return inputStream;
        }
        finally {
            if (releaseReader) {
                reader.close();
            }
        }
    }

    public static final byte[] getCachedBytes(ObjectReader $receiver, @NotNull DirCacheEntry dirCacheEntry) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)dirCacheEntry, (String)"dirCacheEntry");
        return $receiver.open((AnyObjectId)dirCacheEntry.getObjectId(), Constants.OBJ_BLOB).getCachedBytes();
    }

    /*
     * WARNING - void declaration
     */
    public static final int getAheadCommitsCount(Repository $receiver) {
        RevCommit revCommit;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        StoredConfig config = $receiver.getConfig();
        String shortBranchName = Repository.shortenRefName((String)GitExKt.getRemoteBranchFullName((Config)config));
        String string = new BranchConfig((Config)config, shortBranchName).getTrackingBranch();
        if (string == null) {
            return -1;
        }
        String trackingBranch = string;
        Ref ref = $receiver.getRef(Constants.R_HEADS + shortBranchName);
        if (ref == null) {
            return -1;
        }
        Ref local = ref;
        RevWalk walk = new RevWalk($receiver);
        RevCommit localCommit = walk.parseCommit((AnyObjectId)local.getObjectId());
        Ref ref2 = $receiver.getRef(trackingBranch);
        if (ref2 != null) {
            void $receiver2;
            Ref ref3 = ref2;
            Ref it = (Ref)$receiver2;
            revCommit = walk.parseCommit((AnyObjectId)it.getObjectId());
        } else {
            revCommit = null;
        }
        RevCommit trackingCommit = revCommit;
        walk.setRevFilter(RevFilter.MERGE_BASE);
        if (trackingCommit == null) {
            walk.markStart(localCommit);
            walk.sort(RevSort.REVERSE);
        } else {
            walk.markStart(localCommit);
            walk.markStart(trackingCommit);
            RevCommit mergeBase = walk.next();
            walk.reset();
            walk.markStart(localCommit);
            walk.markUninteresting(mergeBase);
        }
        walk.setRevFilter(RevFilter.ALL);
        int num = 0;
        for (RevCommit c : walk) {
            ++num;
        }
        return num;
    }
}

