/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.MapsKt;
import kotlin.PropertyMetadata;
import kotlin.PropertyMetadataImpl;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.errors.UnmergedPathsException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.ignore.IgnoreNode;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ConfigConstants;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.OperationResult;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.Transport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jgit.dirCache.AddLoadedFile;
import org.jetbrains.jgit.dirCache.DeleteDirectory;
import org.jetbrains.jgit.dirCache.DirCacheEditorKt;
import org.jetbrains.keychain.CredentialsStore;
import org.jetbrains.settingsRepository.AuthenticationException;
import org.jetbrains.settingsRepository.BaseRepositoryManager;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.RepositoryManager;
import org.jetbrains.settingsRepository.RepositoryManager$$TImpl;
import org.jetbrains.settingsRepository.SyncType;
import org.jetbrains.settingsRepository.UpdateResult;
import org.jetbrains.settingsRepository.git.CommitKt;
import org.jetbrains.settingsRepository.git.GitExKt;
import org.jetbrains.settingsRepository.git.GitRepositoryManager;
import org.jetbrains.settingsRepository.git.GitRepositoryManagerKt;
import org.jetbrains.settingsRepository.git.IdeaCommitMessageFormatter;
import org.jetbrains.settingsRepository.git.JGitCredentialsProvider;
import org.jetbrains.settingsRepository.git.JGitProgressMonitorKt;
import org.jetbrains.settingsRepository.git.Pull;
import org.jetbrains.settingsRepository.git.PullKt;
import org.jetbrains.settingsRepository.git.Reset;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"G\u0012)!r)\u001b;SKB|7/\u001b;pefl\u0015M\\1hKJT1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\ntKR$\u0018N\\4t%\u0016\u0004xn]5u_JL(bA4ji*)\")Y:f%\u0016\u0004xn]5u_JLX*\u00198bO\u0016\u0014(B\u0002\u001fj]&$hH\u0003\tde\u0016$WM\u001c;jC2\u001c8\u000b^8sK*\u0001bj\u001c;Ok2dG*\u0019>z-\u0006dW/\u001a\u0006\u0004G>l'\u0002C5oi\u0016dG.\u001b6\u000b\u000f=\u0004XM\\1qS*!Q\u000f^5m\u0015A\u0019%/\u001a3f]RL\u0017\r\\:Ti>\u0014XM\u0003\u0005lKf\u001c\u0007.Y5o\u0015\r!\u0017N\u001d\u0006\u0005\r&dWM\u0003\u0003kCZ\f'BA5p\u0015-y&/\u001a9pg&$xN]=\u000b\u0015I+\u0007o\\:ji>\u0014\u0018PC\u0004fG2L\u0007o]3\u000b\t)<\u0017\u000e\u001e\u0006\u0004Y&\u0014'BD4fi~\u0013X\r]8tSR|'/\u001f\u0006\u000fg\u0016$xL]3q_NLGo\u001c:z\u0015M\u0019'/\u001a3f]RL\u0017\r\\:Qe>4\u0018\u000eZ3s\u0015M\u0019%/\u001a3f]RL\u0017\r\\:Qe>4\u0018\u000eZ3s\u0015%!(/\u00198ta>\u0014HO\u0003\u000fde\u0016$WM\u001c;jC2\u001c\bK]8wS\u0012,'\u000f\n3fY\u0016<\u0017\r^3\u000b\r-|G\u000f\\5o\u0015\u0011a\u0015M_=\u000b-\u001d,Go\u0011:fI\u0016tG/[1mgB\u0013xN^5eKJT1\"[4o_J,'+\u001e7fg*Q\u0011j\u001a8pe\u0016tu\u000eZ3\u000b\r%<gn\u001c:f\u0015)\u0011X\r]8tSR|'/\u001f\u0006\u000eO\u0016$(+\u001a9pg&$xN]=\u000b\u0015\u0005$G\rV8J]\u0012,\u0007P\u0003\u0003gS2,'\u0002\u00029bi\"Taa\u0015;sS:<'bB2p]R,g\u000e\u001e\u0006\n\u0005f$X-\u0011:sCfTAa]5{K*\u0019\u0011J\u001c;\u000b\tUs\u0017\u000e\u001e\u0006\u0005Y\u0006twMC\u0005dC:\u001cu.\\7ji*9!i\\8mK\u0006t'BB2p[6LGOC\u0005j]\u0012L7-\u0019;pe*\t\u0002K]8he\u0016\u001c8/\u00138eS\u000e\fGo\u001c:\u000b\u0011A\u0014xn\u001a:fgNT\u0001b]=oGRK\b/\u001a\u0006\t'ft7\rV=qK*1b-\u001b=Ti\u0006$X-\u00134DC:tw\u000e^\"p[6LGOC\u0003qCRD7O\u0003\u0003MSN$(bC2p[6LG/\u00134DC:TQa\u001d;bi\u0016TqBU3q_NLGo\u001c:z'R\fG/\u001a\u0006\u0017GJ,\u0017\r^3SKB|7/\u001b;pefLeMT3fI*yA-\u001a7fi\u00164%o\\7J]\u0012,\u0007P\u0003\u0004jg\u001aKG.\u001a\u0006\u0011I\u0016dW\r^3SKB|7/\u001b;pefTQAZ3uG\"Tq!\u00169eCR,'OC\tSKB|7/\u001b;pefl\u0015M\\1hKJT\u0011DU3q_NLGo\u001c:z\u001b\u0006t\u0017mZ3sIU\u0003H-\u0019;fe*!r-\u001a;BQ\u0016\fGmQ8n[&$8oQ8v]RTabZ3u\u0013\u001etwN]3Sk2,7OC\u0006hKR,\u0006o\u001d;sK\u0006l'b\u00035bgV\u00038\u000f\u001e:fC6TQ\"[:QCRD\u0017j\u001a8pe\u0016$'BE5t%\u0016\u0004xn]5u_JLX\t_5tiNTA\u0001];mY*aQ\u000b\u001d3bi\u0016\u0014Vm];mi*!\u0001/^:i\u0015=\u0011XM\\1nK\u0012K'/Z2u_JL(\"\u00029bSJ\u001c(bA'ba*I!/Z:fiR{W*\u001f\u0006\u001bY>\u001c\u0017\r\u001c*fa>\u001c\u0018\u000e^8ss&s\u0017\u000e^5bY&TXM\u001d\u0006\n\rVt7\r^5p]BR1A\u001b<n\u0015%1WO\\2uS>t7OC\u0007sKN,G\u000fV8UQ\u0016L'o\u001d\u0006\fg\u0016$X\u000b]:ue\u0016\fWNC\u0002ve2TaA\u0019:b]\u000eDgq\u0001\u0006\u0003!\u0005QA\u0001\u0003\u0001\u0011\u0005)!\u0001\"\u0001\t\u0004\u0015\u0011A!\u0001\u0005\u0003\u000b\r!\u0019\u0001\u0003\u0001\r\u0001\u0015\u0019A!\u0001E\u0003\u0019\u0001)\u0011\u0001#\u0003\u0006\u0005\u0011\u0019\u0001\"B\u0003\u0003\t\u000fAY!\u0002\u0002\u0005\t!1Qa\u0001C\u0005\u0011\u0011a\u0001!\u0002\u0002\u0005\u0002!9Qa\u0001C\u0006\u0011\u001ba\u0001!B\u0001\t\u0012\u0015\u0011AQ\u0002\u0005\n\u000b\r!q\u0001\u0003\u0005\r\u0001\u0015\u0011A\u0011\u0002\u0005\u0005\u000b\t!q\u0001\u0003\u0005\u0006\u0005\u0011\u0001\u0001RC\u0003\u0003\t%A1\"\u0002\u0002\u0005\u0014!]Qa\u0001\u0003\u000b\u0011)a\u0001!\u0002\u0002\u0005\u0015!QQA\u0001C\n\u00119)1\u0001b\u0006\t\u001c1\u0001Q!\u0001\u0005\u0010\u000b\t!I\u0002c\b\u0006\u0005\u0011]\u00012D\u0003\u0003\t'A\u0019#B\u0002\u0005\u001d!\tB\u0002A\u0003\u0003\t9A\u0011#B\u0002\u0005\u001a!%B\u0002A\u0003\u0004\t3AY\u0003\u0004\u0001\u0006\u0007\u0011e\u0001R\u0006\u0007\u0001\u000b\r!I\u0002C\f\r\u0001\u0015\u0011AQ\u0002E\u0018\u000b\t!\u0019\u0003#\u000b\u0006\u0007\u0011e\u0001\u0012\u0007\u0007\u0001\u000b\t!A\u0001#\u000e\u0006\u0007\u0011\u0019\u0002B\u0007\u0007\u0001\u000b\r!\u0011\u0001c\u000e\r\u0001\u0015\u0011Aa\u0005\u0005\u001b\u000b\t!\u0011\u0001c\u000e\u0006\u0007\u0011e\u0001\"\b\u0007\u0001\u000b\t!i\u0001\u0003\u0004\u0006\u0005\u00111\u0002\"H\u0003\u0004\t)Ai\u0004\u0004\u0001\u0006\u0005\u0011Q\u0001RH\u0003\u0004\t\u0005A!\u0005\u0004\u0001\u0006\u0007\u0011A\u00022\t\u0007\u0001\u000b\t!\u0011\u0001#\u0012\u0006\u0007\u0011\t\u0001R\n\u0007\u0001\u000b\t!\u0011\u0001#\u0014\u0006\u0007\u0011e\u0001\u0012\u000b\u0007\u0001\u000b\t!a\u0003#\u0015\u0006\u0007\u0011e\u0001B\u000b\u0007\u0001\u000b\t!I\u0002#\u0016\u0006\u0005\u0011a\u0002bK\u0003\u0003\tsA!\u0006B\u0002\r\u0005e\u0019Q!\u0001E\u00031\u000bis\u0003Bb\r1'\tC!B\u0001\t\u00161\u0005\u0001TC+\u0004\u001d\u0015\u0019A1C\u0005\u0002\u0011-i1\u0001\u0002\u0007\n\u0003!Y\u0011#\u0002C\r\u0013\u0005!\u0001!D\u0001\t\u00175\nBa\u0019\u0003\u0019\u001b\u0005\u001aQ!\u0001\u0005\r11!3%V\u0002\t\u000b\r!i\"C\u0001\t\u001b5\u0019A\u0001E\u0005\u0002\u00117i\u0013\u0003B1\u00051\u000f\t\u0003\"B\u0001\t\u000b%!\u0011bA\u0003\u0002\u0011\u0019Ab\u0001G\u0003V\u0007\u0011)1\u0001b\u0002\n\u0003!AQ&\u0004\u0003B\u001aa\u0005\u0012\u0005B\u0003\u0002\u0011;a\t\u0001'\bV\u0007\u0011)1\u0001\"\t\n\u0003!yQ&\u0004\u0003d\ta\u0011\u0012eA\u0003\u0002\u0011+A*\u0002J\u0012V\u0007\u0011i1\u0001\"\n\n\u0003!YQ6\u000e\u0003\u000b1Miz\u0001\u0002\u0001\t(5\u0019Q!\u0001E\b1\u001f\u00016\u0001AO\b\t\u0001AA#D\u0002\u0006\u0003!}\u0001t\u0004)\u0004\u0002u=A\u0001\u0001\u0005\u0016\u001b\r)\u0011\u0001\u0003\t\u0019!A\u001b\u0011!h\u0004\u0005\u0001!1RbA\u0003\u0002\u0011CA\n\u0003UB\u0002C\r)\u0011\u0001C\t\u0019#E\u001bA\u0002B\n\n\u0003\u0011\u0001Q\"\u0001E\t\u001b\u0005A!#\u0004\u0002\u0005\u00041\u0005Q\"\u0001C\u0003[+!1\u0002\u0007\r\"\u0007\u0015\t\u0001R\u0005M\u0013#\u000e\u0019A\u0001G\u0005\u0002\t\u0003iC\u0006B\u0006\u00193uEA\u0001\u0001E\u001a\u001b\u0011)\u0011\u0001c\n\r\u0002a\u001d\u0002k\u0001\u0001\u001e\u0012\u0011\u0001\u0001bG\u0007\u0005\u000b\u0005AA\u0003$\u0001\u0019)A\u001b\t!h\u0004\u0005\u0001!aRbA\u0003\u0002\u0011KA*\u0003U\u0002\u0002C\r)\u0011\u0001#\n\u0019&E\u001b\u0011\u0002B\r\n\u0003\u0011\u0005Q\"\u0001E\u0015\u001b\u0005AQ#D\u0001\u0005\u00025RBa\u0003\r\u001a;3!\u0001\u0001#\u000f\u000e\u0011\u0015\t\u00012F\u0005\u0005\u0013\r)\u0011\u0001c\b\u0019 a-\u0002k\u0001\u0001\"\u0007\u0015\t\u0001\"\u0005\r\u0012#\u000e)A!G\u0005\u0002\t\u0001i\u0011\u0001#\f.B\u0011\t\u00014HO\t\t\u0001A\u0019$\u0004\u0003\u0006\u0003!\u001dB\u0012\u0001M\u0014!\u000e\u0001Qt\u0002\u0003\u0001\u0011yi1!B\u0001\t/a9\u0002k!\u0001\"\u0007\u0015\t\u0001R\u0005M\u0013#\u000e9A1H\u0005\u0002\t\u0003i\u0011\u0001#\u000b\u000e\u0003!=RV\u0003\u0003\f1}\t3!B\u0001\t&a\u0015\u0012kA\u0002\u0005?%\tA\u0011AW \t)Az$h\u0004\u0005\u0001!!RbA\u0003\u0002\u0011?Az\u0002U\u0002\u0001;\u001f!\u0001\u0001\u0003\u0011\u000e\u0007\u0015\t\u0001R\u0005M\u0013!\u000e\u0005\u0011eA\u0003\u0002\u0011EA\u0012#U\u0002\b\t\u007fI\u0011\u0001\u0002\u0001\u000e\u0003!\u0011R\"\u0001C\u0001[+!1\u0002'\u0011\"\u0007\u0015\t\u0001\"\u0005\r\u0012#\u000e\u0019A\u0011I\u0005\u0002\t\u0001ic\u0003B\u0006\u0019CuEA\u0001\u0001E\u001a\u001b\u0011)\u0011\u0001c\n\r\u0002a\u001d\u0002k\u0001\u0001\"\u0007\u0015\t\u0001\u0012\u0007M\u0019#\u000e)A!I\u0005\u0002\u0011ei\u0011\u0001#\u000b.\u0016\u0011Y\u0001dI\u0011\u0004\u000b\u0005A\t\u0003'\tR\u0007\r!1%C\u0001\u0005\u00065^A!\u0001M$C\u0011)\u0011\u0001#\b\r\u0002au\u0011kA\u0002\u0005H%\t\u0001bDW\f\t-AB%\t\u0003\u0006\u0003!}A\u0012\u0001M\u0010#\u000e\u0019A\u0001J\u0005\u0002\u0011Ii+\u0002B\u0006\u0019J\u0005\u001aQ!\u0001E\u00131K\t6a\u0001C%\u0013\u0005!\t!L\u000b\u0005\u0015a)St\u0002\u0003\u0001\u0011Qi1!B\u0001\t a}\u0001k\u0001\u0001\"\u0007\u0015\t\u0001R\u0005M\u0013#\u000e)A!J\u0005\u0002\t\u0003i\u0011\u0001\u0003\n.\u0016\u0011Y\u00014J\u0011\u0004\u000b\u0005A)\u0003'\nR\u0007\r!Y%C\u0001\u0005\u00025:Ba\u0003\r';#!\u0001\u0001c\r\u000e\t\u0015\t\u0001r\u0005G\u00011O\u00016\u0001A\u0011\u0005\u000b\u0005A\u0019\u0004$\u0001\u00194E\u001bQ\u0001\u0002\u0014\n\u0003!QR\"\u0001E\u0015[Y!1\u0002G\u0014\u001e\u0012\u0011\u0001\u00012G\u0007\u0005\u000b\u0005A9\u0003$\u0001\u0019(A\u001b\u0001!I\u0002\u0006\u0003!\t\u0002$E)\u0004\u000b\u00119\u0013\"\u0001\u0003\u0001\u001b\u0005AI#\f\u0011\u0005\u0007a=ST\u0005\u0003\u0001\u0011!ja\"B\u0001\t6%!\u0011bA\u0003\u0002\u0011?Az\"C\u0003\n\t\u0015\t\u0001r\u0004G\u00011?A*\u0004U\u0002\u0001C\r)\u0011\u0001#\n\u0019&E\u001bQ\u0001b\u0014\n\u0003\u0011\u0005Q\"\u0001\u0005\u001c[\u0017\"1\u0002G\u0015\u001e\u0010\u0011\u0001\u00012G\u0007\u0004\u000b\u0005A9\u0003g\nQ\u0007\u0001iZ\u0002\u0002\u0001\tT5IQ!\u0001E\u001c\u0013\u0011I1!B\u0001\t#a\tB\u0012\u0001M\u001c!\u000e\u0005\u0011eA\u0003\u0002\u0011gA\u001a$U\u0002\b\t%J\u0011\u0001\u0003\u000e\u000e\u0003!%R\"\u0001\u0005\u001e[U!1\u0002g\u0016\u001e\u0010\u0011\u0001\u00012G\u0007\u0004\u000b\u0005A9\u0003g\nQ\u0007\u0001\t3!B\u0001\t4aM\u0012kA\u0003\u0005X%\t\u0001BG\u0007\u0002\u0011Si\u001b\u0005B\u0006\u0019YuEA\u0001\u0001E-\u001b\u0011)\u0011\u0001c\b\r\u0002a}\u0001k\u0001\u0001\u001e\u0012\u0011\u0001\u0001\"L\u0007\u0005\u000b\u0005Ay\u0002$\u0001\u0019 A\u001b\t!I\u0002\u0006\u0003!\t\u0002$E)\u0004\u000f\u0011a\u0013\"\u0001\u0003\u0001\u001b\u0005A!#D\u0001\t%U2S!\n\u0003d\u0002a\u0019Q\u0014\u0004\u0003\u0001\u0011\u000fi\u0001\"B\u0001\t\u000b%!\u0011bA\u0003\u0002\u0011\u0019Ab\u0001G\u0003Q\u0007\u0001iz\u0001\u0002\u0001\t\u00105\u0019Q!\u0001E\b1\u001f\u00016\u0011A\u0011\u0004\u000b\u0005A!\u0001\u0007\u0002R\u0007\u001d!1!C\u0001\u0005\u00015\t\u0001\u0002C\u0007\u0002\u0011#\u0001"})
public final class GitRepositoryManager
extends BaseRepositoryManager {
    public static final /* synthetic */ KClass $kotlinClass;
    @Nullable
    private Repository _repository;
    @NotNull
    private final Lazy<? extends JGitCredentialsProvider> credentialsProvider$delegate;
    private IgnoreNode ignoreRules;
    private final NotNullLazyValue<CredentialsStore> credentialsStore;
    private static final /* synthetic */ PropertyMetadata[] $propertyMetadata;

    static {
        $kotlinClass = Reflection.createKotlinClass(GitRepositoryManager.class);
        $propertyMetadata = new PropertyMetadata[]{new PropertyMetadataImpl("credentialsProvider")};
    }

    @NotNull
    public final Repository getRepository() {
        Repository r = this._repository;
        if (r == null) {
            this._repository = r = ((FileRepositoryBuilder)new FileRepositoryBuilder().setWorkTree(this.getDir())).build();
            Application application = ApplicationManager.getApplication();
            if (Intrinsics.areEqual((Object)(application != null ? Boolean.valueOf(application.isUnitTestMode()) : null), (Object)true) ^ true) {
                ShutDownTracker.getInstance().registerShutdownTask(new Runnable(this){
                    final /* synthetic */ GitRepositoryManager this$0;

                    public final void run() {
                        Unit unit;
                        Repository repository2 = this.this$0.get_repository();
                        if (repository2 != null) {
                            repository2.close();
                            unit = Unit.INSTANCE$;
                        } else {
                            unit = null;
                        }
                    }
                    {
                        this.this$0 = gitRepositoryManager;
                    }
                });
            }
        }
        Repository repository2 = r;
        if (repository2 == null) {
            Intrinsics.throwNpe();
        }
        return repository2;
    }

    @Nullable
    public final Repository get_repository() {
        return this._repository;
    }

    public final void set_repository(@Nullable Repository repository2) {
        this._repository = repository2;
    }

    @NotNull
    public final CredentialsProvider getCredentialsProvider() {
        return (CredentialsProvider)LazyKt.get(this.credentialsProvider$delegate, (Object)this, (PropertyMetadata)$propertyMetadata[0]);
    }

    @Override
    public boolean createRepositoryIfNeed() {
        this.ignoreRules = null;
        if (this.isRepositoryExists()) {
            return false;
        }
        this.getRepository().create();
        GitExKt.disableAutoCrLf(this.getRepository());
        return true;
    }

    @Override
    public void deleteRepository() {
        this.ignoreRules = null;
        super.deleteRepository();
        Repository r = this._repository;
        if (r != null) {
            this._repository = null;
            r.close();
        }
    }

    @Override
    @Nullable
    public String getUpstream() {
        return StringUtil.nullize((String)this.getRepository().getConfig().getString(ConfigConstants.CONFIG_REMOTE_SECTION, Constants.DEFAULT_REMOTE_NAME, ConfigConstants.CONFIG_KEY_URL));
    }

    @Override
    public void setUpstream(@Nullable String url, @Nullable String branch) {
        Repository repository2 = this.getRepository();
        String string = branch;
        if (string == null) {
            string = Constants.MASTER;
        }
        GitExKt.setUpstream(repository2, url, string);
    }

    @Override
    public boolean isRepositoryExists() {
        Repository repo = this._repository;
        if (repo == null) {
            return this.getDir().exists() && ((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().setWorkTree(this.getDir())).setup()).getObjectDirectory().exists();
        }
        return repo.getObjectDatabase().exists();
    }

    @Override
    public boolean hasUpstream() {
        return this.getUpstream() != null;
    }

    @Override
    protected void addToIndex(@NotNull File file, @NotNull String path, @NotNull byte[] content, int size) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        DirCacheEditorKt.edit(this.getRepository(), new AddLoadedFile(path, content, size, file.lastModified()));
    }

    @Override
    protected void deleteFromIndex(@NotNull String path, boolean isFile) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        DirCacheEditorKt.deletePath(this.getRepository(), path, isFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public boolean commit(@Nullable ProgressIndicator indicator, @Nullable SyncType syncType, boolean fixStateIfCannotCommit) {
        int it;
        void $receiver;
        ReentrantReadWriteLock reentrantReadWriteLock = this.getLock();
        ReentrantReadWriteLock.ReadLock rl = $receiver.readLock();
        int readCount = $receiver.getWriteHoldCount() == 0 ? $receiver.getReadHoldCount() : 0;
        int n = 0;
        int n2 = readCount - 1;
        if (n <= n2) {
            void index;
            do {
                it = ++index;
                rl.unlock();
            } while (index != n2);
        }
        ReentrantReadWriteLock.WriteLock wl = $receiver.writeLock();
        wl.lock();
        try {
            try {
                RepositoryState repositoryState = !fixStateIfCannotCommit || Intrinsics.areEqual((Object)((Object)syncType), (Object)((Object)SyncType.OVERWRITE_LOCAL)) ? this.getRepository().getRepositoryState() : PullKt.fixAndGetState(this.getRepository());
                Intrinsics.checkExpressionValueIsNotNull((Object)repositoryState, (String)"if (!fixStateIfCannotCom\u2026pository.fixAndGetState()");
                boolean bl = this.commitIfCan(indicator, repositoryState);
                return bl;
            }
            catch (UnmergedPathsException e2) {
                Unit unit;
                Unit unit2;
                block19: {
                    if (!Intrinsics.areEqual((Object)((Object)syncType), (Object)((Object)SyncType.OVERWRITE_LOCAL))) break block19;
                    IcsManagerKt.getLOG().warn("Unmerged detected, ignored because sync type is OVERWRITE_LOCAL", (Throwable)e2);
                    boolean bl = false;
                    it = 0;
                    int e2 = readCount - 1;
                    if (it <= e2) {
                        do {
                            int n3 = ++it;
                            rl.lock();
                        } while (it != e2);
                    }
                    wl.unlock();
                    return bl;
                }
                ProgressIndicator progressIndicator = indicator;
                if (progressIndicator != null) {
                    progressIndicator.checkCanceled();
                    unit2 = Unit.INSTANCE$;
                } else {
                    unit2 = null;
                }
                IcsManagerKt.getLOG().warn("Unmerged detected, will be attempted to resolve", (Throwable)e2);
                PullKt.resolveUnmergedConflicts(this.getRepository());
                ProgressIndicator progressIndicator2 = indicator;
                if (progressIndicator2 != null) {
                    progressIndicator2.checkCanceled();
                    unit = Unit.INSTANCE$;
                } else {
                    unit = null;
                }
                boolean bl = this.commitIfCan(indicator, PullKt.fixAndGetState(this.getRepository()));
                it = 0;
                int n4 = readCount - 1;
                if (it <= n4) {
                    do {
                        int n5 = ++it;
                        rl.lock();
                    } while (it != n4);
                }
                wl.unlock();
                return bl;
            }
        }
        finally {
            it = 0;
            int n6 = readCount - 1;
            if (it <= n6) {
                do {
                    int n7 = ++it;
                    rl.lock();
                } while (it != n6);
            }
            wl.unlock();
        }
    }

    private final boolean commitIfCan(ProgressIndicator indicator, RepositoryState state) {
        if (state.canCommit()) {
            return CommitKt.commit$default(this.getRepository(), indicator, null, 4);
        }
        IcsManagerKt.getLOG().warn("Cannot commit, repository in state " + state.getDescription());
        return false;
    }

    @Override
    public int getAheadCommitsCount() {
        return GitExKt.getAheadCommitsCount(this.getRepository());
    }

    @Override
    public void commit(@NotNull List<? extends String> paths) {
        Intrinsics.checkParameterIsNotNull(paths, (String)"paths");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void push(@Nullable ProgressIndicator indicator) {
        Ref head;
        IcsManagerKt.getLOG().debug("Push");
        SmartList refSpecs = new SmartList((Collection)new RemoteConfig((Config)this.getRepository().getConfig(), Constants.DEFAULT_REMOTE_NAME).getPushRefSpecs());
        if (refSpecs.isEmpty() && (head = this.getRepository().getRef(Constants.HEAD)) != null && head.isSymbolic()) {
            refSpecs.add((Object)new RefSpec(head.getLeaf().getName()));
        }
        ProgressMonitor monitor = JGitProgressMonitorKt.asProgressMonitor(indicator);
        block5: for (Transport transport : Transport.openAll((Repository)this.getRepository(), (String)Constants.DEFAULT_REMOTE_NAME, (Transport.Operation)Transport.Operation.PUSH)) {
            boolean bl = false;
            boolean bl2 = true;
            if (bl > bl2) continue;
            while (true) {
                void attempt;
                transport.setCredentialsProvider(this.getCredentialsProvider());
                try {
                    PushResult result = transport.push(monitor, transport.findRemoteRefUpdatesFor((Collection)refSpecs));
                    if (!IcsManagerKt.getLOG().isDebugEnabled()) continue block5;
                    OperationResult operationResult = (OperationResult)result;
                    Intrinsics.checkExpressionValueIsNotNull((Object)operationResult, (String)"result");
                    GitRepositoryManagerKt.printMessages(operationResult);
                    for (RemoteRefUpdate refUpdate : result.getRemoteUpdates()) {
                        IcsManagerKt.getLOG().debug(refUpdate.toString());
                    }
                    continue block5;
                }
                catch (TransportException e) {
                    if (Intrinsics.areEqual((Object)e.getStatus(), (Object)TransportException.Status.NOT_PERMITTED)) {
                        if (attempt != false) throw (Throwable)new AuthenticationException(e);
                        this.getCredentialsProvider().reset(transport.getURI());
                    } else {
                        GitExKt.wrapIfNeedAndReThrow(e);
                    }
                }
                finally {
                    transport.close();
                    continue block5;
                }
                if (attempt == bl2) continue block5;
                ++attempt;
            }
        }
    }

    @Override
    @NotNull
    public RepositoryManager.Updater fetch(@Nullable ProgressIndicator indicator) {
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator == null) {
            progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
        }
        Pull pullTask = new Pull(this, progressIndicator, null, 4, null);
        Ref refToMerge = Pull.fetch$default(pullTask, null, 1);
        return new RepositoryManager.Updater(this, pullTask, refToMerge){
            public static final /* synthetic */ KClass $kotlinClass;
            private boolean definitelySkipPush;
            final /* synthetic */ GitRepositoryManager this$0;
            final /* synthetic */ Pull $pullTask;
            final /* synthetic */ Ref $refToMerge;

            static {
                $kotlinClass = Reflection.createKotlinClass(fetch.1.class);
            }

            public boolean getDefinitelySkipPush() {
                return this.definitelySkipPush;
            }

            public void setDefinitelySkipPush(boolean bl) {
                this.definitelySkipPush = bl;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @Nullable
            public UpdateResult merge() {
                int committed;
                int it;
                ReentrantReadWriteLock $receiver = GitRepositoryManager.access$getLock$1(this.this$0);
                ReentrantReadWriteLock.ReadLock rl = $receiver.readLock();
                int readCount = $receiver.getWriteHoldCount() == 0 ? $receiver.getReadHoldCount() : 0;
                int n = 0;
                int n2 = readCount - 1;
                if (n <= n2) {
                    void index;
                    do {
                        it = ++index;
                        rl.unlock();
                    } while (index != n2);
                }
                ReentrantReadWriteLock.WriteLock wl = $receiver.writeLock();
                wl.lock();
                try {
                    committed = RepositoryManager$$TImpl.commit$default(this.this$0, this.$pullTask.getIndicator(), null, false, 6);
                    if (this.$refToMerge == null && committed == 0 && this.this$0.getAheadCommitsCount() == 0) {
                        this.setDefinitelySkipPush(true);
                        UpdateResult updateResult = null;
                        return updateResult;
                    }
                    UpdateResult updateResult = Pull.pull$default(this.$pullTask, null, null, this.$refToMerge, 3);
                    return updateResult;
                }
                finally {
                    it = 0;
                    committed = readCount - 1;
                    if (it <= committed) {
                        do {
                            int n3 = ++it;
                            rl.lock();
                        } while (it != committed);
                    }
                    wl.unlock();
                }
            }
            {
                this.this$0 = $outer;
                this.$pullTask = $captured_local_variable$1;
                this.$refToMerge = $captured_local_variable$2;
            }
        };
    }

    @Override
    @Nullable
    public UpdateResult pull(@Nullable ProgressIndicator indicator) {
        return Pull.pull$default(new Pull(this, indicator, null, 4, null), null, null, null, 7);
    }

    @Override
    @NotNull
    public UpdateResult resetToTheirs(@NotNull ProgressIndicator indicator) {
        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
        return Reset.reset$default(new Reset(this, indicator), true, null, 2);
    }

    @Override
    @NotNull
    public UpdateResult resetToMy(@NotNull ProgressIndicator indicator, @Nullable Function0<? extends Unit> localRepositoryInitializer) {
        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
        return new Reset(this, indicator).reset(false, localRepositoryInitializer);
    }

    @Override
    public boolean canCommit() {
        return this.getRepository().getRepositoryState().canCommit();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean renameDirectory(@NotNull Map<String, ? extends String> pairs) {
        void receiver;
        Object object;
        Intrinsics.checkParameterIsNotNull(pairs, (String)"pairs");
        AddCommand addCommand = null;
        SmartList toDelete = new SmartList();
        Iterator iterator = MapsKt.iterator(pairs);
        while (iterator.hasNext()) {
            object = (Map.Entry)iterator.next();
            String oldPath = (String)MapsKt.component1((Map.Entry)object);
            String newPath = (String)MapsKt.component2((Map.Entry)object);
            File old = new File(this.getDir(), oldPath);
            if (!old.exists()) continue;
            IcsManagerKt.getLOG().info("Rename " + oldPath + " to " + newPath);
            File[] files2 = old.listFiles();
            if (files2 != null) {
                File file = newPath == null ? this.getDir() : new File(this.getDir(), newPath);
                for (int i = 0; i < files2.length; ++i) {
                    File file2 = files2[i];
                    try {
                        if (file2.isHidden()) {
                            FileUtil.delete((File)file2);
                            continue;
                        }
                        file2.renameTo(new File(file, file2.getName()));
                        if (addCommand == null) {
                            addCommand = new AddCommand(this.getRepository());
                        }
                        addCommand.addFilepattern(newPath == null ? file2.getName() : newPath + "/" + file2.getName());
                        continue;
                    }
                    catch (Throwable e) {
                        IcsManagerKt.getLOG().error(e);
                    }
                }
                toDelete.add((Object)new DeleteDirectory(oldPath));
            }
            try {
                FileUtil.delete((File)old);
            }
            catch (Throwable e) {
                IcsManagerKt.getLOG().error(e);
            }
        }
        if (toDelete.isEmpty() && addCommand == null) {
            return false;
        }
        DirCacheEditorKt.edit(this.getRepository(), (List)toDelete);
        if (addCommand != null) {
            addCommand.call();
        }
        object = new IdeaCommitMessageFormatter();
        Repository repository2 = this.getRepository();
        IdeaCommitMessageFormatter $receiver = (IdeaCommitMessageFormatter)receiver;
        StringBuilder stringBuilder = $receiver.appendCommitOwnerInfo(new StringBuilder(), true);
        GitExKt.commit$default(repository2, stringBuilder.append("Get rid of $ROOT_CONFIG$ and $APP_CONFIG").toString(), null, null, null, 14);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final IgnoreNode getIgnoreRules() {
        File file;
        void node;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = this.ignoreRules;
        if ((IgnoreNode)node.element == null && (file = new File(this.getDir(), Constants.DOT_GIT_IGNORE)).exists()) {
            node.element = new IgnoreNode();
            Closeable $receiver = FilesKt.inputStream((File)file);
            boolean closed = false;
            try {
                InputStream it = (InputStream)$receiver;
                IgnoreNode ignoreNode = (IgnoreNode)node.element;
                if (ignoreNode == null) {
                    Intrinsics.throwNpe();
                }
                ignoreNode.parse(it);
                it = Unit.INSTANCE$;
            }
            catch (Exception e) {
                closed = true;
                try {
                    $receiver.close();
                }
                catch (Exception closeException) {
                    // empty catch block
                }
                throw (Throwable)e;
            }
            finally {
                if (!closed) {
                    $receiver.close();
                }
            }
            this.ignoreRules = (IgnoreNode)node.element;
        }
        return (IgnoreNode)node.element;
    }

    @Override
    protected boolean isPathIgnored(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        IgnoreNode ignoreNode = this.getIgnoreRules();
        return Intrinsics.areEqual(ignoreNode != null ? ignoreNode.isIgnored("/" + path, false) : null, (Object)IgnoreNode.MatchResult.IGNORED);
    }

    public GitRepositoryManager(@NotNull NotNullLazyValue<CredentialsStore> credentialsStore2, @NotNull File dir) {
        Intrinsics.checkParameterIsNotNull(credentialsStore2, (String)"credentialsStore");
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        super(dir);
        this.credentialsStore = credentialsStore2;
        this.credentialsProvider$delegate = LazyKt.lazy((Function0)((Function0)new Function0<JGitCredentialsProvider>(this){
            final /* synthetic */ GitRepositoryManager this$0;

            @NotNull
            public final JGitCredentialsProvider invoke() {
                return new JGitCredentialsProvider(GitRepositoryManager.access$getCredentialsStore$2(this.this$0), this.this$0.getRepository());
            }
            {
                this.this$0 = gitRepositoryManager;
                super(0);
            }
        }));
    }

    @NotNull
    public static final /* synthetic */ ReentrantReadWriteLock access$getLock$1(GitRepositoryManager $this) {
        return $this.getLock();
    }

    @NotNull
    public static final /* synthetic */ NotNullLazyValue<CredentialsStore> access$getCredentialsStore$2(GitRepositoryManager $this) {
        return $this.credentialsStore;
    }
}

