/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Heap;
import com.android.tools.perflib.heap.NonRecursiveVisitor;
import com.android.tools.perflib.heap.StackTrace;
import com.android.tools.perflib.heap.Type;
import com.android.tools.perflib.heap.Visitor;
import com.android.tools.perflib.heap.io.HprofBuffer;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.UnsignedBytes;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class Instance {
    protected final long mId;
    @NonNull
    protected final StackTrace mStack;
    long mClassId;
    Heap mHeap;
    int mSize;
    int mTopologicalOrder;
    int mDistanceToGcRoot = Integer.MAX_VALUE;
    boolean mReferencesAdded = false;
    Instance mNextInstanceToGcRoot = null;
    @Nullable
    private Instance mImmediateDominator;
    private long[] mRetainedSizes;
    private final ArrayList<Instance> mHardReferences = new ArrayList();
    private ArrayList<Instance> mSoftReferences = null;

    Instance(long id, @NonNull StackTrace stackTrace) {
        this.mId = id;
        this.mStack = stackTrace;
    }

    public long getId() {
        return this.mId;
    }

    public long getUniqueId() {
        return this.getId() & this.mHeap.mSnapshot.getIdSizeMask();
    }

    public abstract void accept(Visitor var1);

    public void setClassId(long classId) {
        this.mClassId = classId;
    }

    public ClassObj getClassObj() {
        return this.mHeap.mSnapshot.findClass(this.mClassId);
    }

    public final int getCompositeSize() {
        CompositeSizeVisitor visitor = new CompositeSizeVisitor();
        visitor.doVisit((Iterable<? extends Instance>)ImmutableList.of((Object)this));
        return visitor.getCompositeSize();
    }

    public int getSize() {
        return this.mSize;
    }

    public void setSize(int size) {
        this.mSize = size;
    }

    public void setHeap(Heap heap) {
        this.mHeap = heap;
    }

    public Heap getHeap() {
        return this.mHeap;
    }

    public int getTopologicalOrder() {
        return this.mTopologicalOrder;
    }

    public void setTopologicalOrder(int topologicalOrder) {
        this.mTopologicalOrder = topologicalOrder;
    }

    @Nullable
    public Instance getImmediateDominator() {
        return this.mImmediateDominator;
    }

    public void setImmediateDominator(@NonNull Instance dominator) {
        this.mImmediateDominator = dominator;
    }

    public int getDistanceToGcRoot() {
        return this.mDistanceToGcRoot;
    }

    public Instance getNextInstanceToGcRoot() {
        return this.mNextInstanceToGcRoot;
    }

    public void setDistanceToGcRoot(int newDistance) {
        assert (newDistance < this.mDistanceToGcRoot);
        this.mDistanceToGcRoot = newDistance;
    }

    public void setNextInstanceToGcRoot(Instance instance) {
        this.mNextInstanceToGcRoot = instance;
    }

    public void resetRetainedSize() {
        ArrayList<Heap> allHeaps = this.mHeap.mSnapshot.mHeaps;
        if (this.mRetainedSizes == null) {
            this.mRetainedSizes = new long[allHeaps.size()];
        } else {
            Arrays.fill(this.mRetainedSizes, 0L);
        }
        this.mRetainedSizes[allHeaps.indexOf((Object)this.mHeap)] = this.getSize();
    }

    public void addRetainedSize(int heapIndex, long size) {
        int n = heapIndex;
        this.mRetainedSizes[n] = this.mRetainedSizes[n] + size;
    }

    public long getRetainedSize(int heapIndex) {
        return this.mRetainedSizes[heapIndex];
    }

    public long getTotalRetainedSize() {
        if (this.mRetainedSizes == null) {
            return 0L;
        }
        long totalSize = 0L;
        for (long mRetainedSize : this.mRetainedSizes) {
            totalSize += mRetainedSize;
        }
        return totalSize;
    }

    public void addReference(@NonNull Instance reference) {
        if (reference.getIsSoftReference()) {
            if (this.mSoftReferences == null) {
                this.mSoftReferences = new ArrayList();
            }
            this.mSoftReferences.add(reference);
        } else {
            this.mHardReferences.add(reference);
        }
    }

    @NonNull
    public ArrayList<Instance> getHardReferences() {
        return this.mHardReferences;
    }

    @Nullable
    public ArrayList<Instance> getSoftReferences() {
        return this.mSoftReferences;
    }

    public boolean getIsSoftReference() {
        return false;
    }

    @Nullable
    protected Object readValue(@NonNull Type type) {
        switch (type) {
            case OBJECT: {
                long id = this.readId();
                return this.mHeap.mSnapshot.findInstance(id);
            }
            case BOOLEAN: {
                return this.getBuffer().readByte() != 0;
            }
            case CHAR: {
                return Character.valueOf(this.getBuffer().readChar());
            }
            case FLOAT: {
                return Float.valueOf(this.getBuffer().readFloat());
            }
            case DOUBLE: {
                return this.getBuffer().readDouble();
            }
            case BYTE: {
                return this.getBuffer().readByte();
            }
            case SHORT: {
                return this.getBuffer().readShort();
            }
            case INT: {
                return this.getBuffer().readInt();
            }
            case LONG: {
                return this.getBuffer().readLong();
            }
        }
        return null;
    }

    protected long readId() {
        switch (this.mHeap.mSnapshot.getTypeSize(Type.OBJECT)) {
            case 1: {
                return this.getBuffer().readByte();
            }
            case 2: {
                return this.getBuffer().readShort();
            }
            case 4: {
                return this.getBuffer().readInt();
            }
            case 8: {
                return this.getBuffer().readLong();
            }
        }
        return 0L;
    }

    protected int readUnsignedByte() {
        return UnsignedBytes.toInt((byte)this.getBuffer().readByte());
    }

    protected int readUnsignedShort() {
        return this.getBuffer().readShort() & 0xFFFF;
    }

    protected HprofBuffer getBuffer() {
        return this.mHeap.mSnapshot.mBuffer;
    }

    public static class CompositeSizeVisitor
    extends NonRecursiveVisitor {
        int mSize = 0;

        @Override
        protected void defaultAction(Instance node) {
            this.mSize += node.getSize();
        }

        public int getCompositeSize() {
            return this.mSize;
        }
    }
}

