/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.statistics;

import com.intellij.diff.impl.DiffSettingsHolder;
import com.intellij.diff.tools.fragmented.UnifiedDiffTool;
import com.intellij.diff.tools.simple.SimpleDiffTool;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.UsagesCollector;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DiffUsagesCollector
extends UsagesCollector {
    public static final GroupDescriptor ID = GroupDescriptor.create("Diff");

    @Override
    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = ID;
        if (groupDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/statistics/DiffUsagesCollector", "getGroupId"));
        }
        return groupDescriptor;
    }

    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages() throws CollectUsagesException {
        HashSet usages = ContainerUtil.newHashSet();
        DiffUsagesCollector.processUsages("Default", usages);
        DiffUsagesCollector.processUsages("ChangesView", usages);
        DiffUsagesCollector.processUsages("CommitDialog", usages);
        DiffSettingsHolder.DiffSettings diffSettings = DiffSettingsHolder.getInstance().getSettings(null);
        usages.add(new UsageDescriptor("diff.DiffSettings.Default.IterateNextFile", diffSettings.isGoToNextFileOnNextDifference() ? 1 : 0));
        HashSet hashSet = usages;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/statistics/DiffUsagesCollector", "getUsages"));
        }
        return hashSet;
    }

    private static void processUsages(@NotNull String place, @NotNull Set<UsageDescriptor> usages) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/diff/statistics/DiffUsagesCollector", "processUsages"));
        }
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/diff/statistics/DiffUsagesCollector", "processUsages"));
        }
        DiffSettingsHolder.DiffSettings diffSettings = DiffSettingsHolder.getInstance().getSettings(place);
        TextDiffSettingsHolder.TextDiffSettings textSettings = TextDiffSettingsHolder.getInstance().getSettings(place);
        usages.add(new UsageDescriptor("diff.TextDiffSettings.Default.IgnorePolicy." + textSettings.getIgnorePolicy().name(), 1));
        usages.add(new UsageDescriptor("diff.TextDiffSettings.Default.HighlightPolicy." + textSettings.getHighlightPolicy().name(), 1));
        usages.add(new UsageDescriptor("diff.TextDiffSettings.Default.ExpandByDefault", textSettings.isExpandByDefault() ? 1 : 0));
        List<String> toolOrder = diffSettings.getDiffToolsOrder();
        int defaultToolIndex = ContainerUtil.indexOf(toolOrder, (Object)SimpleDiffTool.class.getCanonicalName());
        int unifiedToolIndex = ContainerUtil.indexOf(toolOrder, (Object)UnifiedDiffTool.class.getCanonicalName());
        boolean isUnifiedDefault = unifiedToolIndex != -1 && unifiedToolIndex < defaultToolIndex;
        usages.add(new UsageDescriptor("diff.DiffSettings.Default.isUnifiedTool", isUnifiedDefault ? 1 : 0));
    }
}

