/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.external;

import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DirectoryContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.ThreesideMergeRequest;
import com.intellij.diff.tools.external.ExternalDiffSettings;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineTokenizer;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LineSeparator;
import com.intellij.util.PathUtil;
import com.intellij.util.TimeoutUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalDiffToolUtil {
    public static boolean canCreateFile(@NotNull DiffContent content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "canCreateFile"));
        }
        if (content instanceof EmptyContent) {
            return true;
        }
        if (content instanceof DocumentContent) {
            return true;
        }
        if (content instanceof FileContent) {
            return true;
        }
        if (content instanceof DirectoryContent) {
            return ((DirectoryContent)content).getFile().isInLocalFileSystem();
        }
        return false;
    }

    @NotNull
    public static String createFile(@NotNull DiffContent content, @Nullable String title, @Nullable String windowTitle) throws IOException {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createFile"));
        }
        if (content instanceof EmptyContent) {
            String string = ExternalDiffToolUtil.createFile(new byte[0], "empty").getPath();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createFile"));
            }
            return string;
        }
        if (content instanceof FileContent) {
            VirtualFile file = ((FileContent)content).getFile();
            Document document = FileDocumentManager.getInstance().getCachedDocument(file);
            if (document != null) {
                FileDocumentManager.getInstance().saveDocument(document);
            }
            if (file.isInLocalFileSystem()) {
                String string = file.getPath();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createFile"));
                }
                return string;
            }
            String tempFileName = ExternalDiffToolUtil.getFileName(title, windowTitle, content.getContentType());
            String string = ExternalDiffToolUtil.createTempFile(file, tempFileName).getPath();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createFile"));
            }
            return string;
        }
        if (content instanceof DocumentContent) {
            String tempFileName = ExternalDiffToolUtil.getFileName(title, windowTitle, content.getContentType());
            String string = ExternalDiffToolUtil.createTempFile((DocumentContent)content, tempFileName).getPath();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createFile"));
            }
            return string;
        }
        if (content instanceof DirectoryContent) {
            VirtualFile file = ((DirectoryContent)content).getFile();
            if (file.isInLocalFileSystem()) {
                String string = file.getPath();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createFile"));
                }
                return string;
            }
            throw new IllegalArgumentException(content.toString());
        }
        throw new IllegalArgumentException(content.toString());
    }

    @NotNull
    private static File createTempFile(final @NotNull DocumentContent content, @NotNull String tempFileName) throws IOException {
        Charset charset;
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createTempFile"));
        }
        if (tempFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tempFileName", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createTempFile"));
        }
        FileDocumentManager.getInstance().saveDocument(content.getDocument());
        LineSeparator separator = content.getLineSeparator();
        if (separator == null) {
            separator = LineSeparator.getSystemLineSeparator();
        }
        if ((charset = content.getCharset()) == null) {
            charset = Charset.defaultCharset();
        }
        String contentData = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return content.getDocument().getText();
            }
        });
        if (separator != LineSeparator.LF) {
            contentData = StringUtil.convertLineSeparators((String)contentData, (String)separator.getSeparatorString());
        }
        byte[] bytes = contentData.getBytes(charset);
        File file = ExternalDiffToolUtil.createFile(bytes, tempFileName);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createTempFile"));
        }
        return file;
    }

    @NotNull
    private static File createTempFile(@NotNull VirtualFile file, @NotNull String tempFileName) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createTempFile"));
        }
        if (tempFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tempFileName", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createTempFile"));
        }
        byte[] bytes = file.contentsToByteArray();
        File file2 = ExternalDiffToolUtil.createFile(bytes, tempFileName);
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createTempFile"));
        }
        return file2;
    }

    @NotNull
    public static OutputFile createOutputFile(@NotNull DiffContent content, @Nullable String windowTitle) throws IOException {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createOutputFile"));
        }
        if (content instanceof FileContent) {
            VirtualFile file = ((FileContent)content).getFile();
            Document document = FileDocumentManager.getInstance().getCachedDocument(file);
            if (document != null) {
                FileDocumentManager.getInstance().saveDocument(document);
            }
            if (file.isInLocalFileSystem()) {
                LocalOutputFile localOutputFile = new LocalOutputFile(file);
                if (localOutputFile == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createOutputFile"));
                }
                return localOutputFile;
            }
            String tempFileName = ExternalDiffToolUtil.getFileName(null, windowTitle, content.getContentType());
            File tempFile = ExternalDiffToolUtil.createTempFile(file, tempFileName);
            NonLocalOutputFile nonLocalOutputFile = new NonLocalOutputFile(file, tempFile);
            if (nonLocalOutputFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createOutputFile"));
            }
            return nonLocalOutputFile;
        }
        if (content instanceof DocumentContent) {
            String tempFileName = ExternalDiffToolUtil.getFileName(null, windowTitle, content.getContentType());
            File tempFile = ExternalDiffToolUtil.createTempFile((DocumentContent)content, tempFileName);
            DocumentOutputFile documentOutputFile = new DocumentOutputFile(((DocumentContent)content).getDocument(), ((DocumentContent)content).getCharset(), tempFile);
            if (documentOutputFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createOutputFile"));
            }
            return documentOutputFile;
        }
        throw new IllegalArgumentException(content.toString());
    }

    @NotNull
    public static String getFileName(@Nullable String title, @Nullable String windowTitle, @Nullable FileType fileType) {
        String ext;
        String prefix = "";
        if (title != null && windowTitle != null) {
            prefix = title + "_" + windowTitle;
        } else if (title != null || windowTitle != null) {
            prefix = title != null ? title : windowTitle;
        }
        String string = ext = fileType != null ? fileType.getDefaultExtension() : "tmp";
        if (prefix.length() > 50) {
            prefix = prefix.substring(0, 50);
        }
        String string2 = PathUtil.suggestFileName((String)(prefix + "." + ext), (boolean)true, (boolean)false);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "getFileName"));
        }
        return string2;
    }

    @NotNull
    public static File createFile(@NotNull byte[] bytes, @NotNull String name) throws IOException {
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createFile"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createFile"));
        }
        File tempFile = FileUtil.createTempFile((String)"tmp_", (String)("_" + name), (boolean)true);
        FileUtil.writeToFile((File)tempFile, (byte[])bytes);
        File file = tempFile;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createFile"));
        }
        return file;
    }

    public static void execute(@NotNull ExternalDiffSettings settings, @NotNull List<? extends DiffContent> contents, @NotNull List<String> titles, @Nullable String windowTitle) throws IOException, ExecutionException {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "execute"));
        }
        if (contents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contents", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "execute"));
        }
        if (titles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "titles", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "execute"));
        }
        assert (contents.size() == 2 || contents.size() == 3);
        assert (titles.size() == contents.size());
        ArrayList<String> files = new ArrayList<String>();
        for (int i = 0; i < contents.size(); ++i) {
            files.add(ExternalDiffToolUtil.createFile(contents.get(i), titles.get(i), windowTitle));
        }
        CommandLineTokenizer parameterTokenizer = new CommandLineTokenizer(settings.getDiffParameters(), true);
        ArrayList args = new ArrayList();
        while (parameterTokenizer.hasMoreTokens()) {
            String arg = parameterTokenizer.nextToken();
            if ("%1".equals(arg)) {
                args.add(files.get(0));
                continue;
            }
            if ("%2".equals(arg)) {
                if (files.size() == 3) {
                    args.add(files.get(2));
                    continue;
                }
                args.add(files.get(1));
                continue;
            }
            if ("%3".equals(arg)) {
                if (files.size() != 3) continue;
                args.add(files.get(1));
                continue;
            }
            args.add(arg);
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setExePath(settings.getDiffExePath());
        commandLine.addParameters(args);
        commandLine.createProcess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeMerge(@Nullable Project project, @NotNull ExternalDiffSettings settings, @NotNull ThreesideMergeRequest request) throws IOException, ExecutionException {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "executeMerge"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "executeMerge"));
        }
        boolean success = false;
        try {
            DiffContent outputContent = request.getOutputContent();
            List contents = request.getContents();
            List titles = request.getContentTitles();
            String windowTitle = request.getTitle();
            assert (contents.size() == 3);
            assert (titles.size() == contents.size());
            ArrayList<String> files = new ArrayList<String>();
            for (int i = 0; i < contents.size(); ++i) {
                files.add(ExternalDiffToolUtil.createFile((DiffContent)contents.get(i), (String)titles.get(i), windowTitle));
            }
            OutputFile outputFile = ExternalDiffToolUtil.createOutputFile(outputContent, windowTitle);
            CommandLineTokenizer parameterTokenizer = new CommandLineTokenizer(settings.getMergeParameters(), true);
            ArrayList args = new ArrayList();
            while (parameterTokenizer.hasMoreTokens()) {
                String arg = parameterTokenizer.nextToken();
                if ("%1".equals(arg)) {
                    args.add(files.get(0));
                    continue;
                }
                if ("%2".equals(arg)) {
                    args.add(files.get(2));
                    continue;
                }
                if ("%3".equals(arg)) {
                    args.add(files.get(1));
                    continue;
                }
                if ("%4".equals(arg)) {
                    args.add(outputFile.getPath());
                    continue;
                }
                args.add(arg);
            }
            GeneralCommandLine commandLine = new GeneralCommandLine();
            commandLine.setExePath(settings.getMergeExePath());
            commandLine.addParameters(args);
            final Process process = commandLine.createProcess();
            if (settings.isMergeTrustExitCode()) {
                final Ref resultRef = new Ref();
                ProgressManager.getInstance().run((Task)new Task.Modal(project, "Waiting for external tool", true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/tools/external/ExternalDiffToolUtil$2", "run"));
                        }
                        final Semaphore semaphore = new Semaphore(0);
                        Thread waiter = new Thread("external process waiter"){

                            @Override
                            public void run() {
                                try {
                                    resultRef.set((Object)(process.waitFor() == 0 ? 1 : 0));
                                }
                                catch (InterruptedException interruptedException) {
                                }
                                finally {
                                    semaphore.release();
                                }
                            }
                        };
                        waiter.start();
                        try {
                            do {
                                indicator.checkCanceled();
                            } while (!semaphore.tryAcquire(200L, TimeUnit.MILLISECONDS));
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        finally {
                            waiter.interrupt();
                        }
                    }
                });
                success = resultRef.get() == Boolean.TRUE;
            } else {
                ProgressManager.getInstance().run((Task)new Task.Modal(project, "Launching external tool", false){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/tools/external/ExternalDiffToolUtil$3", "run"));
                        }
                        indicator.setIndeterminate(true);
                        TimeoutUtil.sleep((long)1000L);
                    }
                });
                boolean bl = success = Messages.showYesNoDialog((Project)project, (String)"Press \"Mark as Resolved\" when you finish resolving conflicts in the external tool", (String)"Merge In External Tool", (String)"Mark as Resolved", (String)"Revert", null) == 0;
            }
            if (success) {
                outputFile.finish();
            }
            request.applyResult(success ? MergeResult.RESOLVED : MergeResult.CANCEL);
        }
        catch (Throwable throwable) {
            request.applyResult(success ? MergeResult.RESOLVED : MergeResult.CANCEL);
            throw throwable;
        }
    }

    private static class DocumentOutputFile
    implements OutputFile {
        @NotNull
        private final Document myDocument;
        @NotNull
        private final File myLocalFile;
        @NotNull
        private final Charset myCharset;

        public DocumentOutputFile(@NotNull Document document, @Nullable Charset charset, @NotNull File localFile) {
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/tools/external/ExternalDiffToolUtil$DocumentOutputFile", "<init>"));
            }
            if (localFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localFile", "com/intellij/diff/tools/external/ExternalDiffToolUtil$DocumentOutputFile", "<init>"));
            }
            this.myDocument = document;
            this.myLocalFile = localFile;
            this.myCharset = charset != null ? charset : Charset.defaultCharset();
        }

        @Override
        @NotNull
        public String getPath() {
            String string = this.myLocalFile.getPath();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffToolUtil$DocumentOutputFile", "getPath"));
            }
            return string;
        }

        @Override
        public void finish() throws IOException {
            final String content = StringUtil.convertLineSeparators((String)FileUtil.loadFile((File)this.myLocalFile, (Charset)this.myCharset));
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    DocumentOutputFile.this.myDocument.setText((CharSequence)content);
                }
            });
        }
    }

    private static class NonLocalOutputFile
    implements OutputFile {
        @NotNull
        private final VirtualFile myFile;
        @NotNull
        private final File myLocalFile;

        public NonLocalOutputFile(@NotNull VirtualFile file, @NotNull File localFile) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diff/tools/external/ExternalDiffToolUtil$NonLocalOutputFile", "<init>"));
            }
            if (localFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localFile", "com/intellij/diff/tools/external/ExternalDiffToolUtil$NonLocalOutputFile", "<init>"));
            }
            this.myFile = file;
            this.myLocalFile = localFile;
        }

        @Override
        @NotNull
        public String getPath() {
            String string = this.myLocalFile.getPath();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffToolUtil$NonLocalOutputFile", "getPath"));
            }
            return string;
        }

        @Override
        public void finish() throws IOException {
            this.myFile.setBinaryContent(FileUtil.loadFileBytes((File)this.myLocalFile));
        }
    }

    private static class LocalOutputFile
    implements OutputFile {
        @NotNull
        private final VirtualFile myFile;

        public LocalOutputFile(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diff/tools/external/ExternalDiffToolUtil$LocalOutputFile", "<init>"));
            }
            this.myFile = file;
        }

        @Override
        @NotNull
        public String getPath() {
            String string = this.myFile.getPath();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffToolUtil$LocalOutputFile", "getPath"));
            }
            return string;
        }

        @Override
        public void finish() {
            this.myFile.refresh(false, false);
        }
    }

    private static interface OutputFile {
        @NotNull
        public String getPath();

        public void finish() throws IOException;
    }
}

