/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderEnumeratorSettings;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.OrderRootsEnumerator;
import com.intellij.openapi.roots.RootModelProvider;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.impl.OrderRootsCache;
import com.intellij.openapi.roots.impl.OrderRootsEnumeratorImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.NotNullFunction;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class OrderEnumeratorBase
extends OrderEnumerator
implements OrderEnumeratorSettings {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.OrderEnumeratorBase");
    private boolean myProductionOnly;
    private boolean myCompileOnly;
    private boolean myRuntimeOnly;
    private boolean myWithoutJdk;
    private boolean myWithoutLibraries;
    protected boolean myWithoutDepModules;
    private boolean myWithoutModuleSourceEntries;
    protected boolean myRecursively;
    protected boolean myRecursivelyExportedOnly;
    private boolean myExportedOnly;
    private Condition<OrderEntry> myCondition;
    private final List<OrderEnumerationHandler> myCustomHandlers;
    protected RootModelProvider myModulesProvider;
    private final OrderRootsCache myCache;

    public OrderEnumeratorBase(@Nullable Module module, @NotNull Project project, @Nullable OrderRootsCache cache) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/impl/OrderEnumeratorBase", "<init>"));
        }
        this.myCache = cache;
        SmartList customHandlers = null;
        for (OrderEnumerationHandler.Factory handlerFactory : (OrderEnumerationHandler.Factory[])OrderEnumerationHandler.EP_NAME.getExtensions()) {
            if (!handlerFactory.isApplicable(project) || module != null && !handlerFactory.isApplicable(module)) continue;
            if (customHandlers == null) {
                customHandlers = new SmartList();
            }
            customHandlers.add(handlerFactory.createHandler(module));
        }
        this.myCustomHandlers = customHandlers == null ? Collections.emptyList() : customHandlers;
    }

    public OrderEnumerator productionOnly() {
        this.myProductionOnly = true;
        return this;
    }

    public OrderEnumerator compileOnly() {
        this.myCompileOnly = true;
        return this;
    }

    public OrderEnumerator runtimeOnly() {
        this.myRuntimeOnly = true;
        return this;
    }

    public OrderEnumerator withoutSdk() {
        this.myWithoutJdk = true;
        return this;
    }

    public OrderEnumerator withoutLibraries() {
        this.myWithoutLibraries = true;
        return this;
    }

    public OrderEnumerator withoutDepModules() {
        this.myWithoutDepModules = true;
        return this;
    }

    public OrderEnumerator withoutModuleSourceEntries() {
        this.myWithoutModuleSourceEntries = true;
        return this;
    }

    public OrderEnumerator recursively() {
        this.myRecursively = true;
        return this;
    }

    public OrderEnumerator exportedOnly() {
        if (this.myRecursively) {
            this.myRecursivelyExportedOnly = true;
        } else {
            this.myExportedOnly = true;
        }
        return this;
    }

    public OrderEnumerator satisfying(Condition<OrderEntry> condition) {
        this.myCondition = condition;
        return this;
    }

    public OrderEnumerator using(@NotNull RootModelProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/openapi/roots/impl/OrderEnumeratorBase", "using"));
        }
        this.myModulesProvider = provider;
        return this;
    }

    public OrderRootsEnumerator classes() {
        return new OrderRootsEnumeratorImpl(this, OrderRootType.CLASSES);
    }

    public OrderRootsEnumerator sources() {
        return new OrderRootsEnumeratorImpl(this, OrderRootType.SOURCES);
    }

    public OrderRootsEnumerator roots(@NotNull OrderRootType rootType) {
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/openapi/roots/impl/OrderEnumeratorBase", "roots"));
        }
        return new OrderRootsEnumeratorImpl(this, rootType);
    }

    public OrderRootsEnumerator roots(@NotNull NotNullFunction<OrderEntry, OrderRootType> rootTypeProvider) {
        if (rootTypeProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootTypeProvider", "com/intellij/openapi/roots/impl/OrderEnumeratorBase", "roots"));
        }
        return new OrderRootsEnumeratorImpl(this, rootTypeProvider);
    }

    ModuleRootModel getRootModel(Module module) {
        if (this.myModulesProvider != null) {
            return this.myModulesProvider.getRootModel(module);
        }
        return ModuleRootManager.getInstance((Module)module);
    }

    public OrderRootsCache getCache() {
        LOG.assertTrue(this.myCache != null, (Object)"Caching is not supported for ModifiableRootModel");
        LOG.assertTrue(this.myCondition == null, (Object)"Caching not supported for OrderEnumerator with 'satisfying(Condition)' option");
        LOG.assertTrue(this.myModulesProvider == null, (Object)"Caching not supported for OrderEnumerator with 'using(ModulesProvider)' option");
        return this.myCache;
    }

    public int getFlags() {
        int flags = 0;
        if (this.myProductionOnly) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myCompileOnly) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myRuntimeOnly) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myWithoutJdk) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myWithoutLibraries) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myWithoutDepModules) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myWithoutModuleSourceEntries) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myRecursively) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myRecursivelyExportedOnly) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myExportedOnly) {
            flags |= 1;
        }
        return flags;
    }

    protected void processEntries(ModuleRootModel rootModel, Processor<OrderEntry> processor2, Set<Module> processed, boolean firstLevel) {
        if (processed != null && !processed.add(rootModel.getModule())) {
            return;
        }
        for (OrderEntry entry : rootModel.getOrderEntries()) {
            ModuleOrderEntry moduleOrderEntry;
            Module module;
            boolean exported;
            OrderEnumerationHandler handler2;
            if (this.myCondition != null && !this.myCondition.value((Object)entry) || entry instanceof JdkOrderEntry && (this.myWithoutJdk || !firstLevel) || this.myWithoutLibraries && entry instanceof LibraryOrderEntry || this.myWithoutDepModules && (!this.myRecursively && entry instanceof ModuleOrderEntry || entry instanceof ModuleSourceOrderEntry && !this.isRootModuleModel(((ModuleSourceOrderEntry)entry).getRootModel())) || this.myWithoutModuleSourceEntries && entry instanceof ModuleSourceOrderEntry) continue;
            OrderEnumerationHandler.AddDependencyType shouldAdd = OrderEnumerationHandler.AddDependencyType.DEFAULT;
            Iterator<OrderEnumerationHandler> iterator = this.myCustomHandlers.iterator();
            while (iterator.hasNext() && (shouldAdd = (handler2 = iterator.next()).shouldAddDependency(entry, this)) == OrderEnumerationHandler.AddDependencyType.DEFAULT) {
            }
            if (shouldAdd == OrderEnumerationHandler.AddDependencyType.DO_NOT_ADD) continue;
            boolean bl = exported = !(entry instanceof JdkOrderEntry);
            if (entry instanceof ExportableOrderEntry) {
                ExportableOrderEntry exportableEntry = (ExportableOrderEntry)entry;
                if (shouldAdd == OrderEnumerationHandler.AddDependencyType.DEFAULT) {
                    boolean forTestCompile;
                    DependencyScope scope = exportableEntry.getScope();
                    boolean bl2 = forTestCompile = scope.isForTestCompile() || scope == DependencyScope.RUNTIME && this.shouldAddRuntimeDependenciesToTestCompilationClasspath();
                    if (this.myCompileOnly && !scope.isForProductionCompile() && !forTestCompile || this.myRuntimeOnly && !scope.isForProductionRuntime() && !scope.isForTestRuntime() || this.myProductionOnly && (!scope.isForProductionCompile() && !scope.isForProductionRuntime() || this.myCompileOnly && !scope.isForProductionCompile() || this.myRuntimeOnly && !scope.isForProductionRuntime())) continue;
                }
                exported = exportableEntry.isExported();
            }
            if (!exported && (this.myExportedOnly || this.myRecursivelyExportedOnly && !firstLevel)) continue;
            if (this.myRecursively && entry instanceof ModuleOrderEntry && (module = (moduleOrderEntry = (ModuleOrderEntry)entry).getModule()) != null && this.shouldProcessRecursively()) {
                this.processEntries(this.getRootModel(module), processor2, processed, false);
                continue;
            }
            if (this.myWithoutDepModules && entry instanceof ModuleOrderEntry || processor2.process((Object)entry)) continue;
            return;
        }
    }

    private boolean shouldAddRuntimeDependenciesToTestCompilationClasspath() {
        for (OrderEnumerationHandler handler2 : this.myCustomHandlers) {
            if (!handler2.shouldAddRuntimeDependenciesToTestCompilationClasspath()) continue;
            return true;
        }
        return false;
    }

    private boolean shouldProcessRecursively() {
        for (OrderEnumerationHandler handler2 : this.myCustomHandlers) {
            if (handler2.shouldProcessDependenciesRecursively()) continue;
            return false;
        }
        return true;
    }

    public void forEachLibrary(final @NotNull Processor<Library> processor2) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/roots/impl/OrderEnumeratorBase", "forEachLibrary"));
        }
        this.forEach((Processor)new Processor<OrderEntry>(){

            public boolean process(OrderEntry orderEntry) {
                Library library;
                if (orderEntry instanceof LibraryOrderEntry && (library = ((LibraryOrderEntry)orderEntry).getLibrary()) != null) {
                    return processor2.process((Object)library);
                }
                return true;
            }
        });
    }

    public void forEachModule(final @NotNull Processor<Module> processor2) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/roots/impl/OrderEnumeratorBase", "forEachModule"));
        }
        this.forEach((Processor)new Processor<OrderEntry>(){

            public boolean process(OrderEntry orderEntry) {
                Module module;
                if (OrderEnumeratorBase.this.myRecursively && orderEntry instanceof ModuleSourceOrderEntry) {
                    Module module2 = ((ModuleSourceOrderEntry)orderEntry).getRootModel().getModule();
                    return processor2.process((Object)module2);
                }
                if (!(!(orderEntry instanceof ModuleOrderEntry) || OrderEnumeratorBase.this.myRecursively && OrderEnumeratorBase.this.shouldProcessRecursively() || (module = ((ModuleOrderEntry)orderEntry).getModule()) == null)) {
                    return processor2.process((Object)module);
                }
                return true;
            }
        });
    }

    public <R> R process(@NotNull RootPolicy<R> policy, R initialValue) {
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/openapi/roots/impl/OrderEnumeratorBase", "process"));
        }
        OrderEntryProcessor processor2 = new OrderEntryProcessor(policy, initialValue);
        this.forEach(processor2);
        return (R)processor2.myValue;
    }

    boolean shouldIncludeTestsFromDependentModulesToTestClasspath() {
        for (OrderEnumerationHandler handler2 : this.myCustomHandlers) {
            if (handler2.shouldIncludeTestsFromDependentModulesToTestClasspath()) continue;
            return false;
        }
        return true;
    }

    boolean addCustomRootsForLibrary(OrderEntry forOrderEntry, OrderRootType type, Collection<VirtualFile> result2) {
        for (OrderEnumerationHandler handler2 : this.myCustomHandlers) {
            ArrayList<String> urls = new ArrayList<String>();
            boolean added = handler2.addCustomRootsForLibrary(forOrderEntry, type, urls);
            for (String url : urls) {
                ContainerUtil.addIfNotNull((Object)VirtualFileManager.getInstance().findFileByUrl(url), result2);
            }
            if (!added) continue;
            return true;
        }
        return false;
    }

    boolean addCustomRootUrlsForLibrary(OrderEntry forOrderEntry, OrderRootType type, Collection<String> result2) {
        for (OrderEnumerationHandler handler2 : this.myCustomHandlers) {
            ArrayList<String> urls = new ArrayList<String>();
            boolean added = handler2.addCustomRootsForLibrary(forOrderEntry, type, urls);
            result2.addAll(urls);
            if (!added) continue;
            return true;
        }
        return false;
    }

    boolean addCustomRootsForModule(OrderRootType type, ModuleRootModel rootModel, Collection<VirtualFile> result2, boolean includeProduction, boolean includeTests) {
        for (OrderEnumerationHandler handler2 : this.myCustomHandlers) {
            ArrayList<String> urls = new ArrayList<String>();
            boolean added = handler2.addCustomModuleRoots(type, rootModel, urls, includeProduction, includeTests);
            for (String url : urls) {
                ContainerUtil.addIfNotNull((Object)VirtualFileManager.getInstance().findFileByUrl(url), result2);
            }
            if (!added) continue;
            return true;
        }
        return false;
    }

    boolean addCustomRootUrlsForModule(OrderRootType type, ModuleRootModel rootModel, Collection<String> result2, boolean includeProduction, boolean includeTests) {
        for (OrderEnumerationHandler handler2 : this.myCustomHandlers) {
            ArrayList<String> urls = new ArrayList<String>();
            boolean added = handler2.addCustomModuleRoots(type, rootModel, urls, includeProduction, includeTests);
            result2.addAll(urls);
            if (!added) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isRuntimeOnly() {
        return this.myRuntimeOnly;
    }

    @Override
    public boolean isCompileOnly() {
        return this.myCompileOnly;
    }

    @Override
    public boolean isProductionOnly() {
        return this.myProductionOnly;
    }

    public boolean isRootModuleModel(@NotNull ModuleRootModel rootModel) {
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/openapi/roots/impl/OrderEnumeratorBase", "isRootModuleModel"));
        }
        return false;
    }

    public abstract void processRootModules(@NotNull Processor<Module> var1);

    private static class OrderEntryProcessor<R>
    implements Processor<OrderEntry> {
        private R myValue;
        private final RootPolicy<R> myPolicy;

        private OrderEntryProcessor(RootPolicy<R> policy, R initialValue) {
            this.myPolicy = policy;
            this.myValue = initialValue;
        }

        public boolean process(OrderEntry orderEntry) {
            this.myValue = orderEntry.accept(this.myPolicy, this.myValue);
            return true;
        }
    }
}

