/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.renameProject;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.TitledHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.project.DumbModePermission;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.platform.ModuleAttachProcessor;
import com.intellij.projectImport.ProjectAttachProcessor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.RenameHandler;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameProjectHandler
implements RenameHandler,
TitledHandler {
    private static final Logger LOG = Logger.getInstance((String)("#" + RenameProjectHandler.class.getName()));

    public boolean isAvailableOnDataContext(DataContext dataContext) {
        return RenameProjectHandler.isAvailable(dataContext);
    }

    static boolean isAvailable(DataContext dataContext) {
        Module module = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext);
        return module != null;
    }

    public boolean isRenaming(DataContext dataContext) {
        return this.isAvailableOnDataContext(dataContext);
    }

    public String getActionTitle() {
        return RefactoringBundle.message((String)"rename.project.handler.title");
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/platform/renameProject/RenameProjectHandler", "invoke"));
        }
        LOG.error("Project renaming should be never invoked from file");
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/platform/renameProject/RenameProjectHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/platform/renameProject/RenameProjectHandler", "invoke"));
        }
        LOG.assertTrue(project instanceof ProjectEx);
        Module module = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext);
        LOG.assertTrue(module != null);
        Messages.showInputDialog((Project)project, (String)RefactoringBundle.message((String)"enter.new.project.name"), (String)RefactoringBundle.message((String)"rename.project"), (Icon)Messages.getQuestionIcon(), (String)module.getName(), (InputValidator)new MyInputValidator((ProjectEx)project, module));
    }

    protected static class MyInputValidator
    implements InputValidator {
        private final ProjectEx myProject;
        @Nullable
        private final Module myModule;

        public MyInputValidator(ProjectEx project, @Nullable Module module) {
            this.myProject = project;
            this.myModule = module;
        }

        public boolean checkInput(String inputString) {
            return inputString != null && inputString.length() > 0;
        }

        public boolean canClose(String inputString) {
            if (this.shouldRenameProject(inputString)) {
                this.myProject.setProjectName(inputString);
                this.myProject.save();
            }
            if (this.myModule != null && !inputString.equals(this.myModule.getName())) {
                final ModifiableModuleModel modifiableModel = ModuleManager.getInstance((Project)this.myProject).getModifiableModel();
                try {
                    modifiableModel.renameModule(this.myModule, inputString);
                }
                catch (ModuleWithNameAlreadyExists moduleWithNameAlreadyExists) {
                    Messages.showErrorDialog((Project)this.myProject, (String)IdeBundle.message((String)"error.module.already.exists", (Object[])new Object[]{inputString}), (String)IdeBundle.message((String)"title.rename.module", (Object[])new Object[0]));
                    return false;
                }
                Ref success = Ref.create((Object)Boolean.TRUE);
                CommandProcessor.getInstance().executeCommand((Project)this.myProject, new Runnable(){

                    @Override
                    public void run() {
                        ApplicationManager.getApplication().runWriteAction(new Runnable(){

                            @Override
                            public void run() {
                                DumbService.allowStartingDumbModeInside((DumbModePermission)DumbModePermission.MAY_START_BACKGROUND, (Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        modifiableModel.commit();
                                    }
                                });
                            }
                        });
                    }
                }, IdeBundle.message((String)"command.renaming.module", (Object[])new Object[]{this.myModule.getName()}), null);
                return (Boolean)success.get();
            }
            return true;
        }

        private boolean shouldRenameProject(String inputString) {
            if (inputString.equals(this.myProject.getName())) {
                return false;
            }
            if (this.myModule == null) {
                return true;
            }
            if (ProjectAttachProcessor.canAttachToProject()) {
                return this.myModule == ModuleAttachProcessor.getPrimaryModule(this.myProject);
            }
            return this.myModule == ModuleAttachProcessor.findModuleInBaseDir(this.myProject);
        }
    }
}

