/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.PrioritizedInternalDocumentListener;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.editor.impl.event.RetargetRangeMarkers;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ExternalChangeAction;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.impl.CommitToPsiFileAction;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.DocumentCommitProcessor;
import com.intellij.psi.impl.PsiDocumentTransactionListener;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiToDocumentSynchronizer;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.text.BlockSupport;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiDocumentManagerBase
extends PsiDocumentManager
implements DocumentListener,
ProjectComponent {
    static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.PsiDocumentManagerImpl");
    private static final Key<Document> HARD_REF_TO_DOCUMENT = Key.create((String)"HARD_REFERENCE_TO_DOCUMENT");
    private static final Key<PsiFile> HARD_REF_TO_PSI = Key.create((String)"HARD_REFERENCE_TO_PSI");
    private static final Key<List<Runnable>> ACTION_AFTER_COMMIT = Key.create((String)"ACTION_AFTER_COMMIT");
    protected final Project myProject;
    private final PsiManager myPsiManager;
    private final DocumentCommitProcessor myDocumentCommitProcessor;
    protected final Set<Document> myUncommittedDocuments;
    private final Map<Document, UncommittedInfo> myUncommittedInfos;
    protected boolean myStopTrackingDocuments;
    protected boolean myPerformBackgroundCommit;
    private volatile boolean myIsCommitInProgress;
    private final PsiToDocumentSynchronizer mySynchronizer;
    private final List<PsiDocumentManager.Listener> myListeners;
    private final Map<Object, Runnable> actionsWhenAllDocumentsAreCommitted;
    private static final Object PERFORM_ALWAYS_KEY = new Object(){

        @NonNls
        public String toString() {
            return "PERFORM_ALWAYS";
        }
    };

    protected PsiDocumentManagerBase(@NotNull Project project, @NotNull PsiManager psiManager, @NotNull MessageBus bus, @NonNls @NotNull DocumentCommitProcessor documentCommitProcessor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/PsiDocumentManagerBase", "<init>"));
        }
        if (psiManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiManager", "com/intellij/psi/impl/PsiDocumentManagerBase", "<init>"));
        }
        if (bus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bus", "com/intellij/psi/impl/PsiDocumentManagerBase", "<init>"));
        }
        if (documentCommitProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentCommitProcessor", "com/intellij/psi/impl/PsiDocumentManagerBase", "<init>"));
        }
        this.myUncommittedDocuments = ContainerUtil.newConcurrentSet();
        this.myUncommittedInfos = ContainerUtil.newConcurrentMap();
        this.myPerformBackgroundCommit = true;
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.actionsWhenAllDocumentsAreCommitted = new LinkedHashMap<Object, Runnable>();
        this.myProject = project;
        this.myPsiManager = psiManager;
        this.myDocumentCommitProcessor = documentCommitProcessor;
        this.mySynchronizer = new PsiToDocumentSynchronizer(this, bus);
        this.myPsiManager.addPsiTreeChangeListener((PsiTreeChangeListener)this.mySynchronizer);
        bus.connect().subscribe(PsiDocumentTransactionListener.TOPIC, (Object)new PsiDocumentTransactionListener(){

            @Override
            public void transactionStarted(@NotNull Document document, @NotNull PsiFile file) {
                if (document == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase$1", "transactionStarted"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/PsiDocumentManagerBase$1", "transactionStarted"));
                }
                PsiDocumentManagerBase.this.myUncommittedDocuments.remove(document);
            }

            @Override
            public void transactionCompleted(@NotNull Document document, @NotNull PsiFile file) {
                if (document == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase$1", "transactionCompleted"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/PsiDocumentManagerBase$1", "transactionCompleted"));
                }
            }
        });
    }

    @Nullable
    public PsiFile getPsiFile(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "getPsiFile"));
        }
        PsiFile userData = (PsiFile)document.getUserData(HARD_REF_TO_PSI);
        if (userData != null) {
            return userData;
        }
        PsiFile psiFile = this.getCachedPsiFile(document);
        if (psiFile != null) {
            return psiFile;
        }
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null || !virtualFile.isValid()) {
            return null;
        }
        psiFile = this.getPsiFile(virtualFile);
        if (psiFile == null) {
            return null;
        }
        this.fireFileCreated(document, psiFile);
        return psiFile;
    }

    public static void cachePsi(@NotNull Document document, @Nullable PsiFile file) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "cachePsi"));
        }
        document.putUserData(HARD_REF_TO_PSI, (Object)file);
    }

    public PsiFile getCachedPsiFile(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "getCachedPsiFile"));
        }
        PsiFile userData = (PsiFile)document.getUserData(HARD_REF_TO_PSI);
        if (userData != null) {
            return userData;
        }
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null || !virtualFile.isValid()) {
            return null;
        }
        return this.getCachedPsiFile(virtualFile);
    }

    @Nullable
    FileViewProvider getCachedViewProvider(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "getCachedViewProvider"));
        }
        VirtualFile virtualFile = PsiDocumentManagerBase.getVirtualFile(document);
        if (virtualFile == null) {
            return null;
        }
        return this.getCachedViewProvider(virtualFile);
    }

    private FileViewProvider getCachedViewProvider(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/psi/impl/PsiDocumentManagerBase", "getCachedViewProvider"));
        }
        return ((PsiManagerEx)this.myPsiManager).getFileManager().findCachedViewProvider(virtualFile);
    }

    private static VirtualFile getVirtualFile(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "getVirtualFile"));
        }
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null || !virtualFile.isValid()) {
            return null;
        }
        return virtualFile;
    }

    @Nullable
    PsiFile getCachedPsiFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/psi/impl/PsiDocumentManagerBase", "getCachedPsiFile"));
        }
        return ((PsiManagerEx)this.myPsiManager).getFileManager().getCachedPsiFile(virtualFile);
    }

    @Nullable
    private PsiFile getPsiFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/psi/impl/PsiDocumentManagerBase", "getPsiFile"));
        }
        return ((PsiManagerEx)this.myPsiManager).getFileManager().findFile(virtualFile);
    }

    @Nullable
    public Document getDocument(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/PsiDocumentManagerBase", "getDocument"));
        }
        if (file instanceof PsiBinaryFile) {
            return null;
        }
        Document document = this.getCachedDocument(file);
        if (document != null) {
            if (!file.getViewProvider().isPhysical() && document.getUserData(HARD_REF_TO_PSI) == null) {
                PsiUtilCore.ensureValid((PsiElement)file);
                PsiDocumentManagerBase.cachePsi(document, file);
            }
            return document;
        }
        FileViewProvider viewProvider = file.getViewProvider();
        if (!viewProvider.isEventSystemEnabled()) {
            return null;
        }
        document = FileDocumentManager.getInstance().getDocument(viewProvider.getVirtualFile());
        if (document != null) {
            if (document.getTextLength() != file.getTextLength()) {
                String message = "Document/PSI mismatch: " + file + " (" + file.getClass() + "); physical=" + viewProvider.isPhysical();
                if (document.getTextLength() + file.getTextLength() < 8096) {
                    message = message + "\n=== document ===\n" + document.getText() + "\n=== PSI ===\n" + file.getText();
                }
                throw new AssertionError((Object)message);
            }
            if (!viewProvider.isPhysical()) {
                PsiUtilCore.ensureValid((PsiElement)file);
                PsiDocumentManagerBase.cachePsi(document, file);
                file.putUserData(HARD_REF_TO_DOCUMENT, (Object)document);
            }
        }
        return document;
    }

    public Document getCachedDocument(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/PsiDocumentManagerBase", "getCachedDocument"));
        }
        if (!file.isPhysical()) {
            return null;
        }
        VirtualFile vFile = file.getViewProvider().getVirtualFile();
        return FileDocumentManager.getInstance().getCachedDocument(vFile);
    }

    public void commitAllDocuments() {
        Document[] documents;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myUncommittedDocuments.isEmpty()) {
            return;
        }
        for (Document document : documents = this.getUncommittedDocuments()) {
            this.commitDocument(document);
        }
        LOG.assertTrue(!this.hasUncommitedDocuments(), this.myUncommittedDocuments);
    }

    public void performForCommittedDocument(@NotNull Document doc, @NotNull Runnable action) {
        Document document;
        if (doc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doc", "com/intellij/psi/impl/PsiDocumentManagerBase", "performForCommittedDocument"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/psi/impl/PsiDocumentManagerBase", "performForCommittedDocument"));
        }
        Document document2 = document = doc instanceof DocumentWindow ? ((DocumentWindow)doc).getDelegate() : doc;
        if (this.isCommitted(document)) {
            action.run();
        } else {
            PsiDocumentManagerBase.addRunOnCommit(document, action);
        }
    }

    public boolean cancelAndRunWhenAllCommitted(@NonNls @NotNull Object key, @NotNull Runnable action) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/impl/PsiDocumentManagerBase", "cancelAndRunWhenAllCommitted"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/psi/impl/PsiDocumentManagerBase", "cancelAndRunWhenAllCommitted"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myProject.isDisposed()) {
            action.run();
            return true;
        }
        if (this.myUncommittedDocuments.isEmpty()) {
            action.run();
            if (!this.hasUncommitedDocuments()) assert (this.actionsWhenAllDocumentsAreCommitted.isEmpty()) : this.actionsWhenAllDocumentsAreCommitted;
            return true;
        }
        this.actionsWhenAllDocumentsAreCommitted.put(key, action);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRunOnCommit(@NotNull Document document, @NotNull Runnable action) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "addRunOnCommit"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/psi/impl/PsiDocumentManagerBase", "addRunOnCommit"));
        }
        Key<List<Runnable>> key = ACTION_AFTER_COMMIT;
        synchronized (key) {
            List list = (List)document.getUserData(ACTION_AFTER_COMMIT);
            if (list == null) {
                list = new SmartList();
                document.putUserData(ACTION_AFTER_COMMIT, (Object)list);
            }
            list.add(action);
        }
    }

    public void commitDocument(@NotNull Document doc) {
        Document document;
        if (doc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doc", "com/intellij/psi/impl/PsiDocumentManagerBase", "commitDocument"));
        }
        Document document2 = document = doc instanceof DocumentWindow ? ((DocumentWindow)doc).getDelegate() : doc;
        if (!this.isCommitted(document)) {
            this.doCommit(document);
        }
    }

    public boolean finishCommit(final @NotNull Document document, final @NotNull List<Processor<Document>> finishProcessors, final boolean synchronously, @NotNull Object reason) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "finishCommit"));
        }
        if (finishProcessors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finishProcessors", "com/intellij/psi/impl/PsiDocumentManagerBase", "finishCommit"));
        }
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/psi/impl/PsiDocumentManagerBase", "finishCommit"));
        }
        assert (!this.myProject.isDisposed()) : "Already disposed";
        final boolean[] ok = new boolean[]{true};
        ApplicationManager.getApplication().runWriteAction((Runnable)((Object)new CommitToPsiFileAction(document, this.myProject){

            public void run() {
                ok[0] = PsiDocumentManagerBase.this.finishCommitInWriteAction(document, finishProcessors, synchronously);
            }
        }));
        if (ok[0]) {
            if (!this.mySynchronizer.isDocumentAffectedByTransactions(document)) {
                InjectedLanguageManager.getInstance((Project)this.myProject).startRunInjectors(document, synchronously);
            }
            this.runAfterCommitActions(document);
            if (DebugUtil.DO_EXPENSIVE_CHECKS && !ApplicationInfoImpl.isInPerformanceTest()) {
                this.checkAllElementsValid(document, reason);
            }
        }
        return ok[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean finishCommitInWriteAction(@NotNull Document document, @NotNull List<Processor<Document>> finishProcessors, boolean synchronously) {
        boolean success;
        block14: {
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "finishCommitInWriteAction"));
            }
            if (finishProcessors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finishProcessors", "com/intellij/psi/impl/PsiDocumentManagerBase", "finishCommitInWriteAction"));
            }
            if (this.myProject.isDisposed()) {
                return false;
            }
            assert (!(document instanceof DocumentWindow));
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
            if (virtualFile != null) {
                this.getSmartPointerManager().fastenBelts(virtualFile);
            }
            this.myIsCommitInProgress = true;
            success = true;
            try {
                FileViewProvider viewProvider = this.getCachedViewProvider(document);
                if (viewProvider != null) {
                    for (Processor<Document> finishRunnable : finishProcessors) {
                        success = finishRunnable.process((Object)document);
                        if (synchronously) assert (success) : finishRunnable + " in " + finishProcessors;
                        if (success) continue;
                        break;
                    }
                    if (success) {
                        this.clearUncommittedInfo(document);
                        if (virtualFile != null) {
                            this.getSmartPointerManager().updatePointerTargetsAfterReparse(virtualFile);
                        }
                        viewProvider.contentsSynchronized();
                    }
                    break block14;
                }
                this.handleCommitWithoutPsi(document);
            }
            catch (Throwable throwable) {
                this.myDocumentCommitProcessor.log("in PDI.finishDoc: ", null, synchronously, success, this.myUncommittedDocuments);
                if (success) {
                    this.myUncommittedDocuments.remove(document);
                    this.myDocumentCommitProcessor.log("in PDI.finishDoc: removed doc", null, synchronously, success, this.myUncommittedDocuments);
                }
                this.myIsCommitInProgress = false;
                this.myDocumentCommitProcessor.log("in PDI.finishDoc: exit", null, synchronously, success, this.myUncommittedDocuments);
                throw throwable;
            }
        }
        this.myDocumentCommitProcessor.log("in PDI.finishDoc: ", null, synchronously, success, this.myUncommittedDocuments);
        if (success) {
            this.myUncommittedDocuments.remove(document);
            this.myDocumentCommitProcessor.log("in PDI.finishDoc: removed doc", null, synchronously, success, this.myUncommittedDocuments);
        }
        this.myIsCommitInProgress = false;
        this.myDocumentCommitProcessor.log("in PDI.finishDoc: exit", null, synchronously, success, this.myUncommittedDocuments);
        return success;
    }

    private void checkAllElementsValid(@NotNull Document document, final @NotNull Object reason) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "checkAllElementsValid"));
        }
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/psi/impl/PsiDocumentManagerBase", "checkAllElementsValid"));
        }
        final PsiFile psiFile = this.getCachedPsiFile(document);
        if (psiFile != null) {
            psiFile.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                public void visitElement(PsiElement element) {
                    if (!element.isValid()) {
                        throw new AssertionError((Object)("Commit to '" + psiFile.getVirtualFile() + "' has led to invalid element: " + element + "; Reason: '" + reason + "'"));
                    }
                }
            });
        }
    }

    private void doCommit(final @NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "doCommit"));
        }
        assert (!this.myIsCommitInProgress) : "Do not call commitDocument() from inside PSI change listener";
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                if (PsiDocumentManagerBase.this.getSynchronizer().isDocumentAffectedByTransactions(document)) {
                    return;
                }
                PsiDocumentManagerBase.this.myIsCommitInProgress = true;
                try {
                    PsiDocumentManagerBase.this.myDocumentCommitProcessor.commitSynchronously(document, PsiDocumentManagerBase.this.myProject);
                }
                finally {
                    PsiDocumentManagerBase.this.myIsCommitInProgress = false;
                }
                assert (!PsiDocumentManagerBase.this.isInUncommittedSet(document)) : "Document :" + document;
            }
        });
    }

    public <T> T commitAndRunReadAction(final @NotNull Computable<T> computation) {
        if (computation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computation", "com/intellij/psi/impl/PsiDocumentManagerBase", "commitAndRunReadAction"));
        }
        final Ref ref = Ref.create(null);
        this.commitAndRunReadAction(new Runnable(){

            @Override
            public void run() {
                ref.set(computation.compute());
            }
        });
        return (T)ref.get();
    }

    public void reparseFiles(@NotNull Collection<VirtualFile> files, boolean includeOpenFiles) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/psi/impl/PsiDocumentManagerBase", "reparseFiles"));
        }
        FileContentUtilCore.reparseFiles(files);
    }

    public void commitAndRunReadAction(final @NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/psi/impl/PsiDocumentManagerBase", "commitAndRunReadAction"));
        }
        Application application = ApplicationManager.getApplication();
        if (SwingUtilities.isEventDispatchThread()) {
            this.commitAllDocuments();
            runnable.run();
        } else {
            if (ApplicationManager.getApplication().isReadAccessAllowed()) {
                LOG.error("Don't call commitAndRunReadAction inside ReadAction, it will cause a deadlock otherwise. " + Thread.currentThread());
            }
            final Semaphore s1 = new Semaphore();
            final Semaphore s2 = new Semaphore();
            final boolean[] committed = new boolean[]{false};
            application.runReadAction(new Runnable(){

                @Override
                public void run() {
                    if (PsiDocumentManagerBase.this.myUncommittedDocuments.isEmpty()) {
                        runnable.run();
                        committed[0] = true;
                    } else {
                        s1.down();
                        s2.down();
                        Runnable commitRunnable = new Runnable(){

                            @Override
                            public void run() {
                                PsiDocumentManagerBase.this.commitAllDocuments();
                                s1.up();
                                s2.waitFor();
                            }
                        };
                        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                        if (progressIndicator == null) {
                            ApplicationManager.getApplication().invokeLater(commitRunnable);
                        } else {
                            ApplicationManager.getApplication().invokeLater(commitRunnable, progressIndicator.getModalityState());
                        }
                    }
                }
            });
            if (!committed[0]) {
                s1.waitFor();
                application.runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        s2.up();
                        runnable.run();
                    }
                });
            }
        }
    }

    public boolean performWhenAllCommitted(@NotNull Runnable action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/psi/impl/PsiDocumentManagerBase", "performWhenAllCommitted"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        assert (!this.myProject.isDisposed()) : "Already disposed: " + this.myProject;
        if (this.myUncommittedDocuments.isEmpty()) {
            action.run();
            return true;
        }
        CompositeRunnable actions = (CompositeRunnable)this.actionsWhenAllDocumentsAreCommitted.get(PERFORM_ALWAYS_KEY);
        if (actions == null) {
            actions = new CompositeRunnable();
            this.actionsWhenAllDocumentsAreCommitted.put(PERFORM_ALWAYS_KEY, actions);
        }
        actions.add(action);
        this.myDocumentCommitProcessor.log("PDI: added performWhenAllCommitted", null, false, action, this.myUncommittedDocuments);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAfterCommitActions(@NotNull Document document) {
        ArrayList list;
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "runAfterCommitActions"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Key<List<Runnable>> key = ACTION_AFTER_COMMIT;
        synchronized (key) {
            list = (ArrayList)document.getUserData(ACTION_AFTER_COMMIT);
            if (list != null) {
                list = new ArrayList(list);
                document.putUserData(ACTION_AFTER_COMMIT, null);
            }
        }
        if (list != null) {
            for (Runnable runnable : list) {
                runnable.run();
            }
        }
        if (!this.hasUncommitedDocuments() && !this.actionsWhenAllDocumentsAreCommitted.isEmpty()) {
            ArrayList<Object> keys = new ArrayList<Object>(this.actionsWhenAllDocumentsAreCommitted.keySet());
            for (Object e : keys) {
                try {
                    Runnable action = this.actionsWhenAllDocumentsAreCommitted.remove(e);
                    this.myDocumentCommitProcessor.log("Running after commit runnable: ", null, false, e, action);
                    action.run();
                }
                catch (Throwable e2) {
                    LOG.error(e2);
                }
            }
        }
    }

    public void addListener(@NotNull PsiDocumentManager.Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/psi/impl/PsiDocumentManagerBase", "addListener"));
        }
        this.myListeners.add(listener);
    }

    public void removeListener(@NotNull PsiDocumentManager.Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/psi/impl/PsiDocumentManagerBase", "removeListener"));
        }
        this.myListeners.remove(listener);
    }

    public boolean isDocumentBlockedByPsi(@NotNull Document doc) {
        if (doc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doc", "com/intellij/psi/impl/PsiDocumentManagerBase", "isDocumentBlockedByPsi"));
        }
        return false;
    }

    public void doPostponedOperationsAndUnblockDocument(@NotNull Document doc) {
        if (doc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doc", "com/intellij/psi/impl/PsiDocumentManagerBase", "doPostponedOperationsAndUnblockDocument"));
        }
    }

    void fireDocumentCreated(@NotNull Document document, PsiFile file) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "fireDocumentCreated"));
        }
        for (PsiDocumentManager.Listener listener : this.myListeners) {
            listener.documentCreated(document, file);
        }
    }

    private void fireFileCreated(@NotNull Document document, @NotNull PsiFile file) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "fireFileCreated"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/PsiDocumentManagerBase", "fireFileCreated"));
        }
        for (PsiDocumentManager.Listener listener : this.myListeners) {
            listener.fileCreated(file, document);
        }
    }

    @NotNull
    public CharSequence getLastCommittedText(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "getLastCommittedText"));
        }
        CharSequence charSequence = this.getLastCommittedDocument(document).getImmutableCharSequence();
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiDocumentManagerBase", "getLastCommittedText"));
        }
        return charSequence;
    }

    public long getLastCommittedStamp(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "getLastCommittedStamp"));
        }
        return this.getLastCommittedDocument(document).getModificationStamp();
    }

    @Nullable
    public Document getLastCommittedDocument(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/PsiDocumentManagerBase", "getLastCommittedDocument"));
        }
        Document document = this.getDocument(file);
        return document == null ? null : this.getLastCommittedDocument(document);
    }

    @NotNull
    public DocumentEx getLastCommittedDocument(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "getLastCommittedDocument"));
        }
        if (document instanceof FrozenDocument) {
            DocumentEx documentEx = (DocumentEx)document;
            if (documentEx == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiDocumentManagerBase", "getLastCommittedDocument"));
            }
            return documentEx;
        }
        if (document instanceof DocumentWindow) {
            DocumentWindow answer;
            DocumentWindow window = (DocumentWindow)document;
            Document delegate = window.getDelegate();
            if (delegate instanceof FrozenDocument) {
                DocumentEx documentEx = (DocumentEx)window;
                if (documentEx == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiDocumentManagerBase", "getLastCommittedDocument"));
                }
                return documentEx;
            }
            UncommittedInfo info = this.myUncommittedInfos.get(delegate);
            DocumentWindow documentWindow = answer = info == null ? null : (DocumentWindow)info.myFrozenWindows.get(document);
            if (answer == null) {
                answer = this.freezeWindow(window);
            }
            if (info != null) {
                answer = (DocumentWindow)ConcurrencyUtil.cacheOrGet(info.myFrozenWindows, (Object)window, (Object)answer);
            }
            DocumentEx documentEx = (DocumentEx)answer;
            if (documentEx == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiDocumentManagerBase", "getLastCommittedDocument"));
            }
            return documentEx;
        }
        assert (document instanceof DocumentImpl);
        UncommittedInfo info = this.myUncommittedInfos.get(document);
        FrozenDocument frozenDocument = info != null ? info.myFrozen : ((DocumentImpl)document).freeze();
        if (frozenDocument == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiDocumentManagerBase", "getLastCommittedDocument"));
        }
        return frozenDocument;
    }

    @NotNull
    protected DocumentWindow freezeWindow(@NotNull DocumentWindow document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "freezeWindow"));
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public List<DocumentEvent> getEventsSinceCommit(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "getEventsSinceCommit"));
        }
        assert (document instanceof DocumentImpl);
        UncommittedInfo info = this.myUncommittedInfos.get(document);
        if (info != null) {
            List<DocumentEvent> list = info.myEvents;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiDocumentManagerBase", "getEventsSinceCommit"));
            }
            return list;
        }
        List<DocumentEvent> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiDocumentManagerBase", "getEventsSinceCommit"));
        }
        return list;
    }

    @NotNull
    public Document[] getUncommittedDocuments() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Object[] documents = this.myUncommittedDocuments.toArray(new Document[this.myUncommittedDocuments.size()]);
        Document[] documentArray = (Document[])ArrayUtil.stripTrailingNulls((Object[])documents);
        if (documentArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiDocumentManagerBase", "getUncommittedDocuments"));
        }
        return documentArray;
    }

    boolean isInUncommittedSet(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "isInUncommittedSet"));
        }
        if (document instanceof DocumentWindow) {
            return this.isInUncommittedSet(((DocumentWindow)document).getDelegate());
        }
        return this.myUncommittedDocuments.contains(document);
    }

    public boolean isUncommited(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "isUncommited"));
        }
        return !this.isCommitted(document);
    }

    public boolean isCommitted(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "isCommitted"));
        }
        if (document instanceof DocumentWindow) {
            return this.isCommitted(((DocumentWindow)document).getDelegate());
        }
        if (this.getSynchronizer().isInSynchronization(document)) {
            return true;
        }
        return !((DocumentEx)document).isInEventsHandling() && !this.isInUncommittedSet(document);
    }

    public boolean hasUncommitedDocuments() {
        return !this.myIsCommitInProgress && !this.myUncommittedDocuments.isEmpty();
    }

    public void beforeDocumentChange(@NotNull DocumentEvent event) {
        FileViewProvider viewProvider;
        boolean inMyProject;
        boolean isRelevant;
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/psi/impl/PsiDocumentManagerBase", "beforeDocumentChange"));
        }
        if (this.myStopTrackingDocuments || this.myProject.isDisposed()) {
            return;
        }
        Document document = event.getDocument();
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        boolean bl = isRelevant = virtualFile != null && this.isRelevant(virtualFile);
        if (document instanceof DocumentImpl && !this.myUncommittedInfos.containsKey(document)) {
            this.myUncommittedInfos.put(document, new UncommittedInfo((DocumentImpl)document));
        }
        boolean bl2 = inMyProject = (viewProvider = this.getCachedViewProvider(document)) != null && viewProvider.getManager() == this.myPsiManager;
        if (!isRelevant || !inMyProject) {
            return;
        }
        List files = viewProvider.getAllFiles();
        PsiFile psiCause = null;
        for (PsiFile file : files) {
            if (file == null) {
                throw new AssertionError((Object)("View provider " + viewProvider + " (" + viewProvider.getClass() + ") returned null in its files array: " + files + " for file " + viewProvider.getVirtualFile()));
            }
            if (!this.mySynchronizer.isInsideAtomicChange(file)) continue;
            psiCause = file;
        }
        if (psiCause == null) {
            this.beforeDocumentChangeOnUnlockedDocument(viewProvider);
        }
        ((SingleRootFileViewProvider)viewProvider).beforeDocumentChanged(psiCause);
    }

    protected void beforeDocumentChangeOnUnlockedDocument(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewProvider", "com/intellij/psi/impl/PsiDocumentManagerBase", "beforeDocumentChangeOnUnlockedDocument"));
        }
    }

    public void documentChanged(DocumentEvent event) {
        boolean forceCommit;
        boolean inMyProject;
        if (this.myStopTrackingDocuments || this.myProject.isDisposed()) {
            return;
        }
        Document document = event.getDocument();
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        boolean isRelevant = virtualFile != null && this.isRelevant(virtualFile);
        FileViewProvider viewProvider = this.getCachedViewProvider(document);
        if (viewProvider == null) {
            this.handleCommitWithoutPsi(document);
            return;
        }
        boolean bl = inMyProject = viewProvider.getManager() == this.myPsiManager;
        if (!isRelevant || !inMyProject) {
            this.clearUncommittedInfo(document);
            return;
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        List files = viewProvider.getAllFiles();
        boolean commitNecessary = true;
        for (PsiFile file : files) {
            if (this.mySynchronizer.isInsideAtomicChange(file)) {
                commitNecessary = false;
                continue;
            }
            assert (file instanceof PsiFileImpl || "mock.file".equals(file.getName()) && ApplicationManager.getApplication().isUnitTestMode()) : event + "; file=" + file + "; allFiles=" + files + "; viewProvider=" + viewProvider;
        }
        boolean bl2 = forceCommit = ApplicationManager.getApplication().hasWriteAction(ExternalChangeAction.class) && (SystemProperties.getBooleanProperty((String)"idea.force.commit.on.external.change", (boolean)false) || ApplicationManager.getApplication().isHeadlessEnvironment() && !ApplicationManager.getApplication().isUnitTestMode());
        if (event.isWholeTextReplaced() && document.getTextLength() > 100000) {
            document.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, (Object)Boolean.TRUE);
        }
        if (commitNecessary) {
            assert (!(document instanceof DocumentWindow));
            this.myUncommittedDocuments.add(document);
            this.myDocumentCommitProcessor.log("added uncommitted doc", null, false, this.myProject, document, ((DocumentEx)document).isInBulkUpdate());
            if (forceCommit) {
                this.commitDocument(document);
            } else if (!((DocumentEx)document).isInBulkUpdate() && this.myPerformBackgroundCommit) {
                this.myDocumentCommitProcessor.commitAsynchronously(this.myProject, document, event, ApplicationManager.getApplication().getCurrentModalityState());
            }
        } else {
            this.clearUncommittedInfo(document);
        }
    }

    void handleCommitWithoutPsi(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "handleCommitWithoutPsi"));
        }
        UncommittedInfo prevInfo = this.clearUncommittedInfo(document);
        if (prevInfo == null) {
            return;
        }
        if (!this.myProject.isInitialized() || this.myProject.isDisposed()) {
            return;
        }
        this.myUncommittedDocuments.remove(document);
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null || !FileIndexFacade.getInstance((Project)this.myProject).isInContent(virtualFile)) {
            return;
        }
        final PsiFile psiFile = this.getPsiFile(document);
        if (psiFile == null) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction((Runnable)new ExternalChangeAction(){

            @Override
            public void run() {
                FileViewProvider viewProvider = psiFile.getViewProvider();
                if (viewProvider instanceof SingleRootFileViewProvider) {
                    ((SingleRootFileViewProvider)viewProvider).onContentReload();
                } else {
                    LOG.error("Invalid view provider: " + viewProvider + " of " + viewProvider.getClass());
                }
            }
        });
    }

    @Nullable
    private UncommittedInfo clearUncommittedInfo(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "clearUncommittedInfo"));
        }
        UncommittedInfo info = this.myUncommittedInfos.remove(document);
        if (info != null) {
            this.getSmartPointerManager().updatePointers(document, info.myFrozen, info.myEvents);
            info.removeListener();
        }
        return info;
    }

    private SmartPointerManagerImpl getSmartPointerManager() {
        return (SmartPointerManagerImpl)SmartPointerManager.getInstance((Project)this.myProject);
    }

    private boolean isRelevant(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/psi/impl/PsiDocumentManagerBase", "isRelevant"));
        }
        return !virtualFile.getFileType().isBinary() && !this.myProject.isDisposed();
    }

    public static boolean checkConsistency(@NotNull PsiFile psiFile, @NotNull Document document) {
        int i;
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/psi/impl/PsiDocumentManagerBase", "checkConsistency"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "checkConsistency"));
        }
        if (psiFile.getVirtualFile() == null) {
            return true;
        }
        CharSequence editorText = document.getCharsSequence();
        int documentLength = document.getTextLength();
        if (psiFile.textMatches(editorText)) {
            LOG.assertTrue(psiFile.getTextLength() == documentLength);
            return true;
        }
        char[] fileText = psiFile.textToCharArray();
        String error = "File '" + psiFile.getName() + "' text mismatch after reparse. " + "File length=" + fileText.length + "; Doc length=" + documentLength + "\n";
        for (i = 0; i < documentLength; ++i) {
            if (i >= fileText.length) {
                error = error + "editorText.length > psiText.length i=" + i + "\n";
                break;
            }
            if (i >= editorText.length()) {
                error = error + "editorText.length > psiText.length i=" + i + "\n";
                break;
            }
            if (editorText.charAt(i) == fileText[i]) continue;
            error = error + "first unequal char i=" + i + "\n";
            break;
        }
        error = error + "*********************************************\n";
        error = error + "Editor Text tail:(" + (documentLength - i) + ")\n";
        error = error + "*********************************************\n";
        error = error + "Psi Text tail:(" + (fileText.length - i) + ")\n";
        error = error + "*********************************************\n";
        if (document instanceof DocumentWindow) {
            error = error + "doc: '" + document.getText() + "'\n";
            error = error + "psi: '" + psiFile.getText() + "'\n";
            error = error + "ast: '" + psiFile.getNode().getText() + "'\n";
            error = error + psiFile.getLanguage() + "\n";
            PsiLanguageInjectionHost context = InjectedLanguageManager.getInstance((Project)psiFile.getProject()).getInjectionHost((PsiElement)psiFile);
            if (context != null) {
                error = error + "context: " + context + "; text: '" + context.getText() + "'\n";
                error = error + "context file: " + context.getContainingFile() + "\n";
            }
            error = error + "document window ranges: " + Arrays.asList(((DocumentWindow)document).getHostRanges()) + "\n";
        }
        LOG.error(error);
        return false;
    }

    @VisibleForTesting
    public void clearUncommittedDocuments() {
        for (UncommittedInfo info : this.myUncommittedInfos.values()) {
            info.removeListener();
        }
        this.myUncommittedInfos.clear();
        this.myUncommittedDocuments.clear();
        this.mySynchronizer.cleanupForNextTest();
    }

    public void disableBackgroundCommit(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/psi/impl/PsiDocumentManagerBase", "disableBackgroundCommit"));
        }
        assert (this.myPerformBackgroundCommit);
        this.myPerformBackgroundCommit = false;
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                PsiDocumentManagerBase.this.myPerformBackgroundCommit = true;
            }
        });
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    public void initComponent() {
    }

    public void disposeComponent() {
        this.clearUncommittedDocuments();
    }

    @NotNull
    public String getComponentName() {
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiDocumentManagerBase", "getComponentName"));
        }
        return string;
    }

    @NotNull
    public PsiToDocumentSynchronizer getSynchronizer() {
        PsiToDocumentSynchronizer psiToDocumentSynchronizer = this.mySynchronizer;
        if (psiToDocumentSynchronizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiDocumentManagerBase", "getSynchronizer"));
        }
        return psiToDocumentSynchronizer;
    }

    private static class UncommittedInfo
    extends DocumentAdapter
    implements PrioritizedInternalDocumentListener {
        final DocumentImpl myOriginal;
        final FrozenDocument myFrozen;
        final List<DocumentEvent> myEvents = ContainerUtil.newArrayList();
        final ConcurrentMap<DocumentWindow, DocumentWindow> myFrozenWindows = ContainerUtil.newConcurrentMap();

        public UncommittedInfo(DocumentImpl original) {
            this.myOriginal = original;
            this.myFrozen = original.freeze();
            this.myOriginal.addDocumentListener(this);
        }

        @Override
        public int getPriority() {
            return 40;
        }

        public void documentChanged(DocumentEvent e) {
            this.myEvents.add(e);
        }

        @Override
        public void moveTextHappened(int start, int end, int base) {
            this.myEvents.add(new RetargetRangeMarkers(this.myOriginal, start, end, base));
        }

        public void removeListener() {
            this.myOriginal.removeDocumentListener(this);
        }
    }

    private static class CompositeRunnable
    extends ArrayList<Runnable>
    implements Runnable {
        private CompositeRunnable() {
        }

        @Override
        public void run() {
            for (Runnable runnable : this) {
                runnable.run();
            }
        }
    }
}

