/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.util.Computable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilter;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FilterModel<Filter extends VcsLogFilter> {
    @NotNull
    private final Computable<VcsLogDataPack> myDataPackProvider;
    @NotNull
    private final Collection<Runnable> mySetFilterListeners;
    @Nullable
    private Filter myFilter;

    FilterModel(@NotNull Computable<VcsLogDataPack> provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/vcs/log/ui/filter/FilterModel", "<init>"));
        }
        this.mySetFilterListeners = ContainerUtil.newArrayList();
        this.myDataPackProvider = provider;
    }

    void setFilter(@Nullable Filter filter) {
        this.myFilter = filter;
        for (Runnable listener : this.mySetFilterListeners) {
            listener.run();
        }
    }

    @Nullable
    Filter getFilter() {
        return this.myFilter;
    }

    @NotNull
    VcsLogDataPack getDataPack() {
        VcsLogDataPack vcsLogDataPack = (VcsLogDataPack)this.myDataPackProvider.compute();
        if (vcsLogDataPack == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/FilterModel", "getDataPack"));
        }
        return vcsLogDataPack;
    }

    void addSetFilterListener(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/vcs/log/ui/filter/FilterModel", "addSetFilterListener"));
        }
        this.mySetFilterListeners.add(runnable);
    }
}

