/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.cloneable;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CloneUtils;
import org.jetbrains.annotations.NotNull;

public class CloneCallsConstructorsInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("clone.instantiates.objects.with.constructor.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/cloneable/CloneCallsConstructorsInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("clone.instantiates.objects.with.constructor.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/cloneable/CloneCallsConstructorsInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CloneCallsConstructorVisitor();
    }

    private static class CloneCallsConstructorVisitor
    extends BaseInspectionVisitor {
        private CloneCallsConstructorVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/cloneable/CloneCallsConstructorsInspection$CloneCallsConstructorVisitor", "visitMethod"));
            }
            if (!CloneUtils.isClone(method) || method.hasModifierProperty("final")) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null || aClass.hasModifierProperty("final")) {
                return;
            }
            method.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitNewExpression(@NotNull PsiNewExpression newExpression) {
                    if (newExpression == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newExpression", "com/siyeh/ig/cloneable/CloneCallsConstructorsInspection$CloneCallsConstructorVisitor$1", "visitNewExpression"));
                    }
                    super.visitNewExpression(newExpression);
                    PsiExpression[] arrayDimensions = newExpression.getArrayDimensions();
                    if (arrayDimensions.length != 0) {
                        return;
                    }
                    if (newExpression.getArrayInitializer() != null) {
                        return;
                    }
                    if (newExpression.getAnonymousClass() != null) {
                        return;
                    }
                    if (PsiTreeUtil.getParentOfType((PsiElement)newExpression, PsiThrowStatement.class) != null) {
                        return;
                    }
                    CloneCallsConstructorVisitor.this.registerNewExpressionError(newExpression, new Object[0]);
                }
            });
        }
    }
}

