/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncFunction;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.ObsolescentConsumer;
import org.jetbrains.concurrency.ObsolescentFunction;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.ValueNodeAsyncFunction;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"Q\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005A\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0011\u0017)\u0011\u0001b\u0001\u0006\u0003!\u0001R!\u0001C\u0002\u000b\u0005Aq!B\u0001\u0005\u0006\u0015\t\u0001\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001E\u0002\u000b\u0005!1!d\f\t\n59\u0011\"B\u0005\u0005\u0013\tI\u0011\u0001j\u0003\u0019\u000ba\u0005\u0011C\u0001\u0003\u0001\u0011\u0017I\u0012\u0002\u0003\u0004\u000e\u000f%)\u0011\u0002B\u0005\u0003\u0013\u0005![\u0001'\u0001\u0019\u000bQ\u001b!!d\u0006\u0005\b!\u0001Q\u0002B\u0005\u0003\u0013\u0005![\u0001'\u0001\u0012\u0005\u0011\u0001\u00012\u0002+\u0004\u00055u\u0001\u0002A\u0007\u0005\u0013\tI\u0011\u0001j\u0003\u0019\u0002E\u0011A\u0001\u0001E\u00063\rAi!D\u0001\u0019\u000fQ\u001b!!$\u0004\t\u00105\u0019\u0011\"\u0001C\u00021\u0003!6AAG\u0018\u0011\u001fi)\"\u0003\u0004\n\u000bAAQC\u0001G\u0001I\u0017![\u0001'\u0001R\u0007\u0005!\u0019!\u0005\u0002\u0005\u0001!-\u0011d\u0001E\t\u001b\u0005![!U\u0002\u0002\u0011%!6AAG\u0016\t\r\u0003\u00022C\u0007\u00021))b!\u0003\u0003\u0005\u0002%\u0011A\u0012\u0001\r\u00021+Iz\u0001C\u0006\u000e\t%\u0011\u0011\"\u0001\r\u000b1/\u00016\u0011\u0001+\u0004\u00055MCa\u0011\t\t\u00195U\u0011BB\u0005\u0006!!)\"\u0001$\u0001%\f\u0011.\u0001\u0014A)\u0004\u0003\u0011\r\u0011C\u0001\u0003\u0001\u0011\u0017)B!\u0003\u0002\n\u0003\u0011.\u0001\u0014AM\u0005\u00113i\u0011\u0001G\u0007Q\u0007\u0003I:\u0002\u0002\u0002\t\u001c59\u0011BA\u0005\u0002I\u0017I!!C\u0001\u0019\u0015aq\u0001kA\u0001U\u0007\ti\t\u0005B\"\u0011\u0011;iY!C\u0001\u0005\u0004a\u0005\u0011kA\u0001\u0005\u0004U\u0019\u0011\"\u0001C\u00021\u0003IJ\u0001#\u0007\u000e\u0003ai\u0001k!\u0001\u001a\u0018\u0011\u0011\u00012D\u0007\b\u0013\tI\u0011\u0001G\b\n\u0005%\t\u0001D\u0003\r\u000f!\u000e\tAk\u0001\u0002\u000eO\u0011\u0019\u0005\u0003c\b\u000e\u0016%1\u0011\"\u0002\t\t+\ta\t\u0001\n\t%!a\u0005\u0011kA\u0001\u0005\u0004E\u0011A\u0001\u0001E\u0006#\t!\t\u0001\u0003\t\u0016\t%\u0011\u0011\"\u0001S\u00061\u0003I:\u0002\u0002\u0002\t\u001c59\u0011BA\u0005\u0002I\u0017I!!C\u0001%!aq\u0001k!\u0001U\u0007\tiI\u0006B\"\u0011\u0011?i)\"\u0003\u0004\n\u000bAAQC\u0001G\u0001IA!\u0003\u0003'\u0001R\u0007\u0005!\u0019!\u0005\u0002\u0005\u0001!-\u0011C\u0001C\u0001\u0011A)B!\u0003\u0002\n\u0003\u0011.\u0001\u0014AM\u0005\u0011Ci\u0011\u0001G\u0007Q\u0007\u0003I:\u0002\u0002\u0002\t\u001c59\u0011BA\u0005\u0002I\u0017I!!C\u0001%!aq\u0001kA\u0001U\u0007\ti!\u0006B\"\u0011\u0011Ei)\"\u0003\u0004\n\u000bAAQC\u0001G\u0001IA!\u0003\u0003'\u0001R\u0007\u0005!\u0019!\u0005\u0002\u0005\u0001!-\u0011C\u0001C\u0001\u0011A)B!\u0003\u0002\n\u0003\u0011.\u0001\u0014AM\u000f\t\tAY\"\u0004\u0006\n\u0005%\tA5B\u0005\u0006\u0013\u0011I!!C\u0001%!a\u0005\u0001D\u0004)\u0004\u0002Q\u001b!!d\u0018\u0005\u0007BA\u0011#$\u0006\n\r%)\u0001\u0003C\u000b\u0003\u0019\u0003!\u0003\u0003\n\t\u0019\u0002E\u001b\u0011\u0001b\u0001\u0012\u0005\u0011\u0001\u00012B\t\u0003\t\u0003A\u0001#\u0006\u0003\n\u0005%\tA5\u0002M\u00013\u0013AI\"D\u0001\u0019\u001bA\u001b\t!'\b\u0005\u0005!mQBC\u0005\u0003\u0013\u0005![!C\u0003\n\t%\u0011\u0011\"\u0001\u0013\u00111\u0003Ab\u0002U\u0002\u0002)\u000e\u0011Qb\t\u0003D!!\rRrB\u0005\u0004\u0013\ta\t\u0001G\u0001\u0019\u0002E\u001b\u0011\u0001b\u0001\u0012\u0005\u0011\u0001\u00012B\u000b\u0005\u0013\tI\u0011\u0001j\u0003\u0019\u0002emAA\u0001E\u000e\u001b%I!!C\u0001%\f%!\u0011bA\u0005\u0002\t\u0007A\n\u0001\u0007\bQ\u0007\u0003!6AAG)\t\u000f\u0003\u0002BEG\b\u0013\rI!\u0001$\u0001\u0019\u0003a\u0005\u0011kA\u0001\u0005\u0004E\u0011A\u0001\u0001E\u0006+\u0011I!!C\u0001%\fa\u0005\u0011\u0014\u0002E\r\u001b\u0005AR\u0002UB\u000137!!\u0001c\u0007\u000e\u0013%\u0011\u0011\"\u0001S\u0006\u0013\u0011I1!C\u0001\u0005\u0004a\u0005\u0001D\u0004)\u0004\u0003Q\u001b!!E\b\u0005\u0003\"A\u0001!d\u0004\n\u0007%\u0011A\u0012\u0001\r\u00021\u0003\t6!\u0001C\u0002#\u000e\tQ\u0001\u0001+\u0004\u0005E}Aa\u0011\u0005\t\u00065\t\u0001dA\u000b\u0004\u0013\u0005!\u0019\u0001'\u0001\u001dGE\u001b1!\u0004\u0002\u0005\u0006!\u001dAk\u0001\u0002\u0012 \u0011\u0019\u0005\u0002\u0003\u0003\u000e\u0003a\u0019QcA\u0005\u0002\t\u0007A\n\u0001H\u0012R\u0007\ri!\u0001\u0002\u0003\t\bQ\u001b!\u0001"}, strings={"rejectedPromise", "Lorg/jetbrains/concurrency/Promise;", "", "Lorg/jetbrains/annotations/NotNull;", "PromiseKt", "isPending", "", "(Lorg/jetbrains/concurrency/Promise;)Z", "isRejected", "collectResults", "", "T", "promises", "error", "", "resolvedPromise", "kotlin.jvm.PlatformType", "result", "(Ljava/lang/Object;)Lorg/jetbrains/concurrency/Promise;", "catchError", "", "Lorg/jetbrains/concurrency/AsyncPromise;", "task", "Lkotlin/Function0;", "done", "node", "Lorg/jetbrains/concurrency/Obsolescent;", "handler", "Lkotlin/Function1;", "rejected", "", "then", "SUB_RESULT", "obsolescent", "thenAsync", "thenAsyncAccept", "thenAsyncVoid"}, moduleName="platform-impl")
public final class PromiseKt {
    private static final Promise<Object> rejectedPromise = Promise.reject((String)"rejected");

    @NotNull
    public static final <T, SUB_RESULT> Promise<SUB_RESULT> then(Promise<T> $receiver, @NotNull Function1<? super T, ? extends SUB_RESULT> handler2) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(handler2, (String)"handler");
        return $receiver.then(new Function<T, SUB_RESULT>(handler2){
            final /* synthetic */ Function1 $handler;

            public SUB_RESULT fun(T param) {
                return (SUB_RESULT)this.$handler.invoke(param);
            }
            {
                this.$handler = $captured_local_variable$0;
            }
        });
    }

    @NotNull
    public static final <T, SUB_RESULT> Promise<SUB_RESULT> then(Promise<T> $receiver, @NotNull Obsolescent obsolescent, @NotNull Function1<? super T, ? extends SUB_RESULT> handler2) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)obsolescent, (String)"obsolescent");
        Intrinsics.checkParameterIsNotNull(handler2, (String)"handler");
        return $receiver.then((Function)new ObsolescentFunction<T, SUB_RESULT>(handler2, obsolescent){
            final /* synthetic */ Function1 $handler;
            final /* synthetic */ Obsolescent $obsolescent;

            public SUB_RESULT fun(T param) {
                return (SUB_RESULT)this.$handler.invoke(param);
            }

            public boolean isObsolete() {
                return this.$obsolescent.isObsolete();
            }
            {
                this.$handler = $captured_local_variable$0;
                this.$obsolescent = $captured_local_variable$1;
            }
        });
    }

    @NotNull
    public static final <T> Promise<T> done(Promise<T> $receiver, @NotNull Obsolescent node, @NotNull Function1<? super T, ? extends Unit> handler2) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull(handler2, (String)"handler");
        return $receiver.done((Consumer)new ObsolescentConsumer<T>(handler2, node){
            final /* synthetic */ Function1 $handler;

            public void consume(T param) {
                this.$handler.invoke(param);
            }
            {
                this.$handler = $captured_local_variable$0;
                super($super_call_param$1);
            }
        });
    }

    @NotNull
    public static final <T, SUB_RESULT> Promise<SUB_RESULT> thenAsync(Promise<T> $receiver, @NotNull Function1<? super T, ? extends Promise<SUB_RESULT>> handler2) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(handler2, (String)"handler");
        return $receiver.then(new AsyncFunction<T, SUB_RESULT>(handler2){
            final /* synthetic */ Function1 $handler;

            @NotNull
            public Promise<SUB_RESULT> fun(T param) {
                return (Promise)this.$handler.invoke(param);
            }
            {
                this.$handler = $captured_local_variable$0;
            }
        });
    }

    @NotNull
    public static final <T, SUB_RESULT> Promise<SUB_RESULT> thenAsync(Promise<T> $receiver, @NotNull Obsolescent node, @NotNull Function1<? super T, ? extends Promise<SUB_RESULT>> handler2) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull(handler2, (String)"handler");
        return $receiver.then((AsyncFunction)new ValueNodeAsyncFunction<T, SUB_RESULT>(handler2, node){
            final /* synthetic */ Function1 $handler;

            @NotNull
            public Promise<SUB_RESULT> fun(T param) {
                return (Promise)this.$handler.invoke(param);
            }
            {
                this.$handler = $captured_local_variable$0;
                super($super_call_param$1);
            }
        });
    }

    @NotNull
    public static final <T> Promise<Object> thenAsyncVoid(Promise<T> $receiver, @NotNull Obsolescent node, @NotNull Function1<? super T, ? extends Promise<?>> handler2) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull(handler2, (String)"handler");
        return $receiver.then((AsyncFunction)new ValueNodeAsyncFunction<T, Object>(handler2, node){
            final /* synthetic */ Function1 $handler;

            @NotNull
            public Promise<Object> fun(T param) {
                Object object = this.$handler.invoke(param);
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.concurrency.Promise<kotlin.Any?>");
                }
                return (Promise)object;
            }
            {
                this.$handler = $captured_local_variable$0;
                super($super_call_param$1);
            }
        });
    }

    @NotNull
    public static final <T> Promise<Object> thenAsyncAccept(Promise<T> $receiver, @NotNull Function1<? super T, ? extends Promise<?>> handler2) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(handler2, (String)"handler");
        return $receiver.then(new AsyncFunction<T, Object>(handler2){
            final /* synthetic */ Function1 $handler;

            @NotNull
            public Promise<Object> fun(T param) {
                Object object = this.$handler.invoke(param);
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.concurrency.Promise<kotlin.Any?>");
                }
                return (Promise)object;
            }
            {
                this.$handler = $captured_local_variable$0;
            }
        });
    }

    @NotNull
    public static final Promise<?> rejected(Promise<?> $receiver, @NotNull Obsolescent node, @NotNull Function1<? super Throwable, ? extends Unit> handler2) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull(handler2, (String)"handler");
        return $receiver.rejected((Consumer)new ObsolescentConsumer<Throwable>(handler2, node){
            final /* synthetic */ Function1 $handler;

            public void consume(@NotNull Throwable param) {
                Intrinsics.checkParameterIsNotNull((Object)param, (String)"param");
                this.$handler.invoke((Object)param);
            }
            {
                this.$handler = $captured_local_variable$0;
                super($super_call_param$1);
            }
        });
    }

    @NotNull
    public static final Promise<?> resolvedPromise() {
        Promise promise2 = Promise.DONE;
        Intrinsics.checkExpressionValueIsNotNull((Object)promise2, (String)"Promise.DONE");
        return promise2;
    }

    @NotNull
    public static final <T> Promise<T> resolvedPromise(T result2) {
        return Promise.resolve(result2);
    }

    @NotNull
    public static final <T> Promise<T> rejectedPromise(@NotNull String error) {
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        Promise promise2 = Promise.reject((String)error);
        Intrinsics.checkExpressionValueIsNotNull((Object)promise2, (String)"Promise.reject(error)");
        return promise2;
    }

    @NotNull
    public static final <T> Promise<T> rejectedPromise() {
        Promise<Object> promise2 = rejectedPromise;
        if (promise2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.concurrency.Promise<T>");
        }
        return promise2;
    }

    public static final boolean isRejected(Promise<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return Intrinsics.areEqual((Object)$receiver.getState(), (Object)Promise.State.REJECTED);
    }

    public static final boolean isPending(Promise<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return Intrinsics.areEqual((Object)$receiver.getState(), (Object)Promise.State.PENDING);
    }

    public static final void catchError(AsyncPromise<? extends Object> $receiver, @NotNull Function0<? extends Unit> task) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(task, (String)"task");
        try {
            task.invoke();
        }
        catch (Throwable e) {
            $receiver.setError(e);
        }
    }

    @NotNull
    public static final <T> Promise<List<? extends T>> collectResults(@NotNull List<? extends Promise<T>> promises) {
        Intrinsics.checkParameterIsNotNull(promises, (String)"promises");
        if (promises.isEmpty()) {
            Promise<List> promise2 = PromiseKt.resolvedPromise(CollectionsKt.emptyList());
            Intrinsics.checkExpressionValueIsNotNull(promise2, (String)"resolvedPromise(emptyList())");
            return promise2;
        }
        List results = promises.size() == 1 ? (List)new SmartList() : (List)new ArrayList(promises.size());
        for (Promise<T> promise3 : promises) {
            promise3.done(new Consumer<T>(results){
                final /* synthetic */ List $results;

                public final void consume(T it) {
                    this.$results.add(it);
                }
                {
                    this.$results = list;
                }
            });
        }
        Promise promise4 = Promise.all((Collection)promises, (Object)results);
        Intrinsics.checkExpressionValueIsNotNull((Object)promise4, (String)"Promise.all(promises, results)");
        return promise4;
    }
}

