/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"#\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\t\u0015\u0001Q!\u0001\u0005\b\u000b\u0005!\u0019!B\u0001\t\u0003\u0015\u0001Q!\u0001\u0007\u0002\t\u0005a\u0001!G\u0001\u0019\u0002\u0005^\u0011b\u0001\u0005\u0002\u001b\u0005A\u001a!\u0003\u0003\t\u00055\u0011A\u0012\u0001M\u0003#\u000e\t\u0001bA\u0013\t\t-AA!D\u0001\u0019\ne\u0019\u0001\"B\u0007\u00021\u0017Is\u0001B!\t\u0011\ti\u0011\u0001'\u0002R\u0007\u0005)\u0001!K\u0006\u0005\u0003\"A\u0011!D\u0003\u0011\bU\u0011A\u0012\u0001M\u00031\u000b\t6!A\u0003\u0001"}, strings={"Lorg/jetbrains/debugger/ArrayPresentation;", "Lcom/intellij/xdebugger/frame/presentation/XValuePresentation;", "length", "", "className", "", "(ILjava/lang/String;)V", "kotlin.jvm.PlatformType", "renderValue", "", "renderer", "Lcom/intellij/xdebugger/frame/presentation/XValuePresentation$XValueTextRenderer;"}, moduleName="script-debugger-ui")
public final class ArrayPresentation
extends XValuePresentation {
    private final String length;
    private final String className;

    public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
        Intrinsics.checkParameterIsNotNull((Object)renderer, (String)"renderer");
        renderer.renderSpecialSymbol(this.className);
        renderer.renderSpecialSymbol("[");
        renderer.renderSpecialSymbol(this.length);
        renderer.renderSpecialSymbol("]");
    }

    public ArrayPresentation(int length, @Nullable String className) {
        String string;
        this.length = Integer.toString(length);
        if (StringsKt.isNullOrEmpty((CharSequence)className)) {
            string = "Array";
        } else {
            string = className;
            if (string == null) {
                Intrinsics.throwNpe();
            }
        }
        this.className = string;
    }
}

