/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.util.NotNullLazyValue;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.Scope;

public abstract class CallFrameBase
implements CallFrame {
    public static final String RECEIVER_NAME = "this";
    private final String functionName;
    private final int line;
    private final int column;
    protected NotNullLazyValue<List<Scope>> scopes;
    protected EvaluateContext evaluateContext;
    protected boolean hasOnlyGlobalScope;

    protected CallFrameBase(@Nullable String functionName, int line, int column, @Nullable(value="init in your constructor") EvaluateContext evaluateContext2) {
        this.functionName = functionName;
        this.line = line;
        this.column = column;
        this.evaluateContext = evaluateContext2;
    }

    @Override
    public final boolean hasOnlyGlobalScope() {
        return this.hasOnlyGlobalScope;
    }

    @Override
    @NotNull
    public List<Scope> getVariableScopes() {
        List list = (List)this.scopes.getValue();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/CallFrameBase", "getVariableScopes"));
        }
        return list;
    }

    @Override
    @Nullable
    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    @NotNull
    public final EvaluateContext getEvaluateContext() {
        EvaluateContext evaluateContext2 = this.evaluateContext;
        if (evaluateContext2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/CallFrameBase", "getEvaluateContext"));
        }
        return evaluateContext2;
    }
}

