/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.frame;

import com.intellij.util.Consumer;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import java.util.ArrayList;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.ContextDependentAsyncResultConsumer;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.ScriptManager;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.frame.CallFrameView;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"=\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001\"A\u0003\u0001\u000b\u0005AA!\u0002\u0001\u0006\u00031\tQ\u0001\u0001\u0003\u0001\u0019\u0001I\u0012\u0001'\u0001\",%\u0019\u0001\"A\u0007\u00021\u0007I1\u0001\u0003\u0002\u000e\u0003a\u0015\u0011\u0002\u0002\u0005\u0004\u001b\ta\t\u0001g\u0002\n\u000b\u0011\t\u0001\u0002B\u0007\u0003\u0019\u0003AJ!U\u0002\u0002\u0011\u0015)C\u0002B\u0006\t\u000e5\t\u0001dB\r\u0004\u0011\u001fi\u0011\u0001\u0007\u0005\u001a\u0007!EQ\"\u0001\r\nK\u0015!1\u0002c\u0005\u000e\u00051\u0005\u0001DB\u0015\b\t\u0005C\u0001\"A\u0007\u00021\u0007\t6!A\u0003\u0001S!!\u0011\t\bE\u0006\u001b\ta\t\u0001\u0007\u0004R\u0007\u0005)\u0001!\u000b\u0005\u0005\u0003\"A1!\u0004\u0002\r\u0002a\u001d\u0011kA\u0001\u0006\u0001%BA!\u0011\u0005\t\t5\u0011A\u0012\u0001M\u0005#\u000e\tQ\u0001A\u0015\b\t\u0005C\u0001BA\u0007\u00021\u000b\t6!A\u0003\u0001"}, strings={"Lorg/jetbrains/debugger/frame/ExecutionStackImpl;", "Lcom/intellij/xdebugger/frame/XExecutionStack;", "suspendContext", "Lorg/jetbrains/debugger/SuspendContext;", "viewSupport", "Lorg/jetbrains/debugger/DebuggerViewSupport;", "topFrameScript", "Lorg/jetbrains/debugger/Script;", "topFrameSourceInfo", "Lorg/jetbrains/debugger/SourceInfo;", "(Lorg/jetbrains/debugger/SuspendContext;Lorg/jetbrains/debugger/DebuggerViewSupport;Lorg/jetbrains/debugger/Script;Lorg/jetbrains/debugger/SourceInfo;)V", "topCallFrameView", "Lorg/jetbrains/debugger/frame/CallFrameView;", "computeStackFrames", "", "firstFrameIndex", "", "container", "Lcom/intellij/xdebugger/frame/XExecutionStack$XStackFrameContainer;", "getTopFrame"}, moduleName="script-debugger-ui")
public final class ExecutionStackImpl
extends XExecutionStack {
    private CallFrameView topCallFrameView;
    private final SuspendContext suspendContext;
    private final DebuggerViewSupport viewSupport;
    private final Script topFrameScript;
    private final SourceInfo topFrameSourceInfo;

    @Nullable
    public CallFrameView getTopFrame() {
        block5: {
            CallFrame topCallFrame;
            block4: {
                topCallFrame = this.suspendContext.getTopFrame();
                if (this.topCallFrameView == null) break block4;
                CallFrameView callFrameView = this.topCallFrameView;
                if (callFrameView == null) {
                    Intrinsics.throwNpe();
                }
                if (!(Intrinsics.areEqual((Object)callFrameView.getCallFrame(), (Object)topCallFrame) ^ true)) break block5;
            }
            this.topCallFrameView = topCallFrame == null ? (CallFrameView)null : new CallFrameView(topCallFrame, this.viewSupport, this.topFrameScript, this.topFrameSourceInfo, null, 16, null);
        }
        return this.topCallFrameView;
    }

    /*
     * WARNING - void declaration
     */
    public void computeStackFrames(int firstFrameIndex, @NotNull XExecutionStack.XStackFrameContainer container) {
        void context;
        void $receiver;
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        Vm vm = this.viewSupport.getVm();
        if (vm == null) {
            Intrinsics.throwNpe();
        }
        SuspendContext suspendContext = vm.getSuspendContextManager().getContext();
        if (suspendContext == null) {
            return;
        }
        SuspendContext suspendContext2 = suspendContext;
        Promise<CallFrame[]> promise2 = suspendContext2.getFrames();
        SuspendContext suspendContext3 = suspendContext2;
        Intrinsics.checkExpressionValueIsNotNull((Object)suspendContext3, (String)"suspendContext");
        SuspendContext suspendContext4 = suspendContext3;
        $receiver.done((Consumer)new ContextDependentAsyncResultConsumer<T>((SuspendContext)context, this, firstFrameIndex, suspendContext2, container){
            final /* synthetic */ ExecutionStackImpl this$0;
            final /* synthetic */ int $firstFrameIndex$inlined;
            final /* synthetic */ SuspendContext $suspendContext$inlined;
            final /* synthetic */ XExecutionStack.XStackFrameContainer $container$inlined;

            /*
             * WARNING - void declaration
             */
            protected void consume(T result2, Vm vm) {
                List result3;
                CallFrame[] frames = (CallFrame[])result2;
                int count = ((Object[])frames).length - this.$firstFrameIndex$inlined;
                if (count < 1) {
                    result3 = CollectionsKt.emptyList();
                } else {
                    result3 = new ArrayList<E>(count);
                    int n = this.$firstFrameIndex$inlined;
                    int n2 = ((Object[])frames).length - 1;
                    if (n <= n2) {
                        while (true) {
                            void i;
                            if (i == false) {
                                ArrayList arrayList = (ArrayList)result3;
                                CallFrameView callFrameView = this.this$0.getTopFrame();
                                if (callFrameView == null) {
                                    Intrinsics.throwNpe();
                                }
                                arrayList.add(callFrameView);
                            } else {
                                CallFrame frame = frames[i];
                                ScriptManager scriptManager = this.$suspendContext$inlined.getValueManager().getVm().getScriptManager();
                                CallFrame callFrame = frame;
                                Intrinsics.checkExpressionValueIsNotNull((Object)callFrame, (String)"frame");
                                Script script = scriptManager.getScript(callFrame);
                                if (script != null) {
                                    boolean isInLibraryContent;
                                    DebuggerViewSupport debuggerViewSupport = ExecutionStackImpl.access$getViewSupport$p(this.this$0);
                                    CallFrame callFrame2 = frame;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)callFrame2, (String)"frame");
                                    SourceInfo sourceInfo = debuggerViewSupport.getSourceInfo(script, callFrame2);
                                    boolean bl = isInLibraryContent = sourceInfo != null && ExecutionStackImpl.access$getViewSupport$p(this.this$0).isInLibraryContent(sourceInfo, script);
                                    if (!isInLibraryContent || XDebuggerSettingsManager.getInstance().getDataViewSettings().isShowLibraryStackFrames()) {
                                        ArrayList arrayList = (ArrayList)result3;
                                        CallFrame callFrame3 = frame;
                                        Intrinsics.checkExpressionValueIsNotNull((Object)callFrame3, (String)"frame");
                                        arrayList.add(new CallFrameView(callFrame3, ExecutionStackImpl.access$getViewSupport$p(this.this$0), script, sourceInfo, isInLibraryContent));
                                    }
                                }
                            }
                            if (i == n2) break;
                            ++i;
                        }
                    }
                }
                this.$container$inlined.addStackFrames(result3, true);
            }
            {
                void $super_call_param$1;
                this.this$0 = executionStackImpl;
                this.$firstFrameIndex$inlined = n;
                this.$suspendContext$inlined = suspendContext2;
                this.$container$inlined = xStackFrameContainer;
                super((SuspendContext)$super_call_param$1);
            }
        });
    }

    public ExecutionStackImpl(@NotNull SuspendContext suspendContext, @NotNull DebuggerViewSupport viewSupport, @Nullable Script topFrameScript, @Nullable SourceInfo topFrameSourceInfo) {
        Intrinsics.checkParameterIsNotNull((Object)suspendContext, (String)"suspendContext");
        Intrinsics.checkParameterIsNotNull((Object)viewSupport, (String)"viewSupport");
        super("");
        this.suspendContext = suspendContext;
        this.viewSupport = viewSupport;
        this.topFrameScript = topFrameScript;
        this.topFrameSourceInfo = topFrameSourceInfo;
    }

    public /* synthetic */ ExecutionStackImpl(SuspendContext suspendContext, DebuggerViewSupport debuggerViewSupport, Script script, SourceInfo sourceInfo, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            sourceInfo = null;
        }
        this(suspendContext, debuggerViewSupport, script, sourceInfo);
    }

    @NotNull
    public static final /* synthetic */ DebuggerViewSupport access$getViewSupport$p(ExecutionStackImpl $this) {
        return $this.viewSupport;
    }
}

