/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.frame;

import com.intellij.xdebugger.frame.XSuspendContext;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncFunction;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.PromiseKt;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateResult;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.frame.CallFrameView;
import org.jetbrains.debugger.frame.ExecutionStackImpl;
import org.jetbrains.debugger.values.StringValue;
import org.jetbrains.debugger.values.Value;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"C\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\u0011\u001d)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001\u0001B\u0006\r\u0001e\t\u0001\u0014AQ\u0016\u0013\rA\u0011!D\u0001\u0019\u0004%\u0019\u0001BA\u0007\u00021\u000bIA\u0001C\u0002\u000e\u00051\u0005\u0001tA\u0005\u0006\t\u0005AA!\u0004\u0002\r\u0002a%\u0011kA\u0001\t\u000b\u0015R\u0001RB\u0007\u0005\u0013\tI\u0011\u0001g\u0004\u0019\u000fe\u0019\u0001\u0002C\u0007\u00021\u001f)[\u0003B\u0001\t\u000e5U\u0011BB\u0005\u0006!#)\"\u0001$\u0001\u0019\u0010a=\u0001dB)\u0004\u0003\u0011I\u0011d\u0001E\n\u001b\u0005A\"\"G\u0002\t\u00115\t\u0001tB\u0013\u0005\t-A)\"D\u0001\u0019\r%:A!\u0011\u0005\t\f5\t\u0001DB)\u0004\u0003\u0015\u0001\u0001"}, strings={"Lorg/jetbrains/debugger/frame/SuspendContextImpl;", "Lcom/intellij/xdebugger/frame/XSuspendContext;", "suspendContext", "Lorg/jetbrains/debugger/SuspendContext;", "debugProcess", "Lorg/jetbrains/debugger/DebuggerViewSupport;", "topFrameScript", "Lorg/jetbrains/debugger/Script;", "topFrameSourceInfo", "Lorg/jetbrains/debugger/SourceInfo;", "(Lorg/jetbrains/debugger/SuspendContext;Lorg/jetbrains/debugger/DebuggerViewSupport;Lorg/jetbrains/debugger/Script;Lorg/jetbrains/debugger/SourceInfo;)V", "executionStack", "Lorg/jetbrains/debugger/frame/ExecutionStackImpl;", "evaluateExpression", "Lorg/jetbrains/concurrency/Promise;", "", "expression", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "evaluateContext", "Lorg/jetbrains/debugger/EvaluateContext;", "getActiveExecutionStack"}, moduleName="script-debugger-ui")
public class SuspendContextImpl
extends XSuspendContext {
    private final ExecutionStackImpl executionStack;

    @NotNull
    public ExecutionStackImpl getActiveExecutionStack() {
        return this.executionStack;
    }

    @NotNull
    public final Promise<String> evaluateExpression(@NotNull String expression) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        CallFrameView callFrameView = this.executionStack.getTopFrame();
        if (callFrameView == null) {
            return PromiseKt.rejectedPromise("Top frame is null");
        }
        CallFrameView frame = callFrameView;
        EvaluateContext evaluateContext2 = frame.getCallFrame().getEvaluateContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)evaluateContext2, (String)"frame.callFrame.evaluateContext");
        return this.evaluateExpression(evaluateContext2, expression);
    }

    private final Promise<String> evaluateExpression(EvaluateContext evaluateContext2, String expression) {
        Promise<EvaluateResult> $receiver = evaluateContext2.evaluate(expression);
        return $receiver.then(new AsyncFunction<T, SUB_RESULT>(){

            public Promise<SUB_RESULT> fun(T param) {
                Promise<String> promise2;
                EvaluateResult it = (EvaluateResult)param;
                Value value = it.value;
                if (value == null) {
                    promise2 = PromiseKt.resolvedPromise("Log expression result doesn't have value");
                } else {
                    Value value2 = value;
                    if (value2 instanceof StringValue && ((StringValue)value2).isTruncated()) {
                        promise2 = ((StringValue)value2).getFullString();
                    } else {
                        String string = value2.getValueString();
                        if (string == null) {
                            Intrinsics.throwNpe();
                        }
                        promise2 = PromiseKt.resolvedPromise(string);
                    }
                }
                return promise2;
            }
        });
    }

    public SuspendContextImpl(@NotNull SuspendContext suspendContext, @NotNull DebuggerViewSupport debugProcess, @Nullable Script topFrameScript, @Nullable SourceInfo topFrameSourceInfo) {
        Intrinsics.checkParameterIsNotNull((Object)suspendContext, (String)"suspendContext");
        Intrinsics.checkParameterIsNotNull((Object)debugProcess, (String)"debugProcess");
        this.executionStack = new ExecutionStackImpl(suspendContext, debugProcess, topFrameScript, topFrameSourceInfo);
    }

    public /* synthetic */ SuspendContextImpl(SuspendContext suspendContext, DebuggerViewSupport debuggerViewSupport, Script script, SourceInfo sourceInfo, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            sourceInfo = null;
        }
        this(suspendContext, debuggerViewSupport, script, sourceInfo);
    }
}

