/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.config;

import com.intellij.ProjectTopics;
import com.intellij.compiler.server.BuildManager;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ModuleAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectType;
import com.intellij.openapi.project.ProjectTypeService;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.xmlb.XmlSerializer;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.gradle.model.impl.GradleModuleResourceConfiguration;
import org.jetbrains.jps.gradle.model.impl.GradleProjectConfiguration;
import org.jetbrains.jps.gradle.model.impl.ModuleVersion;
import org.jetbrains.jps.gradle.model.impl.ResourceRootConfiguration;
import org.jetbrains.jps.gradle.model.impl.ResourceRootFilter;
import org.jetbrains.plugins.gradle.model.ExternalFilter;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalSourceDirectorySet;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.service.project.data.ExternalProjectDataService;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleResourceCompilerConfigurationGenerator {
    private static Logger LOG = Logger.getInstance(GradleResourceCompilerConfigurationGenerator.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<String, Integer> myModulesConfigurationHash;
    private final ExternalProjectDataService myExternalProjectDataService;

    public GradleResourceCompilerConfigurationGenerator(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/config/GradleResourceCompilerConfigurationGenerator", "<init>"));
        }
        this.myProject = project;
        this.myModulesConfigurationHash = ContainerUtil.newConcurrentMap();
        this.myExternalProjectDataService = (ExternalProjectDataService)((ProjectDataManager)ServiceManager.getService(ProjectDataManager.class)).getDataService(ExternalProjectDataService.KEY);
        assert (this.myExternalProjectDataService != null);
        project.getMessageBus().connect((Disposable)project).subscribe(ProjectTopics.MODULES, (Object)new ModuleAdapter(){

            public void moduleRemoved(@NotNull Project project, @NotNull Module module) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/config/GradleResourceCompilerConfigurationGenerator$1", "moduleRemoved"));
                }
                if (module == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/gradle/config/GradleResourceCompilerConfigurationGenerator$1", "moduleRemoved"));
                }
                GradleResourceCompilerConfigurationGenerator.this.myModulesConfigurationHash.remove(module.getName());
            }

            public void modulesRenamed(@NotNull Project project, @NotNull List<Module> modules, @NotNull Function<Module, String> oldNameProvider) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/config/GradleResourceCompilerConfigurationGenerator$1", "modulesRenamed"));
                }
                if (modules == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "org/jetbrains/plugins/gradle/config/GradleResourceCompilerConfigurationGenerator$1", "modulesRenamed"));
                }
                if (oldNameProvider == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldNameProvider", "org/jetbrains/plugins/gradle/config/GradleResourceCompilerConfigurationGenerator$1", "modulesRenamed"));
                }
                for (Module module : modules) {
                    this.moduleRemoved(project, module);
                }
            }
        });
    }

    public void generateBuildConfiguration(@NotNull CompileContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/gradle/config/GradleResourceCompilerConfigurationGenerator", "generateBuildConfiguration"));
        }
        if (GradleResourceCompilerConfigurationGenerator.shouldBeBuiltByExternalSystem(this.myProject)) {
            return;
        }
        if (!GradleResourceCompilerConfigurationGenerator.hasGradleModules(context)) {
            return;
        }
        final BuildManager buildManager = BuildManager.getInstance();
        File projectSystemDir = buildManager.getProjectSystemDirectory(this.myProject);
        if (projectSystemDir == null) {
            return;
        }
        final File gradleConfigFile = new File(projectSystemDir, "gradle/configuration.xml");
        Map<String, GradleModuleResourceConfiguration> affectedGradleModuleConfigurations = this.generateAffectedGradleModulesConfiguration(context);
        if (affectedGradleModuleConfigurations.isEmpty()) {
            return;
        }
        boolean configurationUpdateRequired = context.isRebuild() || !gradleConfigFile.exists();
        THashMap affectedConfigurationHash = new THashMap();
        for (Map.Entry<String, GradleModuleResourceConfiguration> entry : affectedGradleModuleConfigurations.entrySet()) {
            Integer moduleLastConfigurationHash = this.myModulesConfigurationHash.get(entry.getKey());
            int moduleCurrentConfigurationHash = entry.getValue().computeConfigurationHash();
            if (moduleLastConfigurationHash == null || moduleLastConfigurationHash != moduleCurrentConfigurationHash) {
                configurationUpdateRequired = true;
            }
            affectedConfigurationHash.put(entry.getKey(), moduleCurrentConfigurationHash);
        }
        GradleProjectConfiguration projectConfig = this.loadLastConfiguration(gradleConfigFile);
        projectConfig.moduleConfigurations.putAll(affectedGradleModuleConfigurations);
        final Document document = new Document(new Element("gradle-project-configuration"));
        XmlSerializer.serializeInto((Object)projectConfig, (Element)document.getRootElement());
        final boolean finalConfigurationUpdateRequired = configurationUpdateRequired;
        buildManager.runCommand(new Runnable((Map)affectedConfigurationHash){
            final /* synthetic */ Map val$affectedConfigurationHash;
            {
                this.val$affectedConfigurationHash = map;
            }

            @Override
            public void run() {
                if (finalConfigurationUpdateRequired) {
                    buildManager.clearState(GradleResourceCompilerConfigurationGenerator.this.myProject);
                }
                FileUtil.createIfDoesntExist((File)gradleConfigFile);
                try {
                    JDOMUtil.writeDocument((Document)document, (File)gradleConfigFile, (String)"\n");
                    GradleResourceCompilerConfigurationGenerator.this.myModulesConfigurationHash.putAll(this.val$affectedConfigurationHash);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @NotNull
    private GradleProjectConfiguration loadLastConfiguration(@NotNull File gradleConfigFile) {
        if (gradleConfigFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleConfigFile", "org/jetbrains/plugins/gradle/config/GradleResourceCompilerConfigurationGenerator", "loadLastConfiguration"));
        }
        GradleProjectConfiguration projectConfig = new GradleProjectConfiguration();
        if (gradleConfigFile.exists()) {
            try {
                Document document = JDOMUtil.loadDocument((File)gradleConfigFile);
                XmlSerializer.deserializeInto((Object)projectConfig, (Element)document.getRootElement());
                Set<String> actualModules = this.myModulesConfigurationHash.keySet();
                Iterator iterator = projectConfig.moduleConfigurations.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry configurationEntry = iterator.next();
                    if (actualModules.contains(configurationEntry.getKey())) continue;
                    iterator.remove();
                }
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
            }
        }
        GradleProjectConfiguration gradleProjectConfiguration = projectConfig;
        if (gradleProjectConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/config/GradleResourceCompilerConfigurationGenerator", "loadLastConfiguration"));
        }
        return gradleProjectConfiguration;
    }

    @NotNull
    private Map<String, GradleModuleResourceConfiguration> generateAffectedGradleModulesConfiguration(@NotNull CompileContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/gradle/config/GradleResourceCompilerConfigurationGenerator", "generateAffectedGradleModulesConfiguration"));
        }
        THashMap affectedGradleModuleConfigurations = ContainerUtil.newTroveMap();
        FactoryMap<String, ExternalProject> lazyExternalProjectMap = new FactoryMap<String, ExternalProject>(){

            @Nullable
            protected ExternalProject create(String gradleProjectPath) {
                return GradleResourceCompilerConfigurationGenerator.this.myExternalProjectDataService.getRootExternalProject(GradleConstants.SYSTEM_ID, new File(gradleProjectPath));
            }
        };
        for (Module module : context.getCompileScope().getAffectedModules()) {
            if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module) || GradleResourceCompilerConfigurationGenerator.shouldBeBuiltByExternalSystem(module)) continue;
            String gradleProjectPath = module.getOptionValue("external.root.project.path");
            assert (gradleProjectPath != null);
            ExternalProject externalRootProject = (ExternalProject)lazyExternalProjectMap.get(gradleProjectPath);
            if (externalRootProject == null) {
                context.addMessage(CompilerMessageCategory.ERROR, String.format("Unable to make the module: %s, related gradle configuration was not found. Please, re-import the Gradle project and try again.", module.getName()), VfsUtilCore.pathToUrl((String)gradleProjectPath), -1, -1);
                continue;
            }
            ExternalProject externalProject = this.myExternalProjectDataService.findExternalProject(externalRootProject, module);
            if (externalProject == null) {
                LOG.warn("Unable to find config for module: " + module.getName());
                continue;
            }
            GradleModuleResourceConfiguration resourceConfig = new GradleModuleResourceConfiguration();
            resourceConfig.id = new ModuleVersion(externalProject.getGroup(), externalProject.getName(), externalProject.getVersion());
            resourceConfig.directory = FileUtil.toSystemIndependentName((String)externalProject.getProjectDir().getPath());
            ExternalSourceSet mainSourcesSet = (ExternalSourceSet)externalProject.getSourceSets().get("main");
            GradleResourceCompilerConfigurationGenerator.addResources(resourceConfig.resources, mainSourcesSet, ExternalSystemSourceType.RESOURCE);
            ExternalSourceSet testSourcesSet = (ExternalSourceSet)externalProject.getSourceSets().get("test");
            GradleResourceCompilerConfigurationGenerator.addResources(resourceConfig.testResources, testSourcesSet, ExternalSystemSourceType.TEST_RESOURCE);
            CompilerModuleExtension compilerModuleExtension = CompilerModuleExtension.getInstance((Module)module);
            if (compilerModuleExtension != null && compilerModuleExtension.isCompilerOutputPathInherited()) {
                String outputPath = VfsUtilCore.urlToPath((String)compilerModuleExtension.getCompilerOutputUrl());
                for (ResourceRootConfiguration resource : resourceConfig.resources) {
                    resource.targetPath = outputPath;
                }
                String testOutputPath = VfsUtilCore.urlToPath((String)compilerModuleExtension.getCompilerOutputUrlForTests());
                for (ResourceRootConfiguration resource : resourceConfig.testResources) {
                    resource.targetPath = testOutputPath;
                }
            }
            affectedGradleModuleConfigurations.put(module.getName(), resourceConfig);
        }
        THashMap tHashMap = affectedGradleModuleConfigurations;
        if (tHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/config/GradleResourceCompilerConfigurationGenerator", "generateAffectedGradleModulesConfiguration"));
        }
        return tHashMap;
    }

    private static boolean shouldBeBuiltByExternalSystem(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/config/GradleResourceCompilerConfigurationGenerator", "shouldBeBuiltByExternalSystem"));
        }
        ProjectType projectType = ProjectTypeService.getProjectType((Project)project);
        return projectType != null && "Android".equals(projectType.getId());
    }

    private static boolean shouldBeBuiltByExternalSystem(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/gradle/config/GradleResourceCompilerConfigurationGenerator", "shouldBeBuiltByExternalSystem"));
        }
        for (Facet facet : FacetManager.getInstance((Module)module).getAllFacets()) {
            if (!ArrayUtil.contains((String)facet.getName(), (String[])new String[]{"Android", "Android-Gradle", "Java-Gradle"})) continue;
            return true;
        }
        return false;
    }

    private static boolean hasGradleModules(@NotNull CompileContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/gradle/config/GradleResourceCompilerConfigurationGenerator", "hasGradleModules"));
        }
        for (Module module : context.getCompileScope().getAffectedModules()) {
            if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) continue;
            return true;
        }
        return false;
    }

    private static void addResources(@NotNull List<ResourceRootConfiguration> container, @Nullable ExternalSourceSet externalSourceSet, @NotNull ExternalSystemSourceType sourceType) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "org/jetbrains/plugins/gradle/config/GradleResourceCompilerConfigurationGenerator", "addResources"));
        }
        if (sourceType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceType", "org/jetbrains/plugins/gradle/config/GradleResourceCompilerConfigurationGenerator", "addResources"));
        }
        if (externalSourceSet == null) {
            return;
        }
        ExternalSourceDirectorySet directorySet = (ExternalSourceDirectorySet)externalSourceSet.getSources().get(sourceType);
        if (directorySet == null) {
            return;
        }
        for (File file : directorySet.getSrcDirs()) {
            String dir = file.getPath();
            ResourceRootConfiguration rootConfiguration = new ResourceRootConfiguration();
            rootConfiguration.directory = FileUtil.toSystemIndependentName((String)dir);
            String target = directorySet.getOutputDir().getPath();
            rootConfiguration.targetPath = FileUtil.toSystemIndependentName((String)target);
            rootConfiguration.includes.clear();
            for (String include : directorySet.getIncludes()) {
                rootConfiguration.includes.add(include.trim());
            }
            rootConfiguration.excludes.clear();
            for (String exclude : directorySet.getExcludes()) {
                rootConfiguration.excludes.add(exclude.trim());
            }
            rootConfiguration.isFiltered = !directorySet.getFilters().isEmpty();
            rootConfiguration.filters.clear();
            for (ExternalFilter filter : directorySet.getFilters()) {
                ResourceRootFilter resourceRootFilter = new ResourceRootFilter();
                resourceRootFilter.filterType = filter.getFilterType();
                resourceRootFilter.properties = filter.getPropertiesAsJsonMap();
                rootConfiguration.filters.add(resourceRootFilter);
            }
            container.add(rootConfiguration);
        }
    }
}

