/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.externalSystem.JavaProjectData;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.util.KeyValue;
import com.intellij.util.Consumer;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;

@Order(value=1000)
public abstract class AbstractProjectResolverExtension
implements GradleProjectResolverExtension {
    @NotNull
    protected ProjectResolverContext resolverCtx;
    @NotNull
    protected GradleProjectResolverExtension nextResolver;

    @Override
    public void setProjectResolverContext(@NotNull ProjectResolverContext projectResolverContext) {
        if (projectResolverContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectResolverContext", "org/jetbrains/plugins/gradle/service/project/AbstractProjectResolverExtension", "setProjectResolverContext"));
        }
        this.resolverCtx = projectResolverContext;
    }

    @Override
    public void setNext(@NotNull GradleProjectResolverExtension next) {
        if (next == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "org/jetbrains/plugins/gradle/service/project/AbstractProjectResolverExtension", "setNext"));
        }
        assert (next != null);
        this.nextResolver = next;
    }

    @Override
    @Nullable
    public GradleProjectResolverExtension getNext() {
        return this.nextResolver;
    }

    @Override
    @NotNull
    public ProjectData createProject() {
        ProjectData projectData = this.nextResolver.createProject();
        if (projectData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/AbstractProjectResolverExtension", "createProject"));
        }
        return projectData;
    }

    @Override
    @NotNull
    public JavaProjectData createJavaProjectData() {
        JavaProjectData javaProjectData = this.nextResolver.createJavaProjectData();
        if (javaProjectData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/AbstractProjectResolverExtension", "createJavaProjectData"));
        }
        return javaProjectData;
    }

    @Override
    public void populateProjectExtraModels(@NotNull IdeaProject gradleProject, @NotNull DataNode<ProjectData> ideProject) {
        if (gradleProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleProject", "org/jetbrains/plugins/gradle/service/project/AbstractProjectResolverExtension", "populateProjectExtraModels"));
        }
        if (ideProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideProject", "org/jetbrains/plugins/gradle/service/project/AbstractProjectResolverExtension", "populateProjectExtraModels"));
        }
        this.nextResolver.populateProjectExtraModels(gradleProject, ideProject);
    }

    @Override
    @NotNull
    public ModuleData createModule(@NotNull IdeaModule gradleModule, @NotNull ProjectData projectData) {
        if (gradleModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleModule", "org/jetbrains/plugins/gradle/service/project/AbstractProjectResolverExtension", "createModule"));
        }
        if (projectData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectData", "org/jetbrains/plugins/gradle/service/project/AbstractProjectResolverExtension", "createModule"));
        }
        ModuleData moduleData = this.nextResolver.createModule(gradleModule, projectData);
        if (moduleData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/AbstractProjectResolverExtension", "createModule"));
        }
        return moduleData;
    }

    @Override
    public void populateModuleExtraModels(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        if (gradleModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleModule", "org/jetbrains/plugins/gradle/service/project/AbstractProjectResolverExtension", "populateModuleExtraModels"));
        }
        if (ideModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModule", "org/jetbrains/plugins/gradle/service/project/AbstractProjectResolverExtension", "populateModuleExtraModels"));
        }
        this.nextResolver.populateModuleExtraModels(gradleModule, ideModule);
    }

    @Override
    public void populateModuleContentRoots(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        if (gradleModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleModule", "org/jetbrains/plugins/gradle/service/project/AbstractProjectResolverExtension", "populateModuleContentRoots"));
        }
        if (ideModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModule", "org/jetbrains/plugins/gradle/service/project/AbstractProjectResolverExtension", "populateModuleContentRoots"));
        }
        this.nextResolver.populateModuleContentRoots(gradleModule, ideModule);
    }

    @Override
    public void populateModuleCompileOutputSettings(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        if (gradleModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleModule", "org/jetbrains/plugins/gradle/service/project/AbstractProjectResolverExtension", "populateModuleCompileOutputSettings"));
        }
        if (ideModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModule", "org/jetbrains/plugins/gradle/service/project/AbstractProjectResolverExtension", "populateModuleCompileOutputSettings"));
        }
        this.nextResolver.populateModuleCompileOutputSettings(gradleModule, ideModule);
    }

    @Override
    public void populateModuleDependencies(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule, @NotNull DataNode<ProjectData> ideProject) {
        if (gradleModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleModule", "org/jetbrains/plugins/gradle/service/project/AbstractProjectResolverExtension", "populateModuleDependencies"));
        }
        if (ideModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModule", "org/jetbrains/plugins/gradle/service/project/AbstractProjectResolverExtension", "populateModuleDependencies"));
        }
        if (ideProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideProject", "org/jetbrains/plugins/gradle/service/project/AbstractProjectResolverExtension", "populateModuleDependencies"));
        }
        this.nextResolver.populateModuleDependencies(gradleModule, ideModule, ideProject);
    }

    @Override
    @NotNull
    public Collection<TaskData> populateModuleTasks(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule, @NotNull DataNode<ProjectData> ideProject) throws IllegalArgumentException, IllegalStateException {
        if (gradleModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleModule", "org/jetbrains/plugins/gradle/service/project/AbstractProjectResolverExtension", "populateModuleTasks"));
        }
        if (ideModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModule", "org/jetbrains/plugins/gradle/service/project/AbstractProjectResolverExtension", "populateModuleTasks"));
        }
        if (ideProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideProject", "org/jetbrains/plugins/gradle/service/project/AbstractProjectResolverExtension", "populateModuleTasks"));
        }
        Collection<TaskData> collection = this.nextResolver.populateModuleTasks(gradleModule, ideModule, ideProject);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/AbstractProjectResolverExtension", "populateModuleTasks"));
        }
        return collection;
    }

    @Override
    @NotNull
    public Set<Class> getExtraProjectModelClasses() {
        Set<Class> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/AbstractProjectResolverExtension", "getExtraProjectModelClasses"));
        }
        return set;
    }

    @Override
    @NotNull
    public Set<Class> getToolingExtensionsClasses() {
        Set<Class> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/AbstractProjectResolverExtension", "getToolingExtensionsClasses"));
        }
        return set;
    }

    @Override
    @NotNull
    public List<KeyValue<String, String>> getExtraJvmArgs() {
        List<KeyValue<String, String>> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/AbstractProjectResolverExtension", "getExtraJvmArgs"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<String> getExtraCommandLineArgs() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/AbstractProjectResolverExtension", "getExtraCommandLineArgs"));
        }
        return list;
    }

    @Override
    @NotNull
    public ExternalSystemException getUserFriendlyError(@NotNull Throwable error, @NotNull String projectPath, @Nullable String buildFilePath) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "org/jetbrains/plugins/gradle/service/project/AbstractProjectResolverExtension", "getUserFriendlyError"));
        }
        if (projectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectPath", "org/jetbrains/plugins/gradle/service/project/AbstractProjectResolverExtension", "getUserFriendlyError"));
        }
        ExternalSystemException externalSystemException = this.nextResolver.getUserFriendlyError(error, projectPath, buildFilePath);
        if (externalSystemException == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/AbstractProjectResolverExtension", "getUserFriendlyError"));
        }
        return externalSystemException;
    }

    public void enhanceRemoteProcessing(@NotNull SimpleJavaParameters parameters) throws ExecutionException {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/plugins/gradle/service/project/AbstractProjectResolverExtension", "enhanceRemoteProcessing"));
        }
    }

    public void enhanceLocalProcessing(@NotNull List<URL> urls) {
        if (urls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urls", "org/jetbrains/plugins/gradle/service/project/AbstractProjectResolverExtension", "enhanceLocalProcessing"));
        }
    }

    @Override
    public void preImportCheck() {
    }

    @Override
    public void enhanceTaskProcessing(@NotNull List<String> taskNames, @Nullable String debuggerSetup, @NotNull Consumer<String> initScriptConsumer) {
        if (taskNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskNames", "org/jetbrains/plugins/gradle/service/project/AbstractProjectResolverExtension", "enhanceTaskProcessing"));
        }
        if (initScriptConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initScriptConsumer", "org/jetbrains/plugins/gradle/service/project/AbstractProjectResolverExtension", "enhanceTaskProcessing"));
        }
    }
}

