/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.resources.ResourceType;
import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.android.tools.idea.rendering.LocalResourceRepository;
import com.android.tools.idea.rendering.ModuleResourceRepository;
import com.android.tools.idea.rendering.MultiResourceRepository;
import com.google.common.collect.Lists;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProjectResourceRepository
extends MultiResourceRepository {
    private final AndroidFacet myFacet;

    private ProjectResourceRepository(@NotNull AndroidFacet facet, @NotNull List<? extends LocalResourceRepository> delegates) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/rendering/ProjectResourceRepository", "<init>"));
        }
        if (delegates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegates", "com/android/tools/idea/rendering/ProjectResourceRepository", "<init>"));
        }
        super(facet.getModule().getName() + " with modules", delegates);
        this.myFacet = facet;
    }

    @Nullable
    public static ProjectResourceRepository getProjectResources(@NotNull Module module, boolean createIfNecessary) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/rendering/ProjectResourceRepository", "getProjectResources"));
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet != null) {
            return facet.getProjectResources(createIfNecessary);
        }
        return null;
    }

    @Contract(value="!null, true -> !null")
    @Nullable
    public static ProjectResourceRepository getProjectResources(@NotNull AndroidFacet facet, boolean createIfNecessary) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/rendering/ProjectResourceRepository", "getProjectResources"));
        }
        return facet.getProjectResources(createIfNecessary);
    }

    @NotNull
    public static ProjectResourceRepository create(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/rendering/ProjectResourceRepository", "create"));
        }
        List<LocalResourceRepository> resources = ProjectResourceRepository.computeRepositories(facet);
        final ProjectResourceRepository repository = new ProjectResourceRepository(facet, resources);
        facet.addListener(new GradleSyncListener.Adapter(){

            @Override
            public void syncSucceeded(@NotNull Project project) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/rendering/ProjectResourceRepository$1", "syncSucceeded"));
                }
                repository.updateRoots();
            }
        });
        ProjectResourceRepository projectResourceRepository = repository;
        if (projectResourceRepository == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/ProjectResourceRepository", "create"));
        }
        return projectResourceRepository;
    }

    private static List<LocalResourceRepository> computeRepositories(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/rendering/ProjectResourceRepository", "computeRepositories"));
        }
        LocalResourceRepository main = ModuleResourceRepository.getModuleResources(facet, true);
        List<AndroidFacet> dependentFacets = AndroidUtils.getAllAndroidDependencies(facet.getModule(), true);
        if (dependentFacets.isEmpty()) {
            return Collections.singletonList(main);
        }
        ArrayList resources = Lists.newArrayListWithExpectedSize((int)dependentFacets.size());
        for (AndroidFacet f : dependentFacets) {
            LocalResourceRepository r = ModuleResourceRepository.getModuleResources(f, true);
            resources.add(r);
        }
        resources.add(main);
        return resources;
    }

    void updateRoots() {
        List<LocalResourceRepository> repositories = ProjectResourceRepository.computeRepositories(this.myFacet);
        this.updateRoots(repositories);
    }

    void updateRoots(List<LocalResourceRepository> resourceDirectories) {
        if (resourceDirectories.equals(this.myChildren)) {
            return;
        }
        this.setChildren(resourceDirectories);
    }

    public static void moduleRootsChanged(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/rendering/ProjectResourceRepository", "moduleRootsChanged"));
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            ProjectResourceRepository.moduleRootsChanged(module);
        }
    }

    private static void moduleRootsChanged(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/rendering/ProjectResourceRepository", "moduleRootsChanged"));
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet != null) {
            if (facet.isGradleProject() && facet.getIdeaAndroidProject() == null) {
                return;
            }
            ProjectResourceRepository projectResources = ProjectResourceRepository.getProjectResources(facet, false);
            if (projectResources != null) {
                projectResources.updateRoots();
                AppResourceRepository appResources = AppResourceRepository.getAppResources(facet, false);
                if (appResources != null) {
                    appResources.invalidateCache(projectResources, new ResourceType[0]);
                    appResources.updateRoots();
                }
            }
        }
    }

    @NotNull
    static ProjectResourceRepository createForTest(AndroidFacet facet, List<LocalResourceRepository> modules) {
        ProjectResourceRepository projectResourceRepository = new ProjectResourceRepository(facet, modules);
        if (projectResourceRepository == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/ProjectResourceRepository", "createForTest"));
        }
        return projectResourceRepository;
    }
}

