/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.propertyTable;

import com.intellij.android.designer.model.PropertyParser;
import com.intellij.android.designer.model.RadCustomViewComponent;
import com.intellij.android.designer.model.RadModelBuilder;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.propertyTable.IXmlAttributeLocator;
import com.intellij.android.designer.propertyTable.JavadocParser;
import com.intellij.android.designer.propertyTable.editors.ResourceEditor;
import com.intellij.designer.model.PropertiesContainer;
import com.intellij.designer.model.Property;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.propertyTable.PropertyEditor;
import com.intellij.designer.propertyTable.PropertyRenderer;
import com.intellij.designer.propertyTable.renderers.LabelPropertyRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomViewProperty
extends Property<RadCustomViewComponent>
implements IXmlAttributeLocator {
    private static final String JAVA_DOC = JavadocParser.build("view:class", "The fully qualified name of the class.");
    private final PropertyRenderer myRenderer = new LabelPropertyRenderer(null);
    private final PropertyEditor myEditor = new ResourceEditor(null, Collections.emptySet(), null){

        @Override
        protected void showDialog() {
            String view = RadCustomViewComponent.chooseView(this.myRootComponent);
            if (view != null) {
                this.setValue(view);
            }
        }
    };

    public CustomViewProperty() {
        super(null, "view:class");
        this.setImportant(true);
    }

    public Property<RadCustomViewComponent> createForNewPresentation(@Nullable Property parent, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/android/designer/propertyTable/CustomViewProperty", "createForNewPresentation"));
        }
        return null;
    }

    public Object getValue(@NotNull RadCustomViewComponent component) throws Exception {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/android/designer/propertyTable/CustomViewProperty", "getValue"));
        }
        String viewClass = component.getViewClass();
        return viewClass == null ? "" : viewClass;
    }

    public void setValue(final @NotNull RadCustomViewComponent component, final Object value) throws Exception {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/android/designer/propertyTable/CustomViewProperty", "setValue"));
        }
        if (StringUtil.isEmpty((String)((String)value))) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                XmlTag tag = component.getTag();
                if ("view".equals(tag.getName())) {
                    tag.setAttribute("class", (String)value);
                } else {
                    tag.setName((String)value);
                }
            }
        });
        component.extractClientProperty("view.model");
        component.setProperties(Collections.<Property>emptyList());
        PropertyParser parser = RadModelBuilder.getPropertyParser((RadComponent)component);
        if (parser != null) {
            parser.load(component);
        }
    }

    public boolean isDefaultValue(@NotNull RadCustomViewComponent component) throws Exception {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/android/designer/propertyTable/CustomViewProperty", "isDefaultValue"));
        }
        return false;
    }

    public void setDefaultValue(@NotNull RadCustomViewComponent component) throws Exception {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/android/designer/propertyTable/CustomViewProperty", "setDefaultValue"));
        }
    }

    public boolean availableFor(List<PropertiesContainer> components) {
        return false;
    }

    public boolean needRefreshPropertyList() {
        return true;
    }

    @NotNull
    public PropertyRenderer getRenderer() {
        PropertyRenderer propertyRenderer = this.myRenderer;
        if (propertyRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/propertyTable/CustomViewProperty", "getRenderer"));
        }
        return propertyRenderer;
    }

    public PropertyEditor getEditor() {
        return this.myEditor;
    }

    public String getJavadocText() {
        return JAVA_DOC;
    }

    @Override
    public boolean checkAttribute(RadViewComponent component, XmlAttribute attribute) {
        return component.getTag().getAttribute("class") == attribute;
    }
}

