/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.run;

import com.android.prefs.AndroidLocation;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.utils.ILogger;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.ClickListener;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.sdk.MessageBuildingSdkLog;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateAvdDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.run.CreateAvdDialog");
    private JTextField myNameField;
    private JComboBox myTargetBox;
    private JComboBox mySkinField;
    private JPanel myPanel;
    private JLabel myAvdInfoLink;
    private JLabel myAvdInfoLabel;
    private JRadioButton mySdCardSizeRadioButton;
    private JRadioButton mySdCardFileRadioButton;
    private JSpinner mySdCardSizeSpinner;
    private JComboBox mySdCardSizeUnitCombo;
    private TextFieldWithBrowseButton mySdCardFileTextField;
    private JComboBox myTagAbiCombo;
    private final AvdManager myAvdManager;
    private AvdInfo myCreatedAvd;
    private final Project myProject;
    private static final String MB_UNIT = "MiB";
    private static final String MB_SUFFIX = "M";
    private static final String KB_UNIT = "KiB";
    private static final String KB_SUFFIX = "K";
    private static final String DEFAULT_SKIN = "HVGA";
    private static Map<String, Size> displaySizes;

    private static void initializeDisplaySizes() {
        displaySizes = new HashMap<String, Size>();
        displaySizes.put(DEFAULT_SKIN, new Size(320, 480));
        displaySizes.put("QVGA", new Size(240, 320));
        displaySizes.put("WQVGA", new Size(240, 400));
        displaySizes.put("WQVGA400", new Size(240, 400));
        displaySizes.put("WQVGA432", new Size(240, 432));
        displaySizes.put("FWQVGA", new Size(240, 432));
        displaySizes.put("WVGA800", new Size(480, 800));
        displaySizes.put("WVGA854", new Size(480, 854));
    }

    @NotNull
    private String generateAvdName() {
        String prefix = "MyAvd";
        int i = 0;
        while (true) {
            String candidate;
            if (this.myAvdManager.getAvd(candidate = prefix + i, false) == null) {
                String string = candidate;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/run/CreateAvdDialog", "generateAvdName"));
                }
                return string;
            }
            ++i;
        }
    }

    @Nullable
    private static String getSkinInfo(@NotNull String skinName) {
        Size size;
        String nameWithoutSuffix;
        if (skinName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skinName", "org/jetbrains/android/run/CreateAvdDialog", "getSkinInfo"));
        }
        int index = skinName.indexOf(45);
        String string = nameWithoutSuffix = index >= 0 ? skinName.substring(0, index) : skinName;
        if (displaySizes == null) {
            CreateAvdDialog.initializeDisplaySizes();
        }
        if ((size = displaySizes.get(nameWithoutSuffix)) != null) {
            if (skinName.endsWith("-L")) {
                return size.myHeight + "x" + size.myWidth + ", landscape";
            }
            if (skinName.endsWith("-P")) {
                return size.myWidth + "x" + size.myHeight + ", portrait";
            }
            return size.myWidth + "x" + size.myHeight;
        }
        return null;
    }

    private static boolean containsDefaultSkinWithSuffix(@NotNull File[] skins) {
        if (skins == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skins", "org/jetbrains/android/run/CreateAvdDialog", "containsDefaultSkinWithSuffix"));
        }
        for (File skin : skins) {
            String skinName;
            if (skin == null || (skinName = skin.getName()).equals(DEFAULT_SKIN) || !skinName.startsWith(DEFAULT_SKIN)) continue;
            return true;
        }
        return false;
    }

    private static String getSkinPresentation(@NotNull String skinName) {
        if (skinName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skinName", "org/jetbrains/android/run/CreateAvdDialog", "getSkinPresentation"));
        }
        String info = CreateAvdDialog.getSkinInfo(skinName);
        return info != null ? skinName + " (" + info + ')' : skinName;
    }

    public CreateAvdDialog(@NotNull Project project, @NotNull AndroidFacet facet, @NotNull AvdManager manager, boolean onlyCompatibleTargets, boolean showAvdInfo) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/run/CreateAvdDialog", "<init>"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/run/CreateAvdDialog", "<init>"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/android/run/CreateAvdDialog", "<init>"));
        }
        super(project, true);
        this.myProject = project;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(AndroidBundle.message("create.avd.dialog.title", objectArray));
        this.init();
        this.myAvdManager = manager;
        AndroidSdkData sdkData = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidSdk();
        assert (sdkData != null);
        IAndroidTarget[] targets = sdkData.getTargets();
        this.myTargetBox.setModel(new DefaultComboBoxModel<IAndroidTarget>(targets));
        this.myTargetBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selected = CreateAvdDialog.this.myTargetBox.getSelectedItem();
                CreateAvdDialog.this.mySkinField.setEnabled(selected != null);
                if (selected != null) {
                    File[] skins;
                    IAndroidTarget target = (IAndroidTarget)selected;
                    ArrayList<String> skinsToAdd = new ArrayList<String>();
                    for (File skin : skins = target.getSkins()) {
                        String skinName = skin.getName();
                        if (CreateAvdDialog.DEFAULT_SKIN.equals(skinName) && CreateAvdDialog.containsDefaultSkinWithSuffix(skins)) continue;
                        skinsToAdd.add(skinName);
                    }
                    CreateAvdDialog.this.mySkinField.setModel(new CollectionComboBoxModel(skinsToAdd, null));
                    CreateAvdDialog.this.reloadAbiCombo();
                }
            }
        });
        this.mySkinField.setRenderer(new ListCellRendererWrapper(){

            public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                String presentation = value != null ? CreateAvdDialog.getSkinPresentation((String)value) : null;
                this.setText(presentation);
            }
        });
        this.myTargetBox.setRenderer(new ListCellRendererWrapper<IAndroidTarget>(){

            public void customize(JList list, IAndroidTarget value, int index, boolean selected, boolean hasFocus) {
                this.setText(AndroidSdkUtils.getPresentableTargetName(value));
            }
        });
        this.myTagAbiCombo.setRenderer(new ListCellRendererWrapper<ISystemImage>(){

            public void customize(JList list, ISystemImage value, int index, boolean selected, boolean hasFocus) {
                if (value != null) {
                    this.setText(AvdInfo.getPrettyAbiType((ISystemImage)value));
                }
            }
        });
        IAndroidTarget target = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidTarget();
        if (target != null) {
            this.myTargetBox.setSelectedItem(target);
            if (onlyCompatibleTargets) {
                this.myTargetBox.setEnabled(false);
            }
        } else if (targets.length > 0) {
            this.myTargetBox.setSelectedItem(targets[0]);
        }
        this.myNameField.setText(this.generateAvdName());
        String url = "http://developer.android.com/tools/devices/index.html";
        this.myAvdInfoLink.setText("<html>\n   <body>\n     <p style=\"margin-top: 0;\">\n<a href=\"http://developer.android.com/tools/devices/index.html\">More information about AVDs</a>\n     </p>\n   </body>\n </html>");
        this.myAvdInfoLink.setCursor(new Cursor(12));
        this.myAvdInfoLink.setVisible(showAvdInfo);
        this.myAvdInfoLabel.setVisible(showAvdInfo);
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/android/run/CreateAvdDialog$5", "onClick"));
                }
                try {
                    BrowserUtil.browse((String)"http://developer.android.com/tools/devices/index.html");
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    // empty catch block
                }
                return true;
            }
        }.installOn((Component)this.myAvdInfoLink);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateAvdDialog.this.updateSdCardElements();
            }
        };
        this.mySdCardFileRadioButton.addActionListener(listener);
        this.mySdCardSizeRadioButton.addActionListener(listener);
        this.mySdCardFileRadioButton.setSelected(true);
        this.updateSdCardElements();
        this.mySdCardSizeUnitCombo.setModel(new DefaultComboBoxModel<Object>(new Object[]{MB_UNIT, KB_UNIT}));
        this.mySdCardSizeUnitCombo.setSelectedItem(MB_UNIT);
        this.mySdCardSizeUnitCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateAvdDialog.this.updateSpinner();
            }
        });
        this.updateSpinner();
        this.mySdCardFileTextField.addBrowseFolderListener(AndroidBundle.message("android.create.avd.dialog.sdcard.file.browser.title", new Object[0]), null, project, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
        this.reloadAbiCombo();
    }

    private void reloadAbiCombo() {
        IAndroidTarget selectedTarget = (IAndroidTarget)this.myTargetBox.getSelectedItem();
        if (selectedTarget != null) {
            ISystemImage[] systemImages = CreateAvdDialog.getSystemImages(selectedTarget);
            this.myTagAbiCombo.setModel(new DefaultComboBoxModel<ISystemImage>(systemImages));
            if (systemImages.length == 0) {
                LOG.warn("Tag/ABIs not found for target " + selectedTarget.hashString());
            }
        }
    }

    @NotNull
    private static ISystemImage[] getSystemImages(@NotNull IAndroidTarget target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/android/run/CreateAvdDialog", "getSystemImages"));
        }
        ISystemImage[] images = target.getSystemImages();
        if (!(images != null && images.length != 0 || target.isPlatform())) {
            images = target.getParent().getSystemImages();
        }
        ISystemImage[] iSystemImageArray = images != null ? images : new ISystemImage[]{};
        if (iSystemImageArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/run/CreateAvdDialog", "getSystemImages"));
        }
        return iSystemImageArray;
    }

    private void updateSpinner() {
        boolean mb = MB_UNIT.equals(this.mySdCardSizeUnitCombo.getSelectedItem());
        long max = mb ? 999999999L : 999999999999L;
        long min = mb ? 9L : 9216L;
        Object o = this.mySdCardSizeSpinner.getValue();
        long value = min;
        if (o instanceof Number) {
            value = ((Number)o).longValue();
            if (value < min) {
                value = min;
            } else if (value > max) {
                value = max;
            }
        }
        this.mySdCardSizeSpinner.setModel(new SpinnerNumberModel(new Long(value), new Long(min), new Long(max), new Long(1L)));
    }

    private void updateSdCardElements() {
        boolean file = this.mySdCardFileRadioButton.isSelected();
        this.mySdCardFileTextField.setEnabled(file);
        this.mySdCardSizeSpinner.setEnabled(!file);
        this.mySdCardSizeUnitCombo.setEnabled(!file);
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    protected void doOKAction() {
        File avdFolder;
        if (this.myNameField.getText().length() == 0) {
            Messages.showErrorDialog((Component)this.myPanel, (String)AndroidBundle.message("specify.avd.name.error", new Object[0]));
            return;
        }
        if (this.myTargetBox.getSelectedItem() == null) {
            Messages.showErrorDialog((Component)this.myPanel, (String)AndroidBundle.message("select.target.dialog.text", new Object[0]));
            return;
        }
        String avdName = this.myNameField.getText();
        AvdInfo info = this.myAvdManager.getAvd(avdName, false);
        if (info != null) {
            boolean replace;
            boolean bl = replace = Messages.showYesNoDialog((Component)this.myPanel, (String)AndroidBundle.message("replace.avd.question", avdName), (String)AndroidBundle.message("create.avd.dialog.title", new Object[0]), (Icon)Messages.getQuestionIcon()) == 0;
            if (!replace) {
                return;
            }
        }
        try {
            avdFolder = new File(AndroidLocation.getFolder() + "avd", avdName + ".avd");
        }
        catch (AndroidLocation.AndroidLocationException e) {
            Messages.showErrorDialog((Component)this.myPanel, (String)e.getMessage(), (String)"Error");
            return;
        }
        super.doOKAction();
        IAndroidTarget selectedTarget = (IAndroidTarget)this.myTargetBox.getSelectedItem();
        String skinName = (String)this.mySkinField.getSelectedItem();
        ISystemImage sysImg = (ISystemImage)this.myTagAbiCombo.getSelectedItem();
        String sdCard = this.getSdCardParameter();
        MessageBuildingSdkLog log = new MessageBuildingSdkLog();
        this.myCreatedAvd = this.myAvdManager.createAvd(avdFolder, avdName, selectedTarget, sysImg.getTag(), sysImg.getAbiType(), null, skinName, sdCard, null, null, true, false, false, (ILogger)log);
        if (log.getErrorMessage().length() > 0) {
            Messages.showErrorDialog((Project)this.myProject, (String)log.getErrorMessage(), (String)AndroidBundle.message("android.avd.error.title", new Object[0]));
        }
    }

    @Nullable
    private String getSdCardParameter() {
        if (this.mySdCardFileRadioButton.isSelected()) {
            String text = this.mySdCardFileTextField.getText();
            return text.length() > 0 ? text : null;
        }
        String value = this.mySdCardSizeSpinner.getValue().toString();
        if (value.length() == 0 || "0".equals(value)) {
            return null;
        }
        String suffix = MB_UNIT.equals(this.mySdCardSizeUnitCombo.getSelectedItem()) ? MB_SUFFIX : KB_SUFFIX;
        return value + suffix;
    }

    @Nullable
    public AvdInfo getCreatedAvd() {
        return this.myCreatedAvd;
    }

    protected String getHelpId() {
        return "reference.android.createAVD";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JRadioButton jRadioButton;
        JComboBox jComboBox2;
        JSpinner jSpinner;
        JRadioButton jRadioButton2;
        JLabel jLabel;
        JLabel jLabel2;
        JComboBox jComboBox3;
        JComboBox jComboBox4;
        JTextField jTextField;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel3 = new JLabel();
        Font font = jLabel3.getFont();
        jLabel3.setFont(new Font(font.getName(), font.getStyle(), font.getSize()));
        jLabel3.setText("Name*");
        jLabel3.setDisplayedMnemonic('N');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myNameField = jTextField = new JTextField();
        jTextField.setText("");
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 3, 0, new Dimension(100, -1), new Dimension(100, -1), null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Target*");
        jLabel4.setDisplayedMnemonic('T');
        jLabel4.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel4, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, new Dimension(47, 14), null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Skin");
        jLabel5.setDisplayedMnemonic('S');
        jLabel5.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel5, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTargetBox = jComboBox4 = new JComboBox();
        jPanel.add(jComboBox4, new GridConstraints(1, 3, 1, 1, 8, 1, 3, 0, new Dimension(100, -1), new Dimension(150, -1), null));
        this.mySkinField = jComboBox3 = new JComboBox();
        jComboBox3.setEditable(false);
        jPanel.add(jComboBox3, new GridConstraints(2, 1, 1, 3, 8, 1, 3, 0, new Dimension(170, -1), new Dimension(170, -1), null));
        this.myAvdInfoLink = jLabel2 = new JLabel();
        jLabel2.setHorizontalTextPosition(11);
        jLabel2.setText("LINK");
        jPanel.add((Component)jLabel2, new GridConstraints(5, 0, 1, 4, 4, 0, 0, 0, null, new Dimension(-1, 14), null));
        this.myAvdInfoLabel = jLabel = new JLabel();
        jLabel.setText("<html><body>Android Virtual Devices (AVDs) are configurations of emulator options that let you better model an actual device.<br>To use the emulator, you first must create one or more AVD configurations.</body></html>");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 4, 0, 1, 0, 0, null, new Dimension(0, -1), null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(4, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/AndroidBundle").getString("android.create.avd.dialog.sdcard.title"), (int)0, (int)0, null, null));
        this.mySdCardSizeRadioButton = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.create.avd.dialog.sdcard.size"));
        jPanel2.add((Component)jRadioButton2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySdCardSizeSpinner = jSpinner = new JSpinner();
        jPanel2.add((Component)jSpinner, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, null, null));
        this.mySdCardSizeUnitCombo = jComboBox2 = new JComboBox();
        jPanel2.add(jComboBox2, new GridConstraints(1, 2, 1, 1, 8, 1, 2, 0, null, null, null));
        this.mySdCardFileRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.create.avd.dialog.sdcard.file"));
        jPanel2.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySdCardFileTextField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 2, 0, 1, 6, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("Abi Type:");
        jLabel6.setDisplayedMnemonic('A');
        jLabel6.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel6, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTagAbiCombo = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(3, 1, 1, 3, 8, 1, 2, 0, null, null, null));
        jLabel3.setLabelFor(jTextField);
        jLabel4.setLabelFor(jComboBox4);
        jLabel5.setLabelFor(jComboBox3);
        jLabel6.setLabelFor(jComboBox);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class Size {
        final int myWidth;
        final int myHeight;

        private Size(int width, int height) {
            this.myWidth = width;
            this.myHeight = height;
        }
    }
}

