/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.boxing;

import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.optimization.boxing.ProgressionIteratorBasicValue;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;

public class BoxedBasicValue
extends BasicValue {
    private final Set<AbstractInsnNode> associatedInsns;
    private final Set<Pair<AbstractInsnNode, Type>> unboxingWithCastInsns;
    private final AbstractInsnNode boxingInsn;
    private final Set<Integer> associatedVariables;
    private final Set<BoxedBasicValue> mergedWith;
    private final Type primitiveType;
    private final ProgressionIteratorBasicValue progressionIterator;
    private boolean isSafeToRemove;

    public BoxedBasicValue(@NotNull Type boxedType, @NotNull AbstractInsnNode boxingInsn, @Nullable ProgressionIteratorBasicValue progressionIterator) {
        if (boxedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "boxedType", "org/jetbrains/kotlin/codegen/optimization/boxing/BoxedBasicValue", "<init>"));
        }
        if (boxingInsn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "boxingInsn", "org/jetbrains/kotlin/codegen/optimization/boxing/BoxedBasicValue", "<init>"));
        }
        super(boxedType);
        this.associatedInsns = new HashSet<AbstractInsnNode>();
        this.unboxingWithCastInsns = new HashSet<Pair<AbstractInsnNode, Type>>();
        this.associatedVariables = new HashSet<Integer>();
        this.mergedWith = new HashSet<BoxedBasicValue>();
        this.isSafeToRemove = true;
        this.primitiveType = AsmUtil.unboxType(boxedType);
        this.boxingInsn = boxingInsn;
        this.progressionIterator = progressionIterator;
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    public boolean typeEquals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoxedBasicValue that = (BoxedBasicValue)o;
        return this.getType().equals(that.getType());
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    public List<AbstractInsnNode> getAssociatedInsns() {
        return new ArrayList<AbstractInsnNode>(this.associatedInsns);
    }

    public void addInsn(AbstractInsnNode insnNode) {
        this.associatedInsns.add(insnNode);
    }

    public void addVariableIndex(int index2) {
        this.associatedVariables.add(index2);
    }

    public List<Integer> getVariablesIndexes() {
        return new ArrayList<Integer>(this.associatedVariables);
    }

    public Type getPrimitiveType() {
        return this.primitiveType;
    }

    public void addMergedWith(@NotNull BoxedBasicValue value2) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/optimization/boxing/BoxedBasicValue", "addMergedWith"));
        }
        this.mergedWith.add(value2);
    }

    @NotNull
    public Iterable<BoxedBasicValue> getMergedWith() {
        Set<BoxedBasicValue> set = this.mergedWith;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/optimization/boxing/BoxedBasicValue", "getMergedWith"));
        }
        return set;
    }

    public void markAsUnsafeToRemove() {
        this.isSafeToRemove = false;
    }

    public boolean isSafeToRemove() {
        return this.isSafeToRemove;
    }

    public boolean isDoubleSize() {
        return this.getPrimitiveType().getSize() == 2;
    }

    @NotNull
    public AbstractInsnNode getBoxingInsn() {
        AbstractInsnNode abstractInsnNode = this.boxingInsn;
        if (abstractInsnNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/optimization/boxing/BoxedBasicValue", "getBoxingInsn"));
        }
        return abstractInsnNode;
    }

    public boolean isFromProgressionIterator() {
        return this.progressionIterator != null;
    }

    @Nullable
    public ProgressionIteratorBasicValue getProgressionIterator() {
        return this.progressionIterator;
    }

    public void addUnboxingWithCastTo(@NotNull AbstractInsnNode insn, @NotNull Type type2) {
        if (insn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insn", "org/jetbrains/kotlin/codegen/optimization/boxing/BoxedBasicValue", "addUnboxingWithCastTo"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/optimization/boxing/BoxedBasicValue", "addUnboxingWithCastTo"));
        }
        this.unboxingWithCastInsns.add(Pair.create(insn, type2));
    }

    @NotNull
    public Set<Pair<AbstractInsnNode, Type>> getUnboxingWithCastInsns() {
        Set<Pair<AbstractInsnNode, Type>> set = this.unboxingWithCastInsns;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/optimization/boxing/BoxedBasicValue", "getUnboxingWithCastInsns"));
        }
        return set;
    }
}

