/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import kotlin.CollectionsKt;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeImpl;
import org.jetbrains.kotlin.types.TypeProjectionImpl;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"#\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u0019\u0001I\u0012\u0001'\u0001\"\u0006E\u001b\u0011\u0001C\u0001&)\u0011Y\u00012A\u0007\u00021\t\tB\u0001\u0002\u0001\t\u0006U\t\u0001dA\r\u0007\u0011\u000fiA!\u0003\u0002\n\u0003\u0011\u0016\u0001\u0004B\r\u0004\u0011\u0013i\u0011\u0001G\u0003"}, strings={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JavaClassOnCompanionChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "F", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;"}, moduleName="kotlin-compiler")
public final class JavaClassOnCompanionChecker
implements CallChecker {
    @Override
    public <F extends CallableDescriptor> void check(@NotNull ResolvedCall<F> resolvedCall, @NotNull BasicCallResolutionContext context) {
        ClassifierDescriptor classifierDescriptor;
        Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(context, "context");
        F descriptor2 = resolvedCall.getResultingDescriptor();
        if (!(descriptor2 instanceof PropertyDescriptor) || Intrinsics.areEqual(((PropertyDescriptor)descriptor2).getName().asString(), "javaClass") ^ true) {
            return;
        }
        DeclarationDescriptor container = ((PropertyDescriptor)descriptor2).getContainingDeclaration();
        if (!(container instanceof PackageFragmentDescriptor) || Intrinsics.areEqual(((PackageFragmentDescriptor)container).getFqName().asString(), "kotlin") ^ true) {
            return;
        }
        KotlinType actualType = ((PropertyDescriptor)descriptor2).getType();
        Object object = CollectionsKt.singleOrNull(actualType.getArguments());
        if (!((object != null && (object = object.getType()) != null && (object = object.getConstructor()) != null ? object.getDeclarationDescriptor() : (classifierDescriptor = null)) instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
        if (classDescriptor == null) {
            return;
        }
        ClassDescriptor companionObject = classDescriptor;
        if (companionObject.isCompanionObject()) {
            DeclarationDescriptor declarationDescriptor = companionObject.getContainingDeclaration();
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            ClassDescriptor containingClass = (ClassDescriptor)declarationDescriptor;
            ClassifierDescriptor classifierDescriptor2 = actualType.getConstructor().getDeclarationDescriptor();
            if (!(classifierDescriptor2 instanceof ClassDescriptor)) {
                classifierDescriptor2 = null;
            }
            ClassDescriptor classDescriptor2 = (ClassDescriptor)classifierDescriptor2;
            if (classDescriptor2 == null) {
                return;
            }
            ClassDescriptor javaLangClass = classDescriptor2;
            KotlinTypeImpl expectedType = KotlinTypeImpl.Companion.create(Annotations.Companion.getEMPTY(), javaLangClass, actualType.isMarkedNullable(), CollectionsKt.listOf(new TypeProjectionImpl(containingClass.getDefaultType())));
            context.trace.report(ErrorsJvm.JAVA_CLASS_ON_COMPANION.on((KtElement)((PsiElement)resolvedCall.getCall().getCallElement()), actualType, expectedType));
        }
    }
}

