/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.CopyPastePostProcessor;
import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.codeInsight.editorActions.TextBlockTransferable;
import com.intellij.codeInsight.editorActions.TextBlockTransferableData;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorCopyPasteHelperImpl;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;

public class CopyHandler
extends EditorActionHandler {
    private final EditorActionHandler myOriginalAction;

    public CopyHandler(EditorActionHandler originalHandler) {
        this.myOriginalAction = originalHandler;
    }

    public void doExecute(final Editor editor, Caret caret, DataContext dataContext) {
        EditorEx ex;
        CopyPastePreProcessor processor2;
        assert (caret == null) : "Invocation of 'copy' operation for specific caret is not supported";
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)editor.getComponent()));
        if (project == null) {
            if (this.myOriginalAction != null) {
                this.myOriginalAction.execute(editor, null, dataContext);
            }
            return;
        }
        final PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (file == null) {
            if (this.myOriginalAction != null) {
                this.myOriginalAction.execute(editor, null, dataContext);
            }
            return;
        }
        final SelectionModel selectionModel = editor.getSelectionModel();
        if (!selectionModel.hasSelection(true)) {
            if (Registry.is((String)"editor.skip.copy.and.cut.for.empty.selection")) {
                return;
            }
            editor.getCaretModel().runForEachCaret(new CaretAction(){

                public void perform(Caret caret) {
                    selectionModel.selectLineAtCaret();
                }
            });
            if (!selectionModel.hasSelection(true)) {
                return;
            }
            editor.getCaretModel().runForEachCaret(new CaretAction(){

                public void perform(Caret caret) {
                    EditorActionUtil.moveCaretToLineStartIgnoringSoftWraps(editor);
                }
            });
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        final int[] startOffsets = selectionModel.getBlockSelectionStarts();
        final int[] endOffsets = selectionModel.getBlockSelectionEnds();
        final ArrayList<TextBlockTransferableData> transferableDatas = new ArrayList<TextBlockTransferableData>();
        DumbService.getInstance((Project)project).withAlternativeResolveEnabled(new Runnable(){

            @Override
            public void run() {
                for (CopyPastePostProcessor processor2 : (CopyPastePostProcessor[])Extensions.getExtensions(CopyPastePostProcessor.EP_NAME)) {
                    transferableDatas.addAll(processor2.collectTransferableData(file, editor, startOffsets, endOffsets));
                }
            }
        });
        String text = editor.getCaretModel().supportsMultipleCarets() ? EditorCopyPasteHelperImpl.getSelectedTextForClipboard(editor, transferableDatas) : selectionModel.getSelectedText();
        String rawText = TextBlockTransferable.convertLineSeparators(text, "\n", transferableDatas);
        String escapedText = null;
        CopyPastePreProcessor[] copyPastePreProcessorArray = (CopyPastePreProcessor[])Extensions.getExtensions(CopyPastePreProcessor.EP_NAME);
        int n = copyPastePreProcessorArray.length;
        for (int i = 0; i < n && (escapedText = (processor2 = copyPastePreProcessorArray[i]).preprocessOnCopy(file, startOffsets, endOffsets, rawText)) == null; ++i) {
        }
        TextBlockTransferable transferable = new TextBlockTransferable(escapedText != null ? escapedText : rawText, transferableDatas, escapedText != null ? new RawText(rawText) : null);
        CopyPasteManager.getInstance().setContents((Transferable)transferable);
        if (editor instanceof EditorEx && (ex = (EditorEx)editor).isStickySelection()) {
            ex.setStickySelection(false);
        }
    }
}

