/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.DefaultStorageAnnotation;
import com.intellij.configurationStore.ProjectStateStorageManager;
import com.intellij.configurationStore.ProjectStoreBase;
import com.intellij.configurationStore.ProjectStoreImplKt;
import com.intellij.ide.highlighter.ProjectFileType;
import com.intellij.notification.Notification;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtilRt;
import com.intellij.util.lang.CompoundRuntimeException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.ArraysKt;
import kotlin.PreconditionsKt;
import kotlin.Sequence;
import kotlin.StringsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"k\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\tA1A\u0003\u0002\u0011\u0005)\u0001!B\u0001\t!\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001\u0012E\u0003\u0002\u0011\u0007)\u0011\u0001\u0002\u0002\u0006\u0003!9Q\u0001A\u0003\u0002\u0011#)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u000f!\u0011\u0002\u0004\u0001\u0011+e\t\u0001\u0014AO\u0001+\u0005V\u0011b\u0001\u0005\u0002\u001b\u0005A\u001a!C\u0002\t\u00055\t\u0001TA)\u0004\u0003!\u0019Q%\u0005\u0003\u000b\u0011\u0017i\u0011\u0001\u0007\u0004\u001a\u0019!5QBC\u0005\t\u0013\u001dI!!C\u0001\u0019\u0011%\u0011\u0011\"\u0001M\t1\u001fAr!\n\u0013\u0005\u0015!IQ\"B\u0005\u0003\u0013\u0005A\"\u0002$\u0001\u0019\u0014e1\u0001RC\u0007\u0005\u0013\tI\u0011\u0001\u0007\u0005\u0019\u000fea\u0001RB\u0007\u000b\u0013!Iq!\u0003\u0002\n\u0003aA\u0011BA\u0005\u00021#Az\u0001g\u0005\u001a\u000f!YQ\"B\u0005\u0003\u0013\u0005A\"\u0002$\u0001\u0019\u0014\u0015\"AA\u0001E\f\u001b\u0005A*!\n\u0003\u0005\u0017!aQ\"\u0001M\rKs!!\u0002C\u0007\u000e\u000b%\u0019A\u0011A\u0005\u000219AZ\"\u0005\u0002\u0005\u0001!u\u0011D\u0002\u0005\u0010\u001b\u0011I!!C\u0001%\u001ea}\u0011d\u0001\u0005\u0011\u001b\u0005A\n#G\u0002\t#5\t\u00014E)\u0004\u0003!\u0011R\u0015\u0006\u0003\u000b\u0011KiA!\u0003\u0002\n\u0003aq\u00014D\r\u0007\u0011MiA!\u0003\u0002\n\u0003aq\u00014D\r\u0004\u0011Ei\u0011\u0001g\tR\u0007\u0005A9#\n\u0005\u0005\u0017!!R\"\u0001\r\u00073\rAI#D\u0001\u0019\u001a%:A!\u0011\u0005\t\u00055\t\u0001TA)\u0004\u0003\u0015\u0001\u0011F\u0003\u0003L\u0011!\u001dQ\"\u0001\r\u0005#\u000e!Q\u0001A\u0007\u0003\t\u0013AQ\u0001"}, strings={"Lcom/intellij/configurationStore/ProjectStoreImpl;", "Lcom/intellij/configurationStore/ProjectStoreBase;", "project", "Lcom/intellij/openapi/project/impl/ProjectImpl;", "pathMacroManager", "Lcom/intellij/openapi/components/PathMacroManager;", "(Lcom/intellij/openapi/project/impl/ProjectImpl;Lcom/intellij/openapi/components/PathMacroManager;)V", "storageManager", "Lcom/intellij/configurationStore/ProjectStateStorageManager;", "getStorageManager", "()Lcom/intellij/configurationStore/ProjectStateStorageManager;", "beforeSave", "", "readonlyFiles", "", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/openapi/components/StateStorage$SaveSession;", "Lcom/intellij/openapi/vfs/VirtualFile;", "doSave", "", "", "saveSessions", "prevErrors", "getPathMacroManagerForDefaults", "getProjectName", "", "getStorageSpecs", "", "Lcom/intellij/openapi/components/Storage;", "T", "component", "Lcom/intellij/openapi/components/PersistentStateComponent;", "stateSpec", "Lcom/intellij/openapi/components/State;", "operation", "Lcom/intellij/openapi/components/StateStorageOperation;", "(Lcom/intellij/openapi/components/PersistentStateComponent;Lcom/intellij/openapi/components/State;Lcom/intellij/openapi/components/StateStorageOperation;)[Lcom/intellij/openapi/components/Storage;", "selectDefaultStorages", "storages", "([Lcom/intellij/openapi/components/Storage;Lcom/intellij/openapi/components/StateStorageOperation;)[Lcom/intellij/openapi/components/Storage;", "setPath", "filePath", "Companion"}, moduleName="configuration-store-impl")
public class ProjectStoreImpl
extends ProjectStoreBase {
    private static final DefaultStorageAnnotation DEFAULT_STORAGE_ANNOTATION;
    @NotNull
    private final ProjectStateStorageManager storageManager;
    private final PathMacroManager pathMacroManager;
    public static final Companion Companion;

    static {
        Companion = com.intellij.configurationStore.ProjectStoreImpl$Companion.INSTANCE;
        DEFAULT_STORAGE_ANNOTATION = new DefaultStorageAnnotation();
    }

    @Override
    @NotNull
    protected final PathMacroManager getPathMacroManagerForDefaults() {
        return this.pathMacroManager;
    }

    @Override
    @NotNull
    public ProjectStateStorageManager getStorageManager() {
        return this.storageManager;
    }

    @Override
    public void setPath(@NotNull String filePath) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        this.setPath(filePath, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String getProjectName() {
        int i;
        if (Intrinsics.areEqual((Object)this.getScheme(), (Object)StorageScheme.DIRECTORY_BASED)) {
            String baseDir = this.getProjectBasePath();
            File nameFile = new File(new File(this.getProjectBasePath(), ".idea"), ".name");
            if (nameFile.exists()) {
                try {
                    Object it;
                    void $receiver;
                    void $receiver2;
                    Reader reader = ByteStreamsKt.reader$default((InputStream)FilesKt.inputStream((File)nameFile), null, (int)1);
                    Closeable closeable = TextStreamsKt.buffered$default((Reader)$receiver2, (int)0, (int)1);
                    boolean closed = false;
                    try {
                        Object v0;
                        block16: {
                            void $receiver3;
                            Sequence it2;
                            it = (BufferedReader)$receiver;
                            Sequence sequence = it2 = TextStreamsKt.lineSequence((BufferedReader)it);
                            for (Object element : $receiver3) {
                                String it3 = (String)element;
                                if (!(!StringsKt.isEmpty((CharSequence)it3))) continue;
                                v0 = element;
                                break block16;
                            }
                            v0 = null;
                        }
                        String string = v0;
                        it = string != null ? StringsKt.trim((String)string) : null;
                    }
                    catch (Exception e) {
                        closed = true;
                        try {
                            $receiver.close();
                        }
                        catch (Exception closeException) {
                            // empty catch block
                        }
                        throw (Throwable)e;
                    }
                    finally {
                        if (!closed) {
                            $receiver.close();
                        }
                    }
                    String name = (String)it;
                    if (name != null) {
                        return name;
                    }
                }
                catch (IOException ignored) {
                    // empty catch block
                }
            }
            return StringsKt.replace$default((String)PathUtilRt.getFileName((String)baseDir), (String)":", (String)"", (boolean)false, (int)4);
        }
        String temp = PathUtilRt.getFileName((String)this.getProjectFilePath());
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(temp);
        if (fileType instanceof ProjectFileType) {
            temp = StringsKt.substring((String)temp, (int)0, (int)(temp.length() - ((ProjectFileType)fileType).getDefaultExtension().length() - 1));
        }
        if ((i = StringsKt.lastIndexOf$default((CharSequence)temp, (char)File.separatorChar, (int)0, (boolean)false, (int)6)) >= 0) {
            temp = StringsKt.substring((String)temp, (int)(i + 1), (int)(temp.length() - i + 1));
        }
        String string = temp;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"temp");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    protected List<Throwable> doSave(@NotNull List<? extends StateStorage.SaveSession> saveSessions, @NotNull List<Pair<StateStorage.SaveSession, VirtualFile>> readonlyFiles, @Nullable List<Throwable> prevErrors) {
        ReadonlyStatusHandler.OperationStatus status;
        Intrinsics.checkParameterIsNotNull(saveSessions, (String)"saveSessions");
        Intrinsics.checkParameterIsNotNull(readonlyFiles, (String)"readonlyFiles");
        List<Throwable> errors = prevErrors;
        this.beforeSave(readonlyFiles);
        super.doSave(saveSessions, readonlyFiles, errors);
        ProjectManagerImpl.UnableToSaveProjectNotification[] notifications = (ProjectManagerImpl.UnableToSaveProjectNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(ProjectManagerImpl.UnableToSaveProjectNotification.class, (Project)this.getProject());
        if (readonlyFiles.isEmpty()) {
            for (int i = 0; i < notifications.length; ++i) {
                ProjectManagerImpl.UnableToSaveProjectNotification notification = notifications[i];
                notification.expire();
            }
            return errors;
        }
        if (!ArraysKt.isEmpty((Object[])((Object[])notifications))) {
            throw (Throwable)new IComponentStore.SaveCancelledException();
        }
        AccessToken token = ReadAction.start();
        try {
            VirtualFile[] virtualFileArray = ProjectStoreImpl.Companion.getFilesList(readonlyFiles);
            ReadonlyStatusHandler.OperationStatus operationStatus = ReadonlyStatusHandler.getInstance((Project)this.getProject()).ensureFilesWritable(Arrays.copyOf(virtualFileArray, virtualFileArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)operationStatus, (String)"ReadonlyStatusHandler.ge\u2026FilesList(readonlyFiles))");
            status = operationStatus;
        }
        finally {
            token.finish();
        }
        if (status.hasReadonlyFiles()) {
            Project project = this.getProject();
            VirtualFile[] virtualFileArray = status.getReadonlyFiles();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"status.readonlyFiles");
            ProjectStoreImpl.Companion.dropUnableToSaveProjectNotification(project, virtualFileArray);
            throw (Throwable)new IComponentStore.SaveCancelledException();
        }
        ArrayList oldList = new ArrayList(readonlyFiles);
        readonlyFiles.clear();
        for (Pair entry : oldList) {
            StateStorage.SaveSession saveSession = (StateStorage.SaveSession)entry.first;
            Intrinsics.checkExpressionValueIsNotNull((Object)saveSession, (String)"entry.first");
            errors = ComponentStoreImplKt.executeSave(saveSession, readonlyFiles, errors);
        }
        if (errors != null) {
            CompoundRuntimeException.throwIfNotEmpty(errors);
        }
        if (!readonlyFiles.isEmpty()) {
            ProjectStoreImpl.Companion.dropUnableToSaveProjectNotification(this.getProject(), ProjectStoreImpl.Companion.getFilesList(readonlyFiles));
            throw (Throwable)new IComponentStore.SaveCancelledException();
        }
        return errors;
    }

    protected void beforeSave(@NotNull List<? extends Pair<StateStorage.SaveSession, VirtualFile>> readonlyFiles) {
        Intrinsics.checkParameterIsNotNull(readonlyFiles, (String)"readonlyFiles");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected <T> Storage[] getStorageSpecs(@NotNull PersistentStateComponent<T> component, @NotNull State stateSpec, @NotNull StateStorageOperation operation) {
        void size;
        Intrinsics.checkParameterIsNotNull(component, (String)"component");
        Intrinsics.checkParameterIsNotNull((Object)stateSpec, (String)"stateSpec");
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        Storage[] result2 = super.getStorageSpecs(component, stateSpec, operation);
        for (int i = 0; i < result2.length; ++i) {
            Storage storage2 = result2[i];
            if (!Intrinsics.areEqual((Object)storage2.file(), (Object)"$PROJECT_FILE$")) continue;
            return result2;
        }
        int storage2 = ((Object[])result2).length + 1;
        Storage[] result3 = new Storage[size];
        boolean bl = false;
        void var8_10 = size - true;
        if (bl <= var8_10) {
            void i;
            do {
                void it;
                Storage storage3;
                void var9_11 = ++i;
                void var13_13 = i;
                Storage[] storageArray = result3;
                storageArray[var13_13] = storage3 = it == ((Object[])result2).length ? (Storage)ProjectStoreImpl.Companion.getDEFAULT_STORAGE_ANNOTATION() : result2[it];
            } while (i != var8_10);
        }
        return (Storage[])((Object[])result3);
    }

    @Override
    @NotNull
    protected Storage[] selectDefaultStorages(@NotNull Storage[] storages, @NotNull StateStorageOperation operation) {
        Intrinsics.checkParameterIsNotNull((Object)storages, (String)"storages");
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        return ProjectStoreImplKt.selectDefaultStorages(storages, operation, this.getScheme());
    }

    public ProjectStoreImpl(@NotNull ProjectImpl project, @NotNull PathMacroManager pathMacroManager) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)pathMacroManager, (String)"pathMacroManager");
        super(project);
        this.pathMacroManager = pathMacroManager;
        PreconditionsKt.assert((!project.isDefault() ? 1 : 0) != 0);
        TrackingPathMacroSubstitutor trackingPathMacroSubstitutor = this.pathMacroManager.createTrackingSubstitutor();
        Intrinsics.checkExpressionValueIsNotNull((Object)trackingPathMacroSubstitutor, (String)"pathMacroManager.createTrackingSubstitutor()");
        this.storageManager = new ProjectStateStorageManager(trackingPathMacroSubstitutor, project);
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={";\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005A\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0011#)\u0011\u0001D\u0001\u0006\u0003\u0011\u0011Q!\u0001\u0005\u0011\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\u0001Aaq\u0001\r\u0001e\t\u0001\u0014AQ\u0004\t\u0005\t6!\u0001\u0005\u0002KG!\u0011\u0001c\u0002\u000e\u0003a!\u0011d\u0001E\u0005\u001b\u0005AR!\u0007\u0004\t\f5!\u0011BA\u0005\u00021\u001bAb!U\u0002\u0002\u0011\u001d)+\u0004B\u0001\t\u00105A\u0011BB\u0005\u0006!!)\"\u0001$\u0001\u0019\u000ea5\u0001DB\r\r\u0011#i!\"\u0003\u0005\n\u000f%\u0011\u0011\"\u0001\r\u000b\u0013\tI\u0011\u0001'\u0004\u0019\u0014aI\u0011kA\u0001\t\u0016%ZA!\u0011\u0005\t\u00045\t\u0001DA)\u0004\u000b\u0015\tA\u0012A\u0007\u0003\t\u000bA1\u0001"}, strings={"Lcom/intellij/configurationStore/ProjectStoreImpl$Companion;", "", "()V", "DEFAULT_STORAGE_ANNOTATION", "Lcom/intellij/configurationStore/DefaultStorageAnnotation;", "getDEFAULT_STORAGE_ANNOTATION", "()Lcom/intellij/configurationStore/DefaultStorageAnnotation;", "dropUnableToSaveProjectNotification", "", "project", "Lcom/intellij/openapi/project/Project;", "readOnlyFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/openapi/vfs/VirtualFile;)V", "getFilesList", "kotlin.jvm.PlatformType", "readonlyFiles", "", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/openapi/components/StateStorage$SaveSession;", "(Ljava/util/List;)[Lcom/intellij/openapi/vfs/VirtualFile;"}, moduleName="configuration-store-impl")
    public static final class Companion {
        public static final Companion INSTANCE;

        private final DefaultStorageAnnotation getDEFAULT_STORAGE_ANNOTATION() {
            return DEFAULT_STORAGE_ANNOTATION;
        }

        private final void dropUnableToSaveProjectNotification(Project project, VirtualFile[] readOnlyFiles) {
            ProjectManagerImpl.UnableToSaveProjectNotification[] notifications = (ProjectManagerImpl.UnableToSaveProjectNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(ProjectManagerImpl.UnableToSaveProjectNotification.class, project);
            if (ArraysKt.isEmpty((Object[])((Object[])notifications))) {
                Notifications.Bus.notify((Notification)new ProjectManagerImpl.UnableToSaveProjectNotification(project, readOnlyFiles), (Project)project);
            } else {
                notifications[0].myFiles = readOnlyFiles;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final VirtualFile[] getFilesList(List<? extends Pair<StateStorage.SaveSession, VirtualFile>> readonlyFiles) {
            int size = readonlyFiles.size();
            VirtualFile[] result2 = new VirtualFile[size];
            int n = 0;
            int n2 = size - 1;
            if (n <= n2) {
                void i;
                do {
                    void it;
                    VirtualFile virtualFile;
                    void var6_6 = ++i;
                    void var10_8 = i;
                    VirtualFile[] virtualFileArray = result2;
                    virtualFileArray[var10_8] = virtualFile = (VirtualFile)readonlyFiles.get((int)it).second;
                } while (i != n2);
            }
            return (VirtualFile[])((Object[])result2);
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

