/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.ui.impl.watch.ArrayElementDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.openapi.project.Project;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.Type;
import com.sun.jdi.Value;

class ArrayAccessEvaluator
implements Evaluator {
    private final Evaluator myArrayReferenceEvaluator;
    private final Evaluator myIndexEvaluator;
    private ArrayReference myEvaluatedArrayReference;
    private int myEvaluatedIndex;

    public ArrayAccessEvaluator(Evaluator arrayReferenceEvaluator, Evaluator indexEvaluator) {
        this.myArrayReferenceEvaluator = arrayReferenceEvaluator;
        this.myIndexEvaluator = indexEvaluator;
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        this.myEvaluatedIndex = 0;
        this.myEvaluatedArrayReference = null;
        Value indexValue = (Value)this.myIndexEvaluator.evaluate(context);
        Value arrayValue = (Value)this.myArrayReferenceEvaluator.evaluate(context);
        if (!(arrayValue instanceof ArrayReference)) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.array.reference.expected", (Object[])new Object[0]));
        }
        this.myEvaluatedArrayReference = (ArrayReference)arrayValue;
        if (!DebuggerUtils.isInteger((Value)indexValue)) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.invalid.index.expression", (Object[])new Object[0]));
        }
        this.myEvaluatedIndex = ((PrimitiveValue)indexValue).intValue();
        try {
            return this.myEvaluatedArrayReference.getValue(this.myEvaluatedIndex);
        }
        catch (Exception e) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
        }
    }

    @Override
    public Modifier getModifier() {
        Modifier modifier = null;
        if (this.myEvaluatedArrayReference != null) {
            modifier = new Modifier(){

                public boolean canInspect() {
                    return true;
                }

                public boolean canSetValue() {
                    return true;
                }

                public void setValue(Value value) throws ClassNotLoadedException, InvalidTypeException {
                    ArrayAccessEvaluator.this.myEvaluatedArrayReference.setValue(ArrayAccessEvaluator.this.myEvaluatedIndex, value);
                }

                public Type getExpectedType() throws EvaluateException {
                    try {
                        ArrayType type = (ArrayType)ArrayAccessEvaluator.this.myEvaluatedArrayReference.referenceType();
                        return type.componentType();
                    }
                    catch (ClassNotLoadedException e) {
                        throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
                    }
                }

                public NodeDescriptorImpl getInspectItem(Project project) {
                    return new ArrayElementDescriptorImpl(project, ArrayAccessEvaluator.this.myEvaluatedArrayReference, ArrayAccessEvaluator.this.myEvaluatedIndex);
                }
            };
        }
        return modifier;
    }
}

