/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.codeInsight.daemon.impl.IdentifierHighlighterPass;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.impl.watch.ThreadDescriptorImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class DebuggerContextUtil {
    public static void setStackFrame(DebuggerStateManager manager, StackFrameProxyImpl stackFrame) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        DebuggerContextImpl context = manager.getContext();
        if (context == null) {
            return;
        }
        DebuggerSession session = context.getDebuggerSession();
        SuspendContextImpl threadSuspendContext = SuspendManagerUtil.getSuspendContextForThread(context.getSuspendContext(), stackFrame.threadProxy());
        DebuggerContextImpl newContext = DebuggerContextImpl.createDebuggerContext(session, threadSuspendContext, stackFrame.threadProxy(), stackFrame);
        manager.setState(newContext, session != null ? session.getState() : DebuggerSession.State.DISPOSED, DebuggerSession.Event.REFRESH, null);
    }

    public static void setThread(DebuggerStateManager contextManager, ThreadDescriptorImpl item) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        DebuggerContextImpl context = contextManager.getContext();
        if (context == null) {
            return;
        }
        DebuggerSession session = context.getDebuggerSession();
        DebuggerContextImpl newContext = DebuggerContextImpl.createDebuggerContext(session, item.getSuspendContext(), item.getThreadReference(), null);
        contextManager.setState(newContext, session != null ? session.getState() : DebuggerSession.State.DISPOSED, DebuggerSession.Event.CONTEXT, null);
    }

    @NotNull
    public static DebuggerContextImpl createDebuggerContext(@NotNull DebuggerSession session, SuspendContextImpl suspendContext) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/debugger/impl/DebuggerContextUtil", "createDebuggerContext"));
        }
        DebuggerContextImpl debuggerContextImpl = DebuggerContextImpl.createDebuggerContext(session, suspendContext, suspendContext != null ? suspendContext.getThread() : null, null);
        if (debuggerContextImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/impl/DebuggerContextUtil", "createDebuggerContext"));
        }
        return debuggerContextImpl;
    }

    public static SourcePosition findNearest(@NotNull DebuggerContextImpl context, @NotNull PsiElement psi, @NotNull PsiFile file) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/debugger/impl/DebuggerContextUtil", "findNearest"));
        }
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/debugger/impl/DebuggerContextUtil", "findNearest"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/debugger/impl/DebuggerContextUtil", "findNearest"));
        }
        DebuggerSession session = context.getDebuggerSession();
        if (session != null) {
            try {
                XDebugSession debugSession = session.getXDebugSession();
                if (debugSession != null) {
                    XSourcePosition position = debugSession.getCurrentPosition();
                    Editor editor = ((FileEditorManagerImpl)FileEditorManager.getInstance((Project)file.getProject())).getSelectedTextEditor(true);
                    if (editor != null && position != null && file.getVirtualFile().equals(position.getFile())) {
                        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)PositionUtil.getContextElement((StackFrameContext)context), PsiMethod.class, (boolean)false);
                        Couple<Collection<TextRange>> usages = IdentifierHighlighterPass.getHighlightUsages(psi, (PsiElement)(method != null ? method : file), false);
                        ArrayList ranges = new ArrayList();
                        ranges.addAll((Collection)usages.first);
                        ranges.addAll((Collection)usages.second);
                        int breakPointLine = position.getLine();
                        int bestLine = -1;
                        int bestOffset = -1;
                        for (TextRange range : ranges) {
                            int line = editor.offsetToLogicalPosition((int)range.getStartOffset()).line;
                            if (line > bestLine && line < breakPointLine) {
                                bestLine = line;
                                bestOffset = range.getStartOffset();
                                continue;
                            }
                            if (line != breakPointLine) continue;
                            bestOffset = range.getStartOffset();
                            break;
                        }
                        if (bestOffset > -1) {
                            return SourcePosition.createFromOffset((PsiFile)file, (int)bestOffset);
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

