/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.List;

public class FailedTestsNavigator
implements OccurenceNavigator {
    private static final String NEXT_NAME = ExecutionBundle.message((String)"next.faled.test.action.name", (Object[])new Object[0]);
    private static final String PREVIOUS_NAME = ExecutionBundle.message((String)"prev.faled.test.action.name", (Object[])new Object[0]);
    private TestFrameworkRunningModel myModel;

    public boolean hasNextOccurence() {
        return this.myModel != null && this.getNextOccurenceInfo().hasNextOccurence();
    }

    public boolean hasPreviousOccurence() {
        return this.myModel != null && this.getPreviousOccurenceInfo().hasNextOccurence();
    }

    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        FailedTestInfo result2 = this.getNextOccurenceInfo();
        this.myModel.selectAndNotify(result2.getDefect());
        return new OccurenceNavigator.OccurenceInfo(TestsUIUtil.getOpenFileDescriptor(result2.myDefect, this.myModel), result2.getDefectNumber(), result2.getDefectsCount());
    }

    public void setModel(TestFrameworkRunningModel model) {
        this.myModel = model;
        Disposer.register((Disposable)this.myModel, (Disposable)new Disposable(){

            public void dispose() {
                FailedTestsNavigator.this.myModel = null;
            }
        });
    }

    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        FailedTestInfo result2 = this.getPreviousOccurenceInfo();
        this.myModel.selectAndNotify(result2.getDefect());
        return new OccurenceNavigator.OccurenceInfo(TestsUIUtil.getOpenFileDescriptor(result2.myDefect, this.myModel), result2.getDefectNumber(), result2.getDefectsCount());
    }

    public String getNextOccurenceActionName() {
        return NEXT_NAME;
    }

    public String getPreviousOccurenceActionName() {
        return PREVIOUS_NAME;
    }

    private FailedTestInfo getNextOccurenceInfo() {
        return new NextFailedTestInfo().execute();
    }

    private FailedTestInfo getPreviousOccurenceInfo() {
        return new PreviousFailedTestInfo().execute();
    }

    private class PreviousFailedTestInfo
    extends FailedTestInfo {
        private PreviousFailedTestInfo() {
        }

        @Override
        protected int nextIndex(int defectIndex) {
            return defectIndex - 1;
        }

        @Override
        protected int getBoundIndex() {
            return 0;
        }
    }

    private class NextFailedTestInfo
    extends FailedTestInfo {
        private NextFailedTestInfo() {
        }

        @Override
        protected int nextIndex(int defectIndex) {
            return defectIndex + 1;
        }

        @Override
        protected int getBoundIndex() {
            return this.getDefectsCount() - 1;
        }
    }

    protected abstract class FailedTestInfo {
        private AbstractTestProxy myDefect = null;
        private List<AbstractTestProxy> myAllTests;
        private List<AbstractTestProxy> myDefects;

        protected FailedTestInfo() {
        }

        public AbstractTestProxy getDefect() {
            return this.myDefect;
        }

        private int getDefectNumber() {
            return this.myDefect == null ? this.getDefectsCount() : this.myDefects.indexOf(this.myDefect) + 1;
        }

        public FailedTestInfo execute() {
            this.myAllTests = new ArrayList<AbstractTestProxy>(FailedTestsNavigator.this.myModel.getRoot().getAllTests());
            this.myDefects = Filter.DEFECTIVE_LEAF.select(this.myAllTests);
            AbstractTestProxy selectedTest = FailedTestsNavigator.this.myModel.getTreeView().getSelectedTest();
            int selectionIndex = this.myAllTests.indexOf(selectedTest);
            if (selectionIndex == -1) {
                return this;
            }
            AbstractTestProxy defect = this.findNextDefect(selectionIndex);
            if (defect == null) {
                return this;
            }
            if (defect != selectedTest) {
                this.myDefect = defect;
                return this;
            }
            int defectIndex = this.myDefects.indexOf(defect);
            if (defectIndex == -1 || defectIndex == this.getBoundIndex()) {
                return this;
            }
            this.myDefect = this.myDefects.get(this.nextIndex(defectIndex));
            return this;
        }

        private AbstractTestProxy findNextDefect(int startIndex) {
            int i = this.nextIndex(startIndex);
            while (0 <= i && i < this.myAllTests.size()) {
                AbstractTestProxy nextDefect = this.myAllTests.get(i);
                if (Filter.DEFECTIVE_LEAF.shouldAccept(nextDefect)) {
                    return nextDefect;
                }
                i = this.nextIndex(i);
            }
            return null;
        }

        protected abstract int nextIndex(int var1);

        protected abstract int getBoundIndex();

        protected int getDefectsCount() {
            return this.myDefects.size();
        }

        private boolean hasNextOccurence() {
            return this.myDefect != null;
        }
    }
}

