/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ProjectTopics;
import com.intellij.ide.CopyPasteUtil;
import com.intellij.ide.favoritesTreeView.FavoritesComparator;
import com.intellij.ide.favoritesTreeView.FavoritesListener;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.FavoritesTreeNodeDescriptor;
import com.intellij.ide.favoritesTreeView.FavoritesTreeStructure;
import com.intellij.ide.projectView.BaseProjectTreeBuilder;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ProjectViewPsiTreeChangeListener;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.tree.TreeUtil;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FavoritesViewTreeBuilder
extends BaseProjectTreeBuilder {
    public FavoritesViewTreeBuilder(@NotNull Project project, JTree tree, DefaultTreeModel treeModel, ProjectAbstractTreeStructureBase treeStructure) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/favoritesTreeView/FavoritesViewTreeBuilder", "<init>"));
        }
        super(project, tree, treeModel, treeStructure, new FavoritesComparator(ProjectView.getInstance(project), "Favorites"));
        MessageBusConnection bus = this.myProject.getMessageBus().connect((Disposable)this);
        ProjectViewPsiTreeChangeListener psiTreeChangeListener = new ProjectViewPsiTreeChangeListener(this.myProject){

            @Override
            protected DefaultMutableTreeNode getRootNode() {
                return FavoritesViewTreeBuilder.this.getRootNode();
            }

            @Override
            protected AbstractTreeUpdater getUpdater() {
                return FavoritesViewTreeBuilder.this.getUpdater();
            }

            @Override
            protected boolean isFlattenPackages() {
                return FavoritesViewTreeBuilder.this.getStructure().isFlattenPackages();
            }

            @Override
            protected void childrenChanged(PsiElement parent, boolean stopProcessingForThisModificationCount) {
                if (FavoritesViewTreeBuilder.this.findNodeByElement(parent) == null) {
                    FavoritesViewTreeBuilder.this.queueUpdate(true);
                } else {
                    super.childrenChanged(parent, true);
                }
            }
        };
        bus.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

            public void rootsChanged(ModuleRootEvent event) {
                FavoritesViewTreeBuilder.this.queueUpdate(true);
            }
        });
        PsiManager.getInstance((Project)this.myProject).addPsiTreeChangeListener((PsiTreeChangeListener)psiTreeChangeListener, (Disposable)this);
        MyFileStatusListener fileStatusListener = new MyFileStatusListener();
        FileStatusManager.getInstance((Project)this.myProject).addFileStatusListener((FileStatusListener)fileStatusListener, (Disposable)this);
        CopyPasteUtil.DefaultCopyPasteListener copyPasteListener = new CopyPasteUtil.DefaultCopyPasteListener(this.getUpdater());
        CopyPasteManager.getInstance().addContentChangedListener((CopyPasteManager.ContentChangedListener)copyPasteListener, (Disposable)this);
        FavoritesListener favoritesListener = new FavoritesListener(){

            @Override
            public void rootsChanged() {
                FavoritesViewTreeBuilder.this.updateFromRoot();
            }

            @Override
            public void listAdded(String listName) {
                FavoritesViewTreeBuilder.this.updateFromRoot();
            }

            @Override
            public void listRemoved(String listName) {
                FavoritesViewTreeBuilder.this.updateFromRoot();
            }
        };
        this.initRootNode();
        FavoritesManager.getInstance(this.myProject).addFavoritesListener(favoritesListener, (Disposable)this);
    }

    @NotNull
    public FavoritesTreeStructure getStructure() {
        AbstractTreeStructure structure = this.getTreeStructure();
        assert (structure instanceof FavoritesTreeStructure);
        FavoritesTreeStructure favoritesTreeStructure = (FavoritesTreeStructure)structure;
        if (favoritesTreeStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/FavoritesViewTreeBuilder", "getStructure"));
        }
        return favoritesTreeStructure;
    }

    public AbstractTreeNode getRoot() {
        Object rootElement = this.getRootElement();
        assert (rootElement instanceof AbstractTreeNode);
        return (AbstractTreeNode)rootElement;
    }

    public void updateFromRoot() {
        this.updateFromRootCB();
    }

    @NotNull
    public ActionCallback updateFromRootCB() {
        this.getStructure().rootsChanged();
        if (this.isDisposed()) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/FavoritesViewTreeBuilder", "updateFromRootCB"));
            }
            return actionCallback;
        }
        this.getUpdater().cancelAllRequests();
        ActionCallback actionCallback = super.updateFromRootCB();
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/FavoritesViewTreeBuilder", "updateFromRootCB"));
        }
        return actionCallback;
    }

    @Override
    @NotNull
    public ActionCallback select(Object element, VirtualFile file, boolean requestFocus) {
        DefaultMutableTreeNode node = this.findSmartFirstLevelNodeByElement(element);
        if (node != null) {
            ActionCallback actionCallback = TreeUtil.selectInTree((DefaultMutableTreeNode)node, (boolean)requestFocus, (JTree)this.getTree());
            if (actionCallback == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/FavoritesViewTreeBuilder", "select"));
            }
            return actionCallback;
        }
        ActionCallback actionCallback = super.select(element, file, requestFocus);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/FavoritesViewTreeBuilder", "select"));
        }
        return actionCallback;
    }

    @Nullable
    private static DefaultMutableTreeNode findFirstLevelNodeWithObject(DefaultMutableTreeNode aRoot, Object aObject) {
        for (int i = 0; i < aRoot.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)aRoot.getChildAt(i);
            Object userObject = child.getUserObject();
            if (!(userObject instanceof FavoritesTreeNodeDescriptor) || !Comparing.equal((Object)((FavoritesTreeNodeDescriptor)((Object)userObject)).getElement(), (Object)aObject)) continue;
            return child;
        }
        return null;
    }

    protected Object findNodeByElement(Object element) {
        DefaultMutableTreeNode node = this.findSmartFirstLevelNodeByElement(element);
        if (node != null) {
            return node;
        }
        return super.findNodeByElement(element);
    }

    @Nullable
    DefaultMutableTreeNode findSmartFirstLevelNodeByElement(Object element) {
        for (Object child : this.getRoot().getChildren()) {
            DefaultMutableTreeNode nodeWithObject;
            AbstractTreeNode favorite = (AbstractTreeNode)child;
            Object currentValue = favorite.getValue();
            if (currentValue instanceof SmartPsiElementPointer) {
                currentValue = ((SmartPsiElementPointer)favorite.getValue()).getElement();
            }
            if (!Comparing.equal((Object)element, (Object)currentValue) || (nodeWithObject = FavoritesViewTreeBuilder.findFirstLevelNodeWithObject((DefaultMutableTreeNode)this.getTree().getModel().getRoot(), favorite)) == null) continue;
            return nodeWithObject;
        }
        return null;
    }

    @Override
    protected boolean isAlwaysShowPlus(NodeDescriptor nodeDescriptor) {
        Object[] childElements = this.getStructure().getChildElements(nodeDescriptor);
        return childElements != null && childElements.length > 0;
    }

    @Override
    protected boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
        return nodeDescriptor.getParentDescriptor() == null;
    }

    private final class MyFileStatusListener
    implements FileStatusListener {
        private MyFileStatusListener() {
        }

        public void fileStatusesChanged() {
            FavoritesViewTreeBuilder.this.queueUpdateFrom(FavoritesViewTreeBuilder.this.getRootNode(), false);
        }

        public void fileStatusChanged(@NotNull VirtualFile vFile) {
            if (vFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/ide/favoritesTreeView/FavoritesViewTreeBuilder$MyFileStatusListener", "fileStatusChanged"));
            }
            PsiManager psiManager = PsiManager.getInstance((Project)FavoritesViewTreeBuilder.this.myProject);
            Object element = vFile.isDirectory() ? psiManager.findDirectory(vFile) : psiManager.findFile(vFile);
            if (!FavoritesViewTreeBuilder.this.getUpdater().addSubtreeToUpdateByElement(element) && element instanceof PsiFile && ((PsiFile)element).getFileType() == StdFileTypes.JAVA) {
                FavoritesViewTreeBuilder.this.getUpdater().addSubtreeToUpdateByElement((Object)((PsiFile)element).getContainingDirectory());
            }
        }
    }
}

