/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.impl.ProjectViewSelectInTarget;

public class ProjectSubViewSelectInTarget
implements SelectInTarget {
    private final ProjectViewSelectInTarget myBaseTarget;
    private final String mySubId;
    private final int myWeight;

    public ProjectSubViewSelectInTarget(ProjectViewSelectInTarget target, String subId, int weight) {
        this.myBaseTarget = target;
        this.mySubId = subId;
        this.myWeight = weight;
    }

    public boolean canSelect(SelectInContext context) {
        return this.myBaseTarget.isSubIdSelectable(this.mySubId, context);
    }

    public void selectIn(SelectInContext context, boolean requestFocus) {
        this.myBaseTarget.setSubId(this.mySubId);
        this.myBaseTarget.selectIn(context, requestFocus);
    }

    public String getToolWindowId() {
        return this.myBaseTarget.getToolWindowId();
    }

    public String getMinorViewId() {
        return this.myBaseTarget.getMinorViewId();
    }

    public float getWeight() {
        return this.myWeight;
    }

    public String toString() {
        return this.myBaseTarget.getSubIdPresentableName(this.mySubId);
    }
}

