/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.ArrayUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class ClsRepositoryPsiElement<T extends StubElement>
extends ClsElementImpl
implements StubBasedPsiElement<T> {
    private final T myStub;

    protected ClsRepositoryPsiElement(T stub) {
        this.myStub = stub;
    }

    public IStubElementType getElementType() {
        return this.myStub.getStubType();
    }

    public PsiElement getParent() {
        return this.myStub.getParentStub().getPsi();
    }

    @Override
    public PsiManager getManager() {
        PsiFile file = this.getContainingFile();
        if (file == null) {
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
        return file.getManager();
    }

    @Override
    public PsiFile getContainingFile() {
        Object p = this.myStub;
        while (!(p instanceof PsiFileStub)) {
            p = p.getParentStub();
        }
        return (PsiFile)p.getPsi();
    }

    public T getStub() {
        return this.myStub;
    }

    @Override
    public boolean isPhysical() {
        return this.getContainingFile().isPhysical();
    }

    @NotNull
    public PsiElement[] getChildren() {
        List stubs = this.getStub().getChildrenStubs();
        PsiElement[] children2 = new PsiElement[stubs.size()];
        for (int i = 0; i < stubs.size(); ++i) {
            children2[i] = ((StubElement)stubs.get(i)).getPsi();
        }
        if (children2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsRepositoryPsiElement", "getChildren"));
        }
        return children2;
    }

    @Override
    public PsiElement getFirstChild() {
        List children2 = this.getStub().getChildrenStubs();
        if (children2.isEmpty()) {
            return null;
        }
        return ((StubElement)children2.get(0)).getPsi();
    }

    @Override
    public PsiElement getLastChild() {
        List children2 = this.getStub().getChildrenStubs();
        if (children2.isEmpty()) {
            return null;
        }
        return ((StubElement)children2.get(children2.size() - 1)).getPsi();
    }

    @Override
    public PsiElement getNextSibling() {
        Object[] psiElements = this.getParent().getChildren();
        int i = ArrayUtil.indexOf((Object[])psiElements, (Object)((Object)this));
        if (i < 0 || i >= psiElements.length - 1) {
            return null;
        }
        return psiElements[i + 1];
    }

    @Override
    public PsiElement getPrevSibling() {
        Object[] psiElements = this.getParent().getChildren();
        int i = ArrayUtil.indexOf((Object[])psiElements, (Object)((Object)this));
        if (i < 1) {
            return null;
        }
        return psiElements[i - 1];
    }
}

